/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tagging.uk.IPOSTag;
import org.languagetool.tagging.uk.PosTagHelper;
import org.languagetool.tools.Tools;

public class SimpleReplaceRule
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = SimpleReplaceRule.load((String)"/uk/replace.txt");

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public SimpleReplaceRule(ResourceBundle messages) throws IOException {
        super(messages);
        this.setIgnoreTaggedWords();
    }

    public final String getId() {
        return "UK_SIMPLE_REPLACE";
    }

    public String getDescription() {
        return "\u041f\u043e\u0448\u0443\u043a \u043f\u043e\u043c\u0438\u043b\u043a\u043e\u0432\u0438\u0445 \u0441\u043b\u0456\u0432";
    }

    public String getShort() {
        return "\u041f\u043e\u043c\u0438\u043b\u043a\u0430?";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return tokenStr + " - \u043f\u043e\u043c\u0438\u043b\u043a\u043e\u0432\u0435 \u0441\u043b\u043e\u0432\u043e, \u0432\u0438\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044f: " + String.join((CharSequence)", ", replacements) + ".";
    }

    protected boolean isTagged(AnalyzedTokenReadings tokenReadings) {
        for (AnalyzedToken token : tokenReadings.getReadings()) {
            String posTag = token.getPOSTag();
            if (!this.isGoodPosTag(posTag)) continue;
            return true;
        }
        return false;
    }

    protected List<RuleMatch> findMatches(AnalyzedTokenReadings tokenReadings, AnalyzedSentence sentence) {
        List matches = super.findMatches(tokenReadings, sentence);
        if (matches.isEmpty() && PosTagHelper.hasPosTag(tokenReadings, Pattern.compile(".*?adjp:actv.*?:bad.*"))) {
            String url;
            String msg = "\u0410\u043a\u0442\u0438\u0432\u043d\u0456 \u0434\u0456\u0454\u043f\u0440\u0438\u043a\u043c\u0435\u0442\u043d\u0438\u043a\u0438 \u043d\u0435 \u0432\u043b\u0430\u0441\u0442\u0438\u0432\u0456 \u0443\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0456\u0439 \u043c\u043e\u0432\u0456.";
            if (tokenReadings.getAnalyzedToken(0).getLemma().endsWith("\u0448\u0438\u0439")) {
                msg = msg + " \u0407\u0445 \u043c\u043e\u0436\u043d\u0430 \u0437\u0430\u043c\u0456\u043d\u0438\u0442\u0438 \u043d\u0430 \u0449\u043e + \u0434\u0456\u0454\u0441\u043b\u043e\u0432\u043e (\u0432\u0438\u043f\u0430\u0432\u0448\u0438\u0439 \u0441\u043d\u0456\u0433 - \u0441\u043d\u0456\u0433, \u0449\u043e \u0432\u0438\u043f\u0430\u0432), \u0430\u0431\u043e \u043d\u0430 \u0444\u043e\u0440\u043c\u0443 \u0437 \u0441\u0443\u0444\u0456\u043a\u0441\u043e\u043c -\u043b- (\u043f\u0440\u043e\u043c\u043e\u043a\u0448\u0438\u0439 - \u043f\u0440\u043e\u043c\u043e\u043a\u043b\u0438\u0439)";
                url = "http://padaread.com/?book=53784&pg=94";
            } else {
                msg = msg + " \u0407\u0445 \u043c\u043e\u0436\u043d\u0430 \u0437\u0430\u043c\u0456\u043d\u0438\u0442\u0438 \u043f\u0438\u0442\u043e\u043c\u0438\u043c\u0438 \u0441\u043b\u043e\u0432\u0430\u043c\u0438 \u0432 \u0440\u0456\u0437\u043d\u0438\u0439 \u0441\u043f\u043e\u0441\u0456\u0431: \u0449\u043e + \u0434\u0456\u0454\u0441\u043b\u043e\u0432\u043e (\u0440\u043e\u0431\u043b\u044f\u0447\u0438\u0439  - \u0449\u043e \u0440\u043e\u0431\u0438\u0442\u044c), \u0434\u0456\u0454\u0441\u043b\u0456\u0432\u043d\u0438\u0439 \u043a\u043e\u0440\u0456\u043d\u044c+ \u0441\u0443\u0444\u0456\u043a\u0441\u0438 -\u043b\u044c\u043d-, -\u043b\u0438\u0432- \u0442\u043e\u0449\u043e (\u0437\u0431\u0438\u0440\u0430\u044e\u0447\u0438\u0439 - \u0437\u0431\u0438\u0440\u0430\u043b\u044c\u043d\u0438\u0439, \u043e\u0431\u0442\u044f\u0436\u0443\u044e\u0447\u0438\u0439 - \u043e\u0431\u0442\u044f\u0436\u043b\u0438\u0432\u0438\u0439), \u0437\u0430\u043c\u0456\u043d\u0430 \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u043e\u043c (\u0437\u0430\u0432\u0456\u0434\u0443\u044e\u0447\u0438\u0439 - \u0437\u0430\u0432\u0456\u0434\u0443\u0432\u0430\u0447), \u0437\u0430\u043c\u0456\u043d\u0430 \u043f\u0440\u0438\u043a\u043c\u0435\u0442\u043d\u0438\u043a\u043e\u043c \u0456\u0437 \u0432\u0456\u0434\u043f\u043e\u0432\u0456\u0434\u043d\u0438\u043c \u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f\u043c (\u0434\u0456\u044e\u0447\u0430 \u043c\u043e\u0434\u0435\u043b\u044c - \u0440\u043e\u0431\u043e\u0447\u0430 \u043c\u043e\u0434\u0435\u043b\u044c), \u0437\u043c\u0456\u043d\u0430 \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0456\u0457 (\u0437 \u043d\u0430\u0441\u0442\u0443\u043f\u0430\u044e\u0447\u0438\u043c \u041d\u043e\u0432\u0438\u043c \u0440\u043e\u043a\u043e\u043c - \u0437 \u043d\u0430\u0441\u0442\u0430\u043d\u043d\u044f\u043c \u041d\u043e\u0432\u043e\u0433\u043e \u0440\u043e\u043a\u0443) \u0442\u043e\u0449\u043e.";
                url = "http://nbuv.gov.ua/j-pdf/Nchnpu_8_2013_5_2.pdf";
            }
            RuleMatch match = new RuleMatch((Rule)this, sentence, tokenReadings.getStartPos(), tokenReadings.getStartPos() + tokenReadings.getToken().length(), msg, this.getShort());
            match.setUrl(Tools.getUrl((String)url));
            matches.add(match);
        }
        return matches;
    }

    private boolean isGoodPosTag(String posTag) {
        return posTag != null && !"PARA_END".equals(posTag) && !"SENT_END".equals(posTag) && !posTag.contains(IPOSTag.bad.getText());
    }

    public boolean isCaseSensitive() {
        return false;
    }
}

