/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.uk.CaseGovernmentHelper;
import org.languagetool.rules.uk.InflectionHelper;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.rules.uk.TokenAgreementAdjNounRule;
import org.languagetool.rules.uk.TokenAgreementNounVerbRule;
import org.languagetool.rules.uk.TokenAgreementPrepNounRule;
import org.languagetool.tagging.uk.IPOSTag;
import org.languagetool.tagging.uk.PosTagHelper;

final class TokenAgreementAdjNounExceptionHelper {
    private static final Pattern NUMBER_V_NAZ = Pattern.compile("number|numr:p:v_naz|noun.*?:p:v_naz:&numr.*");
    static final List<String> CONJ_FOR_PLURAL = Arrays.asList("\u0456", "\u0439", "\u0442\u0430", "\u0447\u0438", "\u0430\u0431\u043e", "\u0430\u043d\u0456", "\u0442\u0430\u043a\u043e\u0436", "\u0442\u043e", "a", "i");
    static final Pattern CONJ_FOR_PLULAR_PATTERN = Pattern.compile(StringUtils.join(CONJ_FOR_PLURAL, (String)"|"));
    private static final Pattern DOVYE_TROYE = Pattern.compile(".*[2-4]|.*[2-4][\u2013\u2014-].*[2-4]|\u0434\u0432\u0430|\u043e\u0431\u0438\u0434\u0432\u0430|\u0434\u0432\u043e\u0454|\u0442\u0440\u0438|\u0442\u0440\u043e\u0454|\u0447\u043e\u0442\u0438\u0440\u0438|\u043e\u0434\u0438\u043d[\u2013\u2014-]\u0434\u0432\u0430|\u0434\u0432\u0430[\u2013\u2014-]\u0442\u0440\u0438|\u0442\u0440\u0438[\u2013\u2014-]\u0447\u043e\u0442\u0438\u0440\u0438|\u0434\u0432\u043e\u0454[\u2013\u2014-]\u0442\u0440\u043e\u0454|\u0442\u0440\u043e\u0454[\u2013\u2014-]\u0447\u0435\u0442\u0432\u0435\u0440\u043e");

    private TokenAgreementAdjNounExceptionHelper() {
    }

    public static boolean isException(AnalyzedTokenReadings[] tokens, int i, List<InflectionHelper.Inflection> masterInflections, List<InflectionHelper.Inflection> slaveInflections, List<AnalyzedToken> adjTokenReadings, List<AnalyzedToken> slaveTokenReadings) {
        List<InflectionHelper.Inflection> preAdjInflections;
        Set<String> prepGovernedCases;
        List<InflectionHelper.Inflection> masterInflections_;
        Set<String> prepGovernedCases2;
        AnalyzedTokenReadings adjAnalyzedTokenReadings = tokens[i - 1];
        if (i > 1 && LemmaHelper.hasLemma(tokens[i - 1], "\u043d\u0430\u0446\u0456\u043e\u043d\u0430\u043b\u044c\u043d\u0438\u0439") && LemmaHelper.hasLemma(tokens[i - 2], "\u043f\u0435\u0440\u0448\u0438\u0439") && Character.isUpperCase(tokens[i - 1].getToken().charAt(0)) && Character.isUpperCase(tokens[i - 2].getToken().charAt(0))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[i - 1], Arrays.asList("\u0431\u043e\u0436\u0438\u0439", "\u0433\u043e\u0441\u043f\u043e\u0434\u043d\u0456\u0439", "\u0425\u0440\u0438\u0441\u0442\u043e\u0432\u0438\u0439")) && Character.isUpperCase(tokens[i - 1].getToken().charAt(0))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 1 && PosTagHelper.hasPosTagPart(tokens[i - 2], "noun") && Character.isUpperCase(tokens[i - 1].getToken().charAt(0)) && !Collections.disjoint(masterInflections, InflectionHelper.getNounInflections(tokens[i - 2].getReadings()))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (Pattern.compile("([1-9]|1[0-2])[\u2018-][\u0430-\u0434]").matcher(adjAnalyzedTokenReadings.getToken()).matches() && LemmaHelper.hasLemma(tokens[i], "\u043a\u043b\u0430\u0441")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 1 && LemmaHelper.hasLemma(adjAnalyzedTokenReadings, Arrays.asList("\u043f\u0435\u0440\u0448\u0438\u0439"))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 2 && i < tokens.length - 1 && PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj.*&numr.*") && PosTagHelper.hasPosTag(tokens[i + 1], "adj:.:v_rod.*&numr.*") && LemmaHelper.hasLemma(tokens[i - 2], Arrays.asList("\u0430\u0431\u0437\u0430\u0446", "\u0440\u043e\u0437\u0434\u0456\u043b", "\u043f\u0443\u043d\u043a\u0442", "\u0447\u0430\u0441\u0442\u0438\u043d\u0430")) && LemmaHelper.hasLemma(tokens[i], Arrays.asList("\u0430\u0431\u0437\u0430\u0446", "\u0440\u043e\u0437\u0434\u0456\u043b", "\u043f\u0443\u043d\u043a\u0442", "\u0447\u0430\u0441\u0442\u0438\u043d\u0430"))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 1 && PosTagHelper.hasPosTagPart(adjAnalyzedTokenReadings, "num") && LemmaHelper.hasLemma(tokens[i - 2], "\u0441\u0442\u0430\u0442\u0442\u044f") && !Collections.disjoint(masterInflections, InflectionHelper.getNounInflections(tokens[i - 2].getReadings()))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 1 && tokens[i - 1].getToken().equals("\u0437\u0430\u043f\u0430\u0441\u043d\u0438\u0445") && LemmaHelper.hasLemma(tokens[i - 2], "\u043b\u0430\u0432\u0430")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 1 && tokens[i - 1].getToken().equals("\u043f\u043e\u0432\u043d\u0443") && tokens[i - 2].getToken().equalsIgnoreCase("\u043d\u0430")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 1 && LemmaHelper.hasLemma(tokens[i - 1], Arrays.asList("\u0441\u0432\u0456\u0442\u043e\u0432\u0438\u0439"), ":f:") && LemmaHelper.hasLemma(tokens[i - 2], Arrays.asList("\u0434\u0440\u0443\u0433\u0438\u0439", "\u043f\u0435\u0440\u0448\u0438\u0439"), ":f:")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i < tokens.length - 1 && Arrays.asList("\u043f\u043b\u043e\u0449\u0435\u044e", "\u043e\u0431'\u0454\u043c\u043e\u043c", "\u0434\u043e\u0432\u0436\u0438\u043d\u043e\u044e", "\u0432\u0438\u0441\u043e\u0442\u043e\u044e", "\u0437\u0440\u043e\u0441\u0442\u043e\u043c").contains(tokens[i].getToken()) && PosTagHelper.hasPosTag(tokens[i + 1], "prep.*|.*num.*")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 3 && LemmaHelper.hasLemma(tokens[i - 2], Pattern.compile(".*\u043c\u0435\u0442\u0440.*")) && LemmaHelper.hasLemma(tokens[i - 1], Pattern.compile("\u043a\u0432\u0430\u0434\u0440\u0430\u0442\u043d\u0438\u0439|\u043a\u0443\u0431\u0456\u0447\u043d\u0438\u0439")) && PosTagHelper.hasPosTagPart(tokens[i], "v_rod")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 1 && i < tokens.length - 1 && tokens[i].getToken().equals("\u0433\u0432\u0430\u0440\u0434\u0456\u0457") && PosTagHelper.hasPosTag(tokens[i + 1], "noun.*") && !Collections.disjoint(masterInflections, InflectionHelper.getNounInflections(tokens[i + 1].getReadings()))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 1 && tokens[i - 2].getToken().endsWith("%") && tokens[i - 1].getToken().equals("\u0440\u0456\u0447\u043d\u0438\u0445")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 2 && LemmaHelper.hasLemma(tokens[i - 2], "\u043f\u0430\u0441\u0442\u0438") && tokens[i - 1].getToken().equals("\u0437\u0430\u0434\u043d\u0456\u0445")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 2 && LemmaHelper.hasLemma(tokens[i - 2], "\u043c\u0430\u0442\u0438") && tokens[i - 1].getToken().equals("\u0440\u0456\u0432\u043d\u0438\u0445")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 1 && tokens[i].getToken().equals("\u043c\u0430\u043d\u0435\u0440") && tokens[i - 2].getToken().equalsIgnoreCase("\u043d\u0430")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 2 && tokens[i - 1].getToken().equals("\u0454\u0434\u0438\u043d\u043e\u0433\u043e") && tokens[i - 2].getToken().equals("\u0434\u043e") && LemmaHelper.hasLemma(tokens[i - 3], Arrays.asList("\u0432\u0435\u0441\u044c", "\u0443\u0432\u0435\u0441\u044c"), ":p:")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(adjAnalyzedTokenReadings, Arrays.asList("\u0441\u0438\u043b\u044c\u043d\u0438\u0439", "\u043c\u043e\u0433\u0443\u0442\u043d\u0456\u0439", "\u0432\u0435\u043b\u0438\u043a\u0438\u0439")) && tokens[i].getToken().equals("\u0441\u0432\u0456\u0442\u0443")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[i - 1], Arrays.asList("\u043a\u043e\u043b\u0438\u0448\u043d\u0456\u0439", "\u0442\u043e\u0434\u0456\u0448\u043d\u0456\u0439", "\u0442\u0435\u043f\u0435\u0440\u0456\u0448\u043d\u0456\u0439", "\u043d\u0438\u043d\u0456\u0448\u043d\u0456\u0439"), Pattern.compile("adj.*:f:.*")) && Character.isUpperCase(tokens[i].getToken().charAt(0))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i < tokens.length - 1 && Arrays.asList("\u0456\u043c.", "\u0456\u043c\u0435\u043d\u0456", "\u043e\u0440\u0434\u0435\u043d\u0430").contains(tokens[i].getToken())) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 1 && Arrays.asList("\u0434\u0456\u0432\u043e\u0447\u0435").contains(tokens[i - 1].getToken()) && PosTagHelper.hasPosTagPart(tokens[i], "name")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (Arrays.asList("\u0432\u043e\u043b\u044c\u043d\u043e\u043c\u0443", "\u0432\u0456\u043b\u044c\u043d\u043e\u043c\u0443").contains(adjAnalyzedTokenReadings.getToken().toLowerCase()) && tokens[i].getToken().equals("\u0432\u043e\u043b\u044f")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 1 && LemmaHelper.hasLemma(adjAnalyzedTokenReadings, "\u0434\u0435\u043d\u043d\u0438\u0439") && LemmaHelper.hasLemma(tokens[i - 2], "\u043f\u043e\u0440\u044f\u0434\u043e\u043a") && !Collections.disjoint(masterInflections, InflectionHelper.getNounInflections(tokens[i - 2].getReadings()))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[i - 1], Arrays.asList("\u0437\u0434\u0430\u0442\u043d\u0438\u0439", "\u0437\u043c\u0443\u0448\u0435\u043d\u0438\u0439", "\u0432\u0438\u043d\u043d\u0438\u0439", "\u043f\u043e\u0432\u0438\u043d\u043d\u0438\u0439", "\u0433\u043e\u0442\u043e\u0432\u0438\u0439", "\u0441\u043f\u0440\u043e\u043c\u043e\u0436\u043d\u0438\u0439"))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i < tokens.length - 2 && PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj:p:.*") && TokenAgreementAdjNounExceptionHelper.forwardConjFind(tokens, i + 1, 2) && TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(masterInflections, slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i < tokens.length - 2 && PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj:p:.*") && tokens[i + 1].getToken().matches("[\u2014\u2013-]") && PosTagHelper.hasPosTag(tokens[i + 2], "(adj|noun).*") && TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(masterInflections, slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i < tokens.length - 2 && PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj:p:.*") && Arrays.asList("\u0437", "\u0456\u0437", "\u0437\u0456").contains(tokens[i + 1].getToken()) && PosTagHelper.hasPosTag(tokens[i + 2], "(noun|numr).*:v_oru.*") && TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(masterInflections, slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 2 && PosTagHelper.hasPosTag(tokens[i], "noun:.*:p:.*") && TokenAgreementAdjNounExceptionHelper.reverseConjFind(tokens, i - 2, 3) && TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(masterInflections, slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 2 && PosTagHelper.hasPosTag(tokens[i], "noun:.*:p:.*") && tokens[i - 2].getToken().matches("\u0437|\u0456\u0437|\u0437\u0456") && PosTagHelper.hasPosTag(tokens[i - 1], "adj.*v_oru.*") && TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(InflectionHelper.getAdjInflections(tokens[i - 3].getReadings()), slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj:p:v_rod.*") && tokens[i].getToken().startsWith("\u043f\u0456\u0432") && PosTagHelper.hasPosTag(tokens[i], "noun.*v_rod.*")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i < tokens.length - 1 && PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj:p:v_rod.*") && tokens[i].getToken().equals("\u0447\u0432\u0435\u0440\u0442\u044c") && PosTagHelper.hasPosTag(tokens[i + 1], "noun.*v_rod.*")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (Arrays.asList("\u043f\u0435\u0440\u0435\u043a\u043e\u043d\u0430\u043d\u0430", "\u0432\u043f\u0435\u0432\u043d\u0435\u043d\u0430", "\u0443\u043f\u0435\u0432\u043d\u0435\u043d\u0430", "\u0433\u043e\u0434\u043d\u0430", "\u043b\u0430\u0434\u043d\u0430", "\u043f\u0435\u0432\u043d\u0430", "\u043f\u0440\u0438\u0447\u0435\u0442\u043d\u0430", "\u043e\u0431\u0440\u0430\u043d\u0430", "\u043f\u0440\u0438\u0437\u043d\u0430\u0447\u0435\u043d\u0430").contains(adjAnalyzedTokenReadings.getToken()) && PosTagHelper.hasPosTag(tokens[i], "noun:anim:m:v_naz.*")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i < tokens.length - 1 && tokens[i].getToken().equals("\u0441\u0442\u0430\u043d\u043e\u043c") && tokens[i + 1].getToken().equals("\u043d\u0430")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 1 && tokens[i - 1].getToken().equals("\u0440\u0456\u0432\u043d\u0438\u0445") && tokens[i - 2].getToken().equalsIgnoreCase("\u043d\u0430")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i < tokens.length - 1 && tokens[i].getToken().equals("\u0437\u0440\u0430\u0437\u043a\u0430")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (Arrays.asList("\u043c\u0456\u043d\u0443\u0441", "\u043f\u043b\u044e\u0441").contains(tokens[i].getToken())) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i < tokens.length - 1 && LemmaHelper.hasLemma(tokens[i], Arrays.asList("\u043f\u0430\u0440\u0430", "\u043d\u0438\u0437\u043a\u0430", "\u0440\u044f\u0434", "\u043a\u0443\u043f\u0430", "\u0431\u0456\u043b\u044c\u0448\u0456\u0441\u0442\u044c", "\u0434\u0435\u0441\u044f\u0442\u043a\u0430", "\u0441\u043e\u0442\u043d\u044f", "\u0442\u0438\u0441\u044f\u0447\u0430", "\u043c\u0456\u043b\u044c\u0439\u043e\u043d")) && PosTagHelper.hasPosTag(tokens[i + 1], "noun.*:p:v_rod.*")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i < tokens.length - 1 && LemmaHelper.hasLemma(tokens[i], Arrays.asList("\u0440\u0430\u0437"), Pattern.compile(".*p:v_(naz|rod).*")) && (PosTagHelper.hasPosTag(tokens[i + 1], "number|numr:p:v_naz|noun.*?:p:v_naz:&numr.*") || PosTagHelper.hasPosTagPart(tokens[i + 1], "prep"))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i < tokens.length - 1 && LemmaHelper.hasLemma(tokens[i], LemmaHelper.TIME_PLUS_LEMMAS, Pattern.compile("noun.*?p:v_(naz|rod).*")) && (PosTagHelper.hasPosTag(tokens[i + 1], NUMBER_V_NAZ) || i < tokens.length - 2 && LemmaHelper.hasLemma(tokens[i + 1], Arrays.asList("\u043d\u0430", "\u0437\u0430", "\u0437", "\u0456\u0437", "\u0437\u043e", "\u0447\u0435\u0440\u0435\u0437", "\u043f\u0456\u0434"), "prep") && PosTagHelper.hasPosTag(tokens[i + 2], NUMBER_V_NAZ))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i < tokens.length - 2 && LemmaHelper.hasLemma(tokens[i], Arrays.asList("\u043e\u0441\u043e\u0431\u0430"), Pattern.compile("noun.*?p:v_(naz|rod).*")) && LemmaHelper.hasLemma(tokens[i + 1], Arrays.asList("\u043d\u0430", "\u0437", "\u0456\u0437", "\u0437\u043e", "\u043f\u0456\u0434"), "prep") && PosTagHelper.hasPosTag(tokens[i + 2], NUMBER_V_NAZ)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 3 && LemmaHelper.hasLemma(tokens[i - 3], LemmaHelper.TIME_LEMMAS_SHORT) && PosTagHelper.hasPosTagPart(tokens[i - 2], "prep") && PosTagHelper.hasPosTagPart(tokens[i - 1], "num") && TokenAgreementPrepNounRule.hasVidmPosTag(prepGovernedCases2 = CaseGovernmentHelper.getCaseGovernments(tokens[i - 2], IPOSTag.prep.name()), tokens[i - 3]) && TokenAgreementPrepNounRule.hasVidmPosTag(prepGovernedCases2, tokens[i - 1])) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i < tokens.length - 1 && LemmaHelper.hasLemma(tokens[i], LemmaHelper.TIME_LEMMAS) && LemmaHelper.hasLemma(tokens[i + 1], "\u0442\u043e\u043c\u0443")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i < tokens.length - 1 && LemmaHelper.hasLemma(tokens[i], LemmaHelper.TIME_PLUS_LEMMAS, Pattern.compile("noun:inanim:p:v_oru.*"))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(tokens[i - 1], Arrays.asList("\u0434\u0435\u0441\u044f\u0442\u0438\u0439", "\u0441\u043e\u0442\u0438\u0439", "\u0442\u0438\u0441\u044f\u0447\u043d\u0438\u0439", "\u0434\u0435\u0441\u044f\u0442\u0438\u0442\u0438\u0441\u044f\u0447\u043d\u0438\u0439", "\u0441\u0442\u043e\u0442\u0438\u0442\u0438\u0441\u044f\u0447\u043d\u0438\u0439", "\u043c\u0456\u043b\u044c\u0439\u043e\u043d\u043d\u0438\u0439", "\u043c\u0456\u043b\u044c\u044f\u0440\u0434\u043d\u0438\u0439")) && PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, ".*:[fp]:.*") && PosTagHelper.hasPosTag(tokens[i], "noun.*v_rod.*")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 1 && i < tokens.length && PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, ".*:p:v_(rod|naz).*") && LemmaHelper.reverseSearch(tokens, i - 2, 5, DOVYE_TROYE, null) && (PosTagHelper.hasPosTag(tokens[i], ".*(:p:v_naz|:n:v_rod).*") || Arrays.asList("\u0456\u043c\u0435\u043d\u0456", "\u043e\u043a\u0430").contains(tokens[i].getToken()))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if ((adjAnalyzedTokenReadings.getToken().matches("[0-9]+[\u2014\u2013-][0-9]+[\u2013-][\u0430-\u044f\u0456\u0457\u0454\u0491]{1,3}") || adjAnalyzedTokenReadings.getToken().matches(".*[\u0430-\u044f\u0457\u0456\u0454\u0491][\u2014\u2013-].*") && PosTagHelper.hasPosTagPart(adjAnalyzedTokenReadings, "&numr")) && PosTagHelper.hasPosTag(slaveTokenReadings, ".*:p:.*") && TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(masterInflections, slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 2 && Arrays.asList("\u2013", "\u2014").contains(tokens[i - 2].getToken()) && PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, ".*num.*") && PosTagHelper.hasPosTag(tokens[i - 3], ".*num.*") && PosTagHelper.hasPosTag(slaveTokenReadings, ".*:p:.*") && TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(InflectionHelper.getAdjInflections(tokens[i - 3].getReadings()), slaveInflections) && TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(masterInflections, slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj.*:p:.*") && tokens[i].getToken().matches(".*[\u2014\u2013-].*") && (LemmaHelper.TIME_PLUS_LEMMAS.contains(tokens[i].getAnalyzedToken(0).getLemma().split("[\u2014\u2013-]")[0]) || TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(masterInflections, slaveInflections))) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i < tokens.length - 1 && LemmaHelper.hasLemma(tokens[i], "\u043f\u0430\u0440\u0430") && PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj.*:p:.*") && PosTagHelper.hasPosTag(tokens[i + 1], ".*:p:v_rod.*")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 1 && PosTagHelper.hasPosTag(tokens[i - 1], ".*:p:v_rod.*num.*") && PosTagHelper.hasPosTagPart(tokens[i - 2], "num") && PosTagHelper.hasPosTag(tokens[i], "noun.*v_rod.*")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 3 && "/".equals(tokens[i - 2].getToken()) && PosTagHelper.hasPosTagPart(tokens[i - 3], "numb") && TokenAgreementAdjNounExceptionHelper.hasOverlapIgnoreGender(masterInflections, slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTagPart(adjAnalyzedTokenReadings, ":&numr")) {
            String adjToken = adjAnalyzedTokenReadings.getToken();
            if (adjToken.matches("([12][0-9])?[0-9][0-9][\u2014\u2013-](\u0439|\u0433\u043e|\u043c|\u043c\u0443|\u0445)") || adjToken.matches("([12][0-9])?[0-9]0[\u2014\u2013-](\u0442\u0456|\u0442\u0438\u0445|\u0438\u0445)") || adjToken.matches("[12][0-9][0-9][0-9][\u2014\u2013-][12][0-9][0-9][0-9][\u2014\u2013-](\u0439|\u0433\u043e|\u043c\u0443|\u0445)")) {
                TokenAgreementAdjNounExceptionHelper.logException();
                return true;
            }
            if (i > 1 && PosTagHelper.hasPosTagPart(adjAnalyzedTokenReadings, ":f:") && LemmaHelper.hasLemma(tokens[i - 2], Arrays.asList("\u043d\u0430", "\u0432", "\u0443", "\u0437\u0430", "\u043e", "\u0434\u043e", "\u043f\u0456\u0441\u043b\u044f", "\u0431\u043b\u0438\u0437\u044c\u043a\u043e", "\u0440\u0430\u043d\u0456\u0448\u0435")) && !LemmaHelper.hasLemma(tokens[i], Arrays.asList("\u0445\u0432\u0438\u043b\u0438\u043d\u0430", "\u0433\u043e\u0434\u0438\u043d\u0430"))) {
                TokenAgreementAdjNounExceptionHelper.logException();
                return true;
            }
            if (PosTagHelper.hasPosTagPart(adjAnalyzedTokenReadings, ":f:") && tokens[i].getToken().matches("\u0440\u0430\u043d\u043a\u0443|\u0434\u043d\u044f|\u0432\u0435\u0447\u043e\u0440\u0430|\u043d\u043e\u0447\u0456|\u043f\u043e\u043f\u043e\u043b\u0443\u0434\u043d\u044f")) {
                TokenAgreementAdjNounExceptionHelper.logException();
                return true;
            }
            if (PosTagHelper.hasPosTagPart(adjAnalyzedTokenReadings, ":n:") && LemmaHelper.hasLemma(tokens[i], LemmaHelper.MONTH_LEMMAS, "v_rod")) {
                TokenAgreementAdjNounExceptionHelper.logException();
                return true;
            }
        }
        if (PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, ".*?adjp:actv.*:bad.*")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 2 && i <= tokens.length - 1 && LemmaHelper.hasLemma(tokens[i - 2], Arrays.asList("\u043d\u0456\u0449\u043e", "\u0449\u043e\u0441\u044c", "\u043d\u0456\u0445\u0442\u043e", "\u0445\u0442\u043e\u0441\u044c")) && !Collections.disjoint(InflectionHelper.getNounInflections(tokens[i - 2].getReadings()), masterInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 1 && LemmaHelper.revSearch(tokens, i - 2, Pattern.compile(".*(\u043d\u043d\u044f|\u0442\u0442\u044f)"), null) && PosTagHelper.hasPosTag(tokens[i - 1], "adj.*:v_oru.*") && PosTagHelper.hasPosTag(tokens[i], "noun:.*:v_rod.*") && TokenAgreementAdjNounExceptionHelper.genderMatches(masterInflections, slaveInflections, "v_oru", "v_rod")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        int verbPos = LemmaHelper.revSearchIdx(tokens, i - 2, Pattern.compile("\u0431\u0443\u0442\u0438|\u0441\u0442\u0430\u0432\u0430\u0442\u0438|\u0441\u0442\u0430\u0442\u0438|\u0437\u0430\u043b\u0438\u0448\u0430\u0442\u0438\u0441\u044f|\u0437\u0430\u043b\u0438\u0448\u0438\u0442\u0438\u0441\u044f"), null);
        if (verbPos != -1) {
            if (PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj.*v_naz.*adjp:pasv.*")) {
                if (TokenAgreementAdjNounExceptionHelper.genderMatches(masterInflections, slaveInflections, "v_naz", "v_naz")) {
                    TokenAgreementAdjNounExceptionHelper.logException();
                    return true;
                }
                if (TokenAgreementAdjNounExceptionHelper.genderMatches(masterInflections, slaveInflections, "v_naz", "v_naz")) {
                    TokenAgreementAdjNounExceptionHelper.logException();
                    return true;
                }
            } else if (PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj.*v_oru.*")) {
                if (PosTagHelper.hasPosTag(slaveTokenReadings, "noun.*v_naz.*")) {
                    if (TokenAgreementAdjNounExceptionHelper.genderMatches(masterInflections, slaveInflections, "v_oru", "v_naz")) {
                        if (PosTagHelper.hasPosTagPart(tokens[verbPos], ":inf") || TokenAgreementNounVerbRule.inflectionsOverlap(tokens[verbPos].getReadings(), tokens[i].getReadings())) {
                            TokenAgreementAdjNounExceptionHelper.logException();
                            return true;
                        }
                    } else if (i < tokens.length - 1 && PosTagHelper.hasPosTagPart(tokens[i - 1], "adj:p:") && CONJ_FOR_PLURAL.contains(tokens[i + 1].getToken())) {
                        TokenAgreementAdjNounExceptionHelper.logException();
                        return true;
                    }
                } else if (PosTagHelper.hasPosTag(slaveTokenReadings, "noun.*v_dav.*") && TokenAgreementAdjNounExceptionHelper.genderMatches(masterInflections, slaveInflections, "v_oru", "v_dav")) {
                    TokenAgreementAdjNounExceptionHelper.logException();
                    return true;
                }
            }
        }
        if ((verbPos = LemmaHelper.revSearchIdx(tokens, i - 2, null, "verb.*")) != -1 && PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj.*v_oru.*") && PosTagHelper.hasPosTag(slaveTokenReadings, "noun.*v_naz.*") && TokenAgreementNounVerbRule.inflectionsOverlap(tokens[verbPos].getReadings(), tokens[i].getReadings())) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 2 && Arrays.asList("\u0431\u0456\u043b\u0435", "\u0447\u043e\u0440\u043d\u0435", "\u043e\u0440\u0430\u043d\u0436\u0435\u0432\u0435", "\u0447\u0435\u0440\u0432\u043e\u043d\u0435", "\u0436\u043e\u0432\u0442\u0435", "\u0441\u0438\u043d\u0454", "\u0437\u0435\u043b\u0435\u043d\u0435", "\u0444\u0456\u043e\u043b\u0435\u0442\u043e\u0432\u0435").contains(tokens[i - 1].getToken()) && Arrays.asList("\u0432", "\u0443").contains(tokens[i - 2].getToken()) && PosTagHelper.hasPosTagPart(tokens[i - 3], "adjp:pasv") && !Collections.disjoint(masterInflections_ = InflectionHelper.getAdjInflections(tokens[i - 3].getReadings()), slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 3 && Arrays.asList("\u0431\u0456\u043b\u0435", "\u0447\u043e\u0440\u043d\u0435").contains(tokens[i - 1].getToken()) && Arrays.asList("\u0443\u0441\u0435", "\u0432\u0441\u0435").contains(tokens[i - 2].getToken()) && Arrays.asList("\u0432", "\u0443").contains(tokens[i - 3].getToken()) && PosTagHelper.hasPosTagPart(tokens[i - 4], "adjp:pasv") && !Collections.disjoint(masterInflections_ = InflectionHelper.getAdjInflections(tokens[i - 4].getReadings()), slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i < tokens.length - 1 && PosTagHelper.hasPosTagPart(adjAnalyzedTokenReadings, "adjp:pasv") && Arrays.asList("\u0442\u0438\u0441\u044f\u0447\u0443", "\u0441\u043e\u0442\u043d\u044e", "\u0434\u0435\u0441\u044f\u0442\u043a\u0438").contains(tokens[i].getToken()) && Arrays.asList("\u0440\u0430\u0437\u0456\u0432", "\u0440\u0430\u0437", "\u0440\u043e\u043a\u0456\u0432").contains(tokens[i + 1].getToken())) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 2 && PosTagHelper.hasPosTagPart(tokens[i - 2], "prep") && PosTagHelper.hasPosTag(tokens[i - 3], "(adj|verb|part|noun|adv).*") && TokenAgreementPrepNounRule.hasVidmPosTag(prepGovernedCases = CaseGovernmentHelper.getCaseGovernments(tokens[i - 2], IPOSTag.prep.name()), tokens[i - 1])) {
            if ((PosTagHelper.hasPosTag(tokens[i - 3], "(verb|part).*") || Arrays.asList("\u043f\u043e\u0440\u044f\u0434", "\u0432\u0456\u0434\u043c\u0456\u043d\u0443", "\u043f\u043e\u0440\u0456\u0432\u043d\u044f\u043d\u043d\u0456").contains(tokens[i - 3].getToken().toLowerCase())) && PosTagHelper.hasPosTag(tokens[i], "noun.*v_(naz|zna|oru).*")) {
                TokenAgreementAdjNounExceptionHelper.logException();
                return true;
            }
            List<InflectionHelper.Inflection> masterInflections_2 = InflectionHelper.getAdjInflections(tokens[i - 3].getReadings());
            if (!Collections.disjoint(masterInflections_2, slaveInflections)) {
                TokenAgreementAdjNounExceptionHelper.logException();
                return true;
            }
            if (i < tokens.length - 1 && PosTagHelper.hasPosTagPart(tokens[i - 1], "adj:p:") && CONJ_FOR_PLURAL.contains(tokens[i + 1].getToken())) {
                TokenAgreementAdjNounExceptionHelper.logException();
                return true;
            }
        }
        if (i > 1 && PosTagHelper.hasPosTagPart(tokens[i - 2], "adjp:pasv") && PosTagHelper.hasPosTag(tokens[i - 1], "adj.*v_oru.*") && !Collections.disjoint(InflectionHelper.getAdjInflections(tokens[i - 2].getReadings()), slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTagPart(adjAnalyzedTokenReadings, "adjp:pasv") && PosTagHelper.hasPosTagPart(tokens[i], "v_oru")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (i > 1 && !PosTagHelper.hasPosTag(tokens[i - 2], ".*adjp:pasv.*|prep.*") && PosTagHelper.hasPosTag(adjAnalyzedTokenReadings, "adj.*v_oru.*") && PosTagHelper.hasPosTag(slaveTokenReadings, "noun.*v_naz.*") && LemmaHelper.forwardPosTagSearch(tokens, i + 1, "verb", 3)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if ((i < 3 || !CaseGovernmentHelper.hasCaseGovernment(tokens[i - 2], "v_oru")) && PosTagHelper.hasPosTagPart(adjAnalyzedTokenReadings, "v_oru") && PosTagHelper.hasPosTag(slaveTokenReadings, ".*v_zna.*") && TokenAgreementAdjNounExceptionHelper.genderMatches(masterInflections, slaveInflections, "v_oru", "v_zna")) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        if (TokenAgreementAdjNounExceptionHelper.caseGovernmentMatches(adjTokenReadings, slaveInflections)) {
            if (i < tokens.length - 1 && PosTagHelper.hasPosTagPart(tokens[i + 1], "noun:")) {
                if (PosTagHelper.hasPosTag(tokens[i + 1], "noun.*v_(rod|oru|naz|dav).*")) {
                    TokenAgreementAdjNounExceptionHelper.logException();
                    return true;
                }
                List<InflectionHelper.Inflection> slave2Inflections = InflectionHelper.getNounInflections(tokens[i + 1].getReadings());
                if (!Collections.disjoint(masterInflections, slave2Inflections)) {
                    TokenAgreementAdjNounExceptionHelper.logException();
                    return true;
                }
            } else {
                TokenAgreementAdjNounExceptionHelper.logException();
                return true;
            }
        }
        if (i > 1 && PosTagHelper.hasPosTagPart(tokens[i - 2], "adj") && TokenAgreementAdjNounExceptionHelper.caseGovernmentMatches(tokens[i - 2].getReadings(), masterInflections) && !Collections.disjoint(preAdjInflections = InflectionHelper.getAdjInflections(tokens[i - 2].getReadings()), slaveInflections)) {
            TokenAgreementAdjNounExceptionHelper.logException();
            return true;
        }
        return false;
    }

    private static void logException() {
        if (TokenAgreementAdjNounRule.DEBUG) {
            StackTraceElement stackTraceElement = new Exception().getStackTrace()[1];
            System.err.println("exception: " + stackTraceElement.getFileName() + ": " + stackTraceElement.getLineNumber());
        }
    }

    private static boolean genderMatches(List<InflectionHelper.Inflection> masterInflections, List<InflectionHelper.Inflection> slaveInflections, String masterCaseFilter, String slaveCaseFilter) {
        for (InflectionHelper.Inflection masterInflection : masterInflections) {
            for (InflectionHelper.Inflection slaveInflection : slaveInflections) {
                if (masterCaseFilter != null && !masterInflection._case.equals(masterCaseFilter) || slaveCaseFilter != null && !slaveInflection._case.equals(slaveCaseFilter) || !slaveInflection.gender.equals(masterInflection.gender)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean reverseConjFind(AnalyzedTokenReadings[] tokens, int pos, int depth) {
        for (int i = pos; i > pos - depth && i >= 0; --i) {
            if (!CONJ_FOR_PLURAL.contains(tokens[i].getAnalyzedToken(0).getLemma()) && !tokens[i].getAnalyzedToken(0).getToken().equals("i") && !tokens[i].getAnalyzedToken(0).getToken().equals(",")) continue;
            return true;
        }
        return false;
    }

    private static boolean forwardConjFind(AnalyzedTokenReadings[] tokens, int pos, int depth) {
        for (int i = pos; i < tokens.length && i <= pos + depth; ++i) {
            if (!CONJ_FOR_PLURAL.contains(tokens[i].getAnalyzedToken(0).getLemma()) && !tokens[i].getAnalyzedToken(0).getToken().equals("i") && !tokens[i].getAnalyzedToken(0).getToken().equals(",")) continue;
            return true;
        }
        return false;
    }

    private static boolean caseGovernmentMatches(List<AnalyzedToken> adjTokenReadings, List<InflectionHelper.Inflection> slaveInflections) {
        return adjTokenReadings.stream().map(p -> p.getLemma()).distinct().anyMatch(item -> {
            Set<String> inflections = CaseGovernmentHelper.CASE_GOVERNMENT_MAP.get(item);
            if (inflections != null) {
                for (InflectionHelper.Inflection inflection : slaveInflections) {
                    if (!inflections.contains(inflection._case)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    private static boolean hasOverlapIgnoreGender(List<InflectionHelper.Inflection> masterInflections, List<InflectionHelper.Inflection> slaveInflections) {
        for (InflectionHelper.Inflection mInflection : masterInflections) {
            for (InflectionHelper.Inflection sInflection : slaveInflections) {
                if (!mInflection.equalsIgnoreGender(sInflection)) continue;
                return true;
            }
        }
        return false;
    }
}

