/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.uk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.rules.uk.ExtraDictionaryLoader;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tagging.WordTagger;
import org.languagetool.tagging.uk.CompoundDebugLogger;
import org.languagetool.tagging.uk.IPOSTag;
import org.languagetool.tagging.uk.LetterEndingForNumericHelper;
import org.languagetool.tagging.uk.PosTagHelper;
import org.languagetool.tagging.uk.UkrainianTagger;

class CompoundTagger {
    private static final String TAG_ANIM = ":anim";
    private static final String TAG_INANIM = ":inanim";
    private static final String NV_TAG = ":nv";
    private static final Pattern EXTRA_TAGS = Pattern.compile(":bad");
    private static final Pattern EXTRA_TAGS_DROP = Pattern.compile(":(comp.|np|ns|slang|rare|xp[1-9]|&predic|&insert)");
    private static final Pattern NOUN_SING_V_ROD_REGEX = Pattern.compile("noun.*?:[mfn]:v_rod.*");
    private static final Pattern NOUN_V_NAZ_REGEX = Pattern.compile("noun.*?:.:v_naz.*");
    private static final Pattern SING_REGEX_F = Pattern.compile(":[mfn]:");
    private static final Pattern O_ADJ_PATTERN = Pattern.compile(".*(\u043e|[\u0447\u0448\u0449]\u0435)");
    private static final Pattern DASH_PREFIX_LAT_PATTERN = Pattern.compile("[a-zA-Z]{3,}");
    private static final Pattern YEAR_NUMBER = Pattern.compile("[12][0-9]{3}");
    private static final Pattern NOUN_PREFIX_NUMBER = Pattern.compile("[0-9]+");
    private static final Pattern ADJ_PREFIX_NUMBER = Pattern.compile("[0-9]+(,[0-9]+)?([-\u2013\u2014][0-9]+(,[0-9]+)?)?%?|(XC|XL|L?X{0,3})(IX|IV|V?I{0,3})");
    private static final Pattern MNP_NAZ_REGEX = Pattern.compile(".*:[mnp]:v_naz.*");
    private static final Pattern MNP_ZNA_REGEX = Pattern.compile(".*:[mnp]:v_zna.*");
    private static final Pattern MNP_ROD_REGEX = Pattern.compile(".*:[mnp]:v_rod.*");
    private static final Pattern stdNounTagRegex = Pattern.compile("noun:(?:in)?anim:(.):(v_...).*");
    private static final Set<String> dashPrefixes;
    private static final Set<String> leftMasterSet;
    private static final Map<String, Pattern> rightPartsWithLeftTagMap;
    private static final Set<String> slaveSet;
    private static final String ADJ_TAG_FOR_PO_ADV_MIS = "adj:m:v_mis";
    private static final String ADJ_TAG_FOR_PO_ADV_NAZ = "adj:m:v_naz";
    private static final List<String> LEFT_O_ADJ;
    private static final List<String> LEFT_INVALID;
    private static final List<String> LEFT_O_ADJ_INVALID;
    private static final List<String> WORDS_WITH_YEAR;
    private static final List<String> NUMBERED_ENTITIES;
    private final WordTagger wordTagger;
    private final Locale conversionLocale;
    private final UkrainianTagger ukrainianTagger;
    private final CompoundDebugLogger compoundDebugLogger = new CompoundDebugLogger();

    CompoundTagger(UkrainianTagger ukrainianTagger, WordTagger wordTagger, Locale conversionLocale) {
        this.ukrainianTagger = ukrainianTagger;
        this.wordTagger = wordTagger;
        this.conversionLocale = conversionLocale;
    }

    @Nullable
    public List<AnalyzedToken> guessCompoundTag(String word) {
        List<AnalyzedToken> guessedCompoundTags = this.doGuessCompoundTag(word);
        this.compoundDebugLogger.logTaggedCompound(guessedCompoundTags);
        return guessedCompoundTags;
    }

    @Nullable
    private List<AnalyzedToken> doGuessCompoundTag(String word) {
        List<AnalyzedToken> tagMatch;
        List<TaggedWord> noDashWordList;
        String noDashWord;
        List<AnalyzedToken> noDashAnalyzedTokens;
        List rightWdList;
        List<TaggedWord> leftWdList;
        String rightWord;
        String leftWord;
        block42: {
            ArrayList<AnalyzedToken> newAnalyzedTokens;
            block45: {
                List rightWdList2;
                block43: {
                    block44: {
                        int dashIdx = word.lastIndexOf(45);
                        if (dashIdx == 0 || dashIdx == word.length() - 1) {
                            return null;
                        }
                        int firstDashIdx = word.indexOf(45);
                        if (dashIdx != firstDashIdx) {
                            return null;
                        }
                        leftWord = word.substring(0, dashIdx);
                        rightWord = word.substring(dashIdx + 1);
                        if (LEFT_INVALID.contains(leftWord.toLowerCase())) {
                            return null;
                        }
                        if (leftWord.equalsIgnoreCase("\u043f\u0456\u0432") && Character.isLowerCase(rightWord.charAt(0))) {
                            return null;
                        }
                        leftWdList = this.tagAsIsAndWithLowerCase(leftWord);
                        if (rightPartsWithLeftTagMap.containsKey(rightWord)) {
                            if (leftWdList.isEmpty()) {
                                return null;
                            }
                            Pattern leftTagRegex = rightPartsWithLeftTagMap.get(rightWord);
                            List<AnalyzedToken> leftAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(leftWord, leftWdList);
                            ArrayList<AnalyzedToken> newAnalyzedTokens2 = new ArrayList<AnalyzedToken>(leftAnalyzedTokens.size());
                            if (rightWord.equals("\u0442\u043e") && LemmaHelper.hasLemma(leftAnalyzedTokens, Arrays.asList("\u0445\u0442\u043e", "\u0449\u043e", "\u0447\u0438"))) {
                                return null;
                            }
                            for (AnalyzedToken analyzedToken : leftAnalyzedTokens) {
                                String posTag = analyzedToken.getPOSTag();
                                if ((posTag == null || !leftWord.equals("\u0434\u0443\u0436\u0435") || !posTag.contains("adv")) && !leftTagRegex.matcher(posTag).matches()) continue;
                                newAnalyzedTokens2.add(new AnalyzedToken(word, posTag, analyzedToken.getLemma()));
                            }
                            return newAnalyzedTokens2.isEmpty() ? null : newAnalyzedTokens2;
                        }
                        if (!ADJ_PREFIX_NUMBER.matcher(leftWord).matches()) break block42;
                        newAnalyzedTokens = new ArrayList<AnalyzedToken>();
                        String[] tags = LetterEndingForNumericHelper.findTags(leftWord, rightWord);
                        if (tags == null) break block43;
                        for (String tag : tags) {
                            String lemma = leftWord + "-\u0439";
                            newAnalyzedTokens.add(new AnalyzedToken(word, IPOSTag.adj.getText() + tag + ":&numr", lemma));
                        }
                        if (!"\u043c\u0430".equals(rightWord)) break block44;
                        newAnalyzedTokens.add(new AnalyzedToken(word, IPOSTag.noun.getText() + ":p:v_oru:&numr:bad", leftWord));
                        break block45;
                    }
                    if (!"\u043c\u0438".equals(rightWord) || !Pattern.compile("(.*[^1]|^)[78]").matcher(leftWord).matches()) break block45;
                    newAnalyzedTokens.add(new AnalyzedToken(word, "numr:p:v_rod:bad", leftWord));
                    newAnalyzedTokens.add(new AnalyzedToken(word, "numr:p:v_dav:bad", leftWord));
                    newAnalyzedTokens.add(new AnalyzedToken(word, "numr:p:v_mis:bad", leftWord));
                    break block45;
                }
                if (NOUN_PREFIX_NUMBER.matcher(leftWord).matches()) {
                    if (Pattern.compile("(\u0440\u0456\u0447\u0447|\u043b\u0456\u0442\u0442)(\u044f|\u044e|\u044f\u043c|\u0456)|\u043c\u0435\u0442\u0440\u0456\u0432(\u043a\u0430|\u043a\u0438|\u0446\u0456|\u043a\u0443|\u043a\u043e\u044e)").matcher(rightWord).matches()) {
                        List rightWdList3 = this.wordTagger.tag("\u0441\u0442\u043e" + rightWord);
                        List<AnalyzedToken> rightAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(rightWord, rightWdList3);
                        for (AnalyzedToken analyzedToken : rightAnalyzedTokens) {
                            String lemma = analyzedToken.getLemma().substring(3);
                            newAnalyzedTokens.add(new AnalyzedToken(word, analyzedToken.getPOSTag(), leftWord + "-" + lemma));
                        }
                        return newAnalyzedTokens;
                    }
                    if ("\u043c\u043c".equals(rightWord)) {
                        for (String gender : PosTagHelper.BASE_GENDERS) {
                            for (String vidm : PosTagHelper.VIDMINKY_MAP.keySet()) {
                                if (vidm.equals("v_kly")) continue;
                                String posTag = IPOSTag.adj.getText() + ":" + gender + ":" + vidm;
                                newAnalyzedTokens.add(new AnalyzedToken(word, posTag, word));
                            }
                        }
                        return newAnalyzedTokens;
                    }
                    if ("\u0442\u0438".equals(rightWord) && Pattern.compile(".*([0569]|1[0-9])").matcher(leftWord).matches()) {
                        newAnalyzedTokens.add(new AnalyzedToken(word, "numr:p:v_rod:bad", leftWord));
                        newAnalyzedTokens.add(new AnalyzedToken(word, "numr:p:v_dav:bad", leftWord));
                        newAnalyzedTokens.add(new AnalyzedToken(word, "numr:p:v_mis:bad", leftWord));
                    }
                }
                if ((rightWdList2 = this.wordTagger.tag(rightWord)).isEmpty()) {
                    return null;
                }
                List<AnalyzedToken> rightAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(rightWord, rightWdList2);
                for (AnalyzedToken analyzedToken : rightAnalyzedTokens) {
                    if (!analyzedToken.getPOSTag().startsWith(IPOSTag.adj.getText()) && !"\u0432\u0456\u0434\u0441\u043e\u0442\u043a\u043e\u0432\u043e".equals(analyzedToken.getLemma())) continue;
                    newAnalyzedTokens.add(new AnalyzedToken(word, analyzedToken.getPOSTag(), leftWord + "-" + analyzedToken.getLemma()));
                }
            }
            return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
        }
        if (NOUN_PREFIX_NUMBER.matcher(rightWord).matches() && NUMBERED_ENTITIES.contains(leftWord)) {
            ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>();
            List<String> gens = Arrays.asList("\u0412\u0410\u0417", "\u0417\u0410\u0417").contains(leftWord) ? Arrays.asList("m", "f") : Arrays.asList("m");
            for (String gen : gens) {
                for (String vidm : PosTagHelper.VIDMINKY_MAP.keySet()) {
                    if (vidm.equals("v_kly")) continue;
                    String posTag = "noun:" + gen + ":" + vidm + ":prop";
                    newAnalyzedTokens.add(new AnalyzedToken(word, posTag, word));
                }
            }
            return newAnalyzedTokens;
        }
        if (YEAR_NUMBER.matcher(rightWord).matches() && !leftWdList.isEmpty() && Character.isUpperCase(leftWord.charAt(0))) {
            List<AnalyzedToken> leftAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(leftWord, leftWdList);
            ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>();
            for (AnalyzedToken analyzedToken : leftAnalyzedTokens) {
                Object posTag;
                if (!PosTagHelper.hasPosTagPart(analyzedToken, ":prop") && !WORDS_WITH_YEAR.contains(analyzedToken.getLemma()) || (posTag = analyzedToken.getPOSTag()) == null || ((String)posTag).contains(TAG_ANIM) || ((String)posTag).contains("v_kly") || ((String)posTag).contains(":p:") && !Arrays.asList("\u0433\u0440\u0430", "\u0432\u0438\u0431\u043e\u0440\u0438", "\u0431\u044e\u0434\u0436\u0435\u0442").contains(analyzedToken.getLemma()) && !((String)posTag).contains(":ns") && !((String)posTag).startsWith("verb") || "\u0454\u0432\u0440\u043e".equals(analyzedToken.getLemma()) && !((String)posTag).contains(":m:")) continue;
                String lemma = analyzedToken.getLemma();
                if (!((String)posTag).contains(":prop")) {
                    posTag = (String)posTag + ":prop";
                    lemma = StringUtils.capitalize((String)lemma);
                }
                newAnalyzedTokens.add(new AnalyzedToken(word, (String)posTag, lemma + "-" + rightWord));
            }
            if (newAnalyzedTokens.size() > 0) {
                return newAnalyzedTokens;
            }
        }
        if (leftWord.equalsIgnoreCase("\u043f\u043e") && rightWord.endsWith("\u0441\u044c\u043a\u0438")) {
            rightWord = rightWord + "\u0439";
        }
        if ((rightWdList = this.wordTagger.tag(rightWord)).isEmpty()) {
            return null;
        }
        List<AnalyzedToken> rightAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(rightWord, rightWdList);
        if (leftWord.equalsIgnoreCase("\u043f\u043e")) {
            if (rightWord.endsWith("\u043e\u043c\u0443")) {
                return this.poAdvMatch(word, rightAnalyzedTokens, ADJ_TAG_FOR_PO_ADV_MIS);
            }
            if (rightWord.endsWith("\u0441\u044c\u043a\u0438\u0439")) {
                return this.poAdvMatch(word, rightAnalyzedTokens, ADJ_TAG_FOR_PO_ADV_NAZ);
            }
            return null;
        }
        List<AnalyzedToken> leftAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(leftWord, leftWdList);
        if (!(leftWord.equalsIgnoreCase(rightWord) || !PosTagHelper.hasPosTag(rightAnalyzedTokens, "(part|conj).*|.*:&pron.*") || PosTagHelper.hasPosTag(leftAnalyzedTokens, "numr.*") && PosTagHelper.hasPosTag(rightAnalyzedTokens, "numr.*"))) {
            return null;
        }
        if (Character.isUpperCase(rightWord.charAt(0))) {
            if (word.startsWith("\u043f\u0456\u0432-")) {
                ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(rightAnalyzedTokens.size());
                for (AnalyzedToken rightAnalyzedToken : rightAnalyzedTokens) {
                    String rightPosTag = rightAnalyzedToken.getPOSTag();
                    if (rightPosTag == null || !NOUN_SING_V_ROD_REGEX.matcher(rightPosTag).matches()) continue;
                    for (String vid : PosTagHelper.VIDMINKY_MAP.keySet()) {
                        if (vid.equals("v_kly")) continue;
                        String posTag = rightPosTag.replace("v_rod", vid);
                        newAnalyzedTokens.add(new AnalyzedToken(word, posTag, word));
                    }
                }
                return newAnalyzedTokens;
            }
            return null;
        }
        if (dashPrefixes.contains(leftWord) || dashPrefixes.contains(leftWord.toLowerCase()) || DASH_PREFIX_LAT_PATTERN.matcher(leftWord).matches()) {
            return this.getNvPrefixNounMatch(word, rightAnalyzedTokens, leftWord);
        }
        if (Character.isUpperCase(leftWord.charAt(0)) && LemmaHelper.CITY_AVENU.contains(rightWord)) {
            if (leftWdList.isEmpty()) {
                return null;
            }
            return this.cityAvenueMatch(word, leftAnalyzedTokens);
        }
        if (!PosTagHelper.hasPosTag(leftAnalyzedTokens, "intj.*") && !(noDashAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(noDashWord = word.replace("-", ""), noDashWordList = this.tagAsIsAndWithLowerCase(noDashWord))).isEmpty()) {
            return null;
        }
        if (!leftWdList.isEmpty() && (tagMatch = this.tagMatch(word, leftAnalyzedTokens, rightAnalyzedTokens)) != null) {
            return tagMatch;
        }
        if (LEFT_O_ADJ_INVALID.contains(leftWord.toLowerCase())) {
            return null;
        }
        if (O_ADJ_PATTERN.matcher(leftWord).matches()) {
            return this.oAdjMatch(word, rightAnalyzedTokens, leftWord);
        }
        this.compoundDebugLogger.logUnknownCompound(word);
        return null;
    }

    @Nullable
    private List<AnalyzedToken> cityAvenueMatch(String word, List<AnalyzedToken> leftAnalyzedTokens) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(leftAnalyzedTokens.size());
        for (AnalyzedToken analyzedToken : leftAnalyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!NOUN_V_NAZ_REGEX.matcher(posTag).matches()) continue;
            newAnalyzedTokens.add(new AnalyzedToken(word, posTag.replaceFirst("v_naz", "nv"), word));
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    @Nullable
    private List<AnalyzedToken> tagMatch(String word, List<AnalyzedToken> leftAnalyzedTokens, List<AnalyzedToken> rightAnalyzedTokens) {
        ArrayList<Object> newAnalyzedTokens = new ArrayList<AnalyzedToken>();
        ArrayList<AnalyzedToken> newAnalyzedTokensAnimInanim = new ArrayList<AnalyzedToken>();
        String animInanimNotTagged = null;
        for (AnalyzedToken leftAnalyzedToken : leftAnalyzedTokens) {
            Matcher matcher;
            String leftPosTag = leftAnalyzedToken.getPOSTag();
            if (leftPosTag == null || IPOSTag.contains(leftPosTag, IPOSTag.abbr.getText()) || leftPosTag.startsWith("noun") && leftPosTag.contains("v_kly")) continue;
            String leftPosTagExtra = "";
            boolean leftNv = false;
            if (leftPosTag.contains(NV_TAG)) {
                leftNv = true;
                leftPosTag = leftPosTag.replace(NV_TAG, "");
            }
            if ((matcher = EXTRA_TAGS_DROP.matcher(leftPosTag)).find()) {
                leftPosTag = matcher.replaceAll("");
            }
            if ((matcher = EXTRA_TAGS.matcher(leftPosTag)).find()) {
                leftPosTagExtra = leftPosTagExtra + matcher.group();
                leftPosTag = matcher.replaceAll("");
            }
            for (AnalyzedToken rightAnalyzedToken : rightAnalyzedTokens) {
                String leftGenderConj;
                String agreedPosTag;
                Matcher matcherR;
                String rightPosTag = rightAnalyzedToken.getPOSTag();
                if (rightPosTag == null || IPOSTag.contains(rightPosTag, IPOSTag.abbr.getText())) continue;
                String extraNvTag = "";
                boolean rightNv = false;
                if (rightPosTag.contains(NV_TAG)) {
                    rightNv = true;
                    if (leftNv) {
                        extraNvTag = extraNvTag + NV_TAG;
                    }
                }
                if ((matcherR = EXTRA_TAGS_DROP.matcher(rightPosTag)).find()) {
                    rightPosTag = matcherR.replaceAll("");
                }
                if ((matcherR = EXTRA_TAGS.matcher(rightPosTag)).find()) {
                    rightPosTag = matcherR.replaceAll("");
                }
                if (leftPosTag.equals(rightPosTag) && (IPOSTag.startsWith(leftPosTag, IPOSTag.numr, IPOSTag.adv, IPOSTag.adj, IPOSTag.verb) || IPOSTag.startsWith(leftPosTag, IPOSTag.intj) && leftAnalyzedToken.getLemma().equalsIgnoreCase(rightAnalyzedToken.getLemma()))) {
                    newAnalyzedTokens.add(new AnalyzedToken(word, leftPosTag + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                    continue;
                }
                if (leftPosTag.startsWith(IPOSTag.noun.getText()) && rightPosTag.startsWith(IPOSTag.noun.getText())) {
                    if (leftAnalyzedToken.getToken().equalsIgnoreCase(rightAnalyzedToken.getToken()) && leftPosTag.contains(TAG_ANIM) && rightPosTag.contains(TAG_ANIM)) continue;
                    agreedPosTag = this.getAgreedPosTag(leftPosTag, rightPosTag, leftNv, word);
                    if (agreedPosTag == null && rightPosTag.startsWith("noun:inanim:m:v_naz") && CompoundTagger.isMinMax(rightAnalyzedToken.getToken())) {
                        agreedPosTag = leftPosTag;
                    }
                    if (agreedPosTag == null && !CompoundTagger.isSameAnimStatus(leftPosTag, rightPosTag)) {
                        agreedPosTag = this.tryAnimInanim(leftPosTag, rightPosTag, leftAnalyzedToken.getLemma(), rightAnalyzedToken.getLemma(), leftNv, rightNv, word);
                        if (agreedPosTag == null) {
                            animInanimNotTagged = leftPosTag.contains(TAG_ANIM) ? "anim-inanim" : "inanim-anim";
                        } else {
                            newAnalyzedTokensAnimInanim.add(new AnalyzedToken(word, agreedPosTag + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                            continue;
                        }
                    }
                    if (agreedPosTag == null) continue;
                    newAnalyzedTokens.add(new AnalyzedToken(word, agreedPosTag + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                    continue;
                }
                if (leftPosTag.startsWith(IPOSTag.numr.getText()) && rightPosTag.startsWith(IPOSTag.numr.getText())) {
                    agreedPosTag = this.getNumAgreedPosTag(leftPosTag, rightPosTag, leftNv);
                    if (agreedPosTag == null) continue;
                    newAnalyzedTokens.add(new AnalyzedToken(word, agreedPosTag + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                    continue;
                }
                if (IPOSTag.startsWith(leftPosTag, IPOSTag.noun) && IPOSTag.startsWith(rightPosTag, IPOSTag.numr)) {
                    leftGenderConj = PosTagHelper.getGenderConj(leftPosTag);
                    if (leftGenderConj != null && leftGenderConj.equals(PosTagHelper.getGenderConj(rightPosTag))) {
                        newAnalyzedTokens.add(new AnalyzedToken(word, leftPosTag + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                        if (leftPosTag.contains(":p:")) continue;
                        newAnalyzedTokens.add(new AnalyzedToken(word, leftPosTag.replaceAll(":[mfn]:", ":p:") + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                        continue;
                    }
                    String agreedPosTag2 = this.getNumAgreedPosTag(leftPosTag, rightPosTag, leftNv);
                    if (agreedPosTag2 == null) continue;
                    newAnalyzedTokens.add(new AnalyzedToken(word, agreedPosTag2 + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                    if (agreedPosTag2.contains(":p:")) continue;
                    newAnalyzedTokens.add(new AnalyzedToken(word, agreedPosTag2.replaceAll(":[mfn]:", ":p:") + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                    continue;
                }
                if ((!leftPosTag.startsWith(IPOSTag.noun.getText()) || !IPOSTag.startsWith(rightPosTag, IPOSTag.numr)) && (!IPOSTag.startsWith(rightPosTag, IPOSTag.adj) || !this.isJuniorSenior(leftAnalyzedToken, rightAnalyzedToken)) || (leftGenderConj = PosTagHelper.getGenderConj(leftPosTag)) == null || !leftGenderConj.equals(PosTagHelper.getGenderConj(rightPosTag))) continue;
                newAnalyzedTokens.add(new AnalyzedToken(word, leftPosTag + extraNvTag + leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
            }
        }
        if (!newAnalyzedTokens.isEmpty() && !PosTagHelper.hasPosTagPart(newAnalyzedTokens, ":p:") && (LemmaHelper.hasLemma(leftAnalyzedTokens, LemmaHelper.DAYS_OF_WEEK) && LemmaHelper.hasLemma(rightAnalyzedTokens, LemmaHelper.DAYS_OF_WEEK) || LemmaHelper.hasLemma(leftAnalyzedTokens, LemmaHelper.MONTH_LEMMAS) && LemmaHelper.hasLemma(rightAnalyzedTokens, LemmaHelper.MONTH_LEMMAS))) {
            newAnalyzedTokens.add(new AnalyzedToken(word, ((AnalyzedToken)newAnalyzedTokens.get(0)).getPOSTag().replaceAll(":[mfn]:", ":p:"), ((AnalyzedToken)newAnalyzedTokens.get(0)).getLemma()));
        }
        if ((newAnalyzedTokens = new ArrayList<AnalyzedToken>(new LinkedHashSet<AnalyzedToken>(newAnalyzedTokens))).isEmpty()) {
            newAnalyzedTokens = newAnalyzedTokensAnimInanim;
        }
        if (animInanimNotTagged != null && newAnalyzedTokens.isEmpty()) {
            this.compoundDebugLogger.logUnknownCompound(word + " " + animInanimNotTagged);
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    private boolean isJuniorSenior(AnalyzedToken leftAnalyzedToken, AnalyzedToken rightAnalyzedToken) {
        return leftAnalyzedToken.getPOSTag().matches(".*?:[flp]name.*") && rightAnalyzedToken.getLemma().matches(".*(\u043c\u043e\u043b\u043e\u0434\u0448\u0438\u0439|\u0441\u0442\u0430\u0440\u0448\u0438\u0439)");
    }

    @Nullable
    private String getNumAgreedPosTag(String leftPosTag, String rightPosTag, boolean leftNv) {
        String leftConj;
        String agreedPosTag = null;
        if ((leftPosTag.contains(":p:") && SING_REGEX_F.matcher(rightPosTag).find() || SING_REGEX_F.matcher(leftPosTag).find() && rightPosTag.contains(":p:")) && (leftConj = PosTagHelper.getConj(leftPosTag)) != null && leftConj.equals(PosTagHelper.getConj(rightPosTag))) {
            agreedPosTag = leftPosTag;
        }
        return agreedPosTag;
    }

    @Nullable
    private String getAgreedPosTag(String leftPosTag, String rightPosTag, boolean leftNv, String word) {
        String substring2;
        String substring1;
        Matcher stdNounMatcherRight;
        boolean rightPlural;
        boolean leftPlural = CompoundTagger.isPlural(leftPosTag);
        if (leftPlural != (rightPlural = CompoundTagger.isPlural(rightPosTag))) {
            return null;
        }
        if (!CompoundTagger.isSameAnimStatus(leftPosTag, rightPosTag)) {
            return null;
        }
        Matcher stdNounMatcherLeft = stdNounTagRegex.matcher(leftPosTag);
        if (stdNounMatcherLeft.matches() && (stdNounMatcherRight = stdNounTagRegex.matcher(rightPosTag)).matches() && (substring1 = stdNounMatcherLeft.group(2)).equals(substring2 = stdNounMatcherRight.group(2))) {
            if (!stdNounMatcherLeft.group(1).equals(stdNounMatcherRight.group(1))) {
                this.compoundDebugLogger.logGenderMix(word, leftNv, leftPosTag, rightPosTag);
            }
            if (leftNv) {
                return rightPosTag;
            }
            return leftPosTag;
        }
        return null;
    }

    private static boolean isMinMax(String rightToken) {
        return rightToken.equals("\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c") || rightToken.equals("\u043c\u0456\u043d\u0456\u043c\u0443\u043c");
    }

    @Nullable
    private String tryAnimInanim(String leftPosTag, String rightPosTag, String leftLemma, String rightLemma, boolean leftNv, boolean rightNv, String word) {
        String agreedPosTag = null;
        if (leftMasterSet.contains(leftLemma)) {
            rightPosTag = leftPosTag.contains(TAG_ANIM) ? rightPosTag.replace(TAG_INANIM, TAG_ANIM) : rightPosTag.replace(TAG_ANIM, TAG_INANIM);
            agreedPosTag = this.getAgreedPosTag(leftPosTag, rightPosTag, leftNv, word);
            if (agreedPosTag == null) {
                if (!leftPosTag.contains(TAG_ANIM)) {
                    if (MNP_ZNA_REGEX.matcher(leftPosTag).matches() && MNP_NAZ_REGEX.matcher(rightPosTag).matches() && !leftNv && !rightNv) {
                        agreedPosTag = leftPosTag;
                    }
                } else if (MNP_ZNA_REGEX.matcher(leftPosTag).matches() && MNP_ROD_REGEX.matcher(rightPosTag).matches() && !leftNv && !rightNv) {
                    agreedPosTag = leftPosTag;
                }
            }
        } else if (slaveSet.contains(rightLemma)) {
            agreedPosTag = this.getAgreedPosTag(leftPosTag, rightPosTag = rightPosTag.replace(TAG_ANIM, TAG_INANIM), false, word);
            if (agreedPosTag == null && leftPosTag.contains(TAG_INANIM) && MNP_ZNA_REGEX.matcher(leftPosTag).matches() && MNP_NAZ_REGEX.matcher(rightPosTag).matches() && PosTagHelper.getNum(leftPosTag).equals(PosTagHelper.getNum(rightPosTag)) && !leftNv && !rightNv) {
                agreedPosTag = leftPosTag;
            }
        } else if (slaveSet.contains(leftLemma) && (agreedPosTag = this.getAgreedPosTag(rightPosTag, leftPosTag = leftPosTag.replace(TAG_ANIM, TAG_INANIM), false, word)) == null && rightPosTag.contains(TAG_INANIM) && MNP_ZNA_REGEX.matcher(rightPosTag).matches() && MNP_NAZ_REGEX.matcher(leftPosTag).matches() && PosTagHelper.getNum(leftPosTag).equals(PosTagHelper.getNum(rightPosTag)) && !leftNv && !rightNv) {
            agreedPosTag = rightPosTag;
        }
        return agreedPosTag;
    }

    private static boolean isSameAnimStatus(String leftPosTag, String rightPosTag) {
        boolean rightAnim;
        boolean leftAnim = leftPosTag.contains(TAG_ANIM);
        return leftAnim == (rightAnim = rightPosTag.contains(TAG_ANIM));
    }

    private static boolean isPlural(String posTag) {
        return posTag.startsWith("noun:") && posTag.contains(":p:");
    }

    @Nullable
    private List<AnalyzedToken> oAdjMatch(String word, List<AnalyzedToken> analyzedTokens, String leftWord) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(analyzedTokens.size());
        String leftBase = leftWord.substring(0, leftWord.length() - 1);
        String extraTag = "";
        if (!LEFT_O_ADJ.contains(leftWord.toLowerCase(this.conversionLocale))) {
            List<TaggedWord> taggedWords = this.tagBothCases(leftWord);
            if (taggedWords.isEmpty()) {
                taggedWords = this.tagBothCases(CompoundTagger.oToYj(leftWord));
            }
            if (taggedWords.isEmpty()) {
                taggedWords = this.tagBothCases(leftBase);
            }
            if (taggedWords.isEmpty()) {
                taggedWords = this.tagBothCases(leftBase + "\u0430");
            }
            if (taggedWords.isEmpty()) {
                return null;
            }
            for (TaggedWord taggedWord : taggedWords) {
                if (!taggedWord.getPosTag().contains(":bad")) continue;
                extraTag = ":bad";
                break;
            }
        }
        for (AnalyzedToken analyzedToken : analyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.startsWith(IPOSTag.adj.getText())) continue;
            if (posTag.contains(":comp") || posTag.contains(":super")) {
                posTag = posTag.replaceFirst(":comp[br]|:super", "");
            }
            newAnalyzedTokens.add(new AnalyzedToken(word, posTag + extraTag, leftWord.toLowerCase() + "-" + analyzedToken.getLemma()));
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    private static String oToYj(String leftWord) {
        return leftWord.endsWith("\u044c\u043e") ? leftWord.substring(0, leftWord.length() - 2) + "\u0456\u0439" : leftWord.substring(0, leftWord.length() - 1) + "\u0438\u0439";
    }

    @Nullable
    private List<AnalyzedToken> getNvPrefixNounMatch(String word, List<AnalyzedToken> analyzedTokens, String leftWord) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(analyzedTokens.size());
        for (AnalyzedToken analyzedToken : analyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.startsWith(IPOSTag.noun.getText()) || posTag.contains("v_kly")) continue;
            newAnalyzedTokens.add(new AnalyzedToken(word, posTag, leftWord + "-" + analyzedToken.getLemma()));
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    @Nullable
    private List<AnalyzedToken> poAdvMatch(String word, List<AnalyzedToken> analyzedTokens, String adjTag) {
        for (AnalyzedToken analyzedToken : analyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.startsWith(adjTag)) continue;
            return Arrays.asList(new AnalyzedToken(word, IPOSTag.adv.getText(), word));
        }
        return null;
    }

    private String capitalize(String word) {
        return word.substring(0, 1).toUpperCase(this.conversionLocale) + word.substring(1, word.length());
    }

    private List<TaggedWord> tagBothCases(String leftWord) {
        List leftWdList = this.wordTagger.tag(leftWord);
        String leftLowerCase = leftWord.toLowerCase(this.conversionLocale);
        if (!leftWord.equals(leftLowerCase)) {
            leftWdList.addAll(this.wordTagger.tag(leftLowerCase));
        } else {
            String leftUpperCase = this.capitalize(leftWord);
            if (!leftWord.equals(leftUpperCase)) {
                leftWdList.addAll(this.wordTagger.tag(leftUpperCase));
            }
        }
        return leftWdList;
    }

    private List<TaggedWord> tagAsIsAndWithLowerCase(String leftWord) {
        List leftWdList = this.wordTagger.tag(leftWord);
        String leftLowerCase = leftWord.toLowerCase(this.conversionLocale);
        if (!leftWord.equals(leftLowerCase)) {
            leftWdList.addAll(this.wordTagger.tag(leftLowerCase));
        }
        return leftWdList;
    }

    static {
        rightPartsWithLeftTagMap = new HashMap<String, Pattern>();
        LEFT_O_ADJ = Arrays.asList("\u0430\u0432\u0441\u0442\u0440\u043e", "\u0430\u0434\u0438\u0433\u043e", "\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u043e", "\u0430\u043d\u0433\u043b\u043e", "\u0430\u0444\u0440\u043e", "\u0435\u043a\u043e", "\u0435\u0442\u043d\u043e", "\u0456\u0441\u043f\u0430\u043d\u043e", "\u043a\u0438\u0454\u0432\u043e", "\u043c\u0430\u0440\u043e\u043a\u0430\u043d\u043e", "\u0443\u0433\u0440\u043e");
        LEFT_INVALID = Arrays.asList("\u0430\u0432\u0456\u0430", "\u0430\u0432\u0442\u043e", "\u0430\u0433\u0440\u043e", "\u0430\u043d\u0442\u0438", "\u0430\u0443\u0434\u0456\u043e", "\u0431\u0456\u043e", "\u0432\u0435\u043b\u043e", "\u0432\u0456\u0434\u0435\u043e", "\u0432\u043e\u0434\u043e", "\u0433\u0430\u0437\u043e", "\u0433\u0435\u043b\u0456\u043e", "\u0433\u0435\u043e", "\u0433\u0456\u0434\u0440\u043e", "\u0434\u0430\u0432\u043d\u044c\u043e", "\u0434\u0440\u0435\u0432\u043d\u044c\u043e", "\u0435\u043a\u0437\u043e", "\u0435\u043a\u0441\u0442\u0440\u0430", "\u0435\u043b\u0435\u043a\u0442\u0440\u043e", "\u0437\u043e\u043e", "\u0456\u0437\u043e", "\u043a\u0432\u0430\u0437\u0456", "\u043a\u0456\u043d\u043e", "\u043a\u043e\u0441\u043c\u043e", "\u043a\u043e\u043d\u0442\u0440", "\u043b\u0436\u0435", "\u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e", "\u043c\u0456\u043d\u0456\u043c\u0430\u043b\u044c\u043d\u043e", "\u043c\u0430\u043a\u0440\u043e", "\u043c\u0435\u0442\u0430", "\u043c\u0435\u0442\u0435\u043e", "\u043c\u0456\u043a\u0440\u043e", "\u043c\u0456\u043b\u0456", "\u043c\u043e\u043d\u043e", "\u043c\u043e\u0442\u043e", "\u043c\u0443\u043b\u044c\u0442\u0438", "\u043d\u0430\u043f\u0456\u0432", "\u043d\u0435\u043e", "\u043f\u0430\u043b\u0435\u043e", "\u043f\u043e\u0441\u0442", "\u043f\u0441\u0435\u0432\u0434\u043e", "\u0440\u0430\u0434\u0456\u043e", "\u0440\u0435\u043d\u0442\u0433\u0435\u043d\u043e", "\u0441\u043e\u0446\u0456\u043e", "\u0441\u0442\u0435\u0440\u0435\u043e", "\u0441\u0443\u043f\u0435\u0440", "\u0442\u0435\u043b\u0435", "\u0442\u0435\u0440\u043c\u043e", "\u0442\u0443\u0440\u0431\u043e", "\u0443\u043b\u044c\u0442\u0440\u0430", "\u0444\u043e\u043d\u043e", "\u0444\u043e\u0442\u043e");
        LEFT_O_ADJ_INVALID = Arrays.asList("\u0431\u0430\u0433\u0430\u0442\u043e", "\u043c\u0430\u043b\u043e", "\u0432\u0438\u0441\u043e\u043a\u043e", "\u043d\u0438\u0437\u044c\u043a\u043e");
        WORDS_WITH_YEAR = Arrays.asList("\u0454\u0432\u0440\u043e", "\u0433\u0440\u0430", "\u0431\u044e\u0434\u0436\u0435\u0442", "\u0432\u0438\u0431\u043e\u0440\u0438", "\u043e\u043b\u0456\u043c\u043f\u0456\u0430\u0434\u0430", "\u0443\u043d\u0456\u0432\u0435\u0440\u0441\u0456\u0430\u0434\u0430");
        NUMBERED_ENTITIES = Arrays.asList("\u0410\u043d", "\u0411\u043e\u0457\u043d\u0433", "\u0412\u0410\u0417", "\u0413\u0410\u0417", "\u041c\u0456", "\u041c\u0456\u0433", "\u0417\u0406\u041b", "\u0417\u0410\u0417", "\u0422", "\u0422\u0443", "\u0423\u0422", "\u042f\u043a", "\u0406\u043b", "\u0421\u0443");
        rightPartsWithLeftTagMap.put("\u0431\u043e", Pattern.compile("(verb.*:impr|.*pron|noun|adv|intj|part).*"));
        rightPartsWithLeftTagMap.put("\u043d\u043e", Pattern.compile("(verb.*:(impr|futr)|intj).*"));
        rightPartsWithLeftTagMap.put("\u043e\u0442", Pattern.compile("(.*pron|adv|part).*"));
        rightPartsWithLeftTagMap.put("\u0442\u043e", Pattern.compile("(adv.*pron|adj.*pron|conj).*"));
        rightPartsWithLeftTagMap.put("\u0442\u0430\u043a\u0438", Pattern.compile("(verb.*:(futr|past|pres)|adv|.*pron|part).*"));
        dashPrefixes = ExtraDictionaryLoader.loadSet("/uk/dash_prefixes.txt");
        leftMasterSet = ExtraDictionaryLoader.loadSet("/uk/dash_left_master.txt");
        slaveSet = ExtraDictionaryLoader.loadSet("/uk/dash_slaves.txt");
    }
}

