/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.uk.ExtraDictionaryLoader;
import org.languagetool.tagging.WordTagger;
import org.languagetool.tagging.uk.PosTagHelper;

public class MissingHyphenRule
extends Rule {
    private static final Set<String> dashPrefixes = ExtraDictionaryLoader.loadSet("/uk/dash_prefixes.txt");
    private static final Pattern ALL_LOWER = Pattern.compile("[\u0430-\u044f\u0456\u0457\u0454\u0491'-]+");
    private WordTagger wordTagger;

    public MissingHyphenRule(ResourceBundle messages, WordTagger wordTagger) throws IOException {
        super(messages);
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.wordTagger = wordTagger;
    }

    public final String getId() {
        return "UK_MISSING_HYPHEN";
    }

    public String getDescription() {
        return "\u041f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u0438\u0439 \u0434\u0435\u0444\u0456\u0441";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length - 1; ++i) {
            String tokenToCheck;
            AnalyzedTokenReadings tokenReadings = tokens[i];
            AnalyzedTokenReadings nextTokenReadings = tokens[i + 1];
            boolean isCapitalized = Character.isUpperCase(tokenReadings.getToken().charAt(0));
            if (!this.isInPrefixes(tokenReadings, isCapitalized) || !PosTagHelper.hasPosTagPart(nextTokenReadings, "noun") || !ALL_LOWER.matcher(nextTokenReadings.getToken()).matches()) continue;
            String hyphenedWord = tokenReadings.getToken() + "-" + nextTokenReadings.getToken();
            String string = tokenToCheck = isCapitalized ? StringUtils.uncapitalize((String)hyphenedWord) : hyphenedWord;
            if (this.wordTagger.tag(tokenToCheck).size() <= 0) continue;
            RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, sentence, tokenReadings.getStartPos(), nextTokenReadings.getEndPos(), "\u041c\u043e\u0436\u043b\u0438\u0432\u043e, \u043f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u043e \u0434\u0435\u0444\u0456\u0441?", this.getDescription());
            potentialRuleMatch.setSuggestedReplacement(hyphenedWord);
            ruleMatches.add(potentialRuleMatch);
        }
        return ruleMatches.toArray(new RuleMatch[0]);
    }

    private boolean isInPrefixes(AnalyzedTokenReadings tokenReadings, boolean isCapitalized) {
        String token = tokenReadings.getToken();
        if (isCapitalized) {
            token = StringUtils.uncapitalize((String)token);
        }
        return dashPrefixes.contains(token);
    }

    static {
        dashPrefixes.remove("\u0431\u043b\u043e\u043a");
        dashPrefixes.remove("\u0440\u0435\u0439\u0442\u0438\u043d\u0433");
        dashPrefixes.removeIf(s -> !ALL_LOWER.matcher((CharSequence)s).matches());
    }
}

