/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.uk;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedToken;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tagging.WordTagger;
import org.languagetool.tagging.uk.CompoundTagger;
import org.languagetool.tagging.uk.IPOSTag;
import org.languagetool.tagging.uk.PosTagHelper;
import org.languagetool.tools.StringTools;

public class UkrainianTagger
extends BaseTagger {
    static final Pattern NUMBER = Pattern.compile("[+-\u00b1]?[\u20ac\u20b4\\$]?[0-9]+(,[0-9]+)?([-\u2013\u2014][0-9]+(,[0-9]+)?)?(%|\u00b0\u0421?)?|\\d{1,3}([\\s\u00a0\u202f]\\d{3})+|(XC|XL|L?X{0,3})(IX|IV|V?I{0,3})");
    private static final Pattern DATE = Pattern.compile("[\\d]{2}\\.[\\d]{2}\\.[\\d]{4}");
    private static final Pattern TIME = Pattern.compile("([01]?[0-9]|2[0-3])[.:][0-5][0-9]");
    private static final Pattern ALT_DASHES_IN_WORD = Pattern.compile("[\u0430-\u044f\u0456\u0457\u0454\u04910-9a-z]\u2013[\u0430-\u044f\u0456\u0457\u0454\u0491]|[\u0430-\u044f\u0456\u0457\u0454\u0491]\u2013[0-9]", 66);
    private static final Pattern NAPIV_ALLOWED_TAGS_REGEX = Pattern.compile("(noun|ad(j|v(?!p))(?!.*?:comp[cs])).*");
    private static final Pattern NAPIV_REMOVE_TAGS_REGEX = Pattern.compile(":comp.|:&adjp(:(actv|pasv|perf|imperf))*");
    private final CompoundTagger compoundTagger;

    public String getManualAdditionsFileName() {
        return "/uk/added.txt";
    }

    public UkrainianTagger() {
        super("/uk/ukrainian.dict", new Locale("uk", "UA"), false);
        this.compoundTagger = new CompoundTagger(this, this.wordTagger, this.conversionLocale);
    }

    public List<AnalyzedToken> additionalTags(String word, WordTagger wordTagger) {
        if (NUMBER.matcher(word).matches()) {
            ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
            additionalTaggedTokens.add(new AnalyzedToken(word, IPOSTag.number.getText(), word));
            return additionalTaggedTokens;
        }
        if (TIME.matcher(word).matches()) {
            ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
            additionalTaggedTokens.add(new AnalyzedToken(word, IPOSTag.time.getText(), word));
            return additionalTaggedTokens;
        }
        if (DATE.matcher(word).matches()) {
            ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
            additionalTaggedTokens.add(new AnalyzedToken(word, IPOSTag.date.getText(), word));
            return additionalTaggedTokens;
        }
        if (word.indexOf(45) > 0) {
            List<AnalyzedToken> guessedCompoundTags = this.compoundTagger.guessCompoundTag(word);
            return guessedCompoundTags;
        }
        return this.guessOtherTags(word);
    }

    private List<AnalyzedToken> guessOtherTags(String word) {
        if (word.length() > 7 && StringTools.isCapitalizedWord((String)word) && (word.endsWith("\u0448\u0442\u0440\u0430\u0441\u0441\u0435") || word.endsWith("\u0448\u0442\u0440\u0430\u0441\u0435"))) {
            return PosTagHelper.generateTokensForNv(word, "f", ":prop");
        }
        return null;
    }

    protected List<AnalyzedToken> getAnalyzedTokens(String word) {
        String newWord;
        List<AnalyzedToken> newTokens;
        List<AnalyzedToken> tokens = super.getAnalyzedTokens(word);
        if (((AnalyzedToken)tokens.get(0)).hasNoTag()) {
            String origWord = word;
            if (word.endsWith("\u043c\u00b2") || word.endsWith("\u043c\u00b3")) {
                List<AnalyzedToken> newTokens2 = this.getAdjustedAnalyzedTokens(origWord, word = origWord.substring(0, word.length() - 1), Pattern.compile("noun:inanim.*"), null, null);
                return newTokens2.size() > 0 ? newTokens2 : tokens;
            }
            if (word.indexOf(8211) > 0 && ALT_DASHES_IN_WORD.matcher(word).find() && (newTokens = this.getAdjustedAnalyzedTokens(origWord, word = origWord.replace('\u2013', '-'), null, null, null)).size() > 0) {
                tokens = newTokens;
            }
            if (word.length() > 7 && word.startsWith("\u043d\u0430\u043f\u0456\u0432")) {
                String addPosTag = "";
                Matcher matcher = Pattern.compile("(\u043d\u0430\u043f\u0456\u0432['-]?)(.*)").matcher(word);
                matcher.matches();
                String prefix = matcher.group(1);
                String adjustedWord = matcher.group(2);
                List<AnalyzedToken> newTokens3 = this.getAdjustedAnalyzedTokens(origWord, adjustedWord, NAPIV_ALLOWED_TAGS_REGEX, null, null);
                if (newTokens3.size() > 0) {
                    if (!addPosTag.contains(":bad:")) {
                        if (word.charAt(5) == '-' && !adjustedWord.matches("[\u0410-\u042f\u0406\u0407\u0404\u0490].*")) {
                            addPosTag = addPosTag + ":bad";
                        } else if (word.charAt(5) != '\'' && adjustedWord.matches("[\u0454\u0457\u044e\u044f].*")) {
                            addPosTag = addPosTag + ":bad";
                        }
                    }
                    for (int i = 0; i < newTokens3.size(); ++i) {
                        AnalyzedToken analyzedToken = newTokens3.get(i);
                        String lemma = analyzedToken.getLemma();
                        String posTag = analyzedToken.getPOSTag();
                        posTag = NAPIV_REMOVE_TAGS_REGEX.matcher(posTag).replaceAll("");
                        posTag = PosTagHelper.addIfNotContains(posTag, addPosTag);
                        AnalyzedToken newToken = new AnalyzedToken(origWord, posTag, prefix + lemma);
                        newTokens3.set(i, newToken);
                    }
                    tokens = newTokens3;
                }
            } else if (word.contains("\u0491")) {
                tokens = this.convertTokens(tokens, word, "\u0491", "\u0433", ":alt");
            } else if (word.contains("\u0456\u044f")) {
                tokens = this.convertTokens(tokens, word, "\u0456\u044f", "\u0456\u0430", ":alt");
            } else if (word.endsWith("\u0442\u0435\u0440")) {
                tokens = this.convertTokens(tokens, word, "\u0442\u0435\u0440", "\u0442\u0440", ":alt");
            }
        }
        if (word.length() > 2 && StringUtils.isAllUpperCase((CharSequence)word) && (newTokens = this.getAdjustedAnalyzedTokens(word, newWord = StringUtils.capitalize((String)StringUtils.lowerCase((String)word)), Pattern.compile("noun.*?:prop.*"), null, null)).size() > 0) {
            if (((AnalyzedToken)tokens.get(0)).hasNoTag()) {
                tokens = newTokens;
            } else {
                tokens.addAll(newTokens);
            }
        }
        return tokens;
    }

    private List<AnalyzedToken> convertTokens(List<AnalyzedToken> origTokens, String word, String str, String dictStr, String additionalTag) {
        String adjustedWord = word.replace(str, dictStr);
        List<AnalyzedToken> newTokens = this.getAdjustedAnalyzedTokens(word, adjustedWord, null, additionalTag, lemma -> lemma.replace(dictStr, str));
        if (newTokens.isEmpty()) {
            return origTokens;
        }
        return newTokens;
    }

    private List<AnalyzedToken> getAdjustedAnalyzedTokens(String word, String adjustedWord, Pattern posTagRegex, String additionalTag, UnaryOperator<String> lemmaFunction) {
        List newTokens = super.getAnalyzedTokens(adjustedWord);
        if (((AnalyzedToken)newTokens.get(0)).hasNoTag()) {
            return new ArrayList<AnalyzedToken>();
        }
        ArrayList<AnalyzedToken> derivedTokens = new ArrayList<AnalyzedToken>();
        for (int i = 0; i < newTokens.size(); ++i) {
            AnalyzedToken analyzedToken = (AnalyzedToken)newTokens.get(i);
            String posTag = analyzedToken.getPOSTag();
            if (!adjustedWord.equals(analyzedToken.getToken()) || posTagRegex != null && !posTagRegex.matcher(posTag).matches()) continue;
            String lemma = analyzedToken.getLemma();
            if (lemmaFunction != null) {
                lemma = (String)lemmaFunction.apply(lemma);
            }
            if (additionalTag != null) {
                posTag = PosTagHelper.addIfNotContains(posTag, additionalTag);
            }
            AnalyzedToken newToken = new AnalyzedToken(word, posTag, lemma);
            derivedTokens.add(newToken);
        }
        return derivedTokens;
    }

    List<AnalyzedToken> asAnalyzedTokenListForTaggedWordsInternal(String word, List<TaggedWord> taggedWords) {
        return super.asAnalyzedTokenListForTaggedWords(word, taggedWords);
    }

    public WordTagger getWordTagger() {
        return super.getWordTagger();
    }
}

