/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.uk.InflectionHelper;
import org.languagetool.rules.uk.TokenAgreementNounVerbExceptionHelper;
import org.languagetool.tagging.uk.PosTagHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAgreementNounVerbRule
extends Rule {
    private static Logger logger = LoggerFactory.getLogger(TokenAgreementNounVerbRule.class);
    private static final Pattern VERB_INFLECTION_PATTERN = Pattern.compile(":([mfnps])(:([123])?|$)");
    private static final Pattern NOUN_INFLECTION_PATTERN = Pattern.compile("(?::((?:[iu]n)?anim))?:([mfnps]):(v_naz)");
    private static final Pattern NOUN_PERSON_PATTERN = Pattern.compile(":([123])");

    public TokenAgreementNounVerbRule(ResourceBundle messages) throws IOException {
        super.setCategory(Categories.MISC.getCategory(messages));
    }

    public final String getId() {
        return "UK_NOUN_VERB_INFLECTION_AGREEMENT";
    }

    public String getDescription() {
        return "\u0423\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043d\u044f \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u0430 \u0442\u0430 \u0434\u0456\u0454\u0441\u043b\u043e\u0432\u0430 \u0437\u0430 \u0440\u043e\u0434\u043e\u043c, \u0447\u0438\u0441\u043b\u043e\u043c \u0442\u0430 \u043e\u0441\u043e\u0431\u043e\u044e";
    }

    public String getShort() {
        return "\u0423\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043d\u044f \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u0430 \u0437 \u0434\u0456\u0454\u0441\u043b\u043e\u0432\u043e\u043c";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public final RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        ArrayList<AnalyzedToken> nounTokenReadings = new ArrayList<AnalyzedToken>();
        AnalyzedTokenReadings nounAnalyzedTokenReadings = null;
        block0: for (int i = 1; i < tokens.length; ++i) {
            Iterator token2;
            AnalyzedTokenReadings tokenReadings = tokens[i];
            String posTag0 = tokenReadings.getAnalyzedToken(0).getPOSTag();
            if (posTag0 == null) {
                nounTokenReadings.clear();
                continue;
            }
            if (nounTokenReadings.isEmpty()) {
                if (i == tokens.length - 1 || !PosTagHelper.hasPosTag(tokenReadings, "noun.*:v_naz.*")) continue;
                for (Iterator token2 : tokenReadings) {
                    String nounPosTag = token2.getPOSTag();
                    if (nounPosTag == null) continue;
                    if (nounPosTag.startsWith("noun") && nounPosTag.contains("v_naz")) {
                        nounTokenReadings.add((AnalyzedToken)token2);
                        nounAnalyzedTokenReadings = tokenReadings;
                        continue;
                    }
                    nounTokenReadings.clear();
                    continue block0;
                }
                continue;
            }
            if ("\u043d\u0435".equals(tokenReadings.getToken())) continue;
            ArrayList<AnalyzedToken> verbTokenReadings = new ArrayList<AnalyzedToken>();
            token2 = tokenReadings.iterator();
            while (token2.hasNext()) {
                AnalyzedToken token3 = (AnalyzedToken)token2.next();
                String verbPosTag = token3.getPOSTag();
                if (verbPosTag == null) continue;
                if (verbPosTag.startsWith("<")) {
                    verbTokenReadings.clear();
                    break;
                }
                if (verbPosTag.startsWith("verb")) {
                    verbTokenReadings.add(token3);
                    continue;
                }
                if (verbPosTag.equals("SENT_END")) continue;
                verbTokenReadings.clear();
                break;
            }
            if (verbTokenReadings.isEmpty()) {
                nounTokenReadings.clear();
                continue;
            }
            logger.debug("=== Checking\n\t{}\n\t{}", nounTokenReadings, verbTokenReadings);
            List<Inflection> masterInflections = TokenAgreementNounVerbRule.getNounInflections(nounTokenReadings);
            List<Inflection> slaveInflections = TokenAgreementNounVerbRule.getVerbInflections(verbTokenReadings);
            logger.debug("\t\t{}\n\t{}", masterInflections, slaveInflections);
            if (Collections.disjoint(masterInflections, slaveInflections)) {
                if (TokenAgreementNounVerbExceptionHelper.isException(tokens, i, masterInflections, slaveInflections, nounTokenReadings, verbTokenReadings)) {
                    nounTokenReadings.clear();
                    break;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(MessageFormat.format("=== Found noun/verb mismatch\n\t{0}\n\t{1}", nounAnalyzedTokenReadings.getToken() + ": " + masterInflections + " // " + nounAnalyzedTokenReadings, ((AnalyzedToken)verbTokenReadings.get(0)).getToken() + ": " + slaveInflections + " // " + verbTokenReadings));
                }
                String msg = String.format("\u041d\u0435 \u0443\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043e \u0456\u043c\u0435\u043d\u043d\u0438\u043a \u0437 \u0434\u0456\u0454\u0441\u043b\u043e\u0432\u043e\u043c: \"%s\" (%s) \u0456 \"%s\" (%s)", ((AnalyzedToken)nounTokenReadings.get(0)).getToken(), TokenAgreementNounVerbRule.formatInflections(masterInflections, true), ((AnalyzedToken)verbTokenReadings.get(0)).getToken(), TokenAgreementNounVerbRule.formatInflections(slaveInflections, false));
                RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, sentence, nounAnalyzedTokenReadings.getStartPos(), tokenReadings.getEndPos(), msg, this.getShort());
                ruleMatches.add(potentialRuleMatch);
            }
            nounTokenReadings.clear();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private static String formatInflections(List<Inflection> inflections, boolean noun) {
        Collections.sort(inflections);
        ArrayList<String> list = new ArrayList<String>();
        for (Inflection inflection : inflections) {
            String str = "";
            if (inflection.gender != null) {
                str = PosTagHelper.GENDER_MAP.get(inflection.gender);
            } else {
                if (inflection.person != null) {
                    str = PosTagHelper.PERSON_MAP.get(inflection.person);
                }
                if (inflection.plural != null) {
                    if (str.length() > 0) {
                        str = str + " ";
                    }
                    str = str + PosTagHelper.GENDER_MAP.get(inflection.plural);
                }
            }
            list.add(str);
        }
        LinkedHashSet uniqeList = new LinkedHashSet(list);
        return StringUtils.join(uniqeList, (String)", ");
    }

    static List<Inflection> getVerbInflections(List<AnalyzedToken> nounTokenReadings) {
        ArrayList<Inflection> verbGenders = new ArrayList<Inflection>();
        for (AnalyzedToken token : nounTokenReadings) {
            String posTag = token.getPOSTag();
            if (posTag == null || !posTag.startsWith("verb")) continue;
            if (posTag.contains(":inf")) {
                verbGenders.add(new Inflection("i", null));
                continue;
            }
            if (posTag.contains(":impers")) {
                verbGenders.add(new Inflection("o", null));
                continue;
            }
            Matcher matcher = VERB_INFLECTION_PATTERN.matcher(posTag);
            matcher.find();
            String gen = matcher.group(1);
            String person = matcher.group(3);
            verbGenders.add(new Inflection(gen, person));
        }
        return verbGenders;
    }

    static List<Inflection> getNounInflections(List<AnalyzedToken> nounTokenReadings) {
        ArrayList<Inflection> slaveInflections = new ArrayList<Inflection>();
        for (AnalyzedToken token : nounTokenReadings) {
            Matcher matcher;
            String posTag2 = token.getPOSTag();
            if (posTag2 == null || !(matcher = NOUN_INFLECTION_PATTERN.matcher(posTag2)).find()) continue;
            String gen = matcher.group(2);
            Matcher matcherPerson = NOUN_PERSON_PATTERN.matcher(posTag2);
            String person = matcherPerson.find() ? matcherPerson.group(1) : null;
            slaveInflections.add(new Inflection(gen, person));
        }
        return slaveInflections;
    }

    static boolean inflectionsOverlap(List<AnalyzedToken> verbTokenReadings, List<AnalyzedToken> nounTokenReadings) {
        return !Collections.disjoint(TokenAgreementNounVerbRule.getVerbInflections(verbTokenReadings), TokenAgreementNounVerbRule.getNounInflections(nounTokenReadings));
    }

    static class Inflection
    implements Comparable<Inflection> {
        final String gender;
        final String plural;
        final String person;

        Inflection(String gender, String person) {
            if (gender.equals("s") || gender.equals("p")) {
                this.gender = null;
                this.plural = gender;
            } else if (gender.equals("i")) {
                this.gender = gender;
                this.plural = gender;
            } else {
                this.gender = gender;
                this.plural = "s";
            }
            this.person = person;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Inflection other = (Inflection)obj;
            if (this.person != null && other.person != null && !this.person.equals(other.person)) {
                return false;
            }
            if (this.gender != null && other.gender != null) {
                if (this.gender.equals("i") || other.gender.equals("i")) {
                    return true;
                }
                if (!this.gender.equals(other.gender)) {
                    return false;
                }
            }
            return this.plural.equals(other.plural);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.gender == null ? 0 : this.gender.hashCode());
            result = 31 * result + (this.plural == null ? 0 : this.plural.hashCode());
            result = 31 * result + (this.person == null ? 0 : this.person.hashCode());
            return result;
        }

        public String toString() {
            return "Gender: " + this.gender + "/" + this.plural + "/" + this.person;
        }

        @Override
        public int compareTo(Inflection o) {
            Integer thisOrder = this.gender != null ? InflectionHelper.GEN_ORDER.get(this.gender) : Integer.valueOf(0);
            Integer otherOrder = o.gender != null ? InflectionHelper.GEN_ORDER.get(o.gender) : Integer.valueOf(0);
            int compared = thisOrder.compareTo(otherOrder);
            return compared;
        }
    }
}

