/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.uk;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedToken;

class CompoundDebugLogger {
    private static final String DEBUG_COMPOUNDS_PROPERTY = "org.languagetool.tagging.uk.UkrainianTagger.debugCompounds";
    private BufferedWriter compoundUnknownDebugWriter;
    private BufferedWriter compoundTaggedDebugWriter;
    private BufferedWriter compoundGenderMixDebugWriter;
    private BufferedWriter compoundTaggedLemmaDebugWriter;
    private static int cnt = 0;

    public CompoundDebugLogger() {
        if (Boolean.valueOf(System.getProperty(DEBUG_COMPOUNDS_PROPERTY)).booleanValue()) {
            this.initDebugCompounds();
        }
    }

    private synchronized void initDebugCompounds() {
        if (this.compoundUnknownDebugWriter == null) {
            try {
                this.compoundUnknownDebugWriter = this.createDebugOutFile("compounds-unknown.txt");
                this.compoundTaggedDebugWriter = this.createDebugOutFile("compounds-tagged.txt");
                this.compoundTaggedLemmaDebugWriter = this.createDebugOutFile("compounds-lemma-tagged.txt");
                this.compoundGenderMixDebugWriter = this.createDebugOutFile("gender-mix.txt");
            }
            catch (IOException ex) {
                System.err.println("Failed to open debug compounds file");
            }
        }
    }

    private BufferedWriter createDebugOutFile(String filename) throws IOException {
        Path unknownFile = Paths.get(filename, new String[0]);
        Files.deleteIfExists(unknownFile);
        unknownFile = Files.createFile(unknownFile, new FileAttribute[0]);
        return Files.newBufferedWriter(unknownFile, Charset.defaultCharset(), new OpenOption[0]);
    }

    public void logTaggedCompound(List<AnalyzedToken> guessedCompoundTags) {
        if (this.compoundTaggedDebugWriter == null || guessedCompoundTags == null) {
            return;
        }
        this.debug_tagged_write(guessedCompoundTags, this.compoundTaggedDebugWriter);
        guessedCompoundTags.stream().map(t -> t.getLemma()).collect(Collectors.toSet()).forEach(w -> this.logLine(this.compoundTaggedLemmaDebugWriter, (String)w));
    }

    public void logLine(BufferedWriter writer, String word) {
        if (writer == null) {
            return;
        }
        try {
            writer.append(word).append('\n');
            if (++cnt % 10 == 0) {
                writer.flush();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void logUnknownCompound(String word) {
        this.logLine(this.compoundUnknownDebugWriter, word);
    }

    private void debug_tagged_write(List<AnalyzedToken> analyzedTokens, BufferedWriter writer) {
        if (analyzedTokens.isEmpty() || analyzedTokens.get(0).getLemma() == null || analyzedTokens.get(0).getToken().trim().isEmpty()) {
            return;
        }
        try {
            String prevToken = "";
            String prevLemma = "";
            for (AnalyzedToken analyzedToken : analyzedTokens) {
                String lemma;
                String token = analyzedToken.getToken();
                boolean firstTag = false;
                if (!prevToken.equals(token)) {
                    if (prevToken.length() > 0) {
                        writer.append(";  ");
                        prevLemma = "";
                    }
                    writer.append(token).append(' ');
                    prevToken = token;
                    firstTag = true;
                }
                if (!prevLemma.equals(lemma = analyzedToken.getLemma())) {
                    if (prevLemma.length() > 0) {
                        writer.append(", ");
                    }
                    writer.append(lemma);
                    prevLemma = lemma;
                    firstTag = true;
                }
                writer.append(firstTag ? " " : "|").append(analyzedToken.getPOSTag());
                firstTag = false;
            }
            writer.newLine();
            if (++cnt % 10 == 0) {
                writer.flush();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void logGenderMix(String word, boolean leftNv, String leftPosTag, String rightPosTag) {
        if (this.compoundGenderMixDebugWriter != null) {
            try {
                this.compoundGenderMixDebugWriter.append(word + " " + (leftNv ? rightPosTag : leftPosTag));
                this.compoundGenderMixDebugWriter.newLine();
                this.compoundGenderMixDebugWriter.flush();
            }
            catch (IOException e) {
                System.err.println("Failed to write into gender mix file");
            }
        }
    }
}

