/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.tagging.uk.PosTagHelper;

public class MixedAlphabetsRule
extends Rule {
    private static final Pattern LIKELY_LATIN_NUMBER = Pattern.compile("[XVI\u0425\u0406]{2,8}(-[\u0430-\u044f\u0456\u0457\u0454]{1,3})?");
    private static final Pattern LATIN_NUMBER_WITH_CYRILLICS = Pattern.compile("(\u0425{1,3}\u0406{1,3}|\u0406{1,3}\u0425{1,3}|\u0425{2,3}|\u0406{2,3})(-[\u0430-\u044f\u0456\u0457\u0454]{1,4})?");
    private static final Pattern MIXED_ALPHABETS = Pattern.compile(".*([a-zA-Z\u00ef\u00e1\u00c1\u00e9\u00c9\u00ed\u00cd\u1e2f\u1e2e\u00f3\u00d3\u00fa\u00fd\u00dd]'?[\u0430-\u044f\u0456\u0457\u0454\u0491\u0410-\u042f\u0406\u0407\u0404\u0490]|[\u0430-\u044f\u0456\u0457\u0454\u0491\u0410-\u042f\u0406\u0407\u0404\u0490]'?[a-zA-Z\u00ef\u00e1\u00c1\u00e9\u00c9\u00ed\u00cd\u1e2f\u1e2e\u00f3\u00d3\u00fa\u00fd\u00dd]).*");
    private static final Pattern CYRILLIC_ONLY = Pattern.compile(".*[\u0431\u0432\u0433\u0491\u0434\u0454\u0436\u0437\u0438\u0439\u0457\u043b\u043d\u043f\u0444\u0446\u0447\u0448\u0449\u044c\u044e\u044f\u0411\u0413\u0490\u0414\u0404\u0416\u0417\u0418\u0419\u0407\u041b\u041f\u0424\u0426\u0427\u0428\u0429\u042c\u042e\u042f].*");
    private static final Pattern LATIN_ONLY = Pattern.compile(".*[bdfghjlqrstvzDFGJLNQRSUVZ].*");
    private static final Pattern COMMON_CYR_LETTERS = Pattern.compile("[\u0410\u0412\u0415\u0406\u041a\u041e\u0420\u0421\u0422\u0423\u0425]+");
    private static final Pattern CYRILLIC_FIRST_LETTER = Pattern.compile("[\u0430-\u044f\u0456\u0457\u0454\u0491\u0410-\u042f\u0406\u0407\u0404\u0490].*");
    private static final Map<Character, Character> toLatMap = new HashMap<Character, Character>();
    private static final Map<Character, Character> toCyrMap = new HashMap<Character, Character>();
    private static final String cyrChars = "\u0430\u0435\u0456\u0457\u043a\u043c\u043e\u0440\u0441\u0442\u0443\u0445\u0410\u0412\u0415\u0406\u041a\u041c\u041d\u041e\u0420\u0421\u0422\u0423\u0425";
    private static final String latChars = "aei\u00efkmopctyxABEIKMHOPCTYX";
    private static final String[] umlauts = new String[]{"\u00e1", "\u00c1", "\u00e9", "\u00c9", "\u00ed", "\u00cd", "\u1e2f", "\u1e2e", "\u00f3", "\u00d3", "\u00fa", "\u00fd", "\u00dd"};
    private static final String[] umlautsReplace = new String[]{"\u0430\u0301", "\u0410\u0301", "\u0435\u0301", "\u0415\u0301", "\u0456\u0301", "\u0406\u0301", "\u0457\u0301", "\u0407\u0301", "\u043e\u0301", "\u041e\u0301", "\u0438\u0301", "\u0443\u0301", "\u0423\u0301"};

    public MixedAlphabetsRule(ResourceBundle messages) throws IOException {
        super.setCategory(Categories.MISC.getCategory(messages));
    }

    public final String getId() {
        return "UK_MIXED_ALPHABETS";
    }

    public String getDescription() {
        return "\u0417\u043c\u0456\u0448\u0443\u0432\u0430\u043d\u043d\u044f \u043a\u0438\u0440\u0438\u043b\u0438\u0446\u0456 \u0439 \u043b\u0430\u0442\u0438\u043d\u0438\u0446\u0456";
    }

    private String getShort() {
        return "\u041c\u0456\u0448\u0430\u043d\u0438\u043d\u0430 \u0440\u043e\u0437\u043a\u043b\u0430\u0434\u043e\u043a";
    }

    public final RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length; ++i) {
            RuleMatch potentialRuleMatch;
            String msg;
            ArrayList<String> replacements;
            String prevLemma;
            RuleMatch potentialRuleMatch2;
            String msg2;
            ArrayList<String> replacements2;
            String msg3;
            AnalyzedTokenReadings tokenReadings = tokens[i];
            String tokenString = tokenReadings.getCleanToken();
            if (i < tokens.length - 1 && (tokenString.matches("[iya]") || tokenString.equals("A") && i == 1) && CYRILLIC_FIRST_LETTER.matcher(tokens[i + 1].getToken()).matches() && Arrays.stream(tokens).noneMatch(t -> t.getToken().matches("[xbB]"))) {
                msg3 = "\u0412\u0436\u0438\u0442\u043e \u043b\u0430\u0442\u0438\u043d\u0441\u044c\u043a\u0443 \u00ab" + tokenString + "\u00bb \u0437\u0430\u043c\u0456\u0441\u0442\u044c \u043a\u0438\u0440\u0438\u043b\u0438\u0447\u043d\u043e\u0457";
                RuleMatch potentialRuleMatch3 = this.createRuleMatch(tokenReadings, Arrays.asList(MixedAlphabetsRule.toCyrillic(tokenString)), msg3, sentence);
                ruleMatches.add(potentialRuleMatch3);
            } else if ("\u0406".equals(tokenString) && this.likelyBadLatinI(tokens, i)) {
                replacements2 = new ArrayList<String>();
                replacements2.add(MixedAlphabetsRule.toLatin(tokenString));
                msg2 = "\u0412\u0436\u0438\u0442\u043e \u043a\u0438\u0440\u0438\u043b\u0438\u0447\u043d\u0443 \u043b\u0456\u0442\u0435\u0440\u0443 \u0437\u0430\u043c\u0456\u0441\u0442\u044c \u043b\u0430\u0442\u0438\u043d\u0441\u044c\u043a\u043e\u0457";
                potentialRuleMatch2 = this.createRuleMatch(tokenReadings, replacements2, msg2, sentence);
                ruleMatches.add(potentialRuleMatch2);
            } else if (i <= tokens.length - 1 && "\u0406.".equals(tokenString) && i > 1 && !"\u0422\u043e\u043c\u0443".equals(tokens[i - 1].getCleanToken()) && !"\u0424\u0440\u0430\u043d\u043a\u043e".equals(tokens[i - 1].getCleanToken()) && PosTagHelper.hasPosTag(tokens[i - 1], Pattern.compile("(?!.*:abbr).*fname.*"))) {
                replacements2 = new ArrayList();
                replacements2.add(MixedAlphabetsRule.toLatin(tokenString));
                msg2 = "\u0412\u0436\u0438\u0442\u043e \u043a\u0438\u0440\u0438\u043b\u0438\u0447\u043d\u0443 \u043b\u0456\u0442\u0435\u0440\u0443 \u0437\u0430\u043c\u0456\u0441\u0442\u044c \u043b\u0430\u0442\u0438\u043d\u0441\u044c\u043a\u043e\u0457";
                potentialRuleMatch2 = this.createRuleMatch(tokenReadings, replacements2, msg2, sentence);
                ruleMatches.add(potentialRuleMatch2);
            } else if (COMMON_CYR_LETTERS.matcher(tokenString).matches() && (prevLemma = tokens[i - 1].getAnalyzedToken(0).getLemma()) != null && prevLemma.matches("\u0433\u0435\u043f\u0430\u0442\u0438\u0442|\u0433\u0440\u0443\u043f\u0430|\u0442\u0443\u0440\u043d\u0456\u0440")) {
                replacements = new ArrayList();
                replacements.add(MixedAlphabetsRule.toLatin(tokenString));
                msg = "\u0412\u0436\u0438\u0442\u043e \u043a\u0438\u0440\u0438\u043b\u0438\u0447\u043d\u0443 \u043b\u0456\u0442\u0435\u0440\u0443 \u0437\u0430\u043c\u0456\u0441\u0442\u044c \u043b\u0430\u0442\u0438\u043d\u0441\u044c\u043a\u043e\u0457";
                potentialRuleMatch = this.createRuleMatch(tokenReadings, replacements, msg, sentence);
                ruleMatches.add(potentialRuleMatch);
            }
            if (tokenString.length() < 2) {
                if (!tokenString.equals("\u00b0") || i >= tokens.length - 1 || !tokens[i + 1].getCleanToken().equals("\u0421")) continue;
                replacements2 = new ArrayList();
                replacements2.add("C");
                msg2 = "\u0412\u0436\u0438\u0442\u043e \u043a\u0438\u0440\u0438\u043b\u0438\u0447\u043d\u0443 \u043b\u0456\u0442\u0435\u0440\u0443 \u0437\u0430\u043c\u0456\u0441\u0442\u044c \u043b\u0430\u0442\u0438\u043d\u0441\u044c\u043a\u043e\u0457";
                potentialRuleMatch2 = this.createRuleMatch(tokens[i + 1], replacements2, msg2, sentence);
                ruleMatches.add(potentialRuleMatch2);
                continue;
            }
            if (MIXED_ALPHABETS.matcher(tokenString).matches()) {
                msg3 = "\u0412\u0436\u0438\u0442\u043e \u043a\u0438\u0440\u0438\u043b\u0438\u0447\u043d\u0456 \u0439 \u043b\u0430\u0442\u0438\u043d\u0441\u044c\u043a\u0456 \u043b\u0456\u0442\u0435\u0440\u0438 \u0432 \u043e\u0434\u043d\u043e\u043c\u0443 \u0441\u043b\u043e\u0432\u0456";
                replacements = new ArrayList<String>();
                if (!LATIN_ONLY.matcher(tokenString).matches() && !LIKELY_LATIN_NUMBER.matcher(tokenString).matches()) {
                    replacements.add(MixedAlphabetsRule.toCyrillic(tokenString));
                }
                if (!CYRILLIC_ONLY.matcher(tokenString).matches() || LIKELY_LATIN_NUMBER.matcher(tokenString).matches()) {
                    String converted = this.toLatinLeftOnly(tokenString);
                    converted = this.adjustForInvalidSuffix(converted);
                    replacements.add(converted);
                    msg3 = "\u0412\u0436\u0438\u0442\u043e \u043a\u0438\u0440\u0438\u043b\u0438\u0447\u043d\u0456 \u043b\u0456\u0442\u0435\u0440\u0438 \u0437\u0430\u043c\u0456\u0441\u0442\u044c \u043b\u0430\u0442\u0438\u043d\u0441\u044c\u043a\u0438\u0445";
                    msg3 = this.adjustForInvalidSuffix(tokenString, msg3);
                }
                if (replacements.size() > 0) {
                    potentialRuleMatch2 = this.createRuleMatch(tokenReadings, replacements, msg3, sentence);
                    ruleMatches.add(potentialRuleMatch2);
                }
            } else if (LATIN_NUMBER_WITH_CYRILLICS.matcher(tokenString).matches()) {
                replacements2 = new ArrayList();
                String converted = this.toLatinLeftOnly(tokenString);
                converted = this.adjustForInvalidSuffix(converted);
                replacements2.add(converted);
                msg = "\u0412\u0436\u0438\u0442\u043e \u043a\u0438\u0440\u0438\u043b\u0438\u0447\u043d\u0456 \u043b\u0456\u0442\u0435\u0440\u0438 \u0437\u0430\u043c\u0456\u0441\u0442\u044c \u043b\u0430\u0442\u0438\u043d\u0441\u044c\u043a\u0438\u0445 \u043d\u0430 \u043f\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u0440\u0438\u043c\u0441\u044c\u043a\u043e\u0457 \u0446\u0438\u0444\u0440\u0438";
                msg = this.adjustForInvalidSuffix(tokenString, msg);
                potentialRuleMatch = this.createRuleMatch(tokenReadings, replacements2, msg, sentence);
                ruleMatches.add(potentialRuleMatch);
            }
            if (tokenString.indexOf(774) <= 0 && tokenString.indexOf(776) <= 0 || !tokenString.matches(".*(\u0438\u0306|\u0456\u0308).*")) continue;
            String fix = tokenString.replaceAll("\u0438\u0306", "\u0439").replaceAll("\u0456\u0308", "\u0457");
            msg2 = "\u0412\u0436\u0438\u0442\u043e \u043a\u043e\u043c\u0431\u0456\u043d\u043e\u0432\u0430\u043d\u0456 \u0441\u0438\u043c\u0432\u043e\u043b\u0438 \u0437\u0430\u043c\u0456\u0441\u0442\u044c \u0443\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0438\u0445 \u043b\u0456\u0442\u0435\u0440";
            potentialRuleMatch2 = this.createRuleMatch(tokenReadings, Arrays.asList(fix), msg2, sentence);
            ruleMatches.add(potentialRuleMatch2);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean likelyBadLatinI(AnalyzedTokenReadings[] tokens, int i) {
        return i > 1 && (LemmaHelper.isCapitalized(tokens[i - 1].getCleanToken()) || PosTagHelper.hasPosTagStart(tokens[i - 1], "prep") && i < tokens.length - 1 && !LemmaHelper.isAllUppercaseUk(tokens[i + 1].getCleanToken()) || i < tokens.length - 1 && Arrays.asList("\u0441\u0442.", "\u0442\u0438\u0441.").contains(tokens[i + 1].getCleanToken()) || i < tokens.length - 1 && Arrays.asList("\u043a\u0432\u0430\u0440\u0442\u0430\u043b", "\u043f\u0456\u0432\u0440\u0456\u0447\u0447\u044f", "\u0442\u0438\u0441\u044f\u0447\u043e\u043b\u0456\u0442\u0442\u044f", "\u043f\u043e\u043b\u043e\u0432\u0438\u043d\u0430").contains(tokens[i + 1].getCleanToken()));
    }

    private String adjustForInvalidSuffix(String tokenString) {
        if (tokenString.contains("-")) {
            tokenString = tokenString.replaceFirst("-[\u0430-\u044f\u0456\u0457\u0454]{1,4}", "");
        }
        return tokenString;
    }

    private String adjustForInvalidSuffix(String tokenString, String msg) {
        if (tokenString.contains("-") && tokenString.matches("[IVX\u0406\u0425]+-[\u0430-\u044f\u0456\u0457\u0454]{1,4}")) {
            msg = msg + ". \u0422\u0430\u043a\u043e\u0436: \u0434\u043e \u0440\u0438\u043c\u0441\u044c\u043a\u0438\u0445 \u0446\u0438\u0444\u0440 \u0431\u0443\u043a\u0432\u0438 \u043d\u0435 \u0434\u043e\u043f\u0438\u0441\u0443\u044e\u0442\u044c\u0441\u044f.";
        }
        return msg;
    }

    private String toLatinLeftOnly(String tokenString) {
        String[] parts = tokenString.split("-", 2);
        String right = parts.length > 1 ? "-" + parts[1] : "";
        String converted = MixedAlphabetsRule.toLatin(parts[0]) + right;
        return converted;
    }

    private RuleMatch createRuleMatch(AnalyzedTokenReadings readings, List<String> replacements, String msg, AnalyzedSentence sentence) {
        RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, sentence, readings.getStartPos(), readings.getEndPos(), msg, this.getShort());
        potentialRuleMatch.setSuggestedReplacements(replacements);
        return potentialRuleMatch;
    }

    private static String toCyrillic(String word) {
        for (Map.Entry<Character, Character> entry : toCyrMap.entrySet()) {
            word = word.replace(entry.getKey().charValue(), entry.getValue().charValue());
        }
        for (int i = 0; i < umlauts.length; ++i) {
            word = word.replace(umlauts[i], umlautsReplace[i]);
        }
        return word;
    }

    private static String toLatin(String word) {
        for (Map.Entry<Character, Character> entry : toLatMap.entrySet()) {
            word = word.replace(entry.getKey().charValue(), entry.getValue().charValue());
        }
        return word;
    }

    static {
        for (int i = 0; i < cyrChars.length(); ++i) {
            toLatMap.put(Character.valueOf(cyrChars.charAt(i)), Character.valueOf(latChars.charAt(i)));
            toCyrMap.put(Character.valueOf(latChars.charAt(i)), Character.valueOf(cyrChars.charAt(i)));
        }
    }
}

