/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.uk.InflectionHelper;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.rules.uk.TokenAgreementAdjNounRule;
import org.languagetool.rules.uk.TokenAgreementNumrNounExceptionHelper;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.uk.PosTagHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAgreementNumrNounRule
extends Rule {
    private static final Logger logger = LoggerFactory.getLogger(TokenAgreementNumrNounRule.class);
    private static final Pattern NOUN_IGNORE_PATTERN = Pattern.compile(".*(prop|noun.*pron|v_oru).*");
    private static final Pattern NUMR_PATTERN = Pattern.compile("numr(?!.*abbr).*");
    private static final Pattern NOUN_NUMR_ALL_PATTERN = Pattern.compile("noun:inanim:([mf]:v_naz|p:v_(naz|rod)):&numr.*|numr.*abbr.*|number");
    static final Pattern DVA_3_4_PATTERN = Pattern.compile("\u043e\u0431\u0438(\u0434\u0432\u0430|\u0434\u0432\u0456)|(.+-)?((\u0434\u0432\u0430|\u0434\u0432\u0456)|\u0442\u0440\u0438|\u0447\u043e\u0442\u0438\u0440\u0438)");
    private static final Pattern DVA_PATTERN = Pattern.compile("(\u043e\u0431\u0438)?\u0434\u0432\u0430|.+-\u0434\u0432\u0430", 66);
    private static final Pattern DVI_PATTERN = Pattern.compile("(\u043e\u0431\u0438)?\u0434\u0432\u0456|.+-\u0434\u0432\u0456", 66);
    private static final Pattern _1_5 = Pattern.compile("([0-9]+[\u2013-])?1,5");
    private static final Pattern _2_5 = Pattern.compile(".*(?<!1)[234],5");
    private static final Pattern _5_5 = Pattern.compile("([0-9]+[\u2013-])?([0-9\\h]*[05-9]|[0-9\\h]*1[1-4]),5");
    private static final Pattern _FRA = Pattern.compile(".*,[1-9]+");
    private static final Pattern _2to4 = Pattern.compile("([0-9]+[\u2013-])?[^,]*(?<!1)[234]");
    private static final Pattern _5to9 = Pattern.compile("[0-9\\h]*([5-90]|1[2-4])");
    private static final Pattern _5to9_ALPHA = Pattern.compile("(.+-)?(\u043f.\u044f\u0442\u044c|\u0448\u0456\u0441\u0442\u044c|\u0441\u0456\u043c|\u0432\u0456\u0441\u0456\u043c|(\u0442\u0440\u0438)?\u0434\u0435\u0432.?\u044f\u0442\u044c|.*\u0434\u0446\u044f\u0442\u044c|\u0441\u043e\u0440\u043e\u043a|.*\u0434\u0435\u0441\u044f\u0442\u044c?|\u0434\u0435\u0432.\u044f\u043d\u043e\u0441\u0442\u043e|\u0441\u0442\u043e|\u0434\u0432\u0456\u0441\u0442\u0456|\u0442\u0440\u0438\u0441\u0442\u0430|\u0447\u043e\u0442\u0438\u0440\u0438\u0441\u0442\u0430|\u043f\u0456\u0432\u0442\u043e\u0440\u0430\u0441\u0442\u0430|.+\u0441\u043e\u0442)|(\u0434\u0435)?\u043a\u0456\u043b\u044c\u043a\u0430|\u043a\u0456\u043b\u044c\u043a\u043e\u0445|\u0430\u043d\u0456\u0441\u043a\u0456\u043b\u044c\u043a\u0438");
    private static final Pattern NOUN_FORCE_PATTERN = Pattern.compile("\u0447\u043e\u043b\u043e\u0432\u0456\u043a|\u0441\u043e\u043b\u0434\u0430\u0442|\u0442\u043e\u043d|(\u043d\u0430\u043d\u043e|\u043c\u0456\u043a\u0440\u043e|\u043c\u0456\u043b\u0456|\u0434\u0435\u043a\u0430|\u043a\u0456\u043b\u043e|\u043c\u0435\u0433\u0430|\u0433\u0456\u0433\u0430|\u0442\u0435\u0440\u0430|\u043f\u0435\u0442\u0430)?(\u0433\u0435\u0440\u0446|\u0431\u0430\u0439\u0442|\u0431\u0456\u0442|\u0431\u0430\u0440|\u0431\u0435\u0440|\u0432\u0430\u0442|\u0432\u043e\u043b\u044c\u0442|\u0434\u0435\u0446\u0438\u0431\u0435\u043b|\u0440\u0435\u043d\u0442\u0433\u0435\u043d|\u043c\u043e\u043b\u044c|\u043c\u0456\u043a\u0440\u043e\u043d|\u0433\u0440\u0430\u043c|\u0430\u0440\u0448\u0438\u043d|\u043b\u0430\u0442|\u043a\u0430\u0440\u0430\u0442)");
    private final Synthesizer synthesizer;

    public TokenAgreementNumrNounRule(ResourceBundle messages, Language ukrainian) throws IOException {
        super.setCategory(Categories.MISC.getCategory(messages));
        this.synthesizer = ukrainian.getSynthesizer();
    }

    public final String getId() {
        return "UK_NUMR_NOUN_INFLECTION_AGREEMENT";
    }

    public String getDescription() {
        return "\u0423\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043d\u044f \u0432\u0456\u0434\u043c\u0456\u043d\u043a\u0456\u0432, \u0440\u043e\u0434\u0443 \u0456 \u0447\u0438\u0441\u043b\u0430 \u0447\u0438\u0441\u043b\u0456\u0432\u043d\u0438\u043a\u0430 \u0442\u0430 \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u0430";
    }

    public String getShort() {
        return "\u0423\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043d\u044f \u0447\u0438\u0441\u043b\u0456\u0432\u043d\u0438\u043a\u0430 \u0442\u0430 \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u0430";
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public final RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ruleMatches = new ArrayList<RuleMatch>();
        tokens = sentence.getTokensWithoutWhitespace();
        state = new State();
        for (i = 1; i < tokens.length; ++i) {
            block80: {
                block79: {
                    tokenReadings = tokens[i];
                    posTag0 = tokenReadings.getAnalyzedToken(0).getPOSTag();
                    cleanToken = tokenReadings.getCleanToken();
                    if (posTag0 == null || cleanToken == null) {
                        state.reset();
                        continue;
                    }
                    if (state.isEmpty() && i == tokens.length - 1) continue;
                    cleanTokenLower = cleanToken.toLowerCase();
                    if (PosTagHelper.hasPosTag(tokens[i], TokenAgreementNumrNounRule.NOUN_NUMR_ALL_PATTERN)) {
                        if (i < tokens.length - 1 && TokenAgreementNumrNounRule.NOUN_FORCE_PATTERN.matcher(tokens[i + 1].getCleanToken().toLowerCase()).matches()) {
                            state.reset();
                            state.numrPos = i;
                            state.numrTokenReadings.add(tokenReadings.getAnalyzedToken(0));
                            state.numrAnalyzedTokenReadings = tokenReadings;
                            state.number = PosTagHelper.hasPosTagStart(tokens[i], "number");
                            continue;
                        }
                        if (i < tokens.length - 2 && PosTagHelper.hasPosTag(tokens[i + 1], Pattern.compile("adj:p:v_rod.*")) && TokenAgreementNumrNounRule.NOUN_FORCE_PATTERN.matcher(tokens[i + 2].getCleanToken().toLowerCase()).matches()) {
                            state.reset();
                            state.numrPos = i;
                            state.numrTokenReadings.add(tokenReadings.getAnalyzedToken(0));
                            state.numrAnalyzedTokenReadings = tokenReadings;
                            state.number = PosTagHelper.hasPosTagStart(tokens[i], "number");
                            ++i;
                            continue;
                        }
                    }
                    if (PosTagHelper.hasPosTag(tokens[i], TokenAgreementNumrNounRule.NUMR_PATTERN)) {
                        state.reset();
                        if (cleanToken.matches(".*[0-9]-[\u0430-\u044f\u0456\u0457\u0454\u0491].*")) continue;
                        if (LemmaHelper.hasLemma(tokenReadings, Arrays.asList(new String[]{"\u043c\u0430\u0442\u0438"}), "verb")) {
                            state.reset();
                            continue;
                        }
                        if (LemmaHelper.hasLemma(tokenReadings, Arrays.asList(new String[]{"\u043e\u0434\u0438\u043d"}))) {
                            state.reset();
                            continue;
                        }
                        for (AnalyzedToken token : tokenReadings) {
                            adjPosTag = token.getPOSTag();
                            if (adjPosTag == null || !adjPosTag.startsWith("numr") && !TokenAgreementNumrNounRule.NOUN_NUMR_ALL_PATTERN.matcher(adjPosTag).matches()) continue;
                            state.numrPos = i;
                            state.numrTokenReadings.add(token);
                            state.numrAnalyzedTokenReadings = tokenReadings;
                        }
                        continue;
                    }
                    if (PosTagHelper.hasPosTag(tokens[i], "number")) {
                        state.numrPos = i;
                        state.numrTokenReadings.addAll(tokens[i].getReadings());
                        state.numrAnalyzedTokenReadings = tokenReadings;
                        state.number = true;
                        continue;
                    }
                    if (state.isEmpty()) continue;
                    if (i < tokens.length - 2 && cleanTokenLower.matches("\u0437|\u0456\u0437|\u0437\u0456") && tokens[i + 1].getCleanToken().toLowerCase().matches("\u043f\u043e\u043b\u043e\u0432\u0438\u043d\u043e\u044e|\u0442\u0440\u0435\u0442\u0438\u043d\u043e\u044e|\u0447\u0432\u0435\u0440\u0442\u044e")) {
                        ++i;
                        continue;
                    }
                    if (i < tokens.length - 1 && (TokenAgreementNumrNounRule._2to4.matcher(state.numrAnalyzedTokenReadings.getCleanToken().toLowerCase()).matches() || TokenAgreementNumrNounRule.DVA_3_4_PATTERN.matcher(state.numrAnalyzedTokenReadings.getCleanToken().toLowerCase()).matches()) && PosTagHelper.hasPosTag(tokens[i], Pattern.compile("adj:p:v_(rod|naz).*")) && PosTagHelper.hasPosTagAndToken(tokens[i + 1], Pattern.compile(".*:m:v_rod.*"), Pattern.compile(".*[\u0430\u044f]"))) continue;
                    numrCleanToken = state.numrAnalyzedTokenReadings.getCleanToken();
                    numrToken = numrCleanToken.toLowerCase();
                    if ((numrToken.matches("(\u043e\u0434\u0438\u043d-|\u043e\u0434\u043d\u0435-)?\u043f\u0456\u0432\u0442\u043e\u0440\u0430") || TokenAgreementNumrNounRule._FRA.matcher(numrToken).matches()) && cleanTokenLower.matches("\u0440\u0430\u0437|\u0440\u0430\u0437\u0438|\u0440\u0430\u0437\u0443|\u0440\u0430\u0437\u0456\u0432")) {
                        msg = "\u041f\u0456\u0441\u043b\u044f \u0434\u0435\u0441\u044f\u0442\u043a\u043e\u0432\u043e\u0433\u043e \u0434\u0440\u043e\u0431\u0443 \u0430\u0431\u043e \u00ab\u043f\u0456\u0432\u0442\u043e\u0440\u0430\u00bb \u0442\u0440\u0435\u0431\u0430 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0440\u0430\u0437\u0430\u00bb";
                        url = "http://www.kulturamovy.org.ua/KM/pdfs/mix/61-12-65-26.pdf";
                        potentialRuleMatch = new RuleMatch((Rule)this, sentence, state.numrAnalyzedTokenReadings.getStartPos(), tokenReadings.getEndPos(), msg, this.getShort());
                        potentialRuleMatch.addSuggestedReplacement(state.numrAnalyzedTokenReadings.getToken() + " \u0440\u0430\u0437\u0430");
                        potentialRuleMatch.setUrl(new URL(url));
                        ruleMatches.add(potentialRuleMatch);
                        state.reset();
                        continue;
                    }
                    nounTokenReadings = new ArrayList<AnalyzedToken>();
                    for (AnalyzedToken token : tokenReadings) {
                        nounPosTag = token.getPOSTag();
                        if (nounPosTag == null) continue;
                        if (PosTagHelper.hasPosTag(token, TokenAgreementNumrNounRule.NOUN_IGNORE_PATTERN)) {
                            nounTokenReadings.clear();
                            break;
                        }
                        if (nounPosTag.startsWith("noun") || nounPosTag.startsWith("adj")) {
                            nounTokenReadings.add(token);
                            continue;
                        }
                        if (nounPosTag.equals("SENT_END") || nounPosTag.equals("PARA_END") || PosTagHelper.isPredictOrInsert(token)) continue;
                        nounTokenReadings.clear();
                        break;
                    }
                    if (state.numrAnalyzedTokenReadings.getCleanToken().toLowerCase().endsWith("\u0431\u0430\u0433\u0430\u0442\u043e") && !PosTagHelper.hasMaleUA(tokenReadings) && !TokenAgreementNumrNounRule.NOUN_FORCE_PATTERN.matcher(cleanTokenLower).matches()) {
                        state.reset();
                        continue;
                    }
                    if (nounTokenReadings.isEmpty()) {
                        state.reset();
                        continue;
                    }
                    state.nounPos = i;
                    if (cleanTokenLower.equals("\u0442\u043e\u043d")) {
                        msg = "\u0412\u0438 \u043c\u0430\u043b\u0438 \u043d\u0430 \u0443\u0432\u0430\u0437\u0456: \u00ab\u0442\u043e\u043d\u043d\u00bb?";
                        potentialRuleMatch = new RuleMatch((Rule)this, sentence, tokenReadings.getStartPos(), tokenReadings.getEndPos(), msg, this.getShort());
                        repl = "\u0442\u043e\u043d\u043d";
                        potentialRuleMatch.addSuggestedReplacement(repl);
                        ruleMatches.add(potentialRuleMatch);
                        state.reset();
                        continue;
                    }
                    TokenAgreementNumrNounRule.logger.debug("=== Checking:\n\t{}\n\t{}", state.numrTokenReadings, nounTokenReadings);
                    genderOfPluralNotFound = null;
                    masterInflections = new ArrayList<InflectionHelper.Inflection>();
                    if (state.numrPos != i - 2 || !Arrays.asList(new String[]{"\u0434\u0435\u0441\u044f\u0442\u0438\u0445", "\u0441\u043e\u0442\u0438\u0445", "\u0442\u0438\u0441\u044f\u0447\u043d\u0438\u0445", "\u0442\u0440\u0435\u0442\u0456\u0445", "\u0447\u0435\u0442\u0432\u0435\u0440\u0442\u0438\u0445"}).contains(tokens[i - 1].getCleanToken().toLowerCase())) break block79;
                    masterInflections.clear();
                    masterInflections.add(new InflectionHelper.Inflection("m", "v_rod", null));
                    masterInflections.add(new InflectionHelper.Inflection("f", "v_rod", null));
                    masterInflections.add(new InflectionHelper.Inflection("n", "v_rod", null));
                    break block80;
                }
                if (!state.number) ** GOTO lbl168
                if (TokenAgreementNumrNounRule._5_5.matcher(numrCleanToken).matches()) {
                    masterInflections.add(new InflectionHelper.Inflection("p", "v_rod", null));
                    masterInflections.add(new InflectionHelper.Inflection("m", "v_rod", null));
                    masterInflections.add(new InflectionHelper.Inflection("f", "v_rod", null));
                    masterInflections.add(new InflectionHelper.Inflection("n", "v_rod", null));
                } else if (TokenAgreementNumrNounRule._2_5.matcher(numrCleanToken).matches()) {
                    masterInflections.add(new InflectionHelper.Inflection("p", "v_naz", null));
                    masterInflections.add(new InflectionHelper.Inflection("p", "v_zna", "inanim"));
                    masterInflections.add(new InflectionHelper.Inflection("m", "v_rod", null));
                    masterInflections.add(new InflectionHelper.Inflection("f", "v_rod", null));
                    masterInflections.add(new InflectionHelper.Inflection("n", "v_rod", null));
                } else if (TokenAgreementNumrNounRule._1_5.matcher(numrCleanToken).matches()) {
                    masterInflections.add(new InflectionHelper.Inflection("m", "v_rod", null));
                    masterInflections.add(new InflectionHelper.Inflection("f", "v_rod", null));
                    masterInflections.add(new InflectionHelper.Inflection("n", "v_rod", null));
                } else if (TokenAgreementNumrNounRule._FRA.matcher(numrCleanToken).matches()) {
                    masterInflections.add(new InflectionHelper.Inflection("m", "v_rod", null));
                    masterInflections.add(new InflectionHelper.Inflection("f", "v_rod", null));
                    masterInflections.add(new InflectionHelper.Inflection("n", "v_rod", null));
                } else if (TokenAgreementNumrNounRule._2to4.matcher(numrCleanToken).matches() && PosTagHelper.hasPosTagAndToken(tokens[i], Pattern.compile(".*:m:v_rod.*"), Pattern.compile(".*[\u0430\u044f]"))) {
                    masterInflections.clear();
                    masterInflections.add(new InflectionHelper.Inflection("p", "v_naz", null));
                    masterInflections.add(new InflectionHelper.Inflection("p", "v_zna", null));
                } else if (TokenAgreementNumrNounRule._5to9.matcher(numrCleanToken).matches() && TokenAgreementNumrNounRule.NOUN_FORCE_PATTERN.matcher(cleanTokenLower).matches()) {
                    masterInflections.add(new InflectionHelper.Inflection("p", "v_rod", null));
                } else {
                    state.reset();
                    continue;
lbl168:
                    // 1 sources

                    masterInflections = PosTagHelper.hasPosTag(state.numrTokenReadings, TokenAgreementNumrNounRule.NUMR_PATTERN) != false ? InflectionHelper.getNumrInflections(state.numrTokenReadings) : Arrays.asList(new InflectionHelper.Inflection[]{new InflectionHelper.Inflection("p", "v_rod", null)});
                    pVnazZna = masterInflections.stream().filter((Predicate<InflectionHelper.Inflection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$match$0(org.languagetool.rules.uk.InflectionHelper$Inflection ), (Lorg/languagetool/rules/uk/InflectionHelper$Inflection;)Z)()).collect(Collectors.toList());
                    if (pVnazZna.size() > 0) {
                        if (TokenAgreementNumrNounRule._5to9_ALPHA.matcher(numrToken).matches()) {
                            masterInflections.removeAll(pVnazZna);
                            masterInflections.add(new InflectionHelper.Inflection("p", "v_rod", null));
                        } else if (numrToken.matches("((.+-)?(\u0434\u0432\u043e\u0454|\u0434\u0432\u043e\u0445|\u0442\u0440\u043e\u0454|.+\u0435\u0440\u043e|.+\u044c\u043e\u0445))|\u043e\u0431\u0438\u0434\u0432\u043e\u0454|\u043e\u0431\u0438\u0434\u0432\u043e\u0445|\u043e\u0431\u043e\u0454|\u043e\u0431\u043e\u0445|\u0434\u0432\u0456\u0439\u043a\u043e")) {
                            masterInflections.removeAll(pVnazZna);
                            masterInflections.add(new InflectionHelper.Inflection("p", "v_rod", null));
                        } else if (numrToken.matches("(\u043d\u0435)?\u0431\u0430\u0433\u0430\u0442\u043e|\u0431\u0430\u0433\u0430\u0442\u043e-\u0431\u0430\u0433\u0430\u0442\u043e|(\u043d\u0435|\u0447\u0438)?\u043c\u0430\u043b\u043e|\u0441[\u0442\u043a]\u0456\u043b\u044c\u043a\u0438(-\u0442\u043e|\u0441\u044c)?|.+-\u0441\u043a\u0456\u043b\u044c\u043a\u0438|\u043a\u0456\u043b\u044c\u043a\u043e")) {
                            masterInflections.removeAll(pVnazZna);
                            masterInflections.add(new InflectionHelper.Inflection("p", "v_rod", null));
                            masterInflections.add(new InflectionHelper.Inflection("m", "v_rod", null));
                            masterInflections.add(new InflectionHelper.Inflection("n", "v_rod", null));
                            masterInflections.add(new InflectionHelper.Inflection("f", "v_rod", null));
                        } else if (numrToken.matches("\u043f\u0456\u0432")) {
                            masterInflections.clear();
                            masterInflections.add(new InflectionHelper.Inflection("m", "v_rod", null));
                            masterInflections.add(new InflectionHelper.Inflection("f", "v_rod", null));
                            masterInflections.add(new InflectionHelper.Inflection("n", "v_rod", null));
                        } else if (TokenAgreementNumrNounRule.DVA_3_4_PATTERN.matcher(numrToken).matches()) {
                            masterInflections.removeAll(pVnazZna);
                            masterInflections.add(new InflectionHelper.Inflection("p", "v_naz", null));
                            if (PosTagHelper.hasPosTag(nounTokenReadings, Pattern.compile("(noun:inanim:p:v_zna).*"))) {
                                masterInflections.add(new InflectionHelper.Inflection("p", "v_zna", null));
                            } else if (i < tokens.length - 1 && PosTagHelper.hasPosTag(tokens[i], Pattern.compile("(adj:p:v_zna).*")) && PosTagHelper.hasPosTag(tokens[i + 1], Pattern.compile("(noun:inanim:p:v_zna).*"))) {
                                masterInflections.add(new InflectionHelper.Inflection("p", "v_zna", null));
                            }
                            if (TokenAgreementNumrNounRule.DVI_PATTERN.matcher(numrToken).matches()) {
                                vidm = masterInflections.size() == 2 ? "(naz|zna)" : "naz";
                                v0 = pattern = masterInflections.size() == 2 ? Pattern.compile("noun.*:p:v_" + vidm + "(?!:ns).*") : Pattern.compile("noun.*:p:v_" + vidm + ".*");
                                if (PosTagHelper.hasPosTag(nounTokenReadings, pattern) && !PosTagHelper.hasPosTag(nounTokenReadings, Pattern.compile("adj:p:v_" + vidm + ".*")) && (found = this.findSingulars(nounTokenReadings, pattern, ":f:")) != null && found.isEmpty()) {
                                    genderOfPluralNotFound = "f";
                                }
                            } else if (TokenAgreementNumrNounRule.DVA_PATTERN.matcher(numrToken).matches()) {
                                vidm = masterInflections.size() == 2 ? "(naz|zna)" : "naz";
                                v1 = pattern = masterInflections.size() == 2 ? Pattern.compile("noun.*:p:v_" + vidm + "(?!:ns).*") : Pattern.compile("noun.*:p:v_" + vidm + ".*");
                                if (PosTagHelper.hasPosTag(nounTokenReadings, pattern) && !PosTagHelper.hasPosTag(nounTokenReadings, Pattern.compile("adj:p:v_" + vidm + ".*")) && (found = this.findSingulars(nounTokenReadings, pattern, ":[mn]:")) != null && found.isEmpty()) {
                                    genderOfPluralNotFound = "mn";
                                }
                            }
                        }
                    } else if (numrToken.matches("(\u043e\u0434\u0438\u043d-|\u043e\u0434\u043d\u0435-)?\u043f\u0456\u0432\u0442\u043e\u0440\u0430")) {
                        masterInflections.clear();
                        masterInflections.add(new InflectionHelper.Inflection("m", "v_rod", null));
                        masterInflections.add(new InflectionHelper.Inflection("n", "v_rod", null));
                    } else if (numrToken.matches("(\u043e\u0434\u043d.+-)?\u043f\u0456\u0432\u0442\u043e\u0440\u0438")) {
                        masterInflections.clear();
                        masterInflections.add(new InflectionHelper.Inflection("f", "v_rod", null));
                    }
                }
            }
            nounInflections = InflectionHelper.getNounInflections(nounTokenReadings);
            adjInflections = InflectionHelper.getAdjInflections(nounTokenReadings);
            nounInflections.addAll(adjInflections);
            nounInflections = new ArrayList<InflectionHelper.Inflection>(new LinkedHashSet<InflectionHelper.Inflection>(nounInflections));
            disjoint = Collections.disjoint(masterInflections, nounInflections);
            if (genderOfPluralNotFound != null || disjoint) {
                if (TokenAgreementNumrNounExceptionHelper.isException(tokens, state, masterInflections, nounInflections, nounTokenReadings)) {
                    state.reset();
                    continue;
                }
                if (TokenAgreementNumrNounRule.logger.isDebugEnabled()) {
                    TokenAgreementNumrNounRule.logger.debug(MessageFormat.format("=== Found:\n\t{0}\n\t", new Object[]{state.numrAnalyzedTokenReadings.getToken() + ": " + masterInflections + " // " + state.numrAnalyzedTokenReadings, ((AnalyzedToken)nounTokenReadings.get(0)).getToken() + ": " + nounInflections + " // " + nounTokenReadings}));
                }
                msg = String.format("\u041f\u043e\u0442\u0435\u043d\u0446\u0456\u0439\u043d\u0430 \u043f\u043e\u043c\u0438\u043b\u043a\u0430: \u0447\u0438\u0441\u043b\u0456\u0432\u043d\u0438\u043a \u043d\u0435 \u0443\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u0438\u0439 \u0437 \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u043e\u043c: \"%s\" \u0432\u0438\u043c\u0430\u0433\u0430\u0454: [%s], \u0430 \u0434\u0430\u043b\u0456 \u0439\u0434\u0435 \"%s\": [%s]", new Object[]{state.numrTokenReadings.get(0).getToken(), TokenAgreementAdjNounRule.formatInflections(masterInflections, true), ((AnalyzedToken)nounTokenReadings.get(0)).getToken(), TokenAgreementAdjNounRule.formatInflections(nounInflections, false)});
                if (TokenAgreementNumrNounRule._1_5.matcher(numrCleanToken).matches()) {
                    msg = "\u041f\u0456\u0441\u043b\u044f \u00ab1,5\u00bb \u0442\u0440\u0435\u0431\u0430 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u0440\u043e\u0434\u043e\u0432\u0438\u0439 \u0432\u0456\u0434\u043c\u0456\u043d\u043e\u043a \u043e\u0434\u043d\u0438\u043d\u0438";
                } else if (TokenAgreementNumrNounRule._2_5.matcher(numrCleanToken).matches()) {
                    msg = "\u041f\u0456\u0441\u043b\u044f \u0447\u0438\u0441\u043b\u0456\u0432\u043d\u0438\u043a\u0430, \u0449\u043e \u0437\u0430\u043a\u0456\u043d\u0447\u0443\u0454\u0442\u044c\u0441\u044f \u043d\u0430 2-4 \u0456 \u043f\u043e\u0442\u0456\u043c \u00ab,5\u00bb, \u0456\u043c\u0435\u043d\u043d\u0438\u043a \u043c\u0430\u0454 \u0441\u0442\u043e\u044f\u0442\u0438 \u0432 \u043d\u0430\u0437\u0438\u0432\u043d\u043e\u043c\u0443 \u0432\u0456\u0434\u043c\u0456\u043d\u043a\u0443 \u043c\u043d\u043e\u0436\u0438\u043d\u0438 (\u044f\u043a\u0449\u043e \u0432\u0438\u043c\u043e\u0432\u043b\u044f\u0454\u043c\u043e \u00ab\u0437 \u043f\u043e\u043b\u043e\u0432\u0438\u043d\u043e\u044e\u00bb)";
                    msg = msg + ", \u0430\u0431\u043e \u0432 \u0440\u043e\u0434\u043e\u0432\u043e\u043c \u0432\u0456\u0434\u043c\u0456\u043d\u043a\u0443 \u043e\u0434\u043d\u0438\u043d\u0438 (\u044f\u043a\u0449\u043e \u0432\u0438\u043c\u043e\u0432\u043b\u044f\u0454\u043c\u043e \u00ab\u0456 \u043f'\u044f\u0442\u044c \u0434\u0435\u0441\u044f\u0442\u0438\u0445\u00bb)";
                } else if (numrCleanToken.endsWith(",5")) {
                    msg = "\u041f\u0456\u0441\u043b\u044f \u0447\u0438\u0441\u043b\u0456\u0432\u043d\u0438\u043a\u0430, \u0449\u043e \u0437\u0430\u043a\u0456\u043d\u0447\u0443\u0454\u0442\u044c\u0441\u044f \u043d\u0430 5-9 \u0456 \u043f\u043e\u0442\u0456\u043c \u00ab,5\u00bb, \u0456\u043c\u0435\u043d\u043d\u0438\u043a \u043c\u0430\u0454 \u0441\u0442\u043e\u044f\u0442\u0438 \u0432 \u0440\u043e\u0434\u043e\u0432\u043e\u043c\u0443 \u0432\u0456\u0434\u043c\u0456\u043d\u043a\u0443 \u043c\u043d\u043e\u0436\u0438\u043d\u0438 (\u044f\u043a\u0449\u043e \u0432\u0438\u043c\u043e\u0432\u043b\u044f\u0454\u043c\u043e \u00ab\u0437 \u043f\u043e\u043b\u043e\u0432\u0438\u043d\u043e\u044e\u00bb)";
                    msg = msg + ", \u0430\u0431\u043e \u0432 \u0440\u043e\u0434\u043e\u0432\u043e\u043c \u0432\u0456\u0434\u043c\u0456\u043d\u043a\u0443 \u043e\u0434\u043d\u0438\u043d\u0438 (\u044f\u043a\u0449\u043e \u0432\u0438\u043c\u043e\u0432\u043b\u044f\u0454\u043c\u043e \u00ab\u0456 \u043f'\u044f\u0442\u044c \u0434\u0435\u0441\u044f\u0442\u0438\u0445\u00bb)";
                } else if (numrCleanToken.equalsIgnoreCase("\u043f\u0456\u0432\u0442\u043e\u0440\u0430")) {
                    msg = "\u0406\u0441\u043d\u0443\u0454 \u043f\u0440\u0430\u0432\u0438\u043b\u043e, \u0449\u043e \u043f\u0456\u0441\u043b\u044f \u00ab\u043f\u0456\u0432\u0442\u043e\u0440\u0430\u00bb \u0442\u0440\u0435\u0431\u0430 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u0440\u043e\u0434\u043e\u0432\u0438\u0439 \u0432\u0456\u0434\u043c\u0456\u043d\u043e\u043a \u0447. \u0430\u0431\u043e \u0441.\u0440., \u043e\u0434\u043d\u0430\u043a \u0443 \u0442\u0435\u043a\u0441\u0442\u0430\u0445 \u0432 \u0431\u0430\u0433\u0430\u0442\u044c\u043e\u0445 \u0432\u0438\u043f\u0430\u0434\u043a\u0430\u0445 \u0432\u0436\u0438\u0432\u0430\u044e\u0442\u044c \u0456 \u0444\u043e\u0440\u043c\u0443 \u043c\u043d\u043e\u0436\u0438\u043d\u0438, \u043d\u0430\u0434\u0442\u043e \u043a\u043e\u043b\u0438 \u043f\u0435\u0440\u0435\u0434 \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u043e\u043c \u0456\u0434\u0435 \u043f\u0440\u0438\u043a\u043c\u0435\u0442\u043d\u0438\u043a";
                } else if (numrCleanToken.equalsIgnoreCase("\u043f\u0456\u0432\u0442\u043e\u0440\u0438")) {
                    msg = "\u0406\u0441\u043d\u0443\u0454 \u043f\u0440\u0430\u0432\u0438\u043b\u043e, \u0449\u043e \u043f\u0456\u0441\u043b\u044f \u00ab\u043f\u0456\u0432\u0442\u043e\u0440\u0430\u00bb \u0442\u0440\u0435\u0431\u0430 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u0440\u043e\u0434\u043e\u0432\u0438\u0439 \u0432\u0456\u0434\u043c\u0456\u043d\u043e\u043a \u0436.\u0440., \u043e\u0434\u043d\u0430\u043a \u0443 \u0442\u0435\u043a\u0441\u0442\u0430\u0445 \u0432 \u0431\u0430\u0433\u0430\u0442\u044c\u043e\u0445 \u0432\u0438\u043f\u0430\u0434\u043a\u0430\u0445 \u0432\u0436\u0438\u0432\u0430\u044e\u0442\u044c \u0456 \u0444\u043e\u0440\u043c\u0443 \u043c\u043d\u043e\u0436\u0438\u043d\u0438, \u043d\u0430\u0434\u0442\u043e \u043a\u043e\u043b\u0438 \u043f\u0435\u0440\u0435\u0434 \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u043e\u043c \u0456\u0434\u0435 \u043f\u0440\u0438\u043a\u043c\u0435\u0442\u043d\u0438\u043a";
                } else if (masterInflections.contains(new InflectionHelper.Inflection("m", "v_rod", null)) && tokens[i].getToken().matches(".*[\u0443\u044e]") && PosTagHelper.hasPosTag(nounTokenReadings, "noun.*?:m:v_dav.*")) {
                    msg = msg + ". \u041c\u043e\u0436\u043b\u0438\u0432\u043e, \u0432\u0436\u0438\u0442\u043e \u043d\u0435\u0432\u043d\u043e\u0440\u043c\u043e\u0432\u0430\u043d\u0438\u0439 \u0440\u043e\u0434\u043e\u0432\u0438\u0439 \u0432\u0456\u0434\u043c\u0456\u043d\u043e\u043a \u0447.\u0440. \u0437 \u0437\u0430\u043a\u0456\u043d\u0447\u0435\u043d\u043d\u044f\u043c -\u0443/-\u044e \u0437\u0430\u043c\u0456\u0441\u0442\u044c -\u0430/-\u044f (\u0442\u0430\u043a\u0430 \u0442\u0435\u043d\u0434\u0435\u043d\u0446\u0456\u044f \u0454 \u0432 \u0441\u0443\u0447\u0430\u0441\u043d\u0456\u0439 \u043c\u043e\u0432\u0456)?";
                } else if (!PosTagHelper.hasPosTag(state.numrTokenReadings, "adj.*?v_mis.*") && PosTagHelper.hasPosTag(nounTokenReadings, "noun.*?v_mis.*")) {
                    msg = msg + ". \u041c\u043e\u0436\u043b\u0438\u0432\u043e, \u043f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u043e \u043f\u0440\u0438\u0439\u043c\u0435\u043d\u043d\u0438\u043a \u043d\u0430/\u0432/\u0443...?";
                }
                if (!disjoint && genderOfPluralNotFound != null) {
                    msg = msg + ". \u041c\u043e\u0436\u043b\u0438\u0432\u043e, \u043d\u0435 \u0437\u0431\u0456\u0433\u0430\u0454\u0442\u044c\u0441\u044f \u0440\u0456\u0434 \u043e\u0434\u043d\u0438\u043d\u0438 \u0434\u043b\u044f \u043c\u043d\u043e\u0436\u0438\u043d\u043d\u043e\u0457 \u0444\u043e\u0440\u043c\u0438?";
                }
                potentialRuleMatch = new RuleMatch((Rule)this, sentence, state.numrAnalyzedTokenReadings.getStartPos(), tokenReadings.getEndPos(), msg, this.getShort());
                suggestions = new ArrayList<E>();
                if (!disjoint && genderOfPluralNotFound != null) {
                    sugg1 = "f".equals(genderOfPluralNotFound) != false ? numrCleanToken.replaceFirst("\u0456$", "\u0430") : numrCleanToken.replaceFirst("\u0430$", "\u0456");
                    suggestions = Arrays.asList(new String[]{sugg1 + " " + tokens[state.nounPos].getToken()});
                } else {
                    for (InflectionHelper.Inflection numrInflection : masterInflections) {
                        genderTag = ":" + numrInflection.gender + ":";
                        vidmTag = numrInflection._case;
                        for (AnalyzedToken nounToken : nounTokenReadings) {
                            if (numrInflection.animMatters()) {
                                v2 = animTag = nounToken.getPOSTag().startsWith("noun") != false ? ":" + numrInflection.animTag : ":r" + numrInflection.animTag;
                                if (!nounToken.getPOSTag().contains(animTag)) continue;
                            }
                            newNounPosTag = nounToken.getPOSTag().replaceFirst(":.:v_...", genderTag + vidmTag);
                            try {
                                for (String s : synthesized = this.synthesizer.synthesize(nounToken, newNounPosTag, false)) {
                                    if (numrCleanToken.equalsIgnoreCase("\u043f\u0456\u0432\u0442\u043e\u0440\u0430") && nounToken.getLemma().equals("\u0440\u0430\u0437") && !s.equals("\u0440\u0430\u0437\u0430")) continue;
                                    suggestion = state.numrAnalyzedTokenReadings.getToken();
                                    for (j = state.numrPos + 1; j < state.nounPos; ++j) {
                                        suggestion = suggestion + " " + tokens[j].getToken();
                                    }
                                    if (suggestions.contains(suggestion = suggestion + " " + s)) continue;
                                    suggestions.add(suggestion);
                                }
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                }
                if (suggestions.size() > 0) {
                    potentialRuleMatch.setSuggestedReplacements(suggestions);
                }
                ruleMatches.add(potentialRuleMatch);
            }
            state.reset();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private HashSet<String> findSingulars(List<AnalyzedToken> nounTokenReadings, Pattern pattern, String lookFor) throws IOException {
        HashSet<String> found = new HashSet<String>();
        for (AnalyzedToken tr : nounTokenReadings) {
            if (!PosTagHelper.hasPosTag(tr, pattern)) continue;
            String[] synthTokens0 = this.synthesizer.synthesize(tr, tr.getPOSTag(), false);
            if (synthTokens0.length == 0) {
                return null;
            }
            if (found.contains(tr.getLemma())) continue;
            String singularTag = tr.getPOSTag().replace(":p:", lookFor).replaceAll(":(var|bad|arch)", ".*");
            String[] synthTokens = this.synthesizer.synthesize(tr, singularTag, true);
            found.addAll(Arrays.asList(synthTokens));
        }
        return found;
    }

    private static /* synthetic */ boolean lambda$match$0(InflectionHelper.Inflection inf) {
        return inf.gender.equals("p") && (inf._case.equals("v_naz") || inf._case.equals("v_zna"));
    }

    static class State {
        boolean number;
        int numrPos;
        int nounPos;
        List<AnalyzedToken> numrTokenReadings = new ArrayList<AnalyzedToken>();
        AnalyzedTokenReadings numrAnalyzedTokenReadings = null;

        State() {
        }

        public boolean isEmpty() {
            return this.numrTokenReadings.isEmpty();
        }

        public void reset() {
            this.number = false;
            this.numrTokenReadings.clear();
            this.numrAnalyzedTokenReadings = null;
        }
    }
}

