/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.uk.CaseGovernmentHelper;
import org.languagetool.rules.uk.InflectionHelper;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.rules.uk.RuleException;
import org.languagetool.rules.uk.TokenAgreementAdjNounRule;
import org.languagetool.rules.uk.TokenAgreementPrepNounRule;
import org.languagetool.rules.uk.TokenAgreementVerbNounExceptionHelper;
import org.languagetool.rules.uk.VerbInflectionHelper;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.uk.PosTagHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAgreementVerbNounRule
extends Rule {
    private static final Logger logger = LoggerFactory.getLogger(TokenAgreementVerbNounRule.class);
    private final Synthesizer synthesizer;

    public TokenAgreementVerbNounRule(ResourceBundle messages, Language ukrainian) throws IOException {
        super.setCategory(Categories.MISC.getCategory(messages));
        this.synthesizer = ukrainian.getSynthesizer();
    }

    public final String getId() {
        return "UK_VERB_NOUN_INFLECTION_AGREEMENT";
    }

    public String getDescription() {
        return "\u0423\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043d\u044f \u0434\u0456\u0454\u0441\u043b\u043e\u0432\u0430 \u0437 \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u043e\u043c";
    }

    public String getShort() {
        return "\u0423\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043d\u044f \u0434\u0456\u0454\u0441\u043b\u043e\u0432\u0430 \u0437 \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u043e\u043c";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public final RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        State state = null;
        for (int i = 1; i < tokens.length; ++i) {
            Set<String> cases;
            AnalyzedTokenReadings tokenReadings = tokens[i];
            String posTag0 = tokenReadings.getAnalyzedToken(0).getPOSTag();
            if (posTag0 == null) {
                state = null;
                continue;
            }
            if (state == null && i == tokens.length - 1) continue;
            if (PosTagHelper.hasPosTag(tokenReadings, Pattern.compile("(verb|advp).*"))) {
                RuleException exception = TokenAgreementVerbNounExceptionHelper.isExceptionVerb(tokens, i, state);
                if (exception.type != RuleException.Type.none) {
                    if (exception.type == RuleException.Type.exception) {
                        state = null;
                    }
                    i += exception.skip;
                    continue;
                }
                state = this.getVerbState(tokens, i);
                if (state == null || state.verbPos == i) continue;
            }
            if (state == null) continue;
            int exceptionSkip = TokenAgreementVerbNounExceptionHelper.isExceptionHardAdjNoun(tokens, i, state);
            if (exceptionSkip > -1) {
                i += exceptionSkip;
                state = null;
                continue;
            }
            exceptionSkip = TokenAgreementVerbNounExceptionHelper.isExceptionSkip(tokens, i);
            if (exceptionSkip > -1) {
                i += exceptionSkip;
                continue;
            }
            ArrayList<AnalyzedToken> nounAdjTokenReadingsVnaz = new ArrayList<AnalyzedToken>();
            for (AnalyzedToken token : tokenReadings) {
                String nounAdjPosTag = token.getPOSTag();
                if (nounAdjPosTag == null || nounAdjPosTag.endsWith("_END")) continue;
                if (nounAdjPosTag.startsWith("<")) {
                    state = null;
                    break;
                }
                if (nounAdjPosTag.startsWith("noun") || nounAdjPosTag.startsWith("adj") || nounAdjPosTag.startsWith("numr")) {
                    if (nounAdjPosTag.contains("v_naz")) {
                        nounAdjTokenReadingsVnaz.add(token);
                    } else {
                        state.nounAdjIndirTokenReadings.add(token);
                    }
                    state.nounPos = i;
                    continue;
                }
                state = null;
                break;
            }
            if (state == null || nounAdjTokenReadingsVnaz.isEmpty() && state.nounAdjIndirTokenReadings.isEmpty()) {
                state = null;
                continue;
            }
            logger.debug("=== Checking\n\t{}\n\tnDir: {}\n\tnIndir: {}", new Object[]{state.verbTokenReadings, nounAdjTokenReadingsVnaz, state.nounAdjIndirTokenReadings});
            List<VerbInflectionHelper.Inflection> verbInflections = null;
            boolean pass = false;
            if (nounAdjTokenReadingsVnaz.size() > 0) {
                state.nounAdjNazInflections = VerbInflectionHelper.getNounInflections(nounAdjTokenReadingsVnaz);
                state.nounAdjNazInflections.addAll(VerbInflectionHelper.getAdjInflections(nounAdjTokenReadingsVnaz));
                verbInflections = VerbInflectionHelper.getVerbInflections(state.verbTokenReadings);
                logger.debug("\t\t{}\n\t{}", verbInflections, state.nounAdjNazInflections);
                boolean bl = pass = !Collections.disjoint(verbInflections, state.nounAdjNazInflections);
            }
            if (!pass && state.nounAdjIndirTokenReadings.size() > 0) {
                cases = CaseGovernmentHelper.getCaseGovernments(state.verbAnalyzedTokenReadings, "verb");
                if (cases.isEmpty() && state.verbAnalyzedTokenReadings.getCleanToken().contains("-") && LemmaHelper.hasLemma(state.verbAnalyzedTokenReadings, Pattern.compile(".+\u0442\u0438(\u0441\u044f)?-.+\u0442\u0438(\u0441\u044f)?"))) {
                    List nodashReadings = state.verbAnalyzedTokenReadings.getReadings().stream().filter(r -> PosTagHelper.hasPosTagStart(r, "verb")).map(r -> new AnalyzedToken(r.getToken(), r.getPOSTag(), r.getLemma().replaceFirst("(\u0442\u0438(\u0441\u044f)?)-.*", "$1"))).collect(Collectors.toList());
                    AnalyzedTokenReadings newReadings = new AnalyzedTokenReadings(state.verbAnalyzedTokenReadings, nodashReadings, "nodash");
                    cases = CaseGovernmentHelper.getCaseGovernments(newReadings, "verb");
                }
                if (tokens[state.verbPos - 1].getCleanToken().toLowerCase().matches("\u0431\u0443\u043b\u043e") && PosTagHelper.hasPosTag(tokens[state.verbPos], Pattern.compile("verb.*impers.*"))) {
                    cases.add("v_rod");
                }
                state.cases = cases;
                String tokenLowerCase = tokens[i].getCleanToken().toLowerCase();
                if (cases.contains("v_zna") && tokenLowerCase.matches("\u0433\u0440\u043e\u0448\u0435\u0439|\u0433\u0440\u043e\u0448\u0435\u043d\u044f\u0442|\u0434\u0440\u043e\u0432|\u0442\u043e\u0432\u0430\u0440\u0456\u0432|\u043f\u0456\u0441\u0435\u043d\u044c")) {
                    state = null;
                    continue;
                }
                if (!cases.isEmpty() && TokenAgreementPrepNounRule.hasVidmPosTag(cases, state.nounAdjIndirTokenReadings)) {
                    pass = true;
                }
            }
            if (!pass) {
                if (i < tokens.length - 1 && LemmaHelper.hasLemma(tokens[i], Arrays.asList("\u0432\u0456\u043d", "\u0432\u043e\u043d\u0430", "\u0432\u043e\u043d\u0438"), Pattern.compile("noun:.*v_rod.*")) && PosTagHelper.hasPosTag(tokens[i + 1], Pattern.compile("(noun|adj).*"))) continue;
                if (TokenAgreementVerbNounExceptionHelper.isException(tokens, state, verbInflections, state.nounAdjNazInflections, state.verbTokenReadings, nounAdjTokenReadingsVnaz)) {
                    state.verbTokenReadings.clear();
                    break;
                }
                if (!(nounAdjTokenReadingsVnaz.size() <= 0 && state.nounAdjIndirTokenReadings.size() <= 0 || TokenAgreementPrepNounRule.hasVidmPosTag(cases = CaseGovernmentHelper.getCaseGovernments(state.verbAnalyzedTokenReadings, "verb"), state.nounAdjIndirTokenReadings))) {
                    logger.debug("=== Found verb/noun mismatch\n\t{} // {}\n\t{} // {}", new Object[]{state.verbAnalyzedTokenReadings.getToken(), state.verbAnalyzedTokenReadings, tokens[state.nounPos].getToken(), state.nounAdjIndirTokenReadings});
                    List<InflectionHelper.Inflection> nounAdjInflections2 = InflectionHelper.getNounInflections(state.nounAdjIndirTokenReadings);
                    nounAdjInflections2.addAll(InflectionHelper.getAdjInflections(state.nounAdjIndirTokenReadings));
                    nounAdjInflections2.addAll(InflectionHelper.getNumrInflections(state.nounAdjIndirTokenReadings));
                    if (nounAdjTokenReadingsVnaz.size() > 0) {
                        List<InflectionHelper.Inflection> nounAdjInflections0 = InflectionHelper.getNounInflections(nounAdjTokenReadingsVnaz);
                        nounAdjInflections0.addAll(InflectionHelper.getAdjInflections(nounAdjTokenReadingsVnaz));
                        nounAdjInflections0.addAll(InflectionHelper.getNumrInflections(nounAdjTokenReadingsVnaz));
                        nounAdjInflections2.addAll(nounAdjInflections0);
                    }
                    String msg = String.format("\u041d\u0435 \u0443\u0437\u0433\u043e\u0434\u0436\u0435\u043d\u043e \u0434\u0456\u0454\u0441\u043b\u043e\u0432\u043e \u0437 \u0456\u043c\u0435\u043d\u043d\u0438\u043a\u043e\u043c: \"%s\" (%s) \u0456 \"%s\" (%s)", state.verbTokenReadings.get(0).getToken(), this.formatInflections(cases), state.nounAdjIndirTokenReadings.get(0).getToken(), TokenAgreementAdjNounRule.formatInflections(nounAdjInflections2, false));
                    String verbReplace = null;
                    if (state.verbTokenReadings.get(0).getLemma().equals("\u0441\u0438\u043f\u0456\u0442\u0438")) {
                        msg = msg + ". \u041c\u043e\u0436\u043b\u0438\u0432\u043e \u0432\u0438 \u043c\u0430\u043b\u0438 \u043d\u0430 \u0443\u0432\u0430\u0437\u0456 \u0441\u043b\u043e\u0432\u043e \u00ab\u0441\u0438\u0301\u043f\u0430\u0442\u0438\u00bb, \u0430 \u043d\u0435 \u00ab\u0441\u0438\u043f\u0456\u0301\u0442\u0438\u00bb?";
                        verbReplace = "\u0441\u0438\u043f\u0430\u0442\u0438";
                    } else if (state.verbTokenReadings.get(0).getLemma().equals("\u0441\u0438\u043f\u043b\u044f\u0447\u0438")) {
                        msg = msg + ". \u041c\u043e\u0436\u043b\u0438\u0432\u043e \u0432\u0438 \u043c\u0430\u043b\u0438 \u043d\u0430 \u0443\u0432\u0430\u0437\u0456 \u00ab\u0441\u0438\u043f\u043b\u044e\u0447\u0438\u00bb?";
                        verbReplace = "\u0441\u0438\u043f\u043b\u044e\u0447\u0438";
                    }
                    int startPos = state.verbAnalyzedTokenReadings.getStartPos();
                    RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, sentence, startPos, tokenReadings.getEndPos(), msg, this.getShort());
                    List<String> suggestions = this.getSuggestions(state.cases, tokenReadings);
                    if (tokenReadings.getCleanToken().equals("\u043f\u0456\u043a\u0443") && suggestions.contains("\u043f\u0456\u043a\u0430")) {
                        suggestions = Arrays.asList("\u043f\u0456\u043a\u0430");
                    }
                    State state_ = state;
                    StringBuilder insideWords = new StringBuilder();
                    for (int ii = state.verbPos + 1; ii < state.nounPos; ++ii) {
                        insideWords.append(" ").append(tokens[ii].getToken());
                    }
                    suggestions = verbReplace != null ? Arrays.asList(String.format("%s%s %s", verbReplace, insideWords, tokenReadings.getToken())) : suggestions.stream().map(s -> String.format("%s%s %s", state_.verbAnalyzedTokenReadings.getToken(), insideWords, s)).collect(Collectors.toList());
                    potentialRuleMatch.addSuggestedReplacements(suggestions);
                    ruleMatches.add(potentialRuleMatch);
                }
            }
            state = null;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private State getVerbState(AnalyzedTokenReadings[] tokens, int i) {
        AnalyzedTokenReadings tokenReadings = tokens[i];
        String cleanTokenLower = tokenReadings.getCleanToken().toLowerCase();
        if (PosTagHelper.hasPosTag(tokenReadings, Pattern.compile(".*(arch|bad|slang|alt).*"))) {
            return null;
        }
        if (cleanTokenLower.matches("\u0437\u043d\u0430\u0447\u0438\u0442\u044c|\u0447\u0438\u0442\u0430\u0439|\u0431\u0443\u0432\u0430|\u0437\u0434\u0430\u0432\u0430\u043b\u043e\u0441\u044c|\u0437\u0434\u0430\u0454\u0442\u044c\u0441\u044f|\u0437\u0434\u0430\u043b\u043e\u0441\u044f")) {
            return null;
        }
        State state = null;
        for (AnalyzedToken token : tokenReadings) {
            String verbPosTag = token.getPOSTag();
            if (verbPosTag == null) continue;
            if (!verbPosTag.matches("(verb|advp).*") || verbPosTag.contains("abbr")) {
                return null;
            }
            if (state == null) {
                state = new State();
                state.verbPos = i;
                state.verbAnalyzedTokenReadings = tokenReadings;
            }
            state.verbTokenReadings.add(token);
        }
        return state;
    }

    private List<String> getSuggestions(Set<String> cases, AnalyzedTokenReadings tokenReadings) {
        if (cases.isEmpty()) {
            return new ArrayList<String>();
        }
        String requiredPostTagsRegEx = ":(" + String.join((CharSequence)"|", cases) + ")";
        LinkedHashSet<String> suggestions = new LinkedHashSet<String>();
        for (AnalyzedToken analyzedToken : tokenReadings.getReadings()) {
            String oldPosTag = analyzedToken.getPOSTag();
            if (oldPosTag == null || !oldPosTag.contains(":v_")) continue;
            String posTag = oldPosTag.replaceFirst(":v_[a-z]+", requiredPostTagsRegEx);
            try {
                String[] synthesized = this.synthesizer.synthesize(analyzedToken, posTag, true);
                suggestions.addAll(Arrays.asList(synthesized));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new ArrayList<String>(suggestions);
    }

    private String formatInflections(Set<String> cases) {
        if (cases.isEmpty()) {
            return "\u043d\u0435\u043f\u0435\u0440\u0435\u0445.";
        }
        return "\u0432\u0438\u043c\u0430\u0433\u0430\u0454: " + cases.stream().map(c -> PosTagHelper.VIDMINKY_I_MAP.get(c)).collect(Collectors.joining(", "));
    }

    static class State {
        int verbPos;
        int nounPos;
        List<AnalyzedToken> verbTokenReadings = new ArrayList<AnalyzedToken>();
        AnalyzedTokenReadings verbAnalyzedTokenReadings = null;
        List<VerbInflectionHelper.Inflection> nounAdjNazInflections;
        Set<String> cases = new HashSet<String>();
        List<AnalyzedToken> nounAdjIndirTokenReadings = new ArrayList<AnalyzedToken>();

        State() {
        }
    }
}

