/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.uk;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

class LetterEndingForNumericHelper {
    private static final Map<String, List<RegexToCaseList>> NUMR_ADJ_ENDING_MAP;
    private static final Map<String, List<RegexToCaseList>> NUMR_NOUN_ENDING_MAP;

    LetterEndingForNumericHelper() {
    }

    public static boolean isPossibleAdjAdjEnding(String leftWord, String rightWord) {
        return NUMR_ADJ_ENDING_MAP.containsKey(rightWord);
    }

    public static String[] findTagsAdj(String leftWord, String rightWord) {
        if (NUMR_ADJ_ENDING_MAP.containsKey(rightWord)) {
            String[] tags = RegexToCaseList.getCaseTags(leftWord, LetterEndingForNumericHelper.NUMR_ADJ_ENDING_MAP.get(rightWord));
            return tags;
        }
        return null;
    }

    public static String[] findTagsNoun(String leftWord, String rightWord) {
        if (NUMR_NOUN_ENDING_MAP.containsKey(rightWord)) {
            String[] tags = RegexToCaseList.getCaseTags(leftWord, LetterEndingForNumericHelper.NUMR_NOUN_ENDING_MAP.get(rightWord));
            return tags;
        }
        return null;
    }

    static {
        HashMap<String, List<RegexToCaseList>> map2 = new HashMap<String, List<RegexToCaseList>>();
        map2.put("\u0439", Arrays.asList(RegexToCaseList.always(new String[]{":m:v_naz", ":m:v_zna:rinanim", ":f:v_dav", ":f:v_mis"})));
        map2.put("\u0438\u0439", Arrays.asList(RegexToCaseList.always(new String[]{":m:v_naz", ":m:v_zna:rinanim"})));
        map2.put("\u0456\u0439", Arrays.asList(RegexToCaseList.regex(".*([^3]|13)", new String[]{":f:v_dav", ":f:v_mis"}), RegexToCaseList.always(new String[]{":m:v_naz", ":m:v_zna:rinanim", ":f:v_dav", ":f:v_mis"})));
        map2.put("\u0433\u043e", Arrays.asList(RegexToCaseList.always(new String[]{":m:v_rod", ":m:v_zna:ranim", ":n:v_rod"})));
        map2.put("\u043c\u0443", Arrays.asList(RegexToCaseList.regex(".*(?!<1)7", new String[]{":m:v_dav", ":m:v_mis", ":n:v_dav", ":n:v_mis", ":f:v_zna"}), RegexToCaseList.regex(".*(?!<1)8", new String[]{":f:v_zna", ":m:v_dav", ":m:v_mis", ":n:v_dav", ":n:v_mis"}), RegexToCaseList.always(new String[]{":m:v_dav", ":m:v_mis", ":n:v_dav", ":n:v_mis"})));
        map2.put("\u043c\u0430", Arrays.asList(RegexToCaseList.regex(".*(?!<1)[78]", new String[]{":f:v_naz"})));
        map2.put("\u043c", Arrays.asList(RegexToCaseList.always(new String[]{":m:v_oru", ":n:v_oru", ":p:v_dav"})));
        map2.put("\u0438\u043c", Arrays.asList(RegexToCaseList.always(new String[]{":m:v_oru", ":n:v_oru", ":p:v_dav"})));
        map2.put("\u0456\u043c", Arrays.asList(RegexToCaseList.regex(".*(?!<1)3", new String[]{":m:v_oru", ":m:v_mis", ":n:v_oru", ":n:v_mis"}), RegexToCaseList.always(new String[]{":m:v_mis", ":n:v_oru", ":n:v_mis"})));
        map2.put("\u0430", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_naz"})));
        map2.put("\u0432\u0430", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_naz"})));
        map2.put("\u0448\u0430", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_naz"})));
        map2.put("\u0433\u0430", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_naz"})));
        map2.put("\u0442\u044f", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_naz"})));
        map2.put("\u044f", Arrays.asList(RegexToCaseList.regex(".*(?!<1)3", new String[]{":f:v_naz"})));
        map2.put("\u0442\u0430", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_naz"})));
        map2.put("\u0457", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_rod"})));
        map2.put("\u043e\u0457", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_rod"})));
        map2.put("\u0443", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_zna"})));
        map2.put("\u0448\u0443", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_zna"})));
        map2.put("\u0433\u0443", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_zna"})));
        map2.put("\u0442\u0443", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_zna"})));
        map2.put("\u0442\u044e", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_zna"})));
        map2.put("\u043e\u044e", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_oru"})));
        map2.put("\u044e", Arrays.asList(RegexToCaseList.regex(".*([^3]|13)", new String[]{":f:v_oru"}), RegexToCaseList.always(new String[]{":f:v_zna", ":f:v_oru"})));
        map2.put("\u0435", Arrays.asList(RegexToCaseList.always(new String[]{":n:v_naz", ":n:v_zna"})));
        map2.put("\u0454", Arrays.asList(RegexToCaseList.always(new String[]{":n:v_naz", ":n:v_zna"})));
        map2.put("\u0448\u0435", Arrays.asList(RegexToCaseList.always(new String[]{":n:v_naz", ":n:v_zna"})));
        map2.put("\u0433\u0435", Arrays.asList(RegexToCaseList.always(new String[]{":n:v_naz", ":n:v_zna"})));
        map2.put("\u0442\u0454", Arrays.asList(RegexToCaseList.always(new String[]{":n:v_naz", ":n:v_zna"})));
        map2.put("\u0442\u0435", Arrays.asList(RegexToCaseList.always(new String[]{":n:v_naz", ":n:v_zna"})));
        map2.put("\u043c\u0435", Arrays.asList(RegexToCaseList.regex(".*(?!<1)[78]", new String[]{":n:v_naz", ":n:v_zna"})));
        map2.put("\u0456", Arrays.asList(RegexToCaseList.always(new String[]{":p:v_naz", ":p:v_zna:rinanim"})));
        map2.put("\u0442\u0456", Arrays.asList(RegexToCaseList.always(new String[]{":p:v_naz", ":p:v_zna:rinanim"})));
        map2.put("\u043d\u0456", Arrays.asList(RegexToCaseList.always(new String[]{":p:v_naz", ":p:v_zna:rinanim"})));
        map2.put("\u043c\u0438", Arrays.asList(RegexToCaseList.always(new String[]{":p:v_oru"})));
        map2.put("\u0445", Arrays.asList(RegexToCaseList.always(new String[]{":p:v_rod", ":p:v_zna:ranim", ":p:v_mis"})));
        map2.put("\u0438\u0445", Arrays.asList(RegexToCaseList.always(new String[]{":p:v_rod", ":p:v_zna:ranim", ":p:v_mis"})));
        map2.put("\u0432\u0456", Arrays.asList(RegexToCaseList.regex(".*40", new String[]{":p:v_naz", ":p:v_zna:rinanim"}), RegexToCaseList.regex(".*%", new String[]{":p:v_naz", ":p:v_zna:rinanim"})));
        map2.put("\u0442\u0456\u0439", Arrays.asList(RegexToCaseList.regex(".*([^3]|13)", new String[]{":f:v_dav:bad", ":f:v_mis:bad"}), RegexToCaseList.always(new String[]{":m:v_naz:bad", ":m:v_zna:rinanim:bad", ":f:v_dav:bad", ":f:v_mis:bad"})));
        map2.put("\u043c\u0456\u0439", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_dav:bad", ":f:v_mis:bad"})));
        map2.put("\u043c\u043e\u044e", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_oru:bad"})));
        map2.put("\u0442\u043e\u044e", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_oru:bad"})));
        map2.put("\u0442\u043e\u0457", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_rod:bad"})));
        map2.put("\u0442\u043e\u0433\u043e", Arrays.asList(RegexToCaseList.always(new String[]{":m:v_rod:bad", ":n:v_rod:bad"})));
        map2.put("\u0442\u044c\u043e\u0433\u043e", Arrays.asList(RegexToCaseList.always(new String[]{":m:v_rod:bad", ":n:v_rod:bad"})));
        map2.put("\u0442\u043e\u043c\u0443", Arrays.asList(RegexToCaseList.always(new String[]{":m:v_dav:bad", ":m:v_mis:bad", ":n:v_rod:bad", ":n:v_mis:bad"})));
        map2.put("\u0442\u044c\u043e\u043c\u0443", Arrays.asList(RegexToCaseList.always(new String[]{":m:v_dav:bad", ":m:v_mis:bad", ":n:v_rod:bad", ":n:v_mis:bad"})));
        map2.put("\u0442\u0438\u043c\u0438", Arrays.asList(RegexToCaseList.always(new String[]{":p:v_oru:bad"})));
        map2.put("\u0442\u0456\u043c", Arrays.asList(RegexToCaseList.always(new String[]{":m:v_mis:bad", ":n:v_mis:bad"})));
        map2.put("\u043c\u043e\u0457", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_rod:bad"})));
        map2.put("\u0442\u0438\u0439", Arrays.asList(RegexToCaseList.always(new String[]{":m:v_naz:bad", ":m:v_zna:rinanim:bad"})));
        map2.put("\u043c\u0438\u0439", Arrays.asList(RegexToCaseList.always(new String[]{":m:v_naz:bad", ":m:v_zna:rinanim:bad"})));
        map2.put("\u0442\u0438\u0445", Arrays.asList(RegexToCaseList.always(new String[]{":p:v_rod:bad", ":p:v_mis:bad"})));
        map2.put("\u043e\u0433\u043e", Arrays.asList(RegexToCaseList.always(new String[]{":m:v_rod:bad", ":m:v_zna:ranim:bad", ":n:v_rod:bad"})));
        map2.put("\u043e\u043c\u0443", Arrays.asList(RegexToCaseList.always(new String[]{":m:v_dav:bad", ":m:v_mis:bad", ":n:v_dav:bad", ":n:v_mis:bad"})));
        map2.put("\u0442\u0438\u043c", Arrays.asList(RegexToCaseList.always(new String[]{":m:v_oru:bad", ":n:v_oru:bad", ":p:v_dav:bad"})));
        map2.put("\u043e\u043c\u0430", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_naz:bad", ":p:v_oru:bad"})));
        map2.put("\u0448\u0438\u0439", Arrays.asList(RegexToCaseList.always(new String[]{":m:v_naz:bad", ":m:v_zna:rinanim:bad"})));
        map2.put("\u0433\u0456\u0439", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_mis:bad", ":f:v_dav:bad"})));
        NUMR_ADJ_ENDING_MAP = Collections.unmodifiableMap(map2);
        HashMap<String, List<RegexToCaseList>> map3 = new HashMap<String, List<RegexToCaseList>>();
        map3.put("\u0442\u0438", Arrays.asList(RegexToCaseList.regex(".*([0569]|1[0-9])", new String[]{":p:v_rod:bad", ":p:v_dav:bad", ":p:v_mis:bad"})));
        map3.put("\u0446\u0456", Arrays.asList(RegexToCaseList.regex(".*([03456789]|1[0-9])", new String[]{":f:v_dav:bad", ":f:v_mis:bad"})));
        map3.put("\u043c\u0430", Arrays.asList(RegexToCaseList.regex(".*([023456789]|1[0-9])", new String[]{":p:v_oru:bad"})));
        map3.put("\u043c\u0438", Arrays.asList(RegexToCaseList.always(new String[]{":p:v_rod:bad", ":p:v_mis:bad"})));
        map3.put("\u043e\u0445", Arrays.asList(RegexToCaseList.always(new String[]{":p:v_rod:bad", ":p:v_zna:ranim:bad"})));
        map3.put("\u0432\u0456", Arrays.asList(RegexToCaseList.regex(".*(?!<1)2", new String[]{":p:v_naz:bad", ":p:v_zna:rinanim:bad"})));
        map3.put("\u0442\u044c", Arrays.asList(RegexToCaseList.always(new String[]{":p:v_naz:bad", ":p:v_zna:rinanim:bad"})));
        map3.put("\u043a\u0430", Arrays.asList(RegexToCaseList.always(new String[]{":f:v_naz:bad"})));
        NUMR_NOUN_ENDING_MAP = Collections.unmodifiableMap(map3);
    }

    private static class RegexToCaseList {
        private final Pattern pattern;
        private final String[] cases;

        public RegexToCaseList(String regex, String ... cases) {
            this.pattern = regex != null ? Pattern.compile(regex) : null;
            this.cases = cases;
        }

        private static RegexToCaseList always(String ... cases) {
            return new RegexToCaseList(null, cases);
        }

        private static RegexToCaseList regex(String regex, String ... cases) {
            return new RegexToCaseList(regex, cases);
        }

        private static String[] getCaseTags(String leftWord, List<RegexToCaseList> caseLists) {
            for (RegexToCaseList regexToCaseList : caseLists) {
                if (regexToCaseList.pattern != null && !regexToCaseList.pattern.matcher(leftWord).matches()) continue;
                return regexToCaseList.cases;
            }
            return null;
        }

        public String toString() {
            return String.format("%s: %s", this.pattern, Arrays.asList(this.cases));
        }
    }
}

