/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.tagging.uk.PosTagHelper;

public class CaseGovernmentHelper {
    public static final Map<String, Set<String>> CASE_GOVERNMENT_MAP = CaseGovernmentHelper.loadMap("/uk/case_government.txt");
    public static final Map<String, Set<String>> DERIVATIVES_MAP = CaseGovernmentHelper.loadMap("/uk/derivats.txt");
    static final String USED_U_INSTEAD_OF_A_MSG = ". \u041c\u043e\u0436\u043b\u0438\u0432\u043e, \u0432\u0436\u0438\u0442\u043e \u043d\u0435\u0432\u043d\u043e\u0440\u043c\u043e\u0432\u0430\u043d\u0438\u0439 \u0440\u043e\u0434\u043e\u0432\u0438\u0439 \u0432\u0456\u0434\u043c\u0456\u043d\u043e\u043a \u0447.\u0440. \u0437 \u0437\u0430\u043a\u0456\u043d\u0447\u0435\u043d\u043d\u044f\u043c -\u0443/-\u044e \u0437\u0430\u043c\u0456\u0441\u0442\u044c -\u0430/-\u044f (\u0442\u0430\u043a\u0430 \u0442\u0435\u043d\u0434\u0435\u043d\u0446\u0456\u044f \u0454 \u0432 \u0441\u0443\u0447\u0430\u0441\u043d\u0456\u0439 \u043c\u043e\u0432\u0456)?";

    private static Map<String, Set<String>> loadMap(String path) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(path);
        for (String line : lines) {
            String[] parts = line.split(" ");
            String[] vidm = parts[1].split(":");
            if (result.containsKey(parts[0])) {
                ((Set)result.get(parts[0])).addAll(Arrays.asList(vidm));
                continue;
            }
            result.put(parts[0], new LinkedHashSet<String>(Arrays.asList(vidm)));
        }
        return result;
    }

    public static boolean hasCaseGovernment(AnalyzedTokenReadings analyzedTokenReadings, String rvCase) {
        return CaseGovernmentHelper.hasCaseGovernment(analyzedTokenReadings, null, rvCase);
    }

    public static boolean hasCaseGovernment(AnalyzedTokenReadings analyzedTokenReadings, Pattern startPosTag, String rvCase) {
        return CaseGovernmentHelper.getCaseGovernments(analyzedTokenReadings, startPosTag).contains(rvCase);
    }

    public static Set<String> getCaseGovernments(AnalyzedTokenReadings analyzedTokenReadings, String startPosTag) {
        if ("verb".equals(startPosTag) && PosTagHelper.hasPosTagStart((AnalyzedToken)analyzedTokenReadings.getReadings().get(0), "advp")) {
            startPosTag = "advp";
        }
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        list.addAll(CaseGovernmentHelper.getCustomGovs(analyzedTokenReadings));
        for (AnalyzedToken token : analyzedTokenReadings.getReadings()) {
            if (token.hasNoTag() || (token.getPOSTag() == null || !token.getPOSTag().startsWith(startPosTag)) && (!startPosTag.equals("prep") || token.getPOSTag() == null || !token.getPOSTag().equals("<prep>")) || !CASE_GOVERNMENT_MAP.containsKey(token.getLemma())) continue;
            Set<String> rvList = CASE_GOVERNMENT_MAP.get(token.getLemma());
            list.addAll(rvList);
            if (!token.getPOSTag().contains("adjp:pasv")) continue;
            rvList.add("v_oru");
        }
        return list;
    }

    public static Set<String> getCaseGovernments(AnalyzedTokenReadings analyzedTokenReadings, Pattern posTag) {
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        list.addAll(CaseGovernmentHelper.getCustomGovs(analyzedTokenReadings));
        for (AnalyzedToken token : analyzedTokenReadings.getReadings()) {
            if (token.hasNoTag()) continue;
            if (posTag == null || token.getPOSTag() != null && posTag.matcher(token.getPOSTag()).matches()) {
                String vLemma = token.getLemma();
                if (!CASE_GOVERNMENT_MAP.containsKey(vLemma) && token.getPOSTag() != null && token.getPOSTag().startsWith("advp")) {
                    vLemma = CaseGovernmentHelper.getAdvpVerbLemma(token);
                }
                if (CASE_GOVERNMENT_MAP.containsKey(vLemma)) {
                    Set<String> rvList = CASE_GOVERNMENT_MAP.get(vLemma);
                    list.addAll(rvList);
                }
            }
            if (!PosTagHelper.hasPosTagPart(token, "adjp:pasv")) continue;
            list.add("v_oru");
        }
        return list;
    }

    private static ArrayList<String> getCustomGovs(AnalyzedTokenReadings analyzedTokenReadings) {
        ArrayList<String> list = new ArrayList<String>();
        if (LemmaHelper.hasLemma(analyzedTokenReadings, Arrays.asList("\u043c\u0430\u0442\u0438"), Pattern.compile("verb:imperf:(futr|past|pres).*"))) {
            list.add("v_inf");
        } else if (LemmaHelper.hasLemma(analyzedTokenReadings, Arrays.asList("\u0431\u0443\u0442\u0438"), Pattern.compile("verb:imperf:(futr|past:n|pres:s:3).*"))) {
            list.add("v_inf");
        } else if (LemmaHelper.hasLemma(analyzedTokenReadings, Arrays.asList("\u0432\u0438\u043c\u0430\u0433\u0430\u0442\u0438\u0441\u044f", "\u0432\u0438\u043f\u0430\u0434\u0430\u0442\u0438", "\u0432\u0438\u043f\u0430\u0441\u0442\u0438", "\u043b\u0438\u0447\u0438\u0442\u0438", "\u043d\u0430\u043b\u0435\u0436\u0430\u0442\u0438", "\u0442\u044f\u0433\u043d\u0443\u0442\u0438", "\u0449\u0430\u0441\u0442\u0438\u0442\u0438", "\u043f\u043b\u0430\u043d\u0443\u0432\u0430\u0442\u0438\u0441\u044f", "\u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0432\u0430\u0442\u0438\u0441\u044f", "\u043f\u0440\u043e\u043f\u043e\u043d\u0443\u0432\u0430\u0442\u0438\u0441\u044f", "\u0441\u043f\u043e\u0434\u043e\u0431\u0430\u0442\u0438\u0441\u044f", "\u043f\u043b\u0430\u043d\u0443\u0432\u0430\u0442\u0438\u0441\u044f", "\u043f\u0440\u0438\u0439\u0442\u0438\u0441\u044f", "\u0443\u0434\u0430\u0442\u0438\u0441\u044f", "\u0433\u043e\u0434\u0438\u0442\u0438\u0441\u044f", "\u0434\u043e\u0432\u043e\u0434\u0438\u0442\u0438\u0441\u044f"), Pattern.compile("verb.*(pres:s:3|futr:s:3|past:n).*"))) {
            list.add("v_inf");
        } else if (LemmaHelper.hasLemma(analyzedTokenReadings, Arrays.asList("\u043d\u0430\u043b\u0435\u0436\u0438\u0442\u044c"), Pattern.compile("verb:imperf:inf.*"))) {
            list.add("v_inf");
        } else if (LemmaHelper.hasLemma(analyzedTokenReadings, Pattern.compile("(\u043f\u043e)?\u0431\u0456\u043b\u044c\u0448\u0430\u0442\u0438|(\u043f\u043e)?\u043c\u0435\u043d\u0448\u0430\u0442\u0438"), Pattern.compile("verb.*(inf|pres:s:3|futr:s:3|past:n).*"))) {
            list.add("v_rod");
        }
        return list;
    }

    private static String getAdvpVerbLemma(AnalyzedToken token) {
        String vLemma = token.getLemma();
        vLemma = vLemma.equals("\u0434\u0430\u044e\u0447\u0438") ? "\u0434\u0430\u0432\u0430\u0442\u0438" : (vLemma.equals("\u0437\u043c\u0443\u0448\u0443\u044e\u0447\u0438") ? "\u0437\u043c\u0443\u0448\u0443\u0432\u0430\u0442\u0438" : token.getLemma().replaceFirst("\u043b\u044f\u0447\u0438(\u0441[\u044f\u044c])?", "\u0438\u0442\u0438$1").replaceFirst("(\u044e\u0447\u0438|\u0432\u0448\u0438)(\u0441[\u044f\u044c])?", "\u0442\u0438$2"));
        return vLemma;
    }

    static {
        CASE_GOVERNMENT_MAP.put("\u0437\u0433\u0456\u0434\u043d\u043e \u0437", new HashSet<String>(Arrays.asList("v_oru")));
        for (Map.Entry<String, Set<String>> entry : DERIVATIVES_MAP.entrySet()) {
            HashSet<String> set = new HashSet<String>();
            CASE_GOVERNMENT_MAP.put(entry.getKey(), set);
            for (String verb : entry.getValue()) {
                Set<String> rvs = CASE_GOVERNMENT_MAP.get(verb);
                if (rvs == null) continue;
                set.addAll(rvs);
            }
        }
    }
}

