/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.tagging.uk.PosTagHelper;

class SearchHelper {
    SearchHelper() {
    }

    static class Context {
        final AnalyzedTokenReadings[] tokens;
        final int pos;

        public Context(AnalyzedTokenReadings[] tokens, int pos) {
            this.tokens = tokens;
            this.pos = pos;
        }
    }

    static class Condition {
        Pattern postag;
        Pattern lemma;
        Pattern tokenPattern;
        String tokenStr;
        private boolean negate;

        public Condition() {
        }

        public Condition(Pattern lemma, Pattern postag) {
            this.lemma = lemma;
            this.postag = postag;
        }

        public static Condition postag(Pattern pattern) {
            Condition condition = new Condition();
            condition.postag = pattern;
            return condition;
        }

        public static Condition lemma(Pattern pattern) {
            Condition condition = new Condition();
            condition.lemma = pattern;
            return condition;
        }

        public static Condition token(Pattern pattern) {
            Condition condition = new Condition();
            condition.tokenPattern = pattern;
            return condition;
        }

        public static Condition token(String token) {
            Condition condition = new Condition();
            condition.tokenStr = token;
            return condition;
        }

        public Condition negate() {
            this.negate = true;
            return this;
        }

        public boolean matches(AnalyzedTokenReadings analyzedTokenReadings, Context context) {
            return this.negate ^ !(this.postag != null && !PosTagHelper.hasPosTag(analyzedTokenReadings, this.postag) || this.lemma != null && !LemmaHelper.hasLemma(analyzedTokenReadings, this.lemma) || this.tokenPattern != null && !this.tokenPattern.matcher(analyzedTokenReadings.getCleanToken()).matches() || this.tokenStr != null && !this.tokenStr.equalsIgnoreCase(analyzedTokenReadings.getCleanToken()));
        }

        public String toString() {
            return "Condition [postag=" + this.postag + ", lemma=" + this.lemma + ", token=" + this.tokenPattern + ", tokenStr=" + this.tokenStr + "]";
        }
    }

    public static class Match {
        private static final Pattern WHITESPACE = Pattern.compile("\\s");
        private boolean ignoreQuotes = true;
        private boolean ignoreInserts = false;
        private List<Condition> targets;
        private int limit = -1;
        private List<Condition> skips = new ArrayList<Condition>();

        public Match tokenLine(String tokenLine) {
            this.targets = Stream.of(WHITESPACE.split(tokenLine.replace(",", " ,"))).map(s -> Condition.token(s)).collect(Collectors.toList());
            return this;
        }

        public Match limit(int limit) {
            this.limit = limit;
            return this;
        }

        public Match ignoreInserts() {
            this.ignoreInserts = true;
            return this;
        }

        public Match skip(Condition ... conditions) {
            this.skips = Arrays.asList(conditions);
            return this;
        }

        public Match target(Condition ... conditions) {
            this.targets = Arrays.asList(conditions);
            return this;
        }

        public int mBefore(AnalyzedTokenReadings[] tokens, int pos) {
            boolean foundFirst = false;
            int logicalDistance = 0;
            int iCond = this.targets.size() - 1;
            while (iCond >= 0) {
                if (pos - 1 < iCond) {
                    return -1;
                }
                if (this.limit > 0 && logicalDistance > this.limit) {
                    return -1;
                }
                ++logicalDistance;
                AnalyzedTokenReadings currentToken = tokens[pos];
                if (!this.ignoreQuotes || !LemmaHelper.QUOTES_PATTERN.matcher(currentToken.getToken()).matches()) {
                    if (this.ignoreInserts(tokens, pos, -1)) {
                        pos -= 2;
                    } else {
                        if (this.ignoreInserts && tokens[pos].getToken().equals(")")) {
                            for (int i = pos - 1; i >= 1; --i) {
                                if (!tokens[i].getToken().equals("(")) continue;
                                pos = i;
                            }
                        }
                        Context context = new Context(tokens, pos);
                        if (!this.targets.get(iCond).matches(currentToken, context)) {
                            if (foundFirst) {
                                return -1;
                            }
                            if (!this.canSkip(currentToken, context)) {
                                return -1;
                            }
                        } else {
                            foundFirst = true;
                            --iCond;
                        }
                    }
                }
                --pos;
            }
            return pos + 1;
        }

        public int mAfter(AnalyzedTokenReadings[] tokens, int pos) {
            boolean foundFirst = false;
            int logicalDistance = 0;
            int iCond = 0;
            while (iCond < this.targets.size()) {
                if (pos + this.targets.size() - iCond > tokens.length) {
                    return -1;
                }
                if (this.limit > 0 && logicalDistance > this.limit) {
                    return -1;
                }
                ++logicalDistance;
                AnalyzedTokenReadings currentToken = tokens[pos];
                if (!this.ignoreQuotes || !LemmaHelper.QUOTES_PATTERN.matcher(currentToken.getToken()).matches()) {
                    if (this.ignoreInserts(tokens, pos, 1)) {
                        pos += 2;
                    } else {
                        if (this.ignoreInserts && tokens[pos].getToken().equals("(")) {
                            for (int i = pos + 1; i <= tokens.length - 1; ++i) {
                                if (!tokens[i].getToken().equals(")")) continue;
                                pos = i;
                            }
                        }
                        Context context = new Context(tokens, pos);
                        if (!this.targets.get(iCond).matches(currentToken, context)) {
                            if (foundFirst) {
                                return -1;
                            }
                            if (!this.canSkip(currentToken, context)) {
                                return -1;
                            }
                        } else {
                            foundFirst = true;
                            ++iCond;
                        }
                    }
                }
                ++pos;
            }
            return pos - 1;
        }

        public int mNow(AnalyzedTokenReadings[] tokens, int pos) {
            return this.limit(0).mAfter(tokens, pos);
        }

        private boolean canSkip(AnalyzedTokenReadings currentToken, Context context) {
            return this.skips.isEmpty() || this.skips.stream().anyMatch(s -> s.matches(currentToken, context));
        }

        private boolean ignoreInserts(AnalyzedTokenReadings[] tokens, int pos, int dir) {
            return this.ignoreInserts && (dir > 0 ? pos + 3 < tokens.length : pos - 3 > 0) && ",".equals(tokens[pos].getToken()) && ",".equals(tokens[pos + 2 * dir].getToken()) && (PosTagHelper.hasPosTagPart(tokens[pos + 1 * dir], "insert") || LemmaHelper.hasLemma(tokens[pos + 1 * dir], Arrays.asList("\u0437\u043e\u043a\u0440\u0435\u043c\u0430", "\u0432\u0456\u0434\u043f\u043e\u0432\u0456\u0434\u043d\u043e")));
        }
    }
}

