/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.uk.InflectionHelper;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.rules.uk.TokenAgreementNumrNounRule;
import org.languagetool.tagging.uk.PosTagHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TokenAgreementNumrNounExceptionHelper {
    private static final Logger logger = LoggerFactory.getLogger(TokenAgreementNumrNounExceptionHelper.class);

    TokenAgreementNumrNounExceptionHelper() {
    }

    public static boolean isException(AnalyzedTokenReadings[] tokens, TokenAgreementNumrNounRule.State state, List<InflectionHelper.Inflection> numrInflections, List<InflectionHelper.Inflection> slaveInflections, List<AnalyzedToken> slaveTokenReadings) {
        List<InflectionHelper.Inflection> nounInflections;
        String noun1Genders;
        String adj1Genders;
        List<InflectionHelper.Inflection> nounInflections2;
        String numrTokenLower = state.numrAnalyzedTokenReadings.getCleanToken().toLowerCase();
        AnalyzedTokenReadings nounAnalyzedTokenReadings = tokens[state.nounPos];
        if (numrTokenLower.matches("\u0431\u0430\u0433\u0430\u0442\u044c(\u043e\u0445|\u043e\u043c|\u043c\u0430)|\u043e\u0431\u043e(\u0445|\u043c|\u043c\u0430)|(\u0434\u0432|\u0442\u0440\u044c|\u0447\u043e\u0442\u0438\u0440\u044c)\u043e[\u0445\u043c]|\u0441\u043a\u0456\u043b\u044c\u043a\u0438(\u0441\u044c)?(-\u043d\u0435\u0431\u0443\u0434\u044c)?|\u0441\u0442\u0456\u043b\u044c\u043a\u0438")) {
            TokenAgreementNumrNounExceptionHelper.logException();
            return true;
        }
        String nounLowerToken = nounAnalyzedTokenReadings.getCleanToken().toLowerCase();
        if (nounLowerToken.matches("\u043f\u043b\u044e\u0441|\u043c\u0456\u043d\u0443\u0441|\u0440\u0430\u043d\u043a\u0443|\u0432\u0435\u0447\u043e\u0440\u0430|\u043d\u043e\u0447\u0456|\u0442\u0435\u043f\u043b\u0430|\u043c\u043e\u0440\u043e\u0437\u0443|\u0440\u043e\u0434\u043e\u043c|\u0437\u0440\u043e\u0441\u0442\u043e\u043c|\u0434\u0438\u0432\u043e\u043c|\u0441\u0442\u0430\u043d\u043e\u043c|\u0432\u0430\u0433\u043e\u044e|\u0441\u043b\u0456\u0434|\u0442\u0438\u043f\u0443|\u0444\u043e\u0440\u043c\u0430\u0442\u0443|\u0432\u0430\u0440\u0442\u0456\u0441\u0442\u044e|\u0440\u043e\u0446\u0456|\u043d\u0430\u0441\u0435\u043b\u0435\u043d\u043d\u044f")) {
            TokenAgreementNumrNounExceptionHelper.logException();
            return true;
        }
        if (LemmaHelper.hasLemma(nounAnalyzedTokenReadings, Pattern.compile("\u0443?\u0432\u0435\u0441\u044c|\u044f\u043a\u0438\u0439(\u0441\u044c)?|\u0441\u0432\u0456\u0439|\u0441\u0430\u043c|\u0446\u0435\u0439|\u0440\u0435\u0448\u0442\u0430|\u043a\u0456\u043b\u044c\u043a\u0456\u0441\u0442\u044c|\u0432\u0430\u0440\u0442\u0438\u0439|\u043a\u043e\u0436\u043d\u0438\u0439|\u0436\u043e\u0434\u043d\u0438\u0439|\u043c\u0435\u043d\u0448\u0438\u0439|\u0431\u0456\u043b\u044c\u0448\u0438\u0439|\u0432\u0438\u0449\u0438\u0439|\u043d\u0438\u0436\u0447\u0438\u0439"))) {
            TokenAgreementNumrNounExceptionHelper.logException();
            return true;
        }
        if (state.numrPos > 1 && LemmaHelper.hasLemma(tokens[state.numrPos - 1], LemmaHelper.TIME_PLUS_LEMMAS, Pattern.compile("noun.*?.:v_(naz|rod).*")) && !Collections.disjoint(numrInflections, nounInflections2 = InflectionHelper.getNounInflections(tokens[state.numrPos - 1].getReadings()))) {
            TokenAgreementNumrNounExceptionHelper.logException();
            return true;
        }
        if (state.nounPos < tokens.length - 1 && state.numrAnalyzedTokenReadings.getCleanToken().matches("(\u043e\u0434\u0438\u043d-|\u043e\u0434\u043d\u0435-)?\u043f\u0456\u0432\u0442\u043e\u0440\u0430|(\u043e\u0434\u043d\u0430-)?\u043f\u0456\u0432\u0442\u043e\u0440\u0438") && PosTagHelper.hasPosTag(tokens[state.nounPos], Pattern.compile("adj:p:v_(naz|rod).*")) && PosTagHelper.hasPosTag(tokens[state.nounPos + 1], Pattern.compile("noun.*?:p:v_naz.*"))) {
            TokenAgreementNumrNounExceptionHelper.logException();
            return true;
        }
        if (state.numrPos > 2 && PosTagHelper.hasPosTagStart(tokens[state.numrPos - 1], "prep") && LemmaHelper.hasLemma(tokens[state.numrPos - 2], LemmaHelper.TIME_PLUS_LEMMAS, Pattern.compile("noun.*?p:v_(naz|rod).*")) && !Collections.disjoint(numrInflections, nounInflections2 = InflectionHelper.getNounInflections(tokens[state.numrPos - 2].getReadings()))) {
            TokenAgreementNumrNounExceptionHelper.logException();
            return true;
        }
        if (state.numrPos > 2 && PosTagHelper.hasPosTagStart(tokens[state.numrPos - 2], "prep") && tokens[state.numrPos - 1].getCleanToken().toLowerCase().equals("\u0441\u0432\u043e\u0457") && PosTagHelper.hasPosTag(tokens[state.numrPos], Pattern.compile("numr:p:v_zna.*")) && PosTagHelper.hasPosTag(tokens[state.nounPos], Pattern.compile("noun:anim:.:v_naz.*"))) {
            TokenAgreementNumrNounExceptionHelper.logException();
            return true;
        }
        if (state.nounPos <= tokens.length - 3 && PosTagHelper.hasPosTag(tokens[state.nounPos], Pattern.compile("adj:.:v_rod.*")) && PosTagHelper.hasPosTag(tokens[state.nounPos + 1], Pattern.compile("noun:inanim:.:v_rod(?!.*pron).*")) && PosTagHelper.hasPosTag(tokens[state.nounPos + 2], Pattern.compile("noun(?!.*pron).*")) && (adj1Genders = PosTagHelper.getGenders(tokens[state.nounPos], "adj:.:v_rod.*")).matches(".*[" + (noun1Genders = PosTagHelper.getGenders(tokens[state.nounPos + 1], "noun:inanim:.:v_rod(?!.*pron).*")) + "].*") && !Collections.disjoint(numrInflections, nounInflections = InflectionHelper.getNounInflections(tokens[state.nounPos + 2].getReadings()))) {
            TokenAgreementNumrNounExceptionHelper.logException();
            return true;
        }
        if (numrTokenLower.endsWith(",5") && (Pattern.compile("\u0442\u043e\u043d|\u0442\u0438\u0441|\u043a\u043e\u043f").matcher(nounLowerToken).matches() || state.numrPos > 1 && Pattern.compile("\u0432\u0456\u0434|\u0434\u043e|\u043f\u0440\u043e\u0442\u044f\u0433\u043e\u043c|[\u0443\u0432]\u043f\u0440\u043e\u0434\u043e\u0432\u0436|\u0431\u043b\u0438\u0437\u044c\u043a\u043e|\u043f\u0456\u0441\u043b\u044f|\u0434\u043b\u044f|\u0431\u0456\u043b\u044c\u0448\u0435|\u043c\u0435\u043d\u0448\u0435").matcher(tokens[state.numrPos - 1].getCleanToken().toLowerCase()).matches())) {
            TokenAgreementNumrNounExceptionHelper.logException();
            return true;
        }
        if (numrTokenLower.matches("\u043e\u0431\u043e\u0454|\u0434\u0432\u043e\u0454|\u0442\u0440\u043e\u0454|.+\u0435\u0440\u043e") && PosTagHelper.hasPosTagAndToken(nounAnalyzedTokenReadings, Pattern.compile("adj:p:v_naz.*"), Pattern.compile(".+\u0456"))) {
            TokenAgreementNumrNounExceptionHelper.logException();
            return true;
        }
        if (numrTokenLower.matches("\u043e\u0431\u043e\u0454|\u043e\u0431\u0438\u0434\u0432\u043e\u0454|\u0442\u0440\u043e\u0454") && PosTagHelper.hasPosTag(nounAnalyzedTokenReadings, Pattern.compile("noun:anim:p:v_naz.*"))) {
            TokenAgreementNumrNounExceptionHelper.logException();
            return true;
        }
        if (state.number && LemmaHelper.hasLemma(tokens[state.nounPos], LemmaHelper.MONTH_LEMMAS, ":m:v_rod")) {
            TokenAgreementNumrNounExceptionHelper.logException();
            return true;
        }
        if (state.numrPos > 2 && tokens[state.numrPos - 1].getCleanToken().equals("/")) {
            TokenAgreementNumrNounExceptionHelper.logException();
            return true;
        }
        if (state.numrPos > 1 && (LemmaHelper.hasLemma(tokens[state.numrPos - 1], Arrays.asList("\u0447.", "\u0441\u0442.", "\u043f.", "\u0447\u0430\u0441\u0442\u0438\u043d\u0430", "\u0441\u0442\u0430\u0442\u0442\u044f", "\u043f\u0443\u043d\u043a\u0442", "\u043f\u0456\u0434\u043f\u0443\u043d\u043a\u0442", "\u0430\u0431\u0437\u0430\u0446", "\u2116", "\u043d\u043e\u043c\u0435\u0440")) || tokens[state.numrPos - 1].getCleanToken().equals("\u2116"))) {
            TokenAgreementNumrNounExceptionHelper.logException();
            return true;
        }
        if (PosTagHelper.hasPosTag(nounAnalyzedTokenReadings, Pattern.compile("adj.*numr.*"))) {
            TokenAgreementNumrNounExceptionHelper.logException();
            return true;
        }
        if (TokenAgreementNumrNounRule.DVA_3_4_PATTERN.matcher(numrTokenLower).matches() || state.number) {
            if (PosTagHelper.hasPosTag(tokens[state.nounPos], "adj(?!.*numr).*:p:v_rod.*") && (state.nounPos == tokens.length - 1 || PosTagHelper.hasPosTag(tokens[state.nounPos + 1], "adj(?!.*numr).*:p:v_rod.*|noun.*:p:v_naz.*|prep") || !PosTagHelper.hasPosTag(tokens[state.nounPos + 1], "(adj|noun).*") || tokens[state.nounPos + 1].getCleanToken().matches("[.,:;()\u00ab\u00bb\u2014\u2013-]|\u0456|\u0439|\u0442\u0430"))) {
                TokenAgreementNumrNounExceptionHelper.logException();
                return true;
            }
            if (tokens[state.nounPos].getCleanToken().toLowerCase().endsWith("\u0438\u0445") && PosTagHelper.hasPosTag(tokens[state.nounPos], "noun.*:p:v_rod.*")) {
                TokenAgreementNumrNounExceptionHelper.logException();
                return true;
            }
        }
        if (numrTokenLower.matches("\u0441\u044c\u043e\u043c\u0430|\u0434\u0435\u0432.\u044f\u043d\u043e\u0441\u0442\u0430") && PosTagHelper.hasPosTag(nounAnalyzedTokenReadings, Pattern.compile("(noun:.*?|adj):[fp]:v_naz.*"))) {
            TokenAgreementNumrNounExceptionHelper.logException();
            return true;
        }
        return false;
    }

    private static void logException() {
        if (logger.isDebugEnabled()) {
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
            logger.debug("exception: " + stackTraceElement.getLineNumber());
        }
    }
}

