/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.uk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.rules.uk.ExtraDictionaryLoader;
import org.languagetool.rules.uk.LemmaHelper;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tagging.WordTagger;
import org.languagetool.tagging.uk.CompoundDebugLogger;
import org.languagetool.tagging.uk.IPOSTag;
import org.languagetool.tagging.uk.LetterEndingForNumericHelper;
import org.languagetool.tagging.uk.PosTagHelper;
import org.languagetool.tagging.uk.UkrainianTagger;
import org.languagetool.tools.StringTools;

class CompoundTagger {
    private static final String TAG_ANIM = ":anim";
    private static final String TAG_INANIM = ":inanim";
    private static final Pattern EXTRA_TAGS = Pattern.compile(":bad");
    private static final Pattern EXTRA_TAGS_DROP = Pattern.compile(":(comp.|np|ns|slang|xp[1-9]|predic|insert)");
    private static final Pattern EXTRA_TAGS_DROP_NONINFL = Pattern.compile(":(comp.|np|ns|slang|xp[1-9]|insert)");
    private static final Pattern NOUN_SING_V_ROD_REGEX = Pattern.compile("noun.*?:[mfn]:v_rod.*");
    private static final Pattern SING_REGEX_F = Pattern.compile(":[mfn]:");
    private static final Pattern O_ADJ_PATTERN = Pattern.compile(".+?(\u043e|[\u0447\u0448\u0449]\u0435)");
    private static final Pattern NUMR_ADJ_PATTERN = Pattern.compile(".+?(\u043e\u0434\u043d\u043e|\u0434\u0432\u043e|\u043e\u0445|\u0438)");
    private static final Pattern DASH_PREFIX_LAT_PATTERN = Pattern.compile("[a-zA-Z]{3,}|[\u03b1-\u03c9\u0391-\u03a9]");
    private static final Pattern YEAR_NUMBER = Pattern.compile("[12][0-9]{3}");
    private static final Pattern NOUN_PREFIX_NUMBER = Pattern.compile("[0-9]+");
    private static final Pattern NOUN_WITH_INTERVAL_PREFIX_NUMBER = Pattern.compile("([0-9]+[-\u2013])?[0-9]+");
    private static final Pattern NOUN_SUFFIX_NUMBER_LETTER = Pattern.compile("[0-9][0-9\u0410-\u042f\u0406\u0407\u0404\u0490-]*");
    private static final Pattern ADJ_PREFIX_NUMBER = Pattern.compile("[0-9]+(,[0-9]+)?([-\u2013\u2014][0-9]+(,[0-9]+)?)?%?|(XC|XL|L?X{0,3})(IX|IV|V?I{0,3})|\u0406{2,3}");
    private static final Pattern REQ_NUM_DVA_PATTERN = Pattern.compile("(\u043c\u0456\u0441\u043d|\u0442\u043e\u043c\u043d\u0438\u043a|\u043f\u043e\u0432\u0435\u0440\u0445\u0456\u0432).{0,4}");
    private static final Pattern REQ_NUM_DESYAT_PATTERN = Pattern.compile("(\u043a\u043b\u0430\u0441\u043d\u0438[\u043a\u0446]|\u0431\u0430\u043b\u044c\u043d\u0438[\u043a\u0446]|\u0440\u0430\u0443\u043d\u0434\u043e\u0432|\u0442\u043e\u043c\u043d|\u0442\u043e\u043c\u043e\u0432|\u0445\u0432\u0438\u043b\u0438\u043d|\u0434\u0435\u0441\u044f\u0442\u0438\u0440\u0456\u0447|\u043a\u0456\u043b\u043e\u043c\u0435\u0442\u0440\u0456\u0432|\u0440\u0456\u0447).{0,4}");
    private static final Pattern REQ_NUM_STO_PATTERN = Pattern.compile("(\u0440\u0456\u0447\u0447|\u043b\u0456\u0442\u0442|\u043c\u0435\u0442\u0440\u0456\u0432|\u0433\u0440\u0430\u043c\u043e\u0432|\u0442\u0438\u0441\u044f\u0447\u043d\u0438\u043a).{0,3}");
    private static final Pattern INTJ_PATTERN = Pattern.compile("intj.*");
    private static final Pattern NONINFL_PATTERN = Pattern.compile("noninfl.*(onomat|predic).*");
    private static final Pattern UKR_LETTERS_PATTERN = Pattern.compile("[\u0410-\u042f\u0406\u0407\u0404\u0490\u0430-\u044f\u0456\u0457\u0454\u0491'-]+");
    private static final Pattern GEO_V_NAZ = Pattern.compile("noun:inanim:.:v_naz.*:geo.*");
    private static final Pattern FNAME = Pattern.compile("noun:anim:[mf].*fname.*");
    private static final Pattern LNAME_V_NAZ = Pattern.compile("noun:anim:[fm]:v_naz.*lname.*");
    private static final Pattern LNAME_V_ROD = Pattern.compile("noun:anim:[fm]:v_rod.*lname.*");
    private static final Pattern NAME = Pattern.compile("noun:anim:.*name.*");
    private static final Pattern PROP_V_NAZ = Pattern.compile("noun:inanim:.:v_naz.*prop.*");
    private static final Pattern MNP_NAZ_REGEX = Pattern.compile(".*?:[mnp]:v_naz.*");
    private static final Pattern MNP_ZNA_REGEX = Pattern.compile(".*?:[mnp]:v_zna.*");
    private static final Pattern MNP_ROD_REGEX = Pattern.compile(".*?:[mnp]:v_rod.*");
    private static final Pattern stdNounTagRegex = Pattern.compile("noun:(?:in)?anim:(.):(v_...).*");
    private static final Map<String, String> dashPrefixes;
    private static final Set<String> leftMasterSet;
    private static final Map<String, List<String>> numberedEntities;
    private static final Map<String, Pattern> rightPartsWithLeftTagMap;
    private static final Set<String> followerSet;
    private static final Set<String> dashPrefixesInvalid;
    private static final Set<String> noDashPrefixes2019;
    private static final Set<String> noDashPrefixes;
    private static final String ADJ_TAG_FOR_PO_ADV_MIS = "adj:m:v_mis";
    private static final String ADJ_TAG_FOR_PO_ADV_NAZ = "adj:m:v_naz";
    private static final Pattern PREFIX_NO_DASH_POSTAG_PATTERN;
    private static final List<String> LEFT_O_ADJ;
    static final List<String> LEFT_O_ADJ_INVALID;
    static final Pattern LEFT_O_ADJ_INVALID_PATTERN;
    private static final List<String> WORDS_WITH_YEAR;
    private static final List<String> WORDS_WITH_NUM;
    private static final List<String> NAME_SUFFIX;
    private static final List<String> BAD_SUFFIX;
    private static final Pattern SKY_PATTERN;
    private static final Pattern SKYI_PATTERN;
    private final WordTagger wordTagger;
    private final Locale conversionLocale;
    private final UkrainianTagger ukrainianTagger;
    private final CompoundDebugLogger compoundDebugLogger = new CompoundDebugLogger();
    private static final Pattern ABBR_PATTERN;
    private static final Pattern STRETCH_PATTERN;

    CompoundTagger(UkrainianTagger ukrainianTagger, WordTagger wordTagger, Locale conversionLocale) {
        this.ukrainianTagger = ukrainianTagger;
        this.wordTagger = wordTagger;
        this.conversionLocale = conversionLocale;
    }

    @Nullable
    public List<AnalyzedToken> guessCompoundTag(String word) {
        List<AnalyzedToken> guessedTokens = this.doGuessCompoundTag(word);
        this.compoundDebugLogger.logTaggedCompound(guessedTokens);
        return guessedTokens;
    }

    @Nullable
    private List<AnalyzedToken> doGuessCompoundTag(String word) {
        List<AnalyzedToken> tagMatch;
        List<AnalyzedToken> match;
        List<AnalyzedToken> tagMatch2;
        String wd2;
        List<TaggedWord> wdList;
        Matcher napivMatcher;
        boolean dashPrefixMatch;
        int dashIdx = word.lastIndexOf(45);
        if (dashIdx == word.length() - 1) {
            return null;
        }
        int firstDashIdx = word.indexOf(45);
        if (firstDashIdx == 0) {
            return null;
        }
        boolean startsWithDigit = Character.isDigit(word.charAt(0));
        if (!startsWithDigit && dashIdx != firstDashIdx) {
            List<AnalyzedToken> tokens;
            int dashCount = StringUtils.countMatches((CharSequence)word, (CharSequence)"-");
            if (dashCount >= 2 && dashIdx > firstDashIdx + 1 && (tokens = this.doGuessMultiHyphens(word, firstDashIdx, dashIdx)) != null) {
                return tokens;
            }
            if (dashCount == 2 && dashIdx > firstDashIdx + 1) {
                return this.doGuessTwoHyphens(word, firstDashIdx, dashIdx);
            }
            return null;
        }
        String leftWord = word.substring(0, dashIdx);
        Object rightWord = word.substring(dashIdx + 1);
        String leftWordLowerCase = leftWord.toLowerCase(this.conversionLocale);
        if (leftWord.length() == 1 && ((String)rightWord).length() > 3 && ((String)rightWord).startsWith(leftWordLowerCase)) {
            List<TaggedWord> rightWdList = this.wordTagger.tag((String)rightWord);
            rightWdList = PosTagHelper.adjust(rightWdList, null, null, ":alt");
            return this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(word, rightWdList);
        }
        boolean bl = dashPrefixMatch = dashPrefixes.containsKey(leftWord) || dashPrefixes.containsKey(leftWordLowerCase) || DASH_PREFIX_LAT_PATTERN.matcher(leftWord).matches();
        if (!dashPrefixMatch && (startsWithDigit || word.matches("[XLIV]+-.*"))) {
            return this.matchDigitCompound(word, leftWord, (String)rightWord);
        }
        if (Character.isDigit(((String)rightWord).charAt(0))) {
            return this.matchNumberedProperNoun(word, leftWord, (String)rightWord);
        }
        if (dashPrefixesInvalid.contains(leftWordLowerCase)) {
            List<TaggedWord> rightWdList = this.tagEitherCase((String)rightWord);
            if ((rightWdList = PosTagHelper.filter2(rightWdList, Pattern.compile("(noun|adj)(?!.*pron).*"))).isEmpty()) {
                return null;
            }
            String extraTag = StringTools.isCapitalizedWord((String)rightWord) ? "" : ":bad";
            rightWdList = PosTagHelper.adjust(rightWdList, leftWord + "-", null, extraTag);
            return this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(word, rightWdList);
        }
        if (leftWordLowerCase.equals("\u043f\u0456\u0432") && Character.isLowerCase(((String)rightWord).charAt(0))) {
            List<TaggedWord> rightWdList = this.tagEitherCase((String)rightWord);
            List<AnalyzedToken> rightAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal((String)rightWord, rightWdList);
            List<AnalyzedToken> newAnalyzedTokens = this.addPluralNvTokens(word, rightAnalyzedTokens, ":bad");
            return newAnalyzedTokens;
        }
        List<TaggedWord> leftWdList = this.tagAsIsAndWithLowerCase(leftWord);
        String rightWordLowerCase = ((String)rightWord).toLowerCase();
        if (rightPartsWithLeftTagMap.containsKey(rightWordLowerCase) && !PosTagHelper.hasPosTagPart2(leftWdList, "abbr")) {
            if (leftWdList.isEmpty()) {
                return null;
            }
            Pattern leftTagRegex = rightPartsWithLeftTagMap.get(rightWordLowerCase);
            List<AnalyzedToken> leftAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(leftWord, leftWdList);
            ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(leftAnalyzedTokens.size());
            if (rightWordLowerCase.equals("\u0442\u043e") && LemmaHelper.hasLemma(leftAnalyzedTokens, Arrays.asList("\u0445\u0442\u043e", "\u0449\u043e", "\u0447\u0438"))) {
                return null;
            }
            for (AnalyzedToken analyzedToken : leftAnalyzedTokens) {
                String posTag = analyzedToken.getPOSTag();
                if (leftWord.equalsIgnoreCase("\u044f\u043a") && posTag != null && posTag.contains("noun") || (posTag == null || !leftWordLowerCase.equals("\u0434\u0443\u0436\u0435") || !posTag.contains("adv")) && !leftTagRegex.matcher(posTag).matches()) continue;
                if (((String)rightWord).equals("\u0454\u043c")) {
                    posTag = PosTagHelper.addIfNotContains(posTag, ":arch");
                }
                newAnalyzedTokens.add(new AnalyzedToken(word, posTag, analyzedToken.getLemma()));
            }
            return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
        }
        if (leftWord.equalsIgnoreCase("\u043f\u043e") && SKY_PATTERN.matcher((CharSequence)rightWord).matches()) {
            rightWord = (String)rightWord + "\u0439";
        }
        if (Character.isUpperCase(leftWord.charAt(0)) && LemmaHelper.CITY_AVENU.contains(rightWordLowerCase)) {
            String addPos = ((String)rightWord).equals("\u0448\u0442\u0440\u0430\u0441\u0441\u0435") ? ":alt" : "";
            return PosTagHelper.generateTokensForNv(word, "f", ":prop" + addPos);
        }
        if (rightWordLowerCase.startsWith("\u0432\u043c\u0456\u0441\u043d")) {
            String adjustedWord = "\u0431\u043e\u0440\u043e" + (String)rightWord;
            List<Object> rightWdList = this.tagEitherCase(adjustedWord);
            rightWdList = rightWdList.stream().map(wd -> new TaggedWord("\u0432\u043c\u0456\u0441\u043d\u0438\u0439", wd.getPosTag())).collect(Collectors.toList());
            List<AnalyzedToken> rightAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal((String)rightWord, rightWdList);
            return CompoundTagger.generateTokensWithRighInflected(word, leftWord, rightAnalyzedTokens, IPOSTag.adj.getText(), null, Pattern.compile(":comp."));
        }
        List<TaggedWord> rightWdList = this.tagEitherCase((String)rightWord);
        if (word.toLowerCase().startsWith("\u043d\u0430\u043f\u0456\u0432") && (napivMatcher = Pattern.compile("\u043d\u0430\u043f\u0456\u0432(.+?)-\u043d\u0430\u043f\u0456\u0432(.+)").matcher(word)).matches()) {
            List<AnalyzedToken> napivRightAnalyzedTokens;
            List<TaggedWord> napivRightWdList;
            List<TaggedWord> napivLeftWdList = PosTagHelper.adjust(this.tagAsIsAndWithLowerCase(napivMatcher.group(1)), "\u043d\u0430\u043f\u0456\u0432", null, new String[0]);
            List<TaggedWord> list = napivRightWdList = rightWdList.size() > 0 ? rightWdList : PosTagHelper.adjust(this.tagAsIsAndWithLowerCase(napivMatcher.group(2)), "\u043d\u0430\u043f\u0456\u0432", null, new String[0]);
            if (napivLeftWdList.isEmpty() || napivRightWdList.isEmpty()) {
                return null;
            }
            List<AnalyzedToken> napivLeftAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(napivMatcher.group(1), napivLeftWdList);
            List<AnalyzedToken> tagMatch3 = this.tagMatch(word, napivLeftAnalyzedTokens, napivRightAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(napivMatcher.group(2), napivRightWdList));
            if (tagMatch3 != null) {
                return tagMatch3;
            }
        }
        Pattern TAGS_TO_REMOVE = Pattern.compile(":comp.|:predic|:insert");
        List<AnalyzedToken> leftAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(leftWord, leftWdList);
        if (((String)rightWord).startsWith("\u043f\u0440\u0435") && leftWordLowerCase.equals(((String)rightWord).substring(3).toLowerCase())) {
            if (PosTagHelper.hasPosTagStart2(leftWdList, "adv")) {
                return leftAnalyzedTokens.stream().filter(a -> a.getPOSTag() != null && a.getPOSTag().startsWith("adv")).map(a -> new AnalyzedToken(word, TAGS_TO_REMOVE.matcher(a.getPOSTag()).replaceAll(""), word)).collect(Collectors.toList());
            }
            if (PosTagHelper.hasPosTagStart2(leftWdList, "adj")) {
                return leftAnalyzedTokens.stream().filter(a -> a.getPOSTag() != null && a.getPOSTag().startsWith("adj")).map(a -> new AnalyzedToken(word, TAGS_TO_REMOVE.matcher(a.getPOSTag()).replaceAll(""), a.getLemma() + "-\u043f\u0440\u0435" + a.getLemma())).collect(Collectors.toList());
            }
        }
        if (NAME_SUFFIX.contains(rightWord) && PosTagHelper.hasPosTagPart(leftAnalyzedTokens, "name")) {
            List<TaggedWord> wordList = PosTagHelper.adjust(leftWdList, null, "-" + (String)rightWord, new String[0]);
            return this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(word, wordList);
        }
        if (leftWord.equals("\u0430\u043b\u044c") && (wdList = this.wordTagger.tag(wd2 = "\u0410\u043b\u044c-" + (String)rightWord)).size() > 0) {
            wdList = PosTagHelper.adjust(wdList, null, null, ":bad");
            return this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(wd2, wdList);
        }
        if (rightWdList.isEmpty()) {
            return null;
        }
        List<AnalyzedToken> rightAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal((String)rightWord, rightWdList);
        if (word.startsWith("\u043f\u0456\u0432") && PosTagHelper.hasPosTag(leftAnalyzedTokens, Pattern.compile("noun:inanim:p:v_...:nv.*"))) {
            return rightAnalyzedTokens.stream().filter(a -> a.getPOSTag() != null && a.getPOSTag().startsWith("noun:inanim:")).map(a -> new AnalyzedToken(word, a.getPOSTag().replaceFirst(":[mfn]:", ":p:"), word)).collect(Collectors.toList());
        }
        if (leftWord.equalsIgnoreCase("\u043f\u043e")) {
            if (((String)rightWord).endsWith("\u043e\u043c\u0443")) {
                return this.poAdvMatch(word, rightAnalyzedTokens, ADJ_TAG_FOR_PO_ADV_MIS);
            }
            if (SKYI_PATTERN.matcher((CharSequence)rightWord).matches()) {
                return this.poAdvMatch(word, rightAnalyzedTokens, ADJ_TAG_FOR_PO_ADV_NAZ);
            }
            return null;
        }
        if (Character.isUpperCase(leftWord.charAt(0)) && Character.isUpperCase(((String)rightWord).charAt(0))) {
            if (PosTagHelper.hasPosTag(leftAnalyzedTokens, GEO_V_NAZ) && PosTagHelper.hasPosTag(rightAnalyzedTokens, GEO_V_NAZ)) {
                return Arrays.asList(new AnalyzedToken(word, "noninfl:prop:geo", word));
            }
            if (PosTagHelper.hasPosTag(leftAnalyzedTokens, FNAME) && PosTagHelper.hasPosTag(rightAnalyzedTokens, FNAME)) {
                leftAnalyzedTokens = PosTagHelper.filter(leftAnalyzedTokens, Pattern.compile(".*fname.*"));
                rightAnalyzedTokens = PosTagHelper.filter(rightAnalyzedTokens, Pattern.compile(".*fname.*"));
                return this.tagMatch(word, leftAnalyzedTokens, rightAnalyzedTokens);
            }
            if (PosTagHelper.hasPosTag(leftAnalyzedTokens, LNAME_V_NAZ) && PosTagHelper.hasPosTag(rightAnalyzedTokens, LNAME_V_NAZ)) {
                return Arrays.asList(new AnalyzedToken(word, "noninfl:prop:lname", word));
            }
            if (PosTagHelper.hasPosTag(leftAnalyzedTokens, LNAME_V_ROD) && PosTagHelper.hasPosTag(rightAnalyzedTokens, LNAME_V_ROD)) {
                return Arrays.asList(new AnalyzedToken(word, "noninfl:prop:lname", word));
            }
            if (PosTagHelper.hasPosTag(leftAnalyzedTokens, NAME) && PosTagHelper.hasPosTag(rightAnalyzedTokens, NAME)) {
                return null;
            }
            if (PosTagHelper.hasPosTag(leftAnalyzedTokens, PROP_V_NAZ) && PosTagHelper.hasPosTag(rightAnalyzedTokens, PROP_V_NAZ)) {
                return Arrays.asList(new AnalyzedToken(word, "noninfl:prop", word));
            }
        }
        if (leftWord.length() > 1 && BAD_SUFFIX.contains(rightWord)) {
            List<TaggedWord> wordList = PosTagHelper.adjust(leftWdList, null, "-" + (String)rightWord, new String[0]);
            wordList = PosTagHelper.addIfNotContains(leftWdList, ":bad", null);
            List<AnalyzedToken> tagged = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(word, wordList);
            return tagged;
        }
        if (leftWord.equalsIgnoreCase((String)rightWord) && leftAnalyzedTokens.size() > 0 && LemmaHelper.hasLemma(leftAnalyzedTokens, Pattern.compile("[\u0443\u0432]?\u0432\u0435\u0441\u044c|[\u0432\u0443]\u0441[\u0435\u0456]")) && (tagMatch2 = this.tagMatch(word, leftAnalyzedTokens, rightAnalyzedTokens)) != null) {
            return tagMatch2.stream().filter(m -> CompoundTagger.equalParts(m.getLemma())).collect(Collectors.toList());
        }
        if (PosTagHelper.hasPosTagPart(leftAnalyzedTokens, "pron") && !PosTagHelper.hasPosTagPart(leftAnalyzedTokens, "numr")) {
            return null;
        }
        if (!(leftWord.equalsIgnoreCase((String)rightWord) || !PosTagHelper.hasPosTag(rightAnalyzedTokens, Pattern.compile("(part|conj).*|.*?:pron.*")) || PosTagHelper.hasPosTagStart(leftAnalyzedTokens, "numr") && PosTagHelper.hasPosTagStart(rightAnalyzedTokens, "numr"))) {
            return null;
        }
        List<AnalyzedToken> adjCompounds = new ArrayList<AnalyzedToken>();
        if (leftWord.matches("[\u0410-\u042f\u0406\u0407\u0404\u0490a-zA-Z\u03b1-\u03c9\u0391-\u03a9]|[a-zA-Z-]+") && PosTagHelper.hasPosTag(rightAnalyzedTokens, Pattern.compile("adj(?!.*(pron|bad|slang|arch)).*"))) {
            adjCompounds = CompoundTagger.generateTokensWithRighInflected(word, leftWord, rightAnalyzedTokens, IPOSTag.adj.getText(), null, Pattern.compile(":comp."));
        }
        if (!(!dashPrefixMatch || leftWord.equalsIgnoreCase("\u043c\u0456\u0434\u0456") && LemmaHelper.hasLemma(rightAnalyzedTokens, Arrays.asList("\u0431\u0440\u043e\u043d\u0437\u0430")))) {
            ArrayList<AnalyzedToken> newTokens = new ArrayList<AnalyzedToken>();
            String extraTag = "";
            boolean lowerCased = false;
            if (dashPrefixes.containsKey(leftWord)) {
                extraTag = dashPrefixes.get(leftWord);
            } else if (dashPrefixes.containsKey(leftWordLowerCase)) {
                extraTag = dashPrefixes.get(leftWordLowerCase);
                if (leftWordLowerCase.matches("[\u0430-\u044f\u0456\u0457\u0454\u0491']+")) {
                    lowerCased = true;
                }
            }
            List<AnalyzedToken> newTokensNoun = CompoundTagger.getNvPrefixNounMatch(word, rightAnalyzedTokens, lowerCased ? leftWordLowerCase : leftWord, extraTag);
            if (newTokensNoun != null) {
                newTokens.addAll(newTokensNoun);
            }
            if (leftWord.equalsIgnoreCase("\u0442\u043e\u043f") && PosTagHelper.hasPosTagPart(rightAnalyzedTokens, "numr:")) {
                return CompoundTagger.generateTokensWithRighInflected(word, leftWord, rightAnalyzedTokens, "numr:", ":bad", null);
            }
            if (newTokens.isEmpty()) {
                newTokens.addAll(adjCompounds);
            }
            return newTokens;
        }
        if (adjCompounds.size() > 0) {
            return adjCompounds;
        }
        if (Character.isUpperCase(((String)rightWord).charAt(0))) {
            List<TaggedWord> rightWdList2;
            List<AnalyzedToken> rightAnalyzedTokens2;
            if (word.startsWith("\u043f\u0456\u0432-")) {
                List<AnalyzedToken> newAnalyzedTokens = this.addPluralNvTokens(word, rightAnalyzedTokens, ":up92");
                return newAnalyzedTokens;
            }
            if ((StringTools.isCapitalizedWord((String)rightWord) || leftWord.endsWith("\u043e") || PosTagHelper.hasPosTag(rightAnalyzedTokens, Pattern.compile("adj.*"))) && (match = this.tryOWithAdj(word, leftWord, rightAnalyzedTokens2 = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal((String)rightWord, rightWdList2 = this.tagAsIsAndWithLowerCase((String)rightWord)))) != null) {
                return match;
            }
            if (!PosTagHelper.hasPosTag(leftAnalyzedTokens, Pattern.compile("noun(?!.prop).*")) || !PosTagHelper.hasPosTag(rightAnalyzedTokens, Pattern.compile("noun(?!.prop).*"))) {
                return null;
            }
        }
        List<Object> noDashAnalyzedTokens = new ArrayList();
        boolean hasIntj = PosTagHelper.hasPosTagStart(leftAnalyzedTokens, "intj");
        if (!hasIntj) {
            String noDashWord = word.replace("-", "");
            List<TaggedWord> noDashWordList = this.tagAsIsAndWithLowerCase(noDashWord);
            noDashAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(noDashWord, noDashWordList);
        }
        if (noDashAnalyzedTokens.isEmpty() && !leftWdList.isEmpty() && (leftWord.length() > 2 || hasIntj) && (tagMatch = this.tagMatch(word, leftAnalyzedTokens, rightAnalyzedTokens)) != null) {
            return tagMatch;
        }
        match = this.tryOWithAdj(word, leftWord, rightAnalyzedTokens);
        if (match != null) {
            return match;
        }
        this.compoundDebugLogger.logUnknownCompound(word);
        return null;
    }

    private List<AnalyzedToken> addPluralNvTokens(String word, List<AnalyzedToken> rightAnalyzedTokens, String addTag) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(rightAnalyzedTokens.size());
        for (AnalyzedToken rightAnalyzedToken : rightAnalyzedTokens) {
            String rightPosTag = rightAnalyzedToken.getPOSTag();
            if (rightPosTag == null || !NOUN_SING_V_ROD_REGEX.matcher(rightPosTag).matches()) continue;
            this.addPluralNvTokens(word, newAnalyzedTokens, rightPosTag, addTag);
        }
        return newAnalyzedTokens;
    }

    private void addPluralNvTokens(String word, List<AnalyzedToken> newAnalyzedTokens, String rightPosTag, String addTag) {
        for (String vid : PosTagHelper.VIDMINKY_MAP.keySet()) {
            String posTag;
            AnalyzedToken token;
            if (vid.equals("v_kly") || newAnalyzedTokens.contains(token = new AnalyzedToken(word, posTag = rightPosTag.replace("v_rod", vid).replaceFirst(":[mfn]:v_", ":p:v_") + ":nv" + addTag, word))) continue;
            newAnalyzedTokens.add(token);
        }
    }

    private static boolean equalParts(String lemma) {
        if (!lemma.contains("-")) {
            return false;
        }
        String[] parts = lemma.split("-", 2);
        return parts[0].equals(parts[1]);
    }

    private List<TaggedWord> tagEitherCase(String word) {
        if (word.isEmpty()) {
            return new ArrayList<TaggedWord>();
        }
        List rightWdList = this.wordTagger.tag(word);
        if (rightWdList.isEmpty() && Character.isUpperCase(word.charAt(0))) {
            rightWdList = this.wordTagger.tag(word.toLowerCase());
        }
        return rightWdList;
    }

    private List<AnalyzedToken> tryOWithAdj(String word, String leftWord, List<AnalyzedToken> rightAnalyzedTokens) {
        if (leftWord.length() < 3) {
            return null;
        }
        if (NUMR_ADJ_PATTERN.matcher(leftWord).matches()) {
            return this.numrAdjMatch(word, rightAnalyzedTokens, leftWord);
        }
        if (O_ADJ_PATTERN.matcher(leftWord).matches()) {
            return this.oAdjMatch(word, rightAnalyzedTokens, leftWord);
        }
        return null;
    }

    private List<AnalyzedToken> doGuessMultiHyphens(String word, int firstDashIdx, int dashIdx) {
        Set<AnalyzedToken> tokens;
        String lowerWord = word.toLowerCase();
        String[] parts = lowerWord.split("-");
        LinkedHashSet<String> set = new LinkedHashSet<String>(Arrays.asList(parts));
        String leftWd = parts[0];
        if (set.size() == 2) {
            List<TaggedWord> leftWdList = this.tagEitherCase(leftWd);
            List<TaggedWord> rightWdList = this.tagEitherCase(new ArrayList<String>(set).get(1));
            if (PosTagHelper.hasPosTag2(leftWdList, INTJ_PATTERN) && PosTagHelper.hasPosTag2(rightWdList, INTJ_PATTERN) || PosTagHelper.hasPosTag2(leftWdList, NONINFL_PATTERN) && PosTagHelper.hasPosTag2(rightWdList, NONINFL_PATTERN)) {
                return Arrays.asList(new AnalyzedToken(word, rightWdList.get(0).getPosTag(), lowerWord));
            }
        } else if (set.size() == 1) {
            if (lowerWord.equals("\u043b\u0430")) {
                return Arrays.asList(new AnalyzedToken(word, "intj", lowerWord));
            }
            List<TaggedWord> rightWdList = this.tagEitherCase(leftWd);
            if (PosTagHelper.hasPosTag2(rightWdList, INTJ_PATTERN)) {
                return Arrays.asList(new AnalyzedToken(word, rightWdList.get(0).getPosTag(), lowerWord));
            }
        }
        if (parts.length == 3 && (tokens = this.generateEntities(word)).size() > 0) {
            return new ArrayList<AnalyzedToken>(tokens);
        }
        if (parts.length >= 3 && set.size() > 1 && !dashPrefixes.containsKey(parts[0]) && !dashPrefixesInvalid.contains(parts[0])) {
            String merged = word.replace("-", "");
            List<TaggedWord> tagged = this.tagBothCases(merged, null);
            if (!(tagged = PosTagHelper.filter2Negative(tagged, ABBR_PATTERN)).isEmpty()) {
                return this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(word, PosTagHelper.addIfNotContains(tagged, ":alt"));
            }
            merged = CompoundTagger.collapseStretch(word);
            tagged = this.tagBothCases(merged, null);
            if (!(tagged = PosTagHelper.filter2Negative(tagged, ABBR_PATTERN)).isEmpty()) {
                return this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(word, PosTagHelper.addIfNotContains(tagged, ":alt"));
            }
        }
        return null;
    }

    private static String collapseStretch(String word) {
        boolean capitalized = StringTools.isCapitalizedWord((String)word);
        String merged = STRETCH_PATTERN.matcher(word.toLowerCase()).replaceAll("$1");
        merged = STRETCH_PATTERN.matcher(merged).replaceAll("$1");
        merged = merged.replace("-", "");
        if (capitalized) {
            merged = StringUtils.capitalize((String)merged);
        }
        return merged;
    }

    private List<AnalyzedToken> doGuessTwoHyphens(String word, int firstDashIdx, int dashIdx) {
        List<AnalyzedToken> secondAnalyzedTokens;
        List<AnalyzedToken> tagMatchSecondAndThird;
        String[] parts = word.split("-");
        List<TaggedWord> rightWdList = this.tagEitherCase(parts[2]);
        if (rightWdList.isEmpty()) {
            return null;
        }
        List<AnalyzedToken> rightAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(parts[2], rightWdList);
        String firstAndSecond = parts[0] + "-" + parts[1];
        boolean twoDash = false;
        String extraTag = "";
        if (dashPrefixes.containsKey(firstAndSecond)) {
            extraTag = dashPrefixes.get(firstAndSecond);
            twoDash = true;
        } else if (dashPrefixes.containsKey(firstAndSecond.toLowerCase())) {
            extraTag = dashPrefixes.get(firstAndSecond.toLowerCase());
            twoDash = true;
        }
        if (twoDash) {
            return CompoundTagger.getNvPrefixNounMatch(word, rightAnalyzedTokens, firstAndSecond, extraTag);
        }
        List<TaggedWord> secondWdList = this.tagEitherCase(parts[1]);
        if (PosTagHelper.hasPosTagStart2(secondWdList, "adj") && (tagMatchSecondAndThird = this.tagMatch(word, secondAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(parts[1], secondWdList), rightAnalyzedTokens)) != null) {
            List<TaggedWord> leftWdList = this.tagEitherCase(parts[0]);
            if (!leftWdList.isEmpty()) {
                List<AnalyzedToken> leftAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(parts[0], leftWdList);
                this.tagMatch(word, leftAnalyzedTokens, tagMatchSecondAndThird);
            }
            return tagMatchSecondAndThird;
        }
        List<AnalyzedToken> secondAndThird = this.tryOWithAdj(word, parts[1], rightAnalyzedTokens);
        if (secondAndThird != null) {
            return this.tryOWithAdj(word, parts[0], secondAndThird);
        }
        return null;
    }

    private static List<AnalyzedToken> generateTokensWithRighInflected(String word, String leftWord, List<AnalyzedToken> rightAnalyzedTokens, String posTagStart, String addTag, Pattern dropTag) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(rightAnalyzedTokens.size());
        for (AnalyzedToken analyzedToken : rightAnalyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.startsWith(posTagStart) || posTag.contains("v_kly")) continue;
            if (dropTag != null) {
                posTag = dropTag.matcher(posTag).replaceAll("");
            }
            posTag = PosTagHelper.addIfNotContains(posTag, addTag);
            newAnalyzedTokens.add(new AnalyzedToken(word, posTag, leftWord + "-" + analyzedToken.getLemma()));
        }
        return newAnalyzedTokens;
    }

    private List<AnalyzedToken> matchNumberedProperNoun(String word, String leftWord, String rightWord) {
        ArrayList<AnalyzedToken> newAnalyzedTokens;
        List<AnalyzedToken> leftAnalyzedTokens;
        List<TaggedWord> leftWdList;
        Set<AnalyzedToken> newAnalyzedTokens2;
        if (NOUN_SUFFIX_NUMBER_LETTER.matcher(rightWord).matches() && (newAnalyzedTokens2 = this.generateEntities(word)).size() > 0) {
            return new ArrayList<AnalyzedToken>(newAnalyzedTokens2);
        }
        if (YEAR_NUMBER.matcher(rightWord).matches() && !(leftWdList = this.tagAsIsAndWithLowerCase(leftWord)).isEmpty()) {
            leftAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(leftWord, leftWdList);
            newAnalyzedTokens = new ArrayList<AnalyzedToken>();
            boolean isUppercase = Character.isUpperCase(leftWord.charAt(0));
            for (AnalyzedToken analyzedToken : leftAnalyzedTokens) {
                Object posTag;
                if (!PosTagHelper.hasPosTagPart(analyzedToken, ":prop") && !WORDS_WITH_YEAR.contains(analyzedToken.getLemma()) || (posTag = analyzedToken.getPOSTag()) == null || !((String)posTag).startsWith("noun:inanim") || ((String)posTag).contains("v_kly") || ((String)posTag).contains(":p:") && !Arrays.asList("\u0433\u0440\u0430", "\u0431\u044e\u0434\u0436\u0435\u0442").contains(analyzedToken.getLemma()) && !((String)posTag).contains(":ns")) continue;
                String lemma = analyzedToken.getLemma();
                if (!((String)(posTag = ((String)posTag).replace(":geo", ""))).contains(":prop") && isUppercase) {
                    posTag = (String)posTag + ":prop";
                    lemma = StringUtils.capitalize((String)lemma);
                }
                newAnalyzedTokens.add(new AnalyzedToken(word, (String)posTag, lemma + "-" + rightWord));
            }
            if (newAnalyzedTokens.size() > 0) {
                return newAnalyzedTokens;
            }
        }
        if (NOUN_PREFIX_NUMBER.matcher(rightWord).matches() && !(leftWdList = this.tagAsIsAndWithLowerCase(leftWord)).isEmpty()) {
            leftAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(leftWord, leftWdList);
            newAnalyzedTokens = new ArrayList();
            for (AnalyzedToken analyzedToken : leftAnalyzedTokens) {
                Object posTag = analyzedToken.getPOSTag();
                String lemma = analyzedToken.getLemma();
                if (posTag == null || !((String)posTag).startsWith("noun:inanim") || ((String)posTag).contains("v_kly")) continue;
                if (!((String)posTag).contains(":prop") && !WORDS_WITH_NUM.contains(lemma)) {
                    posTag = (String)posTag + ":prop";
                    lemma = StringUtils.capitalize((String)lemma);
                }
                if (!WORDS_WITH_NUM.contains(lemma)) continue;
                newAnalyzedTokens.add(new AnalyzedToken(word, (String)posTag, lemma + "-" + rightWord));
            }
            if (newAnalyzedTokens.size() > 0) {
                return newAnalyzedTokens;
            }
        }
        return null;
    }

    Set<AnalyzedToken> generateEntities(String word) {
        LinkedHashSet<AnalyzedToken> newAnalyzedTokens = new LinkedHashSet<AnalyzedToken>();
        for (Map.Entry<String, List<String>> entry : numberedEntities.entrySet()) {
            if (!word.matches(entry.getKey())) continue;
            for (String tag : entry.getValue()) {
                if (tag.contains(":nv")) {
                    String[] tagParts = tag.split(":");
                    String extraTags = tag.replaceFirst(".*?:nv", "").replace(":np", "");
                    List<AnalyzedToken> newTokens = PosTagHelper.generateTokensForNv(word, tagParts[1], extraTags);
                    newAnalyzedTokens.addAll(newTokens);
                    if (tag.contains(":np") || tag.contains(":p")) continue;
                    newTokens = PosTagHelper.generateTokensForNv(word, "p", extraTags);
                    newAnalyzedTokens.addAll(newTokens);
                    continue;
                }
                newAnalyzedTokens.add(new AnalyzedToken(word, tag, word));
            }
        }
        return newAnalyzedTokens;
    }

    /*
     * WARNING - void declaration
     */
    private List<AnalyzedToken> matchDigitCompound(String word, String leftWord, String rightWord) {
        if (ADJ_PREFIX_NUMBER.matcher(leftWord).matches()) {
            ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>();
            String[] tags = LetterEndingForNumericHelper.findTagsAdj(leftWord, rightWord);
            if (tags != null) {
                for (String string : tags) {
                    String lemma = leftWord + "-\u0439";
                    String string2 = string.contains(":bad") ? string.replace(":bad", ":numr:bad") : string + ":numr";
                    newAnalyzedTokens.add(new AnalyzedToken(word, IPOSTag.adj.getText() + string2, lemma));
                }
            } else {
                List rightWdList;
                if (NOUN_WITH_INTERVAL_PREFIX_NUMBER.matcher(leftWord).matches()) {
                    String[] tagsNoun = LetterEndingForNumericHelper.findTagsNoun(leftWord, rightWord);
                    if (tagsNoun != null) {
                        void var9_20;
                        String[] stringArray = tagsNoun;
                        int n = stringArray.length;
                        boolean bl = false;
                        while (var9_20 < n) {
                            String tag = stringArray[var9_20];
                            newAnalyzedTokens.add(new AnalyzedToken(word, IPOSTag.numr.getText() + tag, leftWord));
                            ++var9_20;
                        }
                        return newAnalyzedTokens;
                    }
                    if ("\u043c\u043c".equals(rightWord)) {
                        for (String gender : PosTagHelper.BASE_GENDERS) {
                            for (String vidm : PosTagHelper.VIDMINKY_MAP.keySet()) {
                                if (vidm.equals("v_kly")) continue;
                                String posTag = IPOSTag.adj.getText() + ":" + gender + ":" + vidm;
                                newAnalyzedTokens.add(new AnalyzedToken(word, posTag, word));
                            }
                        }
                        return newAnalyzedTokens;
                    }
                    String tryPrefix = this.getTryPrefix(rightWord.toLowerCase());
                    if (tryPrefix != null) {
                        List rightWdList2 = this.wordTagger.tag(tryPrefix + rightWord.toLowerCase());
                        if (rightWdList2 == null) {
                            return null;
                        }
                        List<AnalyzedToken> list = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(rightWord, rightWdList2);
                        for (AnalyzedToken analyzedToken : list) {
                            String lemma = analyzedToken.getLemma().substring(tryPrefix.length());
                            newAnalyzedTokens.add(new AnalyzedToken(word, analyzedToken.getPOSTag(), leftWord + "-" + lemma));
                        }
                        return newAnalyzedTokens;
                    }
                }
                if ((rightWdList = this.wordTagger.tag(rightWord)).isEmpty() || PosTagHelper.hasPosTagPart2(rightWdList, "pron")) {
                    return null;
                }
                List<AnalyzedToken> rightAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(rightWord, rightWdList);
                for (AnalyzedToken analyzedToken : rightAnalyzedTokens) {
                    if (!analyzedToken.getPOSTag().startsWith(IPOSTag.adj.getText()) && !"\u0432\u0456\u0434\u0441\u043e\u0442\u043a\u043e\u0432\u043e".equals(analyzedToken.getLemma())) continue;
                    newAnalyzedTokens.add(new AnalyzedToken(word, analyzedToken.getPOSTag(), leftWord + "-" + analyzedToken.getLemma()));
                }
            }
            return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
        }
        return null;
    }

    private String getTryPrefix(String rightWord) {
        if (REQ_NUM_STO_PATTERN.matcher(rightWord).matches()) {
            return "\u0441\u0442\u043e";
        }
        if (REQ_NUM_DESYAT_PATTERN.matcher(rightWord).matches()) {
            return "\u0434\u0435\u0441\u044f\u0442\u0438";
        }
        if (REQ_NUM_DVA_PATTERN.matcher(rightWord).matches()) {
            return "\u0434\u0432\u043e";
        }
        return null;
    }

    private static String dropExtra(String postags) {
        Matcher matcher = postags.startsWith("noninfl") ? EXTRA_TAGS_DROP_NONINFL.matcher(postags) : EXTRA_TAGS_DROP.matcher(postags);
        postags = matcher.replaceAll("");
        return postags;
    }

    @Nullable
    private List<AnalyzedToken> tagMatch(String word, List<AnalyzedToken> leftAnalyzedTokens, List<AnalyzedToken> rightAnalyzedTokens) {
        ArrayList<Object> newAnalyzedTokens = new ArrayList<AnalyzedToken>();
        ArrayList<AnalyzedToken> newAnalyzedTokensAnimInanim = new ArrayList<AnalyzedToken>();
        String animInanimNotTagged = null;
        for (AnalyzedToken leftAnalyzedToken : leftAnalyzedTokens) {
            Matcher matcher;
            String leftPosTag = leftAnalyzedToken.getPOSTag();
            if (leftPosTag == null || IPOSTag.contains(leftPosTag, IPOSTag.abbr.getText()) || leftPosTag.startsWith("noun:inanim") && leftPosTag.contains("v_kly")) continue;
            Object leftPosTagExtra = "";
            boolean leftNv = false;
            if (leftPosTag.contains(":nv")) {
                leftNv = true;
                leftPosTag = leftPosTag.replace(":nv", "");
            }
            if ((matcher = EXTRA_TAGS.matcher(leftPosTag = CompoundTagger.dropExtra(leftPosTag))).find()) {
                leftPosTagExtra = (String)leftPosTagExtra + matcher.group();
                leftPosTag = matcher.replaceAll("");
            }
            for (AnalyzedToken rightAnalyzedToken : rightAnalyzedTokens) {
                String leftGenderConj;
                String agreedPosTag;
                Matcher matcherR;
                String rightPosTag = rightAnalyzedToken.getPOSTag();
                if (rightPosTag == null || rightPosTag.contains(IPOSTag.abbr.getText()) || rightPosTag.contains("v_zna:var") || rightPosTag.startsWith("noun:inanim") && (rightPosTag.contains("v_kly") || leftPosTag.contains(":geo") && !rightPosTag.contains(":geo") && !rightAnalyzedToken.getLemma().matches("(?iu)\u0440\u0456\u043a\u0430|\u0433\u043e\u0440\u0430|\u043c\u0456\u0441\u0442\u043e|\u0433\u0440\u0430\u0434|\u043f\u043e\u043b\u0435|\u043c\u043e\u0440\u0435|\u043f\u0430\u0440\u043a")) || rightPosTag.startsWith("noun:anim:p:v_zna:rare") && leftPosTag.startsWith("noun:inanim")) continue;
                Object extraNvTag = "";
                boolean rightNv = false;
                if (rightPosTag.contains(":nv")) {
                    rightNv = true;
                    if (leftNv) {
                        extraNvTag = (String)extraNvTag + ":nv";
                    }
                }
                if ((matcherR = EXTRA_TAGS.matcher(rightPosTag = CompoundTagger.dropExtra(rightPosTag))).find()) {
                    rightPosTag = matcherR.replaceAll("");
                }
                if (CompoundTagger.stripPerfImperf(leftPosTag).equals(CompoundTagger.stripPerfImperf(rightPosTag)) && (IPOSTag.startsWith(leftPosTag, IPOSTag.numr, IPOSTag.adv, IPOSTag.adj, IPOSTag.verb) || leftPosTag.matches("intj|noninfl.*") && leftAnalyzedToken.getLemma().equalsIgnoreCase(rightAnalyzedToken.getLemma()))) {
                    Object newPosTag = leftPosTag + (String)extraNvTag + (String)leftPosTagExtra;
                    if (leftPosTag.contains("adjp") && !rightPosTag.contains("adjp") || !leftPosTag.contains("adjp") && rightPosTag.contains("adjp")) {
                        newPosTag = ((String)newPosTag).replaceFirst(":adjp:(actv|pasv):(im)?perf", "");
                    }
                    String newLemma = leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma();
                    newAnalyzedTokens.add(new AnalyzedToken(word, (String)newPosTag, newLemma));
                    continue;
                }
                if (leftPosTag.startsWith(IPOSTag.noun.getText()) && rightPosTag.startsWith(IPOSTag.noun.getText())) {
                    agreedPosTag = this.getAgreedPosTag(leftPosTag, rightPosTag, leftNv, word);
                    if (agreedPosTag == null && rightPosTag.startsWith("noun:inanim:m:v_naz") && CompoundTagger.isMinMax(rightAnalyzedToken.getToken())) {
                        agreedPosTag = leftPosTag;
                    }
                    if (agreedPosTag == null && !CompoundTagger.isSameAnimStatus(leftPosTag, rightPosTag)) {
                        agreedPosTag = this.tryAnimInanim(leftPosTag, rightPosTag, leftAnalyzedToken.getLemma(), rightAnalyzedToken.getLemma(), leftNv, rightNv, word);
                        if (agreedPosTag == null) {
                            animInanimNotTagged = leftPosTag.contains(TAG_ANIM) ? "anim-inanim" : "inanim-anim";
                        } else {
                            newAnalyzedTokensAnimInanim.add(new AnalyzedToken(word, agreedPosTag + (String)extraNvTag + (String)leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                            continue;
                        }
                    }
                    if (agreedPosTag == null) continue;
                    newAnalyzedTokens.add(new AnalyzedToken(word, agreedPosTag + (String)extraNvTag + (String)leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                    continue;
                }
                if (leftPosTag.startsWith(IPOSTag.numr.getText()) && rightPosTag.startsWith(IPOSTag.numr.getText())) {
                    agreedPosTag = this.getNumAgreedPosTag(leftPosTag, rightPosTag, leftNv);
                    if (agreedPosTag == null) continue;
                    if (rightPosTag.contains(":p:") && !agreedPosTag.contains(":p:")) {
                        agreedPosTag = agreedPosTag.replaceFirst(":[mfn]:", ":p:");
                    }
                    newAnalyzedTokens.add(new AnalyzedToken(word, agreedPosTag + (String)extraNvTag + (String)leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                    continue;
                }
                if (IPOSTag.startsWith(leftPosTag, IPOSTag.noun) && IPOSTag.startsWith(rightPosTag, IPOSTag.numr)) {
                    if (leftAnalyzedToken.getLemma().equals("\u043f'\u044f\u0442\u0430")) continue;
                    leftGenderConj = PosTagHelper.getGenderConj(leftPosTag);
                    if (leftGenderConj != null && leftGenderConj.equals(PosTagHelper.getGenderConj(rightPosTag))) {
                        newAnalyzedTokens.add(new AnalyzedToken(word, leftPosTag + (String)extraNvTag + (String)leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                        if (leftPosTag.contains(":p:")) continue;
                        newAnalyzedTokens.add(new AnalyzedToken(word, leftPosTag.replaceAll(":[mfn]:", ":p:") + (String)extraNvTag + (String)leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                        continue;
                    }
                    String agreedPosTag2 = this.getNumAgreedPosTag(leftPosTag, rightPosTag, leftNv);
                    if (agreedPosTag2 == null) continue;
                    newAnalyzedTokens.add(new AnalyzedToken(word, agreedPosTag2 + (String)extraNvTag + (String)leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                    if (agreedPosTag2.contains(":p:")) continue;
                    newAnalyzedTokens.add(new AnalyzedToken(word, agreedPosTag2.replaceAll(":[mfn]:", ":p:") + (String)extraNvTag + (String)leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                    continue;
                }
                if (leftPosTag.startsWith(IPOSTag.noun.getText()) && IPOSTag.startsWith(rightPosTag, IPOSTag.numr) || IPOSTag.startsWith(rightPosTag, IPOSTag.adj) && this.isJuniorSenior(leftAnalyzedToken, rightAnalyzedToken)) {
                    leftGenderConj = PosTagHelper.getGenderConj(leftPosTag);
                    if (leftGenderConj == null || !leftGenderConj.equals(PosTagHelper.getGenderConj(rightPosTag))) continue;
                    newAnalyzedTokens.add(new AnalyzedToken(word, leftPosTag + (String)extraNvTag + (String)leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightAnalyzedToken.getLemma()));
                    continue;
                }
                if (!leftPosTag.startsWith(IPOSTag.noun.getText()) || !rightAnalyzedToken.getLemma().equals("\u0434\u0440\u0443\u0433\u0438\u0439") || (leftGenderConj = PosTagHelper.getGenderConj(leftPosTag)) == null || !leftGenderConj.equals(PosTagHelper.getGenderConj(rightPosTag))) continue;
                String rightLemma = leftGenderConj.startsWith("m") ? "\u0434\u0440\u0443\u0433\u0438\u0439" : (leftGenderConj.startsWith("f") ? "\u0434\u0440\u0443\u0433\u0430" : "\u0434\u0440\u0443\u0433\u0435");
                newAnalyzedTokens.add(new AnalyzedToken(word, leftPosTag + (String)extraNvTag + (String)leftPosTagExtra, leftAnalyzedToken.getLemma() + "-" + rightLemma));
            }
        }
        if (!newAnalyzedTokens.isEmpty() && !PosTagHelper.hasPosTagPart(newAnalyzedTokens, ":p:") && (LemmaHelper.hasLemma(leftAnalyzedTokens, LemmaHelper.DAYS_OF_WEEK) && LemmaHelper.hasLemma(rightAnalyzedTokens, LemmaHelper.DAYS_OF_WEEK) || LemmaHelper.hasLemma(leftAnalyzedTokens, LemmaHelper.MONTH_LEMMAS) && LemmaHelper.hasLemma(rightAnalyzedTokens, LemmaHelper.MONTH_LEMMAS))) {
            newAnalyzedTokens.add(new AnalyzedToken(word, ((AnalyzedToken)newAnalyzedTokens.get(0)).getPOSTag().replaceAll(":[mfn]:", ":p:"), ((AnalyzedToken)newAnalyzedTokens.get(0)).getLemma()));
        }
        if ((newAnalyzedTokens = new ArrayList<AnalyzedToken>(new LinkedHashSet<AnalyzedToken>(newAnalyzedTokens))).isEmpty()) {
            newAnalyzedTokens = newAnalyzedTokensAnimInanim;
        }
        if (animInanimNotTagged != null && newAnalyzedTokens.isEmpty()) {
            this.compoundDebugLogger.logUnknownCompound(word + " " + animInanimNotTagged);
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    private static String stripPerfImperf(String leftPosTag) {
        return leftPosTag.replaceAll(":(im)?perf|:adjp:(actv|pasv)", "");
    }

    private boolean isJuniorSenior(AnalyzedToken leftAnalyzedToken, AnalyzedToken rightAnalyzedToken) {
        return leftAnalyzedToken.getPOSTag().matches(".*?:[flp]name.*") && rightAnalyzedToken.getLemma().matches(".*(\u043c\u043e\u043b\u043e\u0434\u0448\u0438\u0439|\u0441\u0442\u0430\u0440\u0448\u0438\u0439)");
    }

    @Nullable
    private String getNumAgreedPosTag(String leftPosTag, String rightPosTag, boolean leftNv) {
        String leftConj;
        String agreedPosTag = null;
        if ((leftPosTag.contains(":p:") && SING_REGEX_F.matcher(rightPosTag).find() || SING_REGEX_F.matcher(leftPosTag).find() && rightPosTag.contains(":p:")) && (leftConj = PosTagHelper.getConj(leftPosTag)) != null && leftConj.equals(PosTagHelper.getConj(rightPosTag))) {
            agreedPosTag = leftPosTag;
        }
        return agreedPosTag;
    }

    @Nullable
    private String getAgreedPosTag(String leftPosTag, String rightPosTag, boolean leftNv, String word) {
        String substring2;
        String substring1;
        Matcher stdNounMatcherRight;
        boolean rightPlural;
        boolean leftPlural = CompoundTagger.isPlural(leftPosTag);
        if (leftPlural != (rightPlural = CompoundTagger.isPlural(rightPosTag))) {
            return null;
        }
        if (!CompoundTagger.isSameAnimStatus(leftPosTag, rightPosTag)) {
            return null;
        }
        Matcher stdNounMatcherLeft = stdNounTagRegex.matcher(leftPosTag);
        if (stdNounMatcherLeft.matches() && (stdNounMatcherRight = stdNounTagRegex.matcher(rightPosTag)).matches() && (substring1 = stdNounMatcherLeft.group(2)).equals(substring2 = stdNounMatcherRight.group(2))) {
            if (!stdNounMatcherLeft.group(1).equals(stdNounMatcherRight.group(1))) {
                this.compoundDebugLogger.logGenderMix(word, leftNv, leftPosTag, rightPosTag);
                if (word.length() < 10) {
                    return null;
                }
            }
            if (leftNv) {
                return rightPosTag;
            }
            return leftPosTag;
        }
        return null;
    }

    private static boolean isMinMax(String rightToken) {
        return rightToken.equals("\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c") || rightToken.equals("\u043c\u0456\u043d\u0456\u043c\u0443\u043c");
    }

    @Nullable
    private String tryAnimInanim(String leftPosTag, String rightPosTag, String leftLemma, String rightLemma, boolean leftNv, boolean rightNv, String word) {
        String agreedPosTag = null;
        if (leftMasterSet.contains(leftLemma)) {
            rightPosTag = leftPosTag.contains(TAG_ANIM) ? rightPosTag.replace(TAG_INANIM, TAG_ANIM) : rightPosTag.replace(TAG_ANIM, TAG_INANIM);
            agreedPosTag = this.getAgreedPosTag(leftPosTag, rightPosTag, leftNv, word);
            if (agreedPosTag == null) {
                if (!leftPosTag.contains(TAG_ANIM)) {
                    if (MNP_ZNA_REGEX.matcher(leftPosTag).matches() && MNP_NAZ_REGEX.matcher(rightPosTag).matches() && !leftNv && !rightNv) {
                        agreedPosTag = leftPosTag;
                    }
                } else if (MNP_ZNA_REGEX.matcher(leftPosTag).matches() && MNP_ROD_REGEX.matcher(rightPosTag).matches() && !leftNv && !rightNv) {
                    agreedPosTag = leftPosTag;
                }
            }
        } else if (followerSet.contains(rightLemma)) {
            agreedPosTag = this.getAgreedPosTag(leftPosTag, rightPosTag = rightPosTag.replace(TAG_ANIM, TAG_INANIM), false, word);
            if (agreedPosTag == null && leftPosTag.contains(TAG_INANIM) && MNP_ZNA_REGEX.matcher(leftPosTag).matches() && MNP_NAZ_REGEX.matcher(rightPosTag).matches() && PosTagHelper.getNum(leftPosTag).equals(PosTagHelper.getNum(rightPosTag)) && !leftNv && !rightNv) {
                agreedPosTag = leftPosTag;
            }
        } else if (followerSet.contains(leftLemma) && (agreedPosTag = this.getAgreedPosTag(rightPosTag, leftPosTag = leftPosTag.replace(TAG_ANIM, TAG_INANIM), false, word)) == null && rightPosTag.contains(TAG_INANIM) && MNP_ZNA_REGEX.matcher(rightPosTag).matches() && MNP_NAZ_REGEX.matcher(leftPosTag).matches() && PosTagHelper.getNum(leftPosTag).equals(PosTagHelper.getNum(rightPosTag)) && !leftNv && !rightNv) {
            agreedPosTag = rightPosTag;
        }
        return agreedPosTag;
    }

    private static boolean isSameAnimStatus(String leftPosTag, String rightPosTag) {
        boolean rightAnim;
        boolean leftAnim = leftPosTag.contains(TAG_ANIM);
        return leftAnim == (rightAnim = rightPosTag.contains(TAG_ANIM));
    }

    private static boolean isPlural(String posTag) {
        return posTag.startsWith("noun:") && posTag.contains(":p:");
    }

    @Nullable
    private List<AnalyzedToken> oAdjMatch(String word, List<AnalyzedToken> analyzedTokens, String leftWord) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(analyzedTokens.size());
        String leftBase = leftWord.substring(0, leftWord.length() - 1);
        String extraTag = "";
        if (!LEFT_O_ADJ.contains(leftWord.toLowerCase(this.conversionLocale))) {
            List<Object> taggedWords = new ArrayList();
            taggedWords = this.tagBothCases(leftWord, Pattern.compile("^adv.*|.*?numr.*"));
            if (taggedWords.isEmpty()) {
                taggedWords = this.tagBothCases(CompoundTagger.oToYj(leftWord), Pattern.compile("^adj.*"));
            }
            if (taggedWords.isEmpty() && leftWord.length() > 4) {
                taggedWords = this.tagBothCases(leftBase, Pattern.compile("^noun.*"));
            }
            if (taggedWords.isEmpty()) {
                taggedWords = this.tagBothCases(leftBase + "\u0430", Pattern.compile("(noun:inanim:f:v_naz|numr).*"));
            }
            if (taggedWords.isEmpty()) {
                return null;
            }
            if (!extraTag.equals(":bad")) {
                List<TaggedWord> noDashWordList;
                String noDashWord;
                List<AnalyzedToken> noDashAnalyzedTokens;
                List<AnalyzedToken> allCapTokens = this.ukrainianTagger.analyzeAllCapitamizedAdj(word);
                if (((TaggedWord)taggedWords.get(0)).getPosTag().startsWith(IPOSTag.adv.getText()) && PosTagHelper.hasPosTagPart(analyzedTokens, "adjp")) {
                    extraTag = ":bad";
                } else if (PosTagHelper.hasPosTagPart2(taggedWords, ":bad")) {
                    extraTag = ":bad";
                } else if (LEFT_O_ADJ_INVALID.contains(leftWord.toLowerCase())) {
                    if (allCapTokens.isEmpty()) {
                        extraTag = ":bad";
                    }
                } else if (allCapTokens.size() == 0 && !(noDashAnalyzedTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(noDashWord = word.replace("-", ""), noDashWordList = this.tagAsIsAndWithLowerCase(noDashWord))).isEmpty()) {
                    extraTag = ":bad";
                }
            }
        }
        for (AnalyzedToken analyzedToken : analyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.startsWith(IPOSTag.adj.getText())) continue;
            if (posTag.contains(":comp")) {
                posTag = PosTagHelper.ADJ_COMP_REGEX.matcher(posTag).replaceFirst("");
            }
            if (extraTag.contains(":bad")) {
                posTag = posTag.replace(":arch", "");
            }
            posTag = PosTagHelper.addIfNotContains(posTag, extraTag);
            newAnalyzedTokens.add(new AnalyzedToken(word, posTag, leftWord.toLowerCase() + "-" + analyzedToken.getLemma()));
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    @Nullable
    private List<AnalyzedToken> numrAdjMatch(String word, List<AnalyzedToken> analyzedTokens, String leftWord) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(analyzedTokens.size());
        String extraTag = "";
        List taggedWords = this.wordTagger.tag(leftWord);
        if (!PosTagHelper.hasPosTagStart2(taggedWords, "numr")) {
            return null;
        }
        String leftWordLowerCase = leftWord.toLowerCase();
        if (leftWordLowerCase.matches(".*?(\u0434\u0432\u043e\u0445|\u0442\u0440\u044c\u043e\u0445|\u0447\u043e\u0442\u0438\u0440\u044c\u043e\u0445)")) {
            extraTag = ":bad";
        } else if (analyzedTokens.size() > 0 && !analyzedTokens.get(0).getToken().matches("(?iu)(\u0434\u0432\u043e|\u0442\u0440\u0438|\u0447\u043e\u0442\u0438\u0440\u0438|\u043f'\u044f\u0442\u0438|\u0448\u0435\u0441\u0442\u0438|\u0441\u0435\u043c\u0438|\u0432\u0456\u0441\u044c\u043c\u0438|\u0434\u0432\u043e\u0445|\u0442\u0440\u044c\u043e\u0445|\u0447\u043e\u0442\u0438\u0440\u044c\u043e\u0445).+")) {
            extraTag = ":bad";
        }
        for (AnalyzedToken analyzedToken : analyzedTokens) {
            Object posTag = analyzedToken.getPOSTag();
            if (!((String)posTag).startsWith(IPOSTag.adj.getText())) continue;
            if (((String)posTag).contains(":comp")) {
                posTag = PosTagHelper.ADJ_COMP_REGEX.matcher((CharSequence)posTag).replaceFirst("");
            }
            if (!((String)posTag).contains(":bad")) {
                posTag = (String)posTag + extraTag;
            }
            String newLemma = leftWordLowerCase + "-" + analyzedToken.getLemma();
            newAnalyzedTokens.add(new AnalyzedToken(word, (String)posTag, newLemma));
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    private static String oToYj(String leftWord) {
        return leftWord.endsWith("\u044c\u043e") ? leftWord.substring(0, leftWord.length() - 2) + "\u0456\u0439" : leftWord.substring(0, leftWord.length() - 1) + "\u0438\u0439";
    }

    @Nullable
    private static List<AnalyzedToken> getNvPrefixNounMatch(String word, List<AnalyzedToken> analyzedTokens, String leftWord, String extraTag) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(analyzedTokens.size());
        for (AnalyzedToken analyzedToken : analyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.startsWith(IPOSTag.noun.getText()) || posTag.contains("v_kly")) continue;
            if (!(extraTag.equals(":up92") && Character.isUpperCase(analyzedToken.getLemma().charAt(0)) || !StringUtils.isNotEmpty((CharSequence)extraTag))) {
                posTag = PosTagHelper.addIfNotContains(posTag, extraTag);
            }
            String newLemma = leftWord + "-" + analyzedToken.getLemma();
            newAnalyzedTokens.add(new AnalyzedToken(word, posTag, newLemma));
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    @Nullable
    private static List<AnalyzedToken> getNvPrefixLatWithAdjMatch(String word, List<AnalyzedToken> analyzedTokens, String leftWord) {
        ArrayList<AnalyzedToken> newAnalyzedTokens = new ArrayList<AnalyzedToken>(analyzedTokens.size());
        for (AnalyzedToken analyzedToken : analyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.startsWith(IPOSTag.adj.getText()) || posTag.contains("v_kly")) continue;
            newAnalyzedTokens.add(new AnalyzedToken(word, posTag, leftWord + "-" + analyzedToken.getLemma()));
        }
        return newAnalyzedTokens.isEmpty() ? null : newAnalyzedTokens;
    }

    @Nullable
    private List<AnalyzedToken> poAdvMatch(String word, List<AnalyzedToken> analyzedTokens, String adjTag) {
        for (AnalyzedToken analyzedToken : analyzedTokens) {
            String posTag = analyzedToken.getPOSTag();
            if (!posTag.startsWith(adjTag)) continue;
            return Arrays.asList(new AnalyzedToken(word, IPOSTag.adv.getText(), word));
        }
        return null;
    }

    private String capitalize(String word) {
        return word.substring(0, 1).toUpperCase(this.conversionLocale) + word.substring(1);
    }

    List<TaggedWord> tagBothCases(String leftWord, Pattern posTagMatcher) {
        List leftWdList = this.wordTagger.tag(leftWord);
        String leftLowerCase = leftWord.toLowerCase(this.conversionLocale);
        if (!leftWord.equals(leftLowerCase)) {
            leftWdList.addAll(this.wordTagger.tag(leftLowerCase));
        } else {
            String leftUpperCase = this.capitalize(leftWord);
            if (!leftWord.equals(leftUpperCase)) {
                leftWdList.addAll(this.wordTagger.tag(leftUpperCase));
            }
        }
        if (posTagMatcher != null) {
            leftWdList = leftWdList.stream().filter(word -> posTagMatcher.matcher(word.getPosTag()).matches()).collect(Collectors.toList());
        }
        return leftWdList;
    }

    private List<TaggedWord> tagAsIsAndWithLowerCase(String leftWord) {
        List leftWdList = this.wordTagger.tag(leftWord);
        String leftLowerCase = leftWord.toLowerCase(this.conversionLocale);
        if (!leftWord.equals(leftLowerCase)) {
            leftWdList.addAll(this.wordTagger.tag(leftLowerCase));
        }
        return leftWdList;
    }

    @Nullable
    List<AnalyzedToken> guessOtherTags(String word) {
        List<AnalyzedToken> guessedTokens = this.guessOtherTagsInternal(word);
        this.compoundDebugLogger.logTaggedCompound(guessedTokens);
        return guessedTokens;
    }

    @Nullable
    private List<AnalyzedToken> guessOtherTagsInternal(String word) {
        if (word.length() <= 7 || !UKR_LETTERS_PATTERN.matcher(word).matches()) {
            return null;
        }
        if (StringTools.isCapitalizedWord((String)word)) {
            if (word.endsWith("\u0448\u0442\u0440\u0430\u0441\u0441\u0435") || word.endsWith("\u0448\u0442\u0440\u0430\u0441\u0435")) {
                String addPos = word.endsWith("\u0448\u0442\u0440\u0430\u0441\u0441\u0435") ? ":alt" : "";
                return PosTagHelper.generateTokensForNv(word, "f", ":prop" + addPos);
            }
            if (word.endsWith("\u0434\u0437\u0435") || word.endsWith("\u0448\u0432\u0456\u043b\u0456") || word.endsWith("\u0456\u0430\u043d\u0456")) {
                return PosTagHelper.generateTokensForNv(word, "mf", ":prop:lname");
            }
        }
        String lowerCase = word.toLowerCase();
        for (String prefix : noDashPrefixes) {
            if (!lowerCase.startsWith(prefix)) continue;
            String right = word.substring(prefix.length(), word.length());
            String apo = "";
            ArrayList<String> addTag = new ArrayList<String>();
            if (right.startsWith("'")) {
                right = right.substring(1);
                apo = "'";
            }
            if (right.length() < 2) continue;
            boolean apoNeeded = false;
            if ("\u0454\u0457\u044e\u044f".indexOf(right.charAt(0)) != -1 && "\u0430\u0435\u0454\u0438\u0456\u0457\u043e\u0443\u044e\u044f".indexOf(prefix.charAt(prefix.length() - 1)) == -1) {
                apoNeeded = true;
            }
            if (!apoNeeded && !apo.isEmpty()) break;
            if (apoNeeded == apo.isEmpty()) {
                addTag.add(":bad");
            }
            if (noDashPrefixes2019.contains(prefix)) {
                addTag.add(":up19");
            }
            if (right.length() < 4 || StringTools.isCapitalizedWord((String)right)) continue;
            List<TaggedWord> rightWdList = this.wordTagger.tag(right);
            rightWdList = PosTagHelper.filter2(rightWdList, PREFIX_NO_DASH_POSTAG_PATTERN);
            rightWdList.removeIf(w -> w.getPosTag().startsWith("noun:inanim") && w.getPosTag().contains("v_kly"));
            if (rightWdList.size() <= 0) continue;
            rightWdList = PosTagHelper.adjust(rightWdList, prefix + apo, null, addTag.toArray(new String[0]));
            List<AnalyzedToken> compoundTokens = this.ukrainianTagger.asAnalyzedTokenListForTaggedWordsInternal(word, rightWdList);
            return compoundTokens;
        }
        return null;
    }

    static {
        rightPartsWithLeftTagMap = new HashMap<String, Pattern>();
        PREFIX_NO_DASH_POSTAG_PATTERN = Pattern.compile("(noun|adj|adv)(?!.*pron).*");
        LEFT_O_ADJ = Arrays.asList("\u0430\u0432\u0441\u0442\u0440\u043e", "\u0430\u0434\u0438\u0433\u043e", "\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u043e", "\u0430\u043d\u0433\u043b\u043e", "\u0430\u0444\u0440\u043e", "\u0435\u043a\u043e", "\u0456\u043d\u0434\u043e", "\u0456\u0441\u043f\u0430\u043d\u043e", "\u0456\u0442\u0430\u043b\u043e", "\u0456\u0441\u0442\u043e\u0440\u0438\u043a\u043e", "\u043a\u0438\u0454\u0432\u043e", "\u043c\u0430\u0440\u043e\u043a\u0430\u043d\u043e", "\u0443\u0433\u0440\u043e", "\u044f\u043f\u043e\u043d\u043e", "\u0440\u0443\u043c\u0443\u043d\u043e");
        LEFT_O_ADJ_INVALID = Arrays.asList("\u0431\u0430\u0433\u0430\u0442\u043e", "\u043c\u0430\u043b\u043e", "\u0432\u0438\u0441\u043e\u043a\u043e", "\u043d\u0438\u0437\u044c\u043a\u043e", "\u0441\u0442\u0430\u0440\u043e", "\u0432\u0430\u0436\u043a\u043e", "\u0437\u043e\u0432\u043d\u0456\u0448\u043d\u044c\u043e", "\u0432\u043d\u0443\u0442\u0440\u0456\u0448\u043d\u044c\u043e", "\u043d\u043e\u0432\u043e", "\u0441\u0435\u0440\u0435\u0434\u043d\u044c\u043e", "\u043f\u0456\u0432\u0434\u0435\u043d\u043d\u043e", "\u043f\u0456\u0432\u043d\u0456\u0447\u043d\u043e", "\u0437\u0430\u0445\u0456\u0434\u043d\u043e", "\u0441\u0445\u0456\u0434\u043d\u043e", "\u0446\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e", "\u0440\u0430\u043d\u043d\u044c\u043e", "\u043f\u0456\u0437\u043d\u044c\u043e");
        LEFT_O_ADJ_INVALID_PATTERN = Pattern.compile("^(" + StringUtils.join(LEFT_O_ADJ_INVALID, (String)"|") + ")(.+)");
        WORDS_WITH_YEAR = Arrays.asList("\u0431\u044e\u0434\u0436\u0435\u0442", "\u0432\u0438\u0431\u043e\u0440\u0438", "\u0433\u0440\u0430", "\u0434\u0435\u0440\u0436\u0431\u044e\u0434\u0436\u0435\u0442", "\u043a\u043e\u0448\u0442\u043e\u0440\u0438\u0441", "\u043a\u0430\u043c\u043f\u0430\u043d\u0456\u044f", "\u0454\u0432\u0440\u043e\u043a\u0443\u0431\u043e\u043a", "\u0454\u0432\u0440\u043e\u043a\u0432\u0430\u043b\u0456\u0444\u0456\u043a\u0430\u0446\u0456\u044f", "\u0454\u0432\u0440\u043e\u0432\u0456\u0434\u0431\u0456\u0440", "\u0454\u0432\u0440\u043e\u0444\u043e\u0440\u0443\u043c", "\u043a\u043e\u043d\u043a\u0443\u0440\u0441", "\u043a\u0456\u043d\u043e\u0444\u0435\u0441\u0442\u0438\u0432\u0430\u043b\u044c", "\u043a\u0443\u0431\u043e\u043a", "\u043c\u0443\u043d\u0434\u0456\u0430\u043b\u044c", "\u043c'\u044f\u0447", "\u043e\u043b\u0456\u043c\u043f\u0456\u0430\u0434\u0430", "\u043e\u0446\u0456\u043d\u044e\u0432\u0430\u043d\u043d\u044f", "\u043e\u0441\u043a\u0430\u0440", "\u043f\u0435\u043a\u0442\u043e\u0440\u0430\u043b\u044c", "\u043f\u0435\u0440\u0435\u0433\u043e\u043d\u0438", "\u043f\u0435\u0440\u0448\u0456\u0441\u0442\u044c", "\u043f\u043e\u043b\u0456\u0442\u0440\u0435\u0444\u043e\u0440\u043c\u0430", "\u043f\u0440\u0435\u043c\u0456\u044f", "\u0440\u0435\u0439\u0442\u0438\u043d\u0433", "\u0440\u0435\u0444\u043e\u0440\u043c\u0430", "\u0441\u0435\u0437\u043e\u043d", "\u0442\u0443\u0440\u043d\u0456\u0440", "\u0443\u043d\u0456\u0432\u0435\u0440\u0441\u0456\u0430\u0434\u0430", "\u0444\u0435\u0441\u0442\u0438\u0432\u0430\u043b\u044c", "\u0444\u043e\u0440\u0443\u043c", "\u0447\u0435\u043c\u043f\u0456\u043e\u043d\u0430\u0442", "\u0447\u0435\u043c\u043f\u0456\u043e\u043d", "\u0447\u0435\u043c\u043f\u0456\u043e\u043d\u043a\u0430", "\u044f\u0440\u043c\u0430\u0440\u043e\u043a", "\u0427\u0423", "\u0427\u0404");
        WORDS_WITH_NUM = Arrays.asList("\u0424\u043e\u0440\u043c\u0443\u043b\u0430", "\u041a\u0430\u0440\u043f\u0430\u0442\u0438", "\u0414\u0438\u043d\u0430\u043c\u043e", "\u0428\u0430\u0445\u0442\u0430\u0440", "\u0424\u0443\u043a\u0443\u0441\u0456\u043c\u0430", "\u041a\u0432\u0430\u0440\u0442\u0430\u043b", "\u0417\u043e\u043b\u043e\u0442\u0435", "\u041c\u0456\u043d\u0441\u044c\u043a", "\u041d\u044e\u0440\u0435\u043d\u0431\u0435\u0440\u0433", "\u043e\u043c\u0435\u0433\u0430", "\u043f\u043b\u0443\u0442\u043e\u043d\u0456\u0439", "\u043f\u043e\u043b\u043e\u043d\u0456\u0439", "\u0441\u0442\u0440\u043e\u043d\u0446\u0456\u0439", "\u0443\u0440\u0430\u043d", "\u043f\u043e\u0442\u0456\u043a");
        NAME_SUFFIX = Arrays.asList("\u0430\u0433\u0430", "\u0435\u0444\u0435\u043d\u0434\u0456", "\u0431\u0435\u043a", "\u0437\u0430\u0434\u0435", "\u043e\u0433\u043b\u0438", "\u0441\u0430\u043d", "\u043a\u0438\u0437\u0438", "\u0441\u0435\u043d\u0441\u0435\u0439");
        BAD_SUFFIX = Arrays.asList("\u0431", "\u0431\u0438", "\u0436", "\u0436\u0435");
        SKY_PATTERN = Pattern.compile(".*[\u0441\u0437\u0446]\u044c\u043a\u0438");
        SKYI_PATTERN = Pattern.compile(".*[\u0441\u0437\u0446]\u044c\u043a\u0438\u0439");
        rightPartsWithLeftTagMap.put("\u0431\u043e", Pattern.compile("(verb|.*?pron|noun|adv|intj|part).*"));
        rightPartsWithLeftTagMap.put("\u043d\u043e", Pattern.compile("((verb(?!.*bad).*?:(impr|futr|insert))|intj|adv|part|conj).*"));
        rightPartsWithLeftTagMap.put("\u043e\u0442", Pattern.compile("(.*?pron|adv|part|verb).*"));
        rightPartsWithLeftTagMap.put("\u0442\u043e", Pattern.compile("(.*?pron|verb|noun|adj|adv|conj).*"));
        rightPartsWithLeftTagMap.put("\u0442\u0430\u043a\u0438", Pattern.compile("(verb|adv|adj|.*?pron|part|noninfl:predic).*"));
        rightPartsWithLeftTagMap.put("\u0454\u043c", Pattern.compile("(verb).*"));
        dashPrefixes = ExtraDictionaryLoader.loadMap("/uk/dash_prefixes.txt");
        dashPrefixesInvalid = ExtraDictionaryLoader.loadSet("/uk/dash_prefixes_invalid.txt");
        noDashPrefixes2019 = dashPrefixes.entrySet().stream().filter(e -> ((String)e.getValue()).contains("up92")).map(e -> (String)e.getKey()).collect(Collectors.toSet());
        noDashPrefixes = new HashSet<String>(dashPrefixesInvalid);
        noDashPrefixes.addAll(noDashPrefixes2019);
        noDashPrefixes.remove("\u043c\u0456\u043b\u0456");
        noDashPrefixes.remove("\u043f\u043e\u043f");
        noDashPrefixes.remove("\u043f\u0440\u0435\u0441");
        leftMasterSet = ExtraDictionaryLoader.loadSet("/uk/dash_left_master.txt");
        followerSet = ExtraDictionaryLoader.loadSet("/uk/dash_follower.txt");
        numberedEntities = ExtraDictionaryLoader.loadSpacedLists("/uk/entities.txt");
        ABBR_PATTERN = Pattern.compile(".*abbr.*");
        STRETCH_PATTERN = Pattern.compile("([\u0430-\u0456\u044f\u0457\u0454\u0491\u0410-\u042f\u0406\u0407\u0404\u0490])\\1*-\\1+");
    }
}

