/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.index;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.dev.index.DoNotUseAnalyzer;
import org.languagetool.dev.index.LanguageToolAnalyzer;
import org.languagetool.tokenizers.SentenceTokenizer;

public class Indexer {
    private static final Version LUCENE_VERSION = Version.LUCENE_41;
    private final IndexWriter writer;
    private final SentenceTokenizer sentenceTokenizer;

    public Indexer(Directory dir, Language language) {
        try {
            HashMap<String, LanguageToolAnalyzer> analyzerMap = new HashMap<String, LanguageToolAnalyzer>();
            analyzerMap.put("field", new LanguageToolAnalyzer(LUCENE_VERSION, new JLanguageTool(language), false));
            analyzerMap.put("fieldLowercase", new LanguageToolAnalyzer(LUCENE_VERSION, new JLanguageTool(language), true));
            PerFieldAnalyzerWrapper analyzer = new PerFieldAnalyzerWrapper((Analyzer)new DoNotUseAnalyzer(), analyzerMap);
            IndexWriterConfig writerConfig = new IndexWriterConfig(LUCENE_VERSION, (Analyzer)analyzer);
            writerConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            this.writer = new IndexWriter(dir, writerConfig);
            this.sentenceTokenizer = language.getSentenceTokenizer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws IOException {
        Indexer.ensureCorrectUsageOrExit(args);
        Indexer.run(args[0], args[1], args[2]);
    }

    private static void ensureCorrectUsageOrExit(String[] args) {
        if (args.length != 3) {
            System.err.println("Usage: Indexer <textFile> <indexDir> <languageCode>");
            System.err.println("\ttextFile path to a text file to be indexed");
            System.err.println("\tindexDir path to a directory storing the index");
            System.err.println("\tlanguageCode short language code, e.g. en for English");
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run(String textFile, String indexDir, String languageCode) throws IOException {
        File file = new File(textFile);
        if (!file.exists() || !file.canRead()) {
            System.out.println("Text file '" + file.getAbsolutePath() + "' does not exist or is not readable, please check the path");
            System.exit(1);
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            System.out.println("Indexing to directory '" + indexDir + "'...");
            FSDirectory directory = FSDirectory.open((File)new File(indexDir));
            try {
                Language language = Language.getLanguageForShortName((String)languageCode);
                Indexer indexer = new Indexer((Directory)directory, language);
                try {
                    Indexer.run(reader, indexer, false);
                }
                finally {
                    indexer.close();
                }
            }
            finally {
                directory.close();
            }
        }
        finally {
            reader.close();
        }
        System.out.println("Index complete!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(String content, Directory dir, Language language, boolean isSentence) throws IOException {
        BufferedReader br = new BufferedReader(new StringReader(content));
        Indexer indexer = new Indexer(dir, language);
        try {
            Indexer.run(br, indexer, isSentence);
        }
        finally {
            indexer.close();
        }
    }

    public static void run(BufferedReader reader, Indexer indexer, boolean isSentence) throws IOException {
        indexer.index(reader, isSentence, -1);
    }

    public void index(String content, boolean isSentence, int docCount) throws IOException {
        BufferedReader br = new BufferedReader(new StringReader(content));
        this.index(br, isSentence, docCount);
    }

    public void index(BufferedReader reader, boolean isSentence, int docCount) throws IOException {
        String line = "";
        while ((line = reader.readLine()) != null) {
            if (isSentence) {
                this.add(-1, line);
                continue;
            }
            List sentences = this.sentenceTokenizer.tokenize(line);
            for (String sentence : sentences) {
                this.add(docCount, sentence);
            }
        }
    }

    public void add(Document doc) throws IOException {
        this.writer.addDocument((Iterable)doc);
    }

    private void add(int docCount, String sentence) throws IOException {
        Document doc = new Document();
        FieldType type = new FieldType();
        type.setStored(true);
        type.setIndexed(true);
        type.setTokenized(true);
        doc.add((IndexableField)new Field("field", sentence, type));
        doc.add((IndexableField)new Field("fieldLowercase", sentence, type));
        if (docCount != -1) {
            FieldType countType = new FieldType();
            countType.setStored(true);
            countType.setIndexed(false);
            doc.add((IndexableField)new Field("docCount", docCount + "", countType));
        }
        this.writer.addDocument((Iterable)doc);
    }

    public void close() throws IOException {
        this.writer.close();
    }
}

