/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.index;

import java.util.HashSet;
import org.apache.lucene.index.Term;
import org.apache.lucene.sandbox.queries.regex.JavaUtilRegexCapabilities;
import org.apache.lucene.sandbox.queries.regex.RegexCapabilities;
import org.apache.lucene.sandbox.queries.regex.RegexQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.languagetool.Language;
import org.languagetool.dev.index.UnsupportedPatternRuleException;
import org.languagetool.rules.patterns.Element;
import org.languagetool.rules.patterns.PatternRule;

public class PatternRuleQueryBuilder {
    public static final String FIELD_NAME = "field";
    public static final String FIELD_NAME_LOWERCASE = "fieldLowercase";
    private final Language language;

    public PatternRuleQueryBuilder(Language language) {
        this.language = language;
    }

    public Query buildRelaxedQuery(PatternRule rule) throws UnsupportedPatternRuleException {
        BooleanQuery booleanQuery = new BooleanQuery();
        for (Element element : rule.getElements()) {
            try {
                BooleanClause clause = this.makeQuery(element);
                booleanQuery.add(clause);
            }
            catch (UnsupportedPatternRuleException e) {
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create query for rule " + rule.getId(), e);
            }
        }
        if (booleanQuery.clauses().size() == 0) {
            throw new UnsupportedPatternRuleException("No items found in rule that can be used to build a search query: " + rule);
        }
        return booleanQuery;
    }

    private BooleanClause makeQuery(Element element) throws UnsupportedPatternRuleException {
        this.checkUnsupportedElement(element);
        String termStr = element.getString();
        String pos = element.getPOStag();
        BooleanClause termQuery = this.getTermQueryOrNull(element, termStr);
        BooleanClause posQuery = this.getPosQueryOrNull(element, pos);
        if (termQuery != null && posQuery != null) {
            if (this.mustOccur(termQuery) && this.mustOccur(posQuery)) {
                SpanQuery spanQueryForTerm = this.asSpanQuery(termQuery);
                SpanQuery spanQueryForPos = this.asSpanQuery(posQuery);
                SpanQuery[] spanClauses = new SpanQuery[]{spanQueryForTerm, spanQueryForPos};
                return new BooleanClause((Query)new SpanNearQuery(spanClauses, 0, false), BooleanClause.Occur.MUST);
            }
            throw new UnsupportedPatternRuleException("FIXME: Term/POS combination not supported yet: " + element);
        }
        if (termQuery != null) {
            return termQuery;
        }
        if (posQuery != null) {
            return posQuery;
        }
        throw new UnsupportedPatternRuleException("Neither POS tag nor term set for element: " + element);
    }

    private SpanQuery asSpanQuery(BooleanClause query) {
        if (query.getQuery() instanceof MultiTermQuery) {
            return new SpanMultiTermQueryWrapper((MultiTermQuery)query.getQuery());
        }
        HashSet terms = new HashSet();
        query.getQuery().extractTerms(terms);
        if (terms.size() != 1) {
            throw new RuntimeException("Expected term set of size 1: " + terms);
        }
        return new SpanTermQuery((Term)terms.iterator().next());
    }

    private boolean mustOccur(BooleanClause query) {
        return query != null && query.getOccur() == BooleanClause.Occur.MUST;
    }

    private BooleanClause getTermQueryOrNull(Element element, String termStr) {
        if (termStr == null || termStr.isEmpty()) {
            return null;
        }
        Term termQueryTerm = this.getTermQueryTerm(element, termStr);
        if (element.isInflected() && element.isRegularExpression()) {
            return null;
        }
        Object termQuery = element.isRegularExpression() ? this.getRegexQuery(termQueryTerm, termStr) : new TermQuery(termQueryTerm);
        if (element.getNegation()) {
            return null;
        }
        return new BooleanClause(termQuery, BooleanClause.Occur.MUST);
    }

    private BooleanClause getPosQueryOrNull(Element element, String pos) {
        Query posQuery;
        if (pos == null || pos.isEmpty()) {
            return null;
        }
        if (element.isPOStagRegularExpression()) {
            Term posQueryTerm = this.getPosQueryTerm(element, "_POS_(", pos, ")");
            posQuery = this.getRegexQuery(posQueryTerm, pos);
        } else {
            Term posQueryTerm = this.getPosQueryTerm(element, "_POS_", pos, "");
            posQuery = new TermQuery(posQueryTerm);
        }
        if (element.getPOSNegation()) {
            return null;
        }
        return new BooleanClause(posQuery, BooleanClause.Occur.MUST);
    }

    private Term getTermQueryTerm(Element element, String str) {
        if (element.getCaseSensitive()) {
            return new Term(FIELD_NAME, str);
        }
        return new Term(FIELD_NAME_LOWERCASE, str.toLowerCase());
    }

    private Term getPosQueryTerm(Element element, String prefix, String pos, String suffix) {
        if (element.getCaseSensitive()) {
            return new Term(FIELD_NAME, prefix + pos + suffix);
        }
        return new Term(FIELD_NAME_LOWERCASE, prefix.toLowerCase() + pos.toLowerCase() + suffix.toLowerCase());
    }

    private Query getRegexQuery(Term term, String str) {
        try {
            if (str.contains("?iu") || str.contains("?-i")) {
                return this.getFallbackRegexQuery(str);
            }
            return new RegexpQuery(term);
        }
        catch (IllegalArgumentException e) {
            return this.getFallbackRegexQuery(str);
        }
    }

    private RegexQuery getFallbackRegexQuery(String str) {
        RegexQuery query = new RegexQuery(new Term(FIELD_NAME_LOWERCASE, str));
        query.setRegexImplementation((RegexCapabilities)new JavaUtilRegexCapabilities(2));
        return query;
    }

    private void checkUnsupportedElement(Element patternElement) throws UnsupportedPatternRuleException {
        if (patternElement.isUnified()) {
            throw new UnsupportedPatternRuleException("Elements with unified tokens are not supported.");
        }
        if (patternElement.isInflected()) {
            throw new UnsupportedPatternRuleException("Elements with inflected tokens are not supported");
        }
        if (patternElement.getString().contains("\\d")) {
            throw new UnsupportedPatternRuleException("Elements with regex containing \\d are not supported.");
        }
        if (patternElement.getString().matches("\\\\\\d+")) {
            throw new UnsupportedPatternRuleException("Elements with only match references are not supported.");
        }
    }
}

