/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.dev.wikipedia.ArticleLimitReachedException;
import org.languagetool.dev.wikipedia.BaseWikipediaDumpHandler;
import org.languagetool.dev.wikipedia.DatabaseDumpHandler;
import org.languagetool.dev.wikipedia.ErrorLimitReachedException;
import org.languagetool.dev.wikipedia.OutputDumpHandler;
import org.languagetool.rules.Rule;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CheckWikipediaDump {
    private CheckWikipediaDump() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, SAXException, ParserConfigurationException {
        CheckWikipediaDump prg = new CheckWikipediaDump();
        CheckWikipediaDump.ensureCorrectUsageOrExit(args);
        File propFile = null;
        if (!("-".equals(args[0]) || (propFile = new File(args[0])).exists() && !propFile.isDirectory())) {
            throw new IOException("File not found or isn't a file: " + propFile.getAbsolutePath());
        }
        String languageCode = args[2];
        HashSet<String> disabledRuleIds = new HashSet<String>();
        if (!"-".equals(args[1])) {
            File disabledRulesPropFile = new File(args[1]);
            if (!disabledRulesPropFile.exists() || disabledRulesPropFile.isDirectory()) {
                throw new IOException("File not found or isn't a file: " + disabledRulesPropFile.getAbsolutePath());
            }
            Properties disabledRules = new Properties();
            FileInputStream stream = new FileInputStream(disabledRulesPropFile);
            try {
                disabledRules.load(stream);
                CheckWikipediaDump.addDisabledRules("all", disabledRuleIds, disabledRules);
                CheckWikipediaDump.addDisabledRules(languageCode, disabledRuleIds, disabledRules);
            }
            finally {
                stream.close();
            }
        }
        int maxArticles = Integer.parseInt(args[5]);
        int maxErrors = Integer.parseInt(args[6]);
        String[] ruleIds = null;
        if (!"-".equals(args[4])) {
            ruleIds = args[4].split(",");
        }
        prg.run(propFile, disabledRuleIds, languageCode, args[3], ruleIds, maxArticles, maxErrors);
    }

    private static void addDisabledRules(String languageCode, Set<String> disabledRuleIds, Properties disabledRules) {
        String disabledRulesString = disabledRules.getProperty(languageCode);
        if (disabledRulesString != null) {
            String[] ids = disabledRulesString.split(",");
            disabledRuleIds.addAll(Arrays.asList(ids));
        }
    }

    private static void ensureCorrectUsageOrExit(String[] args) {
        if (args.length != 7) {
            System.err.println("Usage: CheckWikipediaDump <propertyFile> <rulePropertyFile> <language> <filename> <ruleIds> <maxArticles> <maxErrors>");
            System.err.println("  propertyFile      a file to set database access properties. Use '-' to print results to stdout.");
            System.err.println("  rulePropertyFile  a file to set rules which should be disabled per language (e.g. en=RULE1,RULE2 or all=RULE3,RULE4). Use '-' to ignore.");
            System.err.println("  language          language code like 'en' or 'de'");
            System.err.println("  filename          path to unpacked Wikipedia XML dump;");
            System.err.println("                    dumps are available from http://dumps.wikimedia.org/backup-index.html");
            System.err.println("  ruleIds           comma-separated list of rule-ids to activate. Use '-' to activate the default rules.");
            System.err.println("  maxArticles       maximum number of articles to check, 0 for no limit");
            System.err.println("  maxErrors         stop when reaching this many errors, 0 for no limit");
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void run(File propFile, Set<String> disabledRules, String langCode, String xmlFileName, String[] ruleIds, int maxArticles, int maxErrors) throws IOException, SAXException, ParserConfigurationException {
        File file = new File(xmlFileName);
        if (!file.exists() || !file.isFile()) {
            throw new IOException("File doesn't exist or isn't a file: " + xmlFileName);
        }
        Language lang = Language.getLanguageForShortName((String)langCode);
        JLanguageTool languageTool = new JLanguageTool(lang);
        languageTool.activateDefaultPatternRules();
        if (ruleIds != null) {
            this.enableSpecifiedRules(ruleIds, languageTool);
        } else {
            this.applyRuleDeactivation(languageTool, disabledRules);
        }
        this.disableSpellingRules(languageTool);
        Date dumpDate = this.getDumpFileDate(file);
        System.out.println("Dump date: " + dumpDate + ", language: " + langCode);
        System.out.println("Article limit: " + (maxArticles > 0 ? Integer.valueOf(maxArticles) : "no limit"));
        System.out.println("Error limit: " + (maxErrors > 0 ? Integer.valueOf(maxErrors) : "no limit"));
        BaseWikipediaDumpHandler xmlHandler = null;
        try {
            xmlHandler = propFile != null ? new DatabaseDumpHandler(languageTool, dumpDate, langCode, propFile, lang) : new OutputDumpHandler(languageTool, dumpDate, langCode, lang);
            xmlHandler.setMaximumArticles(maxArticles);
            xmlHandler.setMaximumErrors(maxErrors);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(file, (DefaultHandler)xmlHandler);
            if (xmlHandler == null) return;
        }
        catch (ErrorLimitReachedException e) {
            System.out.println(e);
            if (xmlHandler == null) return;
            float matchesPerDoc = (float)xmlHandler.getRuleMatchCount() / (float)xmlHandler.getArticleCount();
            System.out.printf(lang + ": %d total matches\n", xmlHandler.getRuleMatchCount());
            System.out.printf(lang + ": \u00f8%.2f rule matches per document\n", Float.valueOf(matchesPerDoc));
            xmlHandler.close();
            return;
        }
        catch (ArticleLimitReachedException e2) {
            System.out.println(e2);
            if (xmlHandler == null) return;
            {
                catch (Throwable throwable) {
                    if (xmlHandler == null) throw throwable;
                    float matchesPerDoc = (float)xmlHandler.getRuleMatchCount() / (float)xmlHandler.getArticleCount();
                    System.out.printf(lang + ": %d total matches\n", xmlHandler.getRuleMatchCount());
                    System.out.printf(lang + ": \u00f8%.2f rule matches per document\n", Float.valueOf(matchesPerDoc));
                    xmlHandler.close();
                    throw throwable;
                }
            }
            float matchesPerDoc = (float)xmlHandler.getRuleMatchCount() / (float)xmlHandler.getArticleCount();
            System.out.printf(lang + ": %d total matches\n", xmlHandler.getRuleMatchCount());
            System.out.printf(lang + ": \u00f8%.2f rule matches per document\n", Float.valueOf(matchesPerDoc));
            xmlHandler.close();
            return;
        }
        float matchesPerDoc = (float)xmlHandler.getRuleMatchCount() / (float)xmlHandler.getArticleCount();
        System.out.printf(lang + ": %d total matches\n", xmlHandler.getRuleMatchCount());
        System.out.printf(lang + ": \u00f8%.2f rule matches per document\n", Float.valueOf(matchesPerDoc));
        xmlHandler.close();
        return;
    }

    private void enableSpecifiedRules(String[] ruleIds, JLanguageTool languageTool) {
        for (Rule rule : languageTool.getAllRules()) {
            languageTool.disableRule(rule.getId());
        }
        for (String ruleId : ruleIds) {
            languageTool.enableRule(ruleId);
        }
        for (Rule rule : languageTool.getAllRules()) {
            if (!rule.isDefaultOff()) continue;
            languageTool.enableDefaultOffRule(rule.getId());
        }
        for (String ruleId : ruleIds) {
            boolean found = false;
            for (Rule rule : languageTool.getAllRules()) {
                if (!rule.getId().equals(ruleId)) continue;
                found = true;
                break;
            }
            if (found) continue;
            System.out.println("WARNING: Could not find rule '" + ruleId + "'");
        }
        System.out.println("Only these rules are enabled: " + Arrays.toString(ruleIds));
    }

    private void applyRuleDeactivation(JLanguageTool languageTool, Set<String> disabledRules) throws IOException {
        for (String disabledRuleId : disabledRules) {
            languageTool.disableRule(disabledRuleId);
        }
        System.out.println("These rules are disabled: " + languageTool.getDisabledRules());
    }

    private void disableSpellingRules(JLanguageTool languageTool) {
        List allActiveRules = languageTool.getAllActiveRules();
        for (Rule rule : allActiveRules) {
            if (!rule.isSpellingRule()) continue;
            languageTool.disableRule(rule.getId());
        }
        System.out.println("All spelling rules are disabled");
    }

    private Date getDumpFileDate(File file) throws IOException {
        String filename = file.getName();
        String[] parts = filename.split("-");
        if (parts.length < 3) {
            throw new IOException("Unexpected filename format: " + file.getName() + ", must be like ??wiki-????????-pages-articles.xml");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        try {
            return sdf.parse(parts[1]);
        }
        catch (ParseException e) {
            throw new IOException("Unexpected date format '" + parts[1] + "', must be yyyymmdd", e);
        }
    }
}

