/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.dev.wikipedia.BaseWikipediaDumpHandler;
import org.languagetool.dev.wikipedia.ErrorLimitReachedException;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.tools.ContextTools;

class DatabaseDumpHandler
extends BaseWikipediaDumpHandler {
    private final Connection conn;
    private final ContextTools contextTools;

    DatabaseDumpHandler(JLanguageTool lt, java.util.Date dumpDate, String langCode, File propertiesFile, Language lang) throws IOException {
        super(lt, dumpDate, langCode, lang);
        Properties dbProperties = new Properties();
        FileInputStream inStream = new FileInputStream(propertiesFile);
        try {
            dbProperties.load(inStream);
            String dbDriver = this.getProperty(dbProperties, "dbDriver");
            String dbUrl = this.getProperty(dbProperties, "dbUrl");
            String dbUser = this.getProperty(dbProperties, "dbUser");
            String dbPassword = this.getProperty(dbProperties, "dbPassword");
            Class.forName(dbDriver);
            this.conn = DriverManager.getConnection(dbUrl, dbUser, dbPassword);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            inStream.close();
        }
        this.contextTools = new ContextTools();
        this.contextTools.setContextSize(50);
        this.contextTools.setErrorMarkerStart("<err>");
        this.contextTools.setErrorMarkerEnd("</err>");
        this.contextTools.setEscapeHtml(false);
    }

    @Override
    protected void close() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String getProperty(Properties prop, String key) {
        String value = prop.getProperty(key);
        if (value == null) {
            throw new RuntimeException("required key '" + key + "' not found in properties");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleResult(String title, List<RuleMatch> ruleMatches, String text, Language language) throws SQLException {
        String sql = "INSERT INTO corpus_match (version, language_code, ruleid, rule_subid, rule_description, message, error_context, corpus_date, check_date, sourceuri, is_visible) VALUES (0, ?, ?, ?, ?, ?, ?, ?, ?, ?, 1)";
        PreparedStatement prepSt = this.conn.prepareStatement("INSERT INTO corpus_match (version, language_code, ruleid, rule_subid, rule_description, message, error_context, corpus_date, check_date, sourceuri, is_visible) VALUES (0, ?, ?, ?, ?, ?, ?, ?, ?, ?, 1)");
        try {
            Date dumpSqlDate = new Date(this.dumpDate.getTime());
            Date nowDate = new Date(new java.util.Date().getTime());
            for (RuleMatch match : ruleMatches) {
                prepSt.setString(1, language.getShortName());
                Rule rule = match.getRule();
                prepSt.setString(2, rule.getId());
                if (rule instanceof PatternRule) {
                    PatternRule patternRule = (PatternRule)rule;
                    prepSt.setString(3, patternRule.getSubId());
                } else {
                    prepSt.setNull(3, 12);
                }
                prepSt.setString(4, rule.getDescription());
                prepSt.setString(5, StringUtils.abbreviate((String)match.getMessage(), (int)255));
                String context = this.contextTools.getContext(match.getFromPos(), match.getToPos(), text);
                if (context.length() > 255) continue;
                prepSt.setString(6, context);
                prepSt.setDate(7, dumpSqlDate);
                prepSt.setDate(8, nowDate);
                prepSt.setString(9, "http://XX.wikipedia.org/wiki/".replaceAll("XX", this.langCode) + title);
                prepSt.executeUpdate();
                ++this.errorCount;
                if (this.maxErrors <= 0 || this.errorCount < this.maxErrors) continue;
                throw new ErrorLimitReachedException(this.maxErrors);
            }
        }
        finally {
            prepSt.close();
        }
    }
}

