/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.dev.wikipedia.SwebleWikipediaTextFilter;
import org.languagetool.dev.wikipedia.WikipediaQuickCheckResult;
import org.languagetool.language.German;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WikipediaQuickCheck {
    private static final Pattern WIKIPEDIA_URL_REGEX = Pattern.compile("https?://(..)\\.wikipedia\\.org/wiki/(.*)");
    private static final Pattern SECURE_WIKIPEDIA_URL_REGEX = Pattern.compile("https://secure\\.wikimedia\\.org/wikipedia/(..)/wiki/(.*)");
    private List<String> disabledRuleIds = new ArrayList<String>();

    public String getMediaWikiContent(URL wikipediaUrl) throws IOException {
        Language lang = this.getLanguage(wikipediaUrl);
        String pageTitle = this.getPageTitle(wikipediaUrl);
        String apiUrl = "http://" + lang.getShortName() + ".wikipedia.org/w/api.php?titles=" + pageTitle + "&action=query&prop=revisions&rvprop=content&format=xml";
        return this.getContent(new URL(apiUrl));
    }

    public Language getLanguage(URL url) {
        Matcher matcher = this.getUrlMatcher(url.toString());
        return Language.getLanguageForShortName((String)matcher.group(1));
    }

    public String getPageTitle(URL url) {
        Matcher matcher = this.getUrlMatcher(url.toString());
        return matcher.group(2);
    }

    private Matcher getUrlMatcher(String url) {
        Matcher matcher1 = WIKIPEDIA_URL_REGEX.matcher(url);
        Matcher matcher2 = SECURE_WIKIPEDIA_URL_REGEX.matcher(url);
        if (matcher1.matches()) {
            return matcher1;
        }
        if (matcher2.matches()) {
            return matcher2;
        }
        throw new RuntimeException("URL does not seem to be a valid Wikipedia URL: " + url);
    }

    public void setDisabledRuleIds(List<String> ruleIds) {
        this.disabledRuleIds = ruleIds;
    }

    public List<String> getDisabledRuleIds() {
        return this.disabledRuleIds;
    }

    public WikipediaQuickCheckResult checkPage(String plainText, Language lang) throws IOException {
        JLanguageTool langTool = this.getLanguageTool(lang);
        List ruleMatches = langTool.check(plainText);
        return new WikipediaQuickCheckResult(plainText, ruleMatches, lang.getShortName());
    }

    public void validateWikipediaUrl(URL wikipediaUrl) {
        this.getUrlMatcher(wikipediaUrl.toString());
    }

    String getPlainText(String completeWikiContent) {
        String wikiContent = this.getRevisionContent(completeWikiContent);
        String cleanedWikiContent = this.removeInterLanguageLinks(wikiContent);
        SwebleWikipediaTextFilter filter = new SwebleWikipediaTextFilter();
        String plainText = filter.filter(cleanedWikiContent);
        return plainText;
    }

    String removeInterLanguageLinks(String wikiContent) {
        return wikiContent.replaceAll("\\[\\[[a-z]{2,6}:.*?\\]\\]", "");
    }

    private String getRevisionContent(String completeWikiContent) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        RevisionContentHandler handler = new RevisionContentHandler();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new InputSource(new StringReader(completeWikiContent)), (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse XML: " + completeWikiContent, e);
        }
        return handler.getRevisionContent();
    }

    private JLanguageTool getLanguageTool(Language lang) throws IOException {
        JLanguageTool langTool = new JLanguageTool(lang);
        langTool.activateDefaultPatternRules();
        for (String disabledRuleId : this.disabledRuleIds) {
            langTool.disableRule(disabledRuleId);
        }
        this.disableSpellingRules(langTool);
        return langTool;
    }

    private void disableSpellingRules(JLanguageTool languageTool) {
        List allActiveRules = languageTool.getAllActiveRules();
        for (Rule rule : allActiveRules) {
            if (!rule.isSpellingRule()) continue;
            languageTool.disableRule(rule.getId());
        }
    }

    private String getContent(URL wikipediaUrl) throws IOException {
        InputStream contentStream = (InputStream)wikipediaUrl.getContent();
        return StringTools.streamToString((InputStream)contentStream, (String)"UTF-8");
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("Usage: " + WikipediaQuickCheck.class.getName() + " <url>");
            System.exit(1);
        }
        WikipediaQuickCheck check = new WikipediaQuickCheck();
        String urlString = args[0];
        URL url = new URL(urlString);
        String mediaWikiContent = check.getMediaWikiContent(url);
        String plainText = check.getPlainText(mediaWikiContent);
        WikipediaQuickCheckResult checkResult = check.checkPage(plainText, (Language)new German());
        for (RuleMatch ruleMatch : checkResult.getRuleMatches()) {
            System.out.println(ruleMatch.getMessage());
            String context = StringTools.getContext((int)ruleMatch.getFromPos(), (int)ruleMatch.getToPos(), (String)checkResult.getText());
            System.out.println(context);
        }
    }

    class RevisionContentHandler
    extends DefaultHandler {
        private final StringBuilder revisionText = new StringBuilder();
        private boolean inRevision = false;

        RevisionContentHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
            if ("rev".equals(qName)) {
                this.inRevision = true;
            }
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            if ("rev".equals(qName)) {
                this.inRevision = false;
            }
        }

        @Override
        public void characters(char[] buf, int offset, int len) {
            String s = new String(buf, offset, len);
            if (this.inRevision) {
                this.revisionText.append(s);
            }
        }

        public String getRevisionContent() {
            return this.revisionText.toString();
        }
    }
}

