/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia;

import java.util.Arrays;
import org.languagetool.JLanguageTool;
import org.languagetool.dev.index.Indexer;
import org.languagetool.dev.index.Searcher;
import org.languagetool.dev.wikipedia.CheckWikipediaDump;
import org.languagetool.dev.wikipedia.WikipediaIndexHandler;
import org.languagetool.dev.wikipedia.WikipediaQuickCheck;
import org.languagetool.tools.JnaTools;

public class Main {
    public static void main(String[] args) throws Exception {
        JnaTools.setBugWorkaroundProperty();
        if (args.length == 0) {
            Main.printUsageAndExit();
        } else {
            String[] remainingArgs = Arrays.copyOfRange(args, 1, args.length);
            String command = args[0];
            if (command.equals("check-dump")) {
                CheckWikipediaDump.main(remainingArgs);
            } else if (command.equals("wiki-index")) {
                WikipediaIndexHandler.main(remainingArgs);
            } else if (command.equals("wiki-check")) {
                WikipediaQuickCheck.main(remainingArgs);
            } else if (command.equals("index")) {
                Indexer.main(remainingArgs);
            } else if (command.equals("search")) {
                Searcher.main(remainingArgs);
            } else if (command.equals("version")) {
                System.out.println("2.3.1 (" + JLanguageTool.BUILD_DATE + ")");
            } else {
                System.out.println("Error: unknown command '" + command + "'");
                Main.printUsageAndExit();
            }
        }
    }

    private static void printUsageAndExit() {
        System.out.println("Usage: " + Main.class.getName() + " <command> <command-specific-arguments>");
        System.out.println("Where <command> is one of:");
        System.out.println("   check-dump - check a Wikipedia XML dump,");
        System.out.println("                like those available from http://dumps.wikimedia.org/backup-index.html");
        System.out.println("   wiki-index - index a Wikipedia XML dump");
        System.out.println("   wiki-check - check a single Wikipedia page, fetched via the Mediawiki API");
        System.out.println("   index      - index a plain text file, putting the analysis in a Lucene index for faster rule match search");
        System.out.println("   search     - search for rule matches in an index created with 'index' or 'wiki-index'");
        System.out.println("   version    - print LanguageTool version number and build date");
        System.out.println("All commands have different usages. Call them without arguments to get help.");
        System.out.println("Example for a call with valid arguments:");
        System.out.println("   java -jar languagetool-wikipedia.jar wiki-check http://de.wikipedia.org/wiki/Bielefeld");
        System.exit(1);
    }
}

