/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.dev.wikipedia.BaseWikipediaDumpHandler;
import org.languagetool.dev.wikipedia.ErrorLimitReachedException;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.tools.ContextTools;
import org.languagetool.tools.StringTools;

class OutputDumpHandler
extends BaseWikipediaDumpHandler {
    private static final ContextTools contextTools = new ContextTools();

    OutputDumpHandler(JLanguageTool lt, Date dumpDate, String langCode, Language lang) {
        super(lt, dumpDate, langCode, lang);
        contextTools.setContextSize(50);
    }

    @Override
    protected void close() {
    }

    @Override
    protected void handleResult(String title, List<RuleMatch> ruleMatches, String text, Language language) {
        if (ruleMatches.size() > 0) {
            int i = 1;
            System.out.println("\nTitle: " + title);
            for (RuleMatch match : ruleMatches) {
                String output = i + ".) Line " + (match.getLine() + 1) + ", column " + match.getColumn() + ", Rule ID: " + match.getRule().getId();
                if (match.getRule() instanceof PatternRule) {
                    PatternRule pRule = (PatternRule)match.getRule();
                    output = output + "[" + pRule.getSubId() + "]";
                }
                System.out.println(output);
                String msg = match.getMessage();
                msg = msg.replaceAll("<suggestion>", "'");
                msg = msg.replaceAll("</suggestion>", "'");
                System.out.println("Message: " + msg);
                List replacements = match.getSuggestedReplacements();
                if (!replacements.isEmpty()) {
                    System.out.println("Suggestion: " + StringTools.listToString((Collection)replacements, (String)"; "));
                }
                System.out.println(contextTools.getPlainTextContext(match.getFromPos(), match.getToPos(), text));
                ++i;
                ++this.errorCount;
                if (this.maxErrors <= 0 || this.errorCount < this.maxErrors) continue;
                throw new ErrorLimitReachedException(this.maxErrors);
            }
        }
    }
}

