/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia;

import org.languagetool.rules.RuleMatch;

public class RuleMatchApplication {
    private final RuleMatch ruleMatch;
    private final String text;
    private final String textWithCorrection;
    private final String errorMarkerStart;
    private final String errorMarkerEnd;
    private final boolean hasRealReplacement;

    static RuleMatchApplication forMatchWithReplacement(RuleMatch ruleMatch, String text, String textWithCorrection, String errorMarkerStart, String errorMarkerEnd) {
        return new RuleMatchApplication(ruleMatch, text, textWithCorrection, errorMarkerStart, errorMarkerEnd, true);
    }

    static RuleMatchApplication forMatchWithoutReplacement(RuleMatch ruleMatch, String text, String textWithCorrection, String errorMarkerStart, String errorMarkerEnd) {
        return new RuleMatchApplication(ruleMatch, text, textWithCorrection, errorMarkerStart, errorMarkerEnd, false);
    }

    private RuleMatchApplication(RuleMatch ruleMatch, String text, String textWithCorrection, String errorMarkerStart, String errorMarkerEnd, boolean hasRealReplacement) {
        if (!textWithCorrection.contains(errorMarkerStart)) {
            throw new IllegalArgumentException("No start error marker (" + errorMarkerEnd + ") found in text with correction");
        }
        if (!textWithCorrection.contains(errorMarkerEnd)) {
            throw new IllegalArgumentException("No end error marker (" + errorMarkerEnd + ") found in text with correction");
        }
        this.ruleMatch = ruleMatch;
        this.text = text;
        this.textWithCorrection = textWithCorrection;
        this.errorMarkerStart = errorMarkerStart;
        this.errorMarkerEnd = errorMarkerEnd;
        this.hasRealReplacement = hasRealReplacement;
    }

    public String getOriginalErrorContext(int contextSize) {
        return this.getContext(this.text, contextSize);
    }

    public String getCorrectedErrorContext(int contextSize) {
        return this.getContext(this.textWithCorrection, contextSize);
    }

    private String getContext(String text, int contextSize) {
        int errorStart = this.textWithCorrection.indexOf(this.errorMarkerStart);
        int errorEnd = this.textWithCorrection.indexOf(this.errorMarkerEnd);
        int errorContextStart = Math.max(errorStart - contextSize, 0);
        int errorContentEnd = Math.min(errorEnd + contextSize, text.length());
        return text.substring(errorContextStart, errorContentEnd);
    }

    public RuleMatch getRuleMatch() {
        return this.ruleMatch;
    }

    public String getOriginalText() {
        return this.text;
    }

    public String getTextWithCorrection() {
        return this.textWithCorrection;
    }

    public String getErrorMarkerStart() {
        return this.errorMarkerStart;
    }

    public String getErrorMarkerEnd() {
        return this.errorMarkerEnd;
    }

    public boolean hasRealReplacement() {
        return this.hasRealReplacement;
    }

    public String toString() {
        return this.ruleMatch.toString();
    }
}

