/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia;

import de.fau.cs.osr.ptk.common.Visitor;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.ContentNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.ptk.common.ast.StringContentNode;
import de.fau.cs.osr.ptk.common.ast.Text;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;
import org.sweble.wikitext.engine.Page;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.config.WikiConfigurationInterface;
import org.sweble.wikitext.engine.utils.EntityReferences;
import org.sweble.wikitext.engine.utils.SimpleWikiConfiguration;
import org.sweble.wikitext.lazy.LinkTargetException;
import org.sweble.wikitext.lazy.encval.IllegalCodePoint;
import org.sweble.wikitext.lazy.parser.Bold;
import org.sweble.wikitext.lazy.parser.Enumeration;
import org.sweble.wikitext.lazy.parser.EnumerationItem;
import org.sweble.wikitext.lazy.parser.ExternalLink;
import org.sweble.wikitext.lazy.parser.HorizontalRule;
import org.sweble.wikitext.lazy.parser.ImageLink;
import org.sweble.wikitext.lazy.parser.InternalLink;
import org.sweble.wikitext.lazy.parser.Italics;
import org.sweble.wikitext.lazy.parser.Itemization;
import org.sweble.wikitext.lazy.parser.ItemizationItem;
import org.sweble.wikitext.lazy.parser.MagicWord;
import org.sweble.wikitext.lazy.parser.Paragraph;
import org.sweble.wikitext.lazy.parser.Section;
import org.sweble.wikitext.lazy.parser.Url;
import org.sweble.wikitext.lazy.parser.Whitespace;
import org.sweble.wikitext.lazy.parser.XmlElement;
import org.sweble.wikitext.lazy.preprocessor.TagExtension;
import org.sweble.wikitext.lazy.preprocessor.Template;
import org.sweble.wikitext.lazy.preprocessor.TemplateArgument;
import org.sweble.wikitext.lazy.preprocessor.TemplateParameter;
import org.sweble.wikitext.lazy.preprocessor.XmlComment;
import org.sweble.wikitext.lazy.utils.XmlCharRef;
import org.sweble.wikitext.lazy.utils.XmlEntityRef;
import xtc.tree.Locatable;
import xtc.tree.Location;

public class TextConverter
extends Visitor {
    private static final Pattern ws = Pattern.compile("\\s+");
    private final SimpleWikiConfiguration config;
    private final int wrapCol;
    private Map<Integer, Location> mapping = new HashMap<Integer, Location>();
    private StringBuilder sb;
    private StringBuilder line;
    private boolean pastBod;
    private int needNewlines;
    private boolean needSpace;
    private boolean noWrap;
    private LinkedList<Integer> sections;

    public TextConverter(SimpleWikiConfiguration config, int wrapCol) {
        this.config = config;
        this.wrapCol = wrapCol;
    }

    public Map<Integer, Location> getMapping() {
        return this.mapping;
    }

    protected boolean before(AstNode node) {
        this.sb = new StringBuilder();
        this.line = new StringBuilder();
        this.mapping = new HashMap<Integer, Location>();
        this.pastBod = false;
        this.needNewlines = 0;
        this.needSpace = false;
        this.noWrap = false;
        this.sections = new LinkedList();
        return super.before((Object)node);
    }

    protected Object after(AstNode node, Object result) {
        this.finishLine();
        return this.sb.toString();
    }

    public void visit(AstNode n) {
    }

    public void visit(NodeList n) {
        this.iterate((AstNode)n);
    }

    public void visit(Itemization e) {
        this.iterate((AstNode)e.getContent());
    }

    public void visit(ItemizationItem i) {
        this.newline(2);
        this.iterate((AstNode)i.getContent());
    }

    public void visit(Enumeration e) {
        this.iterate((AstNode)e.getContent());
    }

    public void visit(EnumerationItem item) {
        this.newline(2);
        this.iterate((AstNode)item.getContent());
    }

    public void visit(Page p) {
        this.iterate((AstNode)p.getContent());
    }

    public void visit(Text text) {
        this.addMapping((Locatable)text);
        this.write(text.getContent());
    }

    public void visit(Whitespace w) {
        this.addMapping((Locatable)w);
        this.write(" ");
    }

    public void visit(Bold b) {
        this.iterate((AstNode)b.getContent());
    }

    public void visit(Italics i) {
        this.iterate((AstNode)i.getContent());
    }

    public void visit(XmlCharRef cr) {
        this.addMapping((Locatable)cr);
        this.write(Character.toChars(cr.getCodePoint()));
    }

    public void visit(XmlEntityRef er) {
        this.addMapping((Locatable)er);
        String ch = EntityReferences.resolve((String)er.getName());
        if ("nbsp".equals(er.getName())) {
            this.write(' ');
        } else if (ch == null) {
            this.write('&');
            this.write(er.getName());
            this.write(';');
        } else {
            this.write(ch);
        }
    }

    public void visit(Url url) {
        this.addMapping((Locatable)url);
        this.write(url.getProtocol());
        this.write(':');
        this.write(url.getPath());
    }

    public void visit(ExternalLink link) {
        StringBuilder out = new StringBuilder();
        for (AstNode node : link.getTitle()) {
            try {
                out.append(this.toText(node));
            }
            catch (IOException e) {
                throw new RuntimeException("Error getting content of external link " + link, e);
            }
        }
        this.addMapping((Locatable)link);
        this.write(out.toString());
    }

    public void visit(InternalLink link) {
        try {
            PageTitle page = PageTitle.make((WikiConfigurationInterface)this.config, (String)link.getTarget());
            if (page.getNamespace().equals((Object)this.config.getNamespace("Category"))) {
                return;
            }
        }
        catch (LinkTargetException linkTargetException) {
            // empty catch block
        }
        this.addMapping((Locatable)link);
        this.write(link.getPrefix());
        if (link.getTitle().getContent() == null || link.getTitle().getContent().isEmpty()) {
            this.addMapping((Locatable)link);
            this.write(link.getTarget());
        } else {
            this.addMapping((Locatable)link);
            this.iterate((AstNode)link.getTitle());
        }
        this.write(link.getPostfix());
    }

    public void visit(Section s) {
        this.finishLine();
        StringBuilder saveSb = this.sb;
        boolean saveNoWrap = this.noWrap;
        this.sb = new StringBuilder();
        this.noWrap = true;
        this.iterate((AstNode)s.getTitle());
        this.finishLine();
        String title = this.sb.toString().trim();
        this.sb = saveSb;
        if (s.getLevel() >= 1) {
            while (this.sections.size() > s.getLevel()) {
                this.sections.removeLast();
            }
            while (this.sections.size() < s.getLevel()) {
                this.sections.add(1);
            }
            StringBuilder sb2 = new StringBuilder();
            for (int i = 0; i < this.sections.size(); ++i) {
                if (i < 1) continue;
                sb2.append(this.sections.get(i));
                sb2.append('.');
            }
            if (sb2.length() > 0) {
                sb2.append(' ');
            }
            sb2.append(title);
            title = sb2.toString();
        }
        this.newline(2);
        this.addMapping((Locatable)s);
        this.write(title);
        this.newline(2);
        this.noWrap = saveNoWrap;
        this.iterate((AstNode)s.getBody());
        while (this.sections.size() > s.getLevel()) {
            this.sections.removeLast();
        }
        this.sections.add(this.sections.removeLast() + 1);
    }

    public void visit(Paragraph p) {
        this.iterate((AstNode)p.getContent());
        this.newline(2);
    }

    public void visit(HorizontalRule hr) {
        this.newline(2);
    }

    public void visit(XmlElement e) {
        if (e.getName().equalsIgnoreCase("br")) {
            this.newline(1);
        } else {
            this.iterate((AstNode)e.getBody());
        }
    }

    public void visit(ImageLink n) {
    }

    public void visit(IllegalCodePoint n) {
    }

    public void visit(XmlComment n) {
    }

    public void visit(Template n) {
    }

    public void visit(TemplateArgument n) {
    }

    public void visit(TemplateParameter n) {
    }

    public void visit(TagExtension n) {
    }

    public void visit(MagicWord n) {
    }

    private String toText(AstNode node) throws IOException {
        StringBuilder out = new StringBuilder();
        if (node instanceof StringContentNode) {
            out.append(((StringContentNode)node).getContent());
        } else if (node instanceof ContentNode) {
            NodeList nodes = ((ContentNode)node).getContent();
            for (AstNode subNode : nodes) {
                out.append(this.toText(subNode));
            }
        }
        return out.toString();
    }

    private void addMapping(Locatable loc) {
        String contentSoFar = this.sb.toString() + this.line;
        int textPos = contentSoFar.length() + this.needNewlines + 1;
        if (loc.hasLocation()) {
            this.mapping.put(textPos, loc.getLocation());
        }
    }

    private void newline(int num) {
        if (this.pastBod && num > this.needNewlines) {
            this.needNewlines = num;
        }
    }

    private void wantSpace() {
        if (this.pastBod) {
            this.needSpace = true;
        }
    }

    private void finishLine() {
        this.sb.append(this.line.toString());
        this.line.setLength(0);
    }

    private void writeNewlines(int num) {
        this.finishLine();
        for (int i = 0; i < num; ++i) {
            this.sb.append('\n');
        }
        this.needNewlines = 0;
        this.needSpace = false;
    }

    private void writeWord(String s) {
        int length = s.length();
        if (length == 0) {
            return;
        }
        if (!this.noWrap && this.needNewlines <= 0) {
            if (this.needSpace) {
                ++length;
            }
            if (this.line.length() + length >= this.wrapCol && this.line.length() > 0) {
                this.writeNewlines(1);
            }
        }
        if (this.needSpace && this.needNewlines <= 0) {
            this.line.append(' ');
        }
        if (this.needNewlines > 0) {
            this.writeNewlines(this.needNewlines);
        }
        this.needSpace = false;
        this.pastBod = true;
        this.line.append(s);
    }

    private void write(String s) {
        if (s.isEmpty()) {
            return;
        }
        if (Character.isSpaceChar(s.charAt(0))) {
            this.wantSpace();
        }
        String[] words = ws.split(s);
        int i = 0;
        while (i < words.length) {
            this.writeWord(words[i]);
            if (++i >= words.length) continue;
            this.wantSpace();
        }
        if (Character.isSpaceChar(s.charAt(s.length() - 1))) {
            this.wantSpace();
        }
    }

    private void write(char[] cs) {
        this.write(String.valueOf(cs));
    }

    private void write(char ch) {
        this.writeWord(String.valueOf(ch));
    }

    private void write(int num) {
        this.writeWord(String.valueOf(num));
    }
}

