/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.dumpcheck;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.languagetool.Language;
import org.languagetool.dev.dumpcheck.DocumentLimitReachedException;
import org.languagetool.dev.dumpcheck.ErrorLimitReachedException;
import org.languagetool.dev.dumpcheck.ResultHandler;
import org.languagetool.dev.dumpcheck.Sentence;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.tools.ContextTools;

class DatabaseHandler
extends ResultHandler {
    private static final int MAX_CONTEXT_LENGTH = 500;
    private static final int SMALL_CONTEXT_LENGTH = 40;
    private final Connection conn;
    private final ContextTools contextTools;
    private final ContextTools smallContextTools;

    DatabaseHandler(File propertiesFile, int maxSentences, int maxErrors) {
        super(maxSentences, maxErrors);
        Properties dbProperties = new Properties();
        try (FileInputStream inStream = new FileInputStream(propertiesFile);){
            dbProperties.load(inStream);
            String dbUrl = this.getProperty(dbProperties, "dbUrl");
            String dbUser = this.getProperty(dbProperties, "dbUser");
            String dbPassword = this.getProperty(dbProperties, "dbPassword");
            this.conn = DriverManager.getConnection(dbUrl, dbUser, dbPassword);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
        this.contextTools = new ContextTools();
        this.contextTools.setContextSize(500);
        this.contextTools.setErrorMarkerStart("<err>");
        this.contextTools.setErrorMarkerEnd("</err>");
        this.contextTools.setEscapeHtml(false);
        this.smallContextTools = new ContextTools();
        this.smallContextTools.setContextSize(40);
        this.smallContextTools.setErrorMarkerStart("<err>");
        this.smallContextTools.setErrorMarkerEnd("</err>");
        this.smallContextTools.setEscapeHtml(false);
    }

    private String getProperty(Properties prop, String key) {
        String value = prop.getProperty(key);
        if (value == null) {
            throw new RuntimeException("Required key '" + key + "' not found in properties");
        }
        return value;
    }

    @Override
    protected void handleResult(Sentence sentence, List<RuleMatch> ruleMatches, Language language) {
        String lookupSql = "SELECT id FROM corpus_match_hidden WHERE language_code = ? AND sourceuri = ? AND ruleid = ? AND small_error_context = ?";
        String insertSql = "INSERT INTO corpus_match (version, language_code, ruleid, rule_category, rule_subid, rule_description, message, error_context, small_error_context, corpus_date, check_date, sourceuri, source_type, is_visible) VALUES (0, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 1)";
        try (PreparedStatement lookupSt = this.conn.prepareStatement("SELECT id FROM corpus_match_hidden WHERE language_code = ? AND sourceuri = ? AND ruleid = ? AND small_error_context = ?");
             PreparedStatement insertSt = this.conn.prepareStatement("INSERT INTO corpus_match (version, language_code, ruleid, rule_category, rule_subid, rule_description, message, error_context, small_error_context, corpus_date, check_date, sourceuri, source_type, is_visible) VALUES (0, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 1)");){
            Date nowDate = new Date(new java.util.Date().getTime());
            for (RuleMatch match : ruleMatches) {
                String smallContext = this.smallContextTools.getContext(match.getFromPos(), match.getToPos(), sentence.getText());
                if (this.ruleIsMarkedHidden(language, sentence.getUrl(), match, smallContext, lookupSt)) {
                    System.out.println("Skipping match " + match.getRule().getId() + " for " + sentence.getTitle() + " as it is hidden");
                    continue;
                }
                insertSt.setString(1, language.getShortName());
                Rule rule = match.getRule();
                insertSt.setString(2, rule.getId());
                insertSt.setString(3, rule.getCategory().getName());
                if (rule instanceof PatternRule) {
                    PatternRule patternRule = (PatternRule)rule;
                    insertSt.setString(4, patternRule.getSubId());
                } else {
                    insertSt.setNull(4, 12);
                }
                insertSt.setString(5, rule.getDescription());
                insertSt.setString(6, StringUtils.abbreviate((String)match.getMessage(), (int)255));
                String context = this.contextTools.getContext(match.getFromPos(), match.getToPos(), sentence.getText());
                if (context.length() > 500) continue;
                insertSt.setString(7, context);
                insertSt.setString(8, StringUtils.abbreviate((String)smallContext, (int)255));
                insertSt.setDate(9, nowDate);
                insertSt.setDate(10, nowDate);
                insertSt.setString(11, sentence.getUrl());
                insertSt.setString(12, sentence.getSource());
                insertSt.executeUpdate();
                this.checkMaxErrors(++this.errorCount);
                if (this.errorCount % 100 != 0) continue;
                System.out.println("Storing error #" + this.errorCount + " for text:");
                System.out.println("  " + sentence.getText());
            }
            this.checkMaxSentences(++this.sentenceCount);
        }
        catch (DocumentLimitReachedException | ErrorLimitReachedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error storing matches for '" + sentence.getTitle() + "'", e);
        }
    }

    private boolean ruleIsMarkedHidden(Language language, String url, RuleMatch match, String smallContext, PreparedStatement lookupSt) throws SQLException {
        lookupSt.setString(1, language.getShortName());
        lookupSt.setString(2, url);
        lookupSt.setString(3, match.getRule().getId());
        lookupSt.setString(4, smallContext);
        try (ResultSet resultSet = lookupSt.executeQuery();){
            boolean bl = resultSet.first();
            return bl;
        }
    }

    @Override
    public void close() throws Exception {
        if (this.conn != null) {
            this.conn.close();
        }
    }
}

