/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia;

public final class RomanianDiacriticsModifier {
    private static final int REPLACEMENT_BUFF_SIZE = 10240;
    private static char[] cCorrectDiacritics = null;
    private static char[] replacementBuff = null;

    private RomanianDiacriticsModifier() {
    }

    private static synchronized void initCharMap() {
        if (cCorrectDiacritics == null) {
            replacementBuff = new char[10240];
            cCorrectDiacritics = new char[65535];
            char c = '\u0000';
            for (int i = 0; i < 65535; ++i) {
                char newC;
                RomanianDiacriticsModifier.cCorrectDiacritics[i] = newC = RomanianDiacriticsModifier.diac(c);
                c = (char)(c + '\u0001');
            }
        }
    }

    private static char diac(char c) {
        int result = c;
        switch (c) {
            case 351: {
                result = 537;
                break;
            }
            case 355: {
                result = 539;
                break;
            }
            case 354: {
                result = 538;
                break;
            }
            case 350: {
                result = 536;
                break;
            }
        }
        return (char)result;
    }

    static synchronized String correctDiacritics(String s) {
        if (s == null) {
            return null;
        }
        RomanianDiacriticsModifier.initCharMap();
        int length = s.length();
        if (length > replacementBuff.length) {
            replacementBuff = new char[length];
        }
        s.getChars(0, length, replacementBuff, 0);
        for (int i = 0; i < length; ++i) {
            RomanianDiacriticsModifier.replacementBuff[i] = cCorrectDiacritics[replacementBuff[i]];
        }
        return String.valueOf(replacementBuff, 0, length);
    }
}

