/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia.atom;

import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.languagetool.dev.wikipedia.atom.WikipediaRuleMatch;

class ChangeAnalysis {
    private final String title;
    private final long diffId;
    private final List<WikipediaRuleMatch> oldMatches;
    private final List<WikipediaRuleMatch> newMatches;

    ChangeAnalysis(String title, long diffId, List<WikipediaRuleMatch> oldMatches, List<WikipediaRuleMatch> newMatches) {
        this.title = Objects.requireNonNull(title);
        this.diffId = Objects.requireNonNull(diffId);
        this.oldMatches = Objects.requireNonNull(oldMatches);
        this.newMatches = Objects.requireNonNull(newMatches);
    }

    String getTitle() {
        return this.title;
    }

    long getDiffId() {
        return this.diffId;
    }

    List<WikipediaRuleMatch> getAddedMatches() {
        List<Delta> deltas = this.getDeltas();
        return this.getWikipediaRuleMatches(deltas, Delta.TYPE.INSERT);
    }

    List<WikipediaRuleMatch> getRemovedMatches() {
        List<Delta> deltas = this.getDeltas();
        return this.getWikipediaRuleMatches(deltas, Delta.TYPE.DELETE);
    }

    private List<WikipediaRuleMatch> getWikipediaRuleMatches(List<Delta> deltas, Delta.TYPE changeType) {
        ArrayList<WikipediaRuleMatch> matches = new ArrayList<WikipediaRuleMatch>();
        for (Delta delta : deltas) {
            if (!delta.getType().equals((Object)changeType)) continue;
            List lines = changeType == Delta.TYPE.INSERT ? delta.getRevised().getLines() : delta.getOriginal().getLines();
            matches.addAll(lines);
        }
        return matches;
    }

    private List<Delta> getDeltas() {
        Patch diff = DiffUtils.diff(this.oldMatches, this.newMatches);
        return diff.getDeltas();
    }

    public String toString() {
        return "ChangeAnalysis{title=" + this.title + ",diffId=" + this.diffId + "}";
    }
}

