/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia.atom;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.languagetool.Language;
import org.languagetool.dev.wikipedia.atom.StoredWikipediaRuleMatch;
import org.languagetool.dev.wikipedia.atom.WikipediaRuleMatch;
import org.languagetool.rules.patterns.PatternRule;

class MatchDatabase {
    private final Connection conn;

    MatchDatabase(String dbUrl, String dbUser, String dbPassword) {
        try {
            this.conn = DriverManager.getConnection(dbUrl, dbUser, dbPassword);
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not get database connection to " + dbUrl, e);
        }
    }

    void add(WikipediaRuleMatch ruleMatch) {
        String sql = "INSERT INTO feed_matches (title, language_code, rule_id, rule_sub_id, rule_description, rule_message, rule_category, error_context, edit_date, diff_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement prepSt = this.conn.prepareStatement(sql);){
            prepSt.setString(1, StringUtils.abbreviate((String)ruleMatch.getTitle(), (int)255));
            prepSt.setString(2, ruleMatch.getLanguage().getShortName());
            prepSt.setString(3, ruleMatch.getRule().getId());
            if (ruleMatch.getRule() instanceof PatternRule) {
                prepSt.setString(4, ((PatternRule)ruleMatch.getRule()).getSubId());
            } else {
                prepSt.setString(4, null);
            }
            prepSt.setString(5, StringUtils.abbreviate((String)ruleMatch.getRule().getDescription(), (int)255));
            prepSt.setString(6, StringUtils.abbreviate((String)ruleMatch.getMessage(), (int)255));
            if (ruleMatch.getRule().getCategory() != null) {
                prepSt.setString(7, StringUtils.abbreviate((String)ruleMatch.getRule().getCategory().getName(), (int)255));
            } else {
                prepSt.setString(7, "<no category>");
            }
            prepSt.setString(8, StringUtils.abbreviate((String)ruleMatch.getErrorContext(), (int)500));
            prepSt.setTimestamp(9, new Timestamp(ruleMatch.getEditDate().getTime()));
            prepSt.setLong(10, ruleMatch.getDiffId());
            prepSt.execute();
        }
        catch (SQLException e) {
            if (e.toString().contains("Incorrect string value")) {
                System.err.println("Could not add rule match " + (Object)((Object)ruleMatch) + " to database - stacktrace follows:");
                e.printStackTrace();
            }
            throw new RuntimeException("Could not add rule match " + (Object)((Object)ruleMatch) + " to database", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int markedFixed(WikipediaRuleMatch ruleMatch) {
        String sql = "UPDATE feed_matches SET fix_date = ?, fix_diff_id = ? WHERE language_code = ? AND title = ? AND rule_id = ? AND error_context = ?";
        try (PreparedStatement prepSt = this.conn.prepareStatement(sql);){
            prepSt.setTimestamp(1, new Timestamp(ruleMatch.getEditDate().getTime()));
            prepSt.setLong(2, ruleMatch.getDiffId());
            prepSt.setString(3, ruleMatch.getLanguage().getShortName());
            prepSt.setString(4, ruleMatch.getTitle());
            prepSt.setString(5, ruleMatch.getRule().getId());
            prepSt.setString(6, ruleMatch.getErrorContext());
            int n = prepSt.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not make rule match " + (Object)((Object)ruleMatch) + " as fixed in database", e);
        }
    }

    void createTable() throws SQLException {
        try (PreparedStatement prepSt = this.conn.prepareStatement("CREATE TABLE feed_matches (  id INT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),  language_code VARCHAR(5) NOT NULL,  title VARCHAR(255) NOT NULL,  rule_id VARCHAR(255) NOT NULL,  rule_sub_id VARCHAR(255),  rule_description VARCHAR(255) NOT NULL,  rule_message VARCHAR(255) NOT NULL,  rule_category VARCHAR(255) NOT NULL,  error_context VARCHAR(500) NOT NULL,  edit_date TIMESTAMP NOT NULL,  diff_id INT NOT NULL,  fix_date TIMESTAMP,  fix_diff_id INT)");){
            prepSt.executeUpdate();
        }
    }

    Date getLatestDate(Language language) {
        Date fixDate;
        Date editDate = this.getLatestDate("edit_date", language);
        if (editDate.after(fixDate = this.getLatestDate("fix_date", language))) {
            return editDate;
        }
        return fixDate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Date getLatestDate(String dateField, Language language) {
        try {
            String sql = "SELECT " + dateField + " FROM feed_matches WHERE language_code = ? ORDER BY " + dateField + " DESC";
            try (PreparedStatement prepSt = this.conn.prepareStatement(sql);){
                prepSt.setString(1, language.getShortName());
                ResultSet resultSet = prepSt.executeQuery();
                if (!resultSet.next()) return new Date(0L);
                if (resultSet.getTimestamp(dateField) == null) return new Date(0L);
                Date date = new Date(resultSet.getTimestamp(dateField).getTime());
                return date;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get latest " + dateField + " from database", e);
        }
    }

    void drop() throws SQLException {
        try (PreparedStatement prepSt = this.conn.prepareStatement("DROP TABLE feed_matches");){
            prepSt.execute();
        }
        catch (SQLException e) {
            System.err.println("Note: could not drop table 'feed_matches' - this is okay on the first run: " + e.toString());
        }
    }

    List<StoredWikipediaRuleMatch> list() throws SQLException {
        try (PreparedStatement prepSt = this.conn.prepareStatement("SELECT * FROM feed_matches");){
            ResultSet resultSet = prepSt.executeQuery();
            ArrayList<StoredWikipediaRuleMatch> result = new ArrayList<StoredWikipediaRuleMatch>();
            while (resultSet.next()) {
                String ruleId = resultSet.getString("rule_id");
                String ruleSubId = resultSet.getString("rule_sub_id");
                String ruleDescription = resultSet.getString("rule_description");
                String ruleMessage = resultSet.getString("rule_message");
                String errorContext = resultSet.getString("error_context");
                String title = resultSet.getString("title");
                Date editDate = new Date(resultSet.getTimestamp("edit_date").getTime());
                Timestamp fixTimeStamp = resultSet.getTimestamp("fix_date");
                Date fixDate = fixTimeStamp != null ? new Date(resultSet.getTimestamp("fix_date").getTime()) : null;
                long diffId = resultSet.getLong("diff_id");
                long fixDiffId = resultSet.getLong("fix_diff_id");
                result.add(new StoredWikipediaRuleMatch(ruleId, ruleSubId, ruleDescription, ruleMessage, errorContext, title, editDate, fixDate, diffId, fixDiffId));
            }
            ArrayList<StoredWikipediaRuleMatch> arrayList = result;
            return arrayList;
        }
    }
}

