/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.MultiThreadedJLanguageTool;
import org.languagetool.dev.dumpcheck.ArticleLimitReachedException;
import org.languagetool.dev.dumpcheck.ErrorLimitReachedException;
import org.languagetool.dev.wikipedia.BaseWikipediaDumpHandler;
import org.languagetool.dev.wikipedia.DatabaseDumpHandler;
import org.languagetool.dev.wikipedia.OutputDumpHandler;
import org.languagetool.rules.Rule;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Deprecated
public class CheckWikipediaDump {
    private CheckWikipediaDump() {
    }

    public static void main(String[] args) throws IOException, SAXException, ParserConfigurationException {
        System.err.println("*** Note: this class has been deprecated - please use option 'check-data' instead");
        CheckWikipediaDump prg = new CheckWikipediaDump();
        CommandLine commandLine = CheckWikipediaDump.ensureCorrectUsageOrExit(args);
        File propFile = null;
        if (commandLine.hasOption('d') && (!(propFile = new File(commandLine.getOptionValue('d'))).exists() || propFile.isDirectory())) {
            throw new IOException("File not found or isn't a file: " + propFile.getAbsolutePath());
        }
        String languageCode = commandLine.getOptionValue('l');
        HashSet<String> disabledRuleIds = new HashSet<String>();
        if (commandLine.hasOption("rule-properties")) {
            File disabledRulesPropFile = new File(commandLine.getOptionValue("rule-properties"));
            if (!disabledRulesPropFile.exists() || disabledRulesPropFile.isDirectory()) {
                throw new IOException("File not found or isn't a file: " + disabledRulesPropFile.getAbsolutePath());
            }
            Properties disabledRules = new Properties();
            try (FileInputStream stream = new FileInputStream(disabledRulesPropFile);){
                disabledRules.load(stream);
                CheckWikipediaDump.addDisabledRules("all", disabledRuleIds, disabledRules);
                CheckWikipediaDump.addDisabledRules(languageCode, disabledRuleIds, disabledRules);
            }
        }
        int maxArticles = Integer.parseInt(commandLine.getOptionValue("max-articles", "0"));
        int maxErrors = Integer.parseInt(commandLine.getOptionValue("max-errors", "0"));
        String[] ruleIds = null;
        if (commandLine.hasOption('r')) {
            ruleIds = commandLine.getOptionValue('r').split(",");
        }
        prg.run(propFile, disabledRuleIds, languageCode, commandLine.getOptionValue('f'), ruleIds, maxArticles, maxErrors);
    }

    private static void addDisabledRules(String languageCode, Set<String> disabledRuleIds, Properties disabledRules) {
        String disabledRulesString = disabledRules.getProperty(languageCode);
        if (disabledRulesString != null) {
            String[] ids = disabledRulesString.split(",");
            disabledRuleIds.addAll(Arrays.asList(ids));
        }
    }

    private static CommandLine ensureCorrectUsageOrExit(String[] args) {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"language");
        OptionBuilder.withArgName((String)"code");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"language code like 'en' or 'de'");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"l"));
        OptionBuilder.withLongOpt((String)"db-properties");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"A file to set database access properties. If not set, the output will be written to STDOUT. The file needs to set dbDriver (fully qualified driver class), dbUrl ('jdbc:...'), dbUser, and dbPassword.");
        options.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withLongOpt((String)"rule-properties");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"A file to set rules which should be disabled per language (e.g. en=RULE1,RULE2 or all=RULE3,RULE4)");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"rule-ids");
        OptionBuilder.withArgName((String)"id");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"comma-separated list of rule-ids to activate");
        options.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withLongOpt((String)"file");
        OptionBuilder.withArgName((String)"xmlfile");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"an unpacked Wikipedia XML dump; dumps are available from http://dumps.wikimedia.org/backup-index.html");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withLongOpt((String)"max-articles");
        OptionBuilder.withArgName((String)"number");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"maximum number of articles to check");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"max-errors");
        OptionBuilder.withArgName((String)"number");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"maximum number of errors, stop when finding more");
        options.addOption(OptionBuilder.create());
        try {
            GnuParser parser = new GnuParser();
            return parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println("Error: " + e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(80);
            formatter.setSyntaxPrefix("Usage: ");
            formatter.printHelp(CheckWikipediaDump.class.getSimpleName() + " [OPTION]... --file <xmlfile> --language <code>", options);
            System.exit(1);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void run(File propFile, Set<String> disabledRules, String langCode, String xmlFileName, String[] ruleIds, int maxArticles, int maxErrors) throws IOException, SAXException, ParserConfigurationException {
        File file = new File(xmlFileName);
        if (!file.exists() || !file.isFile()) {
            throw new IOException("File doesn't exist or isn't a file: " + xmlFileName);
        }
        Language lang = Language.getLanguageForShortName((String)langCode);
        MultiThreadedJLanguageTool languageTool = new MultiThreadedJLanguageTool(lang);
        languageTool.activateDefaultPatternRules();
        if (ruleIds != null) {
            this.enableSpecifiedRules(ruleIds, (JLanguageTool)languageTool);
        } else {
            this.applyRuleDeactivation((JLanguageTool)languageTool, disabledRules);
        }
        this.disableSpellingRules((JLanguageTool)languageTool);
        Date dumpDate = this.getDumpFileDate(file);
        System.out.println("Dump date: " + dumpDate + ", language: " + langCode);
        System.out.println("Article limit: " + (maxArticles > 0 ? Integer.valueOf(maxArticles) : "no limit"));
        System.out.println("Error limit: " + (maxErrors > 0 ? Integer.valueOf(maxErrors) : "no limit"));
        BaseWikipediaDumpHandler xmlHandler = null;
        try {
            xmlHandler = propFile != null ? new DatabaseDumpHandler((JLanguageTool)languageTool, dumpDate, langCode, propFile, lang) : new OutputDumpHandler((JLanguageTool)languageTool, dumpDate, langCode, lang);
            xmlHandler.setMaximumArticles(maxArticles);
            xmlHandler.setMaximumErrors(maxErrors);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(file, (DefaultHandler)xmlHandler);
            if (xmlHandler == null) return;
        }
        catch (ArticleLimitReachedException | ErrorLimitReachedException e) {
            try {
                System.out.println(e);
                if (xmlHandler == null) return;
            }
            catch (Throwable throwable) {
                if (xmlHandler == null) throw throwable;
                float matchesPerDoc = (float)xmlHandler.getRuleMatchCount() / (float)xmlHandler.getArticleCount();
                System.out.printf(lang + ": %d total matches\n", xmlHandler.getRuleMatchCount());
                System.out.printf(lang + ": \u00f8%.2f rule matches per document\n", Float.valueOf(matchesPerDoc));
                xmlHandler.close();
                throw throwable;
            }
            float matchesPerDoc = (float)xmlHandler.getRuleMatchCount() / (float)xmlHandler.getArticleCount();
            System.out.printf(lang + ": %d total matches\n", xmlHandler.getRuleMatchCount());
            System.out.printf(lang + ": \u00f8%.2f rule matches per document\n", Float.valueOf(matchesPerDoc));
            xmlHandler.close();
            return;
        }
        float matchesPerDoc = (float)xmlHandler.getRuleMatchCount() / (float)xmlHandler.getArticleCount();
        System.out.printf(lang + ": %d total matches\n", xmlHandler.getRuleMatchCount());
        System.out.printf(lang + ": \u00f8%.2f rule matches per document\n", Float.valueOf(matchesPerDoc));
        xmlHandler.close();
        return;
    }

    private void enableSpecifiedRules(String[] ruleIds, JLanguageTool languageTool) {
        for (Rule rule : languageTool.getAllRules()) {
            languageTool.disableRule(rule.getId());
        }
        for (String ruleId : ruleIds) {
            languageTool.enableRule(ruleId);
        }
        for (Rule rule : languageTool.getAllRules()) {
            if (!rule.isDefaultOff()) continue;
            languageTool.enableDefaultOffRule(rule.getId());
        }
        for (String ruleId : ruleIds) {
            boolean found = false;
            for (Rule rule : languageTool.getAllRules()) {
                if (!rule.getId().equals(ruleId)) continue;
                found = true;
                break;
            }
            if (found) continue;
            System.out.println("WARNING: Could not find rule '" + ruleId + "'");
        }
        System.out.println("Only these rules are enabled: " + Arrays.toString(ruleIds));
    }

    private void applyRuleDeactivation(JLanguageTool languageTool, Set<String> disabledRules) {
        for (String disabledRuleId : disabledRules) {
            languageTool.disableRule(disabledRuleId);
        }
        System.out.println("These rules are disabled: " + languageTool.getDisabledRules());
    }

    private void disableSpellingRules(JLanguageTool languageTool) {
        List allActiveRules = languageTool.getAllActiveRules();
        for (Rule rule : allActiveRules) {
            if (!rule.isDictionaryBasedSpellingRule()) continue;
            languageTool.disableRule(rule.getId());
        }
        System.out.println("All spelling rules are disabled");
    }

    private Date getDumpFileDate(File file) throws IOException {
        String filename = file.getName();
        String[] parts = filename.split("-");
        if (parts.length < 3) {
            throw new IOException("Unexpected filename format: " + file.getName() + ", must be like ??wiki-????????-pages-articles.xml");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        try {
            return sdf.parse(parts[1]);
        }
        catch (java.text.ParseException e) {
            throw new IOException("Unexpected date format '" + parts[1] + "', must be yyyymmdd", e);
        }
    }

    private String getRunTime(long startTime) {
        long runtime = System.currentTimeMillis() - startTime;
        return String.format("%02d:%02d", TimeUnit.MILLISECONDS.toMinutes(runtime), TimeUnit.MILLISECONDS.toSeconds(runtime) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(runtime)));
    }
}

