/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.dumpcheck;

import java.util.List;
import org.languagetool.Language;
import org.languagetool.dev.dumpcheck.DocumentLimitReachedException;
import org.languagetool.dev.dumpcheck.ErrorLimitReachedException;
import org.languagetool.dev.dumpcheck.Sentence;
import org.languagetool.rules.RuleMatch;

abstract class ResultHandler
implements AutoCloseable {
    protected static final int CONTEXT_SIZE = 50;
    protected static final String MARKER_START = "<err>";
    protected static final String MARKER_END = "</err>";
    protected int sentenceCount = 0;
    protected int errorCount = 0;
    private final int maxSentences;
    private final int maxErrors;

    protected abstract void handleResult(Sentence var1, List<RuleMatch> var2, Language var3);

    protected ResultHandler(int maxSentences, int maxErrors) {
        this.maxSentences = maxSentences;
        this.maxErrors = maxErrors;
    }

    protected void checkMaxSentences(int i) {
        if (this.maxSentences > 0 && this.sentenceCount >= this.maxSentences) {
            throw new DocumentLimitReachedException(this.maxSentences);
        }
    }

    protected void checkMaxErrors(int i) {
        if (this.maxErrors > 0 && this.errorCount >= this.maxErrors) {
            throw new ErrorLimitReachedException(this.maxErrors);
        }
    }
}

