/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.dumpcheck;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.languagetool.Language;
import org.languagetool.dev.dumpcheck.DocumentLimitReachedException;
import org.languagetool.dev.dumpcheck.MixingSentenceSource;
import org.languagetool.dev.dumpcheck.Sentence;
import org.languagetool.dev.index.Indexer;
import org.xml.sax.helpers.DefaultHandler;

public class SentenceSourceIndexer
extends DefaultHandler
implements AutoCloseable {
    private static final String MAX_DOC_COUNT_VALUE = "maxDocCountValue";
    private static final String MAX_DOC_COUNT_FIELD = "maxDocCount";
    private static final String MAX_DOC_COUNT_FIELD_VAL = "1";
    private final Indexer indexer;
    private final int maxSentences;
    private int sentenceCount = 0;

    SentenceSourceIndexer(Directory dir, Language language, int maxSentences) {
        this.indexer = new Indexer(dir, language);
        this.maxSentences = maxSentences;
    }

    @Override
    public void close() throws Exception {
        this.indexer.close();
    }

    private void run(List<String> dumpFileNames, Language language) throws IOException {
        MixingSentenceSource mixingSource = MixingSentenceSource.create(dumpFileNames, language);
        while (mixingSource.hasNext()) {
            Sentence sentence = mixingSource.next();
            if (this.sentenceCount % 100 == 0) {
                System.out.println("Indexing sentence #" + this.sentenceCount + " (" + mixingSource.getSourceDistribution() + "):");
                System.out.println("  [" + sentence.getSource() + "] " + sentence);
            }
            this.indexer.index(sentence.getText(), sentence.getSource(), true, this.sentenceCount);
            ++this.sentenceCount;
            if (this.sentenceCount < this.maxSentences) continue;
            throw new DocumentLimitReachedException(this.maxSentences);
        }
    }

    private void writeMetaDocuments() throws IOException {
        Document doc = new Document();
        doc.add((IndexableField)new StringField(MAX_DOC_COUNT_FIELD, MAX_DOC_COUNT_FIELD_VAL, Field.Store.YES));
        doc.add((IndexableField)new StringField(MAX_DOC_COUNT_VALUE, this.sentenceCount + "", Field.Store.YES));
        this.indexer.add(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) throws Exception {
        if (args.length != 4) {
            System.out.println("Usage: " + SentenceSourceIndexer.class.getSimpleName() + " <dataFile...> <indexDir> <languageCode> <maxSentences>");
            System.out.println("\t<dataFiles> comma-separated list of a Wikipedia XML dumps (*.xml) and/or Tatoeba files (tatoeba-*)");
            System.out.println("\t<indexDir> directory where Lucene index will be written to, existing index content will be removed");
            System.out.println("\t<languageCode> short code like en for English, de for German etc");
            System.out.println("\t<maxSentences> maximum number of sentences to be indexed, use 0 for no limit");
            System.exit(1);
        }
        List<String> dumpFilesNames = Arrays.asList(args[0].split(","));
        File indexDir = new File(args[1]);
        String languageCode = args[2];
        int maxSentences = Integer.parseInt(args[3]);
        Language language = Language.getLanguageForShortName((String)languageCode);
        if (maxSentences == 0) {
            System.out.println("Going to index contents from " + dumpFilesNames);
        } else {
            System.out.println("Going to index up to " + maxSentences + " sentences from " + dumpFilesNames);
        }
        System.out.println("Output index dir: " + indexDir);
        long start = System.currentTimeMillis();
        try (FSDirectory fsDirectory = FSDirectory.open((File)indexDir);){
            SentenceSourceIndexer indexer = new SentenceSourceIndexer((Directory)fsDirectory, language, maxSentences);
            try {
                indexer.run(dumpFilesNames, language);
            }
            catch (DocumentLimitReachedException e) {
                System.out.println("Sentence limit (" + e.getLimit() + ") reached, stopping indexing");
            }
            finally {
                indexer.writeMetaDocuments();
                indexer.close();
            }
        }
        long end = System.currentTimeMillis();
        float minutes = (float)(end - start) / 60000.0f;
        System.out.printf("Indexing took %.2f minutes\n", Float.valueOf(minutes));
    }
}

