/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia;

import org.languagetool.dev.wikipedia.ErrorMarker;
import org.languagetool.rules.RuleMatch;

public class RuleMatchApplication {
    private final RuleMatch ruleMatch;
    private final String text;
    private final String textWithCorrection;
    private final ErrorMarker errorMarker;
    private final boolean hasRealReplacement;

    static RuleMatchApplication forMatchWithReplacement(RuleMatch ruleMatch, String text, String textWithCorrection, ErrorMarker errorMarker) {
        return new RuleMatchApplication(ruleMatch, text, textWithCorrection, errorMarker, true);
    }

    static RuleMatchApplication forMatchWithoutReplacement(RuleMatch ruleMatch, String text, String textWithCorrection, ErrorMarker errorMarker) {
        return new RuleMatchApplication(ruleMatch, text, textWithCorrection, errorMarker, false);
    }

    private RuleMatchApplication(RuleMatch ruleMatch, String text, String textWithCorrection, ErrorMarker errorMarker, boolean hasRealReplacement) {
        if (!textWithCorrection.contains(errorMarker.getStartMarker())) {
            throw new IllegalArgumentException("No start error marker (" + errorMarker.getStartMarker() + ") found in text with correction");
        }
        if (!textWithCorrection.contains(errorMarker.getEndMarker())) {
            throw new IllegalArgumentException("No end error marker (" + errorMarker.getEndMarker() + ") found in text with correction");
        }
        this.ruleMatch = ruleMatch;
        this.text = text;
        this.textWithCorrection = textWithCorrection;
        this.errorMarker = errorMarker;
        this.hasRealReplacement = hasRealReplacement;
    }

    public String getOriginalErrorContext(int contextSize) {
        return this.getContext(this.text, contextSize);
    }

    public String getCorrectedErrorContext(int contextSize) {
        return this.getContext(this.textWithCorrection, contextSize);
    }

    private String getContext(String text, int contextSize) {
        int errorStart = this.textWithCorrection.indexOf(this.errorMarker.getStartMarker());
        int errorEnd = this.textWithCorrection.indexOf(this.errorMarker.getEndMarker());
        int errorContextStart = Math.max(errorStart - contextSize, 0);
        int errorContentEnd = Math.min(errorEnd + contextSize, text.length());
        return text.substring(errorContextStart, errorContentEnd);
    }

    public RuleMatch getRuleMatch() {
        return this.ruleMatch;
    }

    public String getOriginalText() {
        return this.text;
    }

    public String getTextWithCorrection() {
        return this.textWithCorrection;
    }

    public ErrorMarker getErrorMarker() {
        return this.errorMarker;
    }

    public String getErrorMarkerStart() {
        return this.errorMarker.getStartMarker();
    }

    public String getErrorMarkerEnd() {
        return this.errorMarker.getEndMarker();
    }

    public boolean hasRealReplacement() {
        return this.hasRealReplacement;
    }

    public String toString() {
        return this.ruleMatch.toString();
    }
}

