/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia;

import org.languagetool.Language;
import org.languagetool.dev.wikipedia.PlainTextMapping;
import org.languagetool.dev.wikipedia.RomanianDiacriticsModifier;
import org.languagetool.dev.wikipedia.SwebleWikipediaTextFilter;

class TextFilterTools {
    private TextFilterTools() {
    }

    static SwebleWikipediaTextFilter getTextFilter(Language lang) {
        SwebleWikipediaTextFilter textFilter = lang.getShortName().equals("ro") ? new SwebleWikipediaTextFilter(){

            @Override
            public PlainTextMapping filter(String arg0) {
                PlainTextMapping tmp = super.filter(arg0);
                String text = RomanianDiacriticsModifier.correctDiacritics(tmp.getPlainText());
                return new PlainTextMapping(text, tmp.getMapping());
            }
        } : new SwebleWikipediaTextFilter();
        return textFilter;
    }
}

