/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.dumpcheck;

import java.io.FileInputStream;
import java.io.IOException;
import org.languagetool.Language;
import org.languagetool.dev.dumpcheck.WikipediaSentenceSource;

class WikipediaSentenceExtractor {
    WikipediaSentenceExtractor() {
    }

    private void extract(Language language, String xmlDumpPath) throws IOException {
        try (FileInputStream fis = new FileInputStream(xmlDumpPath);){
            int sentenceCount = 0;
            WikipediaSentenceSource source = new WikipediaSentenceSource(fis, language);
            while (source.hasNext()) {
                String sentence = source.next().getText();
                if (this.skipSentence(sentence)) continue;
                System.out.println(sentence);
                if (++sentenceCount % 1000 != 0) continue;
                System.err.println("Exporting sentence #" + sentenceCount + "...");
            }
        }
    }

    private boolean skipSentence(String sentence) {
        return sentence.trim().length() == 0 || Character.isLowerCase(sentence.trim().charAt(0));
    }

    private static void checkUsageOrExit(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: " + WikipediaSentenceExtractor.class.getSimpleName() + " <langCode> <wikipediaXmlDump>");
            System.exit(1);
        }
    }

    public static void main(String[] args) throws IOException {
        WikipediaSentenceExtractor.checkUsageOrExit(args);
        WikipediaSentenceExtractor extractor = new WikipediaSentenceExtractor();
        extractor.extract(Language.getLanguageForShortName((String)args[0]), args[1]);
    }
}

