/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia;

import java.util.Date;
import java.util.List;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.dev.dumpcheck.ArticleLimitReachedException;
import org.languagetool.dev.dumpcheck.ErrorLimitReachedException;
import org.languagetool.dev.wikipedia.PlainTextMapping;
import org.languagetool.dev.wikipedia.SwebleWikipediaTextFilter;
import org.languagetool.dev.wikipedia.TextFilterTools;
import org.languagetool.dev.wikipedia.TextMapFilter;
import org.languagetool.rules.RuleMatch;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Deprecated
abstract class BaseWikipediaDumpHandler
extends DefaultHandler {
    protected static final int CONTEXT_SIZE = 50;
    protected static final String MARKER_START = "<err>";
    protected static final String MARKER_END = "</err>";
    protected static final String LANG_MARKER = "XX";
    protected static final String URL_PREFIX = "http://XX.wikipedia.org/wiki/";
    protected Date dumpDate;
    protected String langCode;
    protected int maxErrors = 0;
    protected int errorCount = 0;
    private final JLanguageTool languageTool;
    private int ruleMatchCount = 0;
    private int maxArticles = 0;
    private int articleCount = 0;
    private Location location;
    private StringBuilder title = new StringBuilder();
    private StringBuilder text = new StringBuilder();
    private TextMapFilter textFilter = new SwebleWikipediaTextFilter();

    protected BaseWikipediaDumpHandler(JLanguageTool languageTool, Date dumpDate, String langCode, Language lang) {
        this.languageTool = languageTool;
        this.dumpDate = dumpDate;
        this.langCode = langCode;
        this.textFilter = TextFilterTools.getTextFilter(lang);
    }

    public void setMaximumArticles(int maxArticles) {
        this.maxArticles = maxArticles;
    }

    public void setMaximumErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    int getArticleCount() {
        return this.articleCount;
    }

    int getRuleMatchCount() {
        return this.ruleMatchCount;
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        if (qName.equals("title")) {
            this.title = new StringBuilder();
            this.location = Location.TITLE;
        } else if (qName.equals("text")) {
            this.text = new StringBuilder();
            this.location = Location.TEXT;
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) {
        if (qName.equals("title")) {
            this.location = Location.OTHER;
        } else if (qName.equals("text")) {
            try {
                this.handleEndText();
            }
            catch (ArticleLimitReachedException | ErrorLimitReachedException e) {
                throw e;
            }
            catch (Exception e) {
                System.err.println("Error checking text of '" + this.title + "', ignoring document. Stacktrace:");
                e.printStackTrace();
            }
            this.text = new StringBuilder();
            this.location = Location.OTHER;
        }
    }

    private void handleEndText() {
        PlainTextMapping mapping = this.textFilter.filter(this.text.toString());
        String textToCheck = mapping.getPlainText();
        if (!textToCheck.contains("#REDIRECT")) {
            ++this.articleCount;
            if (this.maxArticles > 0 && this.articleCount > this.maxArticles) {
                throw new ArticleLimitReachedException(this.maxArticles);
            }
            try {
                List ruleMatches = this.languageTool.check(textToCheck);
                this.ruleMatchCount += ruleMatches.size();
                System.out.println("Checking article " + this.articleCount + " (" + textToCheck.length() / 1024 + "KB, '" + this.title + "')" + ", found " + ruleMatches.size() + " matches");
                this.handleResult(this.title.toString(), ruleMatches, textToCheck, this.languageTool.getLanguage());
            }
            catch (ErrorLimitReachedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Error checking '" + this.title + "' (" + this.articleCount + ")", e);
            }
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) {
        String s = new String(buf, offset, len);
        if (this.location == Location.TITLE) {
            this.title.append(s);
        } else if (this.location == Location.TEXT) {
            this.text.append(s);
        }
    }

    protected abstract void handleResult(String var1, List<RuleMatch> var2, String var3, Language var4) throws Exception;

    protected abstract void close();

    private static enum Location {
        TITLE,
        TEXT,
        OTHER;

    }
}

