/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.languagetool.dev.wikipedia.ErrorMarker;
import org.languagetool.dev.wikipedia.LocationHelper;
import org.languagetool.dev.wikipedia.PlainTextMapping;
import org.languagetool.dev.wikipedia.RuleMatchApplication;
import org.languagetool.rules.RuleMatch;
import xtc.tree.Location;

public class SuggestionReplacer {
    private final PlainTextMapping textMapping;
    private final String originalText;
    private final ErrorMarker errorMarker;

    public SuggestionReplacer(PlainTextMapping textMapping, String originalText) {
        this(textMapping, originalText, new ErrorMarker("<<span class=\"error\">>", "<</span>>"));
    }

    public SuggestionReplacer(PlainTextMapping textMapping, String originalText, ErrorMarker errorMarker) {
        this.textMapping = textMapping;
        this.originalText = originalText;
        this.errorMarker = errorMarker;
    }

    public List<RuleMatchApplication> applySuggestionsToOriginalText(RuleMatch match) {
        boolean hasRealReplacements;
        List replacements = match.getSuggestedReplacements();
        boolean bl = hasRealReplacements = replacements.size() > 0;
        if (!hasRealReplacements) {
            String plainText = this.textMapping.getPlainText();
            replacements.add(plainText.substring(match.getFromPos(), match.getToPos()));
        }
        ArrayList<RuleMatchApplication> ruleMatchApplications = new ArrayList<RuleMatchApplication>();
        Location fromPosLocation = this.textMapping.getOriginalTextPositionFor(match.getFromPos() + 1);
        Location toPosLocation = this.textMapping.getOriginalTextPositionFor(match.getToPos() + 1);
        int fromPos = LocationHelper.absolutePositionFor(fromPosLocation, this.originalText);
        int toPos = LocationHelper.absolutePositionFor(toPosLocation, this.originalText);
        for (String replacement : replacements) {
            String newContext;
            String errorText = this.textMapping.getPlainText().substring(match.getFromPos(), match.getToPos());
            int contextFrom = this.findNextWhitespaceToTheLeft(this.originalText, fromPos);
            int contextTo = this.findNextWhitespaceToTheRight(this.originalText, toPos);
            String context = this.originalText.substring(contextFrom, contextTo);
            String text = this.originalText.substring(0, contextFrom) + this.errorMarker.getStartMarker() + context + this.errorMarker.getEndMarker() + this.originalText.substring(contextTo);
            if (StringUtils.countMatches((String)context, (String)errorText) == 1) {
                newContext = context.replace(errorText, replacement);
            } else {
                newContext = context;
                hasRealReplacements = false;
            }
            String newText = this.originalText.substring(0, contextFrom) + this.errorMarker.getStartMarker() + newContext + this.errorMarker.getEndMarker() + this.originalText.substring(contextTo);
            RuleMatchApplication application = hasRealReplacements ? RuleMatchApplication.forMatchWithReplacement(match, text, newText, this.errorMarker) : RuleMatchApplication.forMatchWithoutReplacement(match, text, newText, this.errorMarker);
            ruleMatchApplications.add(application);
        }
        return ruleMatchApplications;
    }

    int findNextWhitespaceToTheRight(String text, int position) {
        for (int i = position; i < text.length(); ++i) {
            if (!Character.isWhitespace(text.charAt(i))) continue;
            return i;
        }
        return text.length();
    }

    int findNextWhitespaceToTheLeft(String text, int position) {
        for (int i = position; i >= 0; --i) {
            if (!Character.isWhitespace(text.charAt(i))) continue;
            return i + 1;
        }
        return 0;
    }
}

