/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.MultiThreadedJLanguageTool;
import org.languagetool.dev.wikipedia.AppliedRuleMatch;
import org.languagetool.dev.wikipedia.ErrorMarker;
import org.languagetool.dev.wikipedia.MarkupAwareWikipediaResult;
import org.languagetool.dev.wikipedia.MediaWikiContent;
import org.languagetool.dev.wikipedia.PageNotFoundException;
import org.languagetool.dev.wikipedia.PlainTextMapping;
import org.languagetool.dev.wikipedia.RuleMatchApplication;
import org.languagetool.dev.wikipedia.SuggestionReplacer;
import org.languagetool.dev.wikipedia.SwebleWikipediaTextFilter;
import org.languagetool.dev.wikipedia.WikipediaQuickCheckResult;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.tools.StringTools;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WikipediaQuickCheck {
    private static final Pattern WIKIPEDIA_URL_REGEX = Pattern.compile("https?://(..)\\.wikipedia\\.org/wiki/(.*)");
    private static final Pattern SECURE_WIKIPEDIA_URL_REGEX = Pattern.compile("https://secure\\.wikimedia\\.org/wikipedia/(..)/wiki/(.*)");
    private List<String> disabledRuleIds = new ArrayList<String>();

    public String getMediaWikiContent(URL wikipediaUrl) throws IOException {
        Language lang = this.getLanguage(wikipediaUrl);
        String pageTitle = this.getPageTitle(wikipediaUrl);
        String apiUrl = "http://" + lang.getShortName() + ".wikipedia.org/w/api.php?titles=" + pageTitle + "&action=query&prop=revisions&rvprop=content|timestamp&format=xml";
        return this.getContent(new URL(apiUrl));
    }

    public Language getLanguage(URL url) {
        Matcher matcher = this.getUrlMatcher(url.toString());
        return Language.getLanguageForShortName((String)matcher.group(1));
    }

    public String getPageTitle(URL url) {
        Matcher matcher = this.getUrlMatcher(url.toString());
        return matcher.group(2);
    }

    private Matcher getUrlMatcher(String url) {
        Matcher matcher1 = WIKIPEDIA_URL_REGEX.matcher(url);
        Matcher matcher2 = SECURE_WIKIPEDIA_URL_REGEX.matcher(url);
        if (matcher1.matches()) {
            return matcher1;
        }
        if (matcher2.matches()) {
            return matcher2;
        }
        throw new RuntimeException("URL does not seem to be a valid Wikipedia URL: " + url);
    }

    public void setDisabledRuleIds(List<String> ruleIds) {
        this.disabledRuleIds = ruleIds;
    }

    public List<String> getDisabledRuleIds() {
        return this.disabledRuleIds;
    }

    public MarkupAwareWikipediaResult checkPage(URL url) throws IOException, PageNotFoundException {
        return this.checkPage(url, null);
    }

    public MarkupAwareWikipediaResult checkPage(URL url, ErrorMarker errorMarker) throws IOException, PageNotFoundException {
        this.validateWikipediaUrl(url);
        WikipediaQuickCheck check = new WikipediaQuickCheck();
        String xml = check.getMediaWikiContent(url);
        MediaWikiContent wikiContent = this.getRevisionContent(xml);
        if (wikiContent.getContent().trim().isEmpty() || wikiContent.getContent().toLowerCase().contains("#redirect")) {
            throw new PageNotFoundException("No content found at " + url);
        }
        return this.checkWikipediaMarkup(url, wikiContent, this.getLanguage(url), errorMarker);
    }

    MarkupAwareWikipediaResult checkWikipediaMarkup(URL url, MediaWikiContent wikiContent, Language language, ErrorMarker errorMarker) throws IOException {
        SwebleWikipediaTextFilter filter = new SwebleWikipediaTextFilter();
        PlainTextMapping mapping = filter.filter(wikiContent.getContent());
        JLanguageTool langTool = this.getLanguageTool(language);
        ArrayList<AppliedRuleMatch> appliedMatches = new ArrayList<AppliedRuleMatch>();
        List matches = langTool.check(mapping.getPlainText());
        int internalErrors = 0;
        for (RuleMatch match : matches) {
            SuggestionReplacer replacer = errorMarker != null ? new SuggestionReplacer(mapping, wikiContent.getContent(), errorMarker) : new SuggestionReplacer(mapping, wikiContent.getContent());
            try {
                List<RuleMatchApplication> ruleMatchApplications = replacer.applySuggestionsToOriginalText(match);
                appliedMatches.add(new AppliedRuleMatch(match, ruleMatchApplications));
            }
            catch (Exception e) {
                System.err.println("Failed to apply suggestion for rule match '" + match + "' for URL " + url + ": " + e.toString());
                ++internalErrors;
            }
        }
        return new MarkupAwareWikipediaResult(wikiContent, appliedMatches, internalErrors);
    }

    public WikipediaQuickCheckResult checkPage(String plainText, Language lang) throws IOException {
        JLanguageTool langTool = this.getLanguageTool(lang);
        List ruleMatches = langTool.check(plainText);
        return new WikipediaQuickCheckResult(plainText, ruleMatches, lang.getShortName());
    }

    public void validateWikipediaUrl(URL wikipediaUrl) {
        this.getUrlMatcher(wikipediaUrl.toString());
    }

    public String getPlainText(String completeWikiContent) {
        MediaWikiContent wikiContent = this.getRevisionContent(completeWikiContent);
        String cleanedWikiContent = this.removeWikipediaLinks(wikiContent.getContent());
        SwebleWikipediaTextFilter filter = new SwebleWikipediaTextFilter();
        return filter.filter(cleanedWikiContent).getPlainText();
    }

    public PlainTextMapping getPlainTextMapping(String completeWikiContent) {
        MediaWikiContent wikiContent = this.getRevisionContent(completeWikiContent);
        SwebleWikipediaTextFilter filter = new SwebleWikipediaTextFilter();
        return filter.filter(wikiContent.getContent());
    }

    String removeWikipediaLinks(String wikiContent) {
        return wikiContent.replaceAll("\\[\\[[a-z]{2,6}:.*?\\]\\]", "").replaceAll("\\[\\[:?(Category|Categoria|Categor\u00eda|Cat\u00e9gorie|Kategorie):.*?\\]\\]", "").replaceAll("(File|Fitxer|Fichero|Ficheiro|Fichier|Datei):.*?\\.(png|jpg|svg|jpeg|tiff|gif|PNG|JPG|SVG|JPEG|TIFF|GIF)\\|((thumb|miniatur)\\|)?((right|left)\\|)?", "");
    }

    private MediaWikiContent getRevisionContent(String completeWikiContent) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        RevisionContentHandler handler = new RevisionContentHandler();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new InputSource(new StringReader(completeWikiContent)), (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse XML: " + completeWikiContent, e);
        }
        return new MediaWikiContent(handler.getRevisionContent(), handler.getTimestamp());
    }

    private JLanguageTool getLanguageTool(Language lang) throws IOException {
        MultiThreadedJLanguageTool langTool = new MultiThreadedJLanguageTool(lang);
        langTool.activateDefaultPatternRules();
        this.enableWikipediaRules((JLanguageTool)langTool);
        for (String disabledRuleId : this.disabledRuleIds) {
            langTool.disableRule(disabledRuleId);
        }
        this.disableSpellingRules((JLanguageTool)langTool);
        return langTool;
    }

    private void enableWikipediaRules(JLanguageTool langTool) {
        List allRules = langTool.getAllRules();
        for (Rule rule : allRules) {
            if (!rule.getCategory().getName().equals("Wikipedia")) continue;
            langTool.enableDefaultOffRule(rule.getId());
        }
    }

    private void disableSpellingRules(JLanguageTool languageTool) {
        List allActiveRules = languageTool.getAllActiveRules();
        for (Rule rule : allActiveRules) {
            if (!rule.isDictionaryBasedSpellingRule()) continue;
            languageTool.disableRule(rule.getId());
        }
    }

    private String getContent(URL wikipediaUrl) throws IOException {
        InputStream contentStream = (InputStream)wikipediaUrl.getContent();
        return StringTools.streamToString((InputStream)contentStream, (String)"UTF-8");
    }

    public static void main(String[] args) throws IOException, PageNotFoundException {
        if (args.length != 1) {
            System.out.println("Usage: " + WikipediaQuickCheck.class.getName() + " <url>");
            System.exit(1);
        }
        WikipediaQuickCheck check = new WikipediaQuickCheck();
        String urlString = args[0];
        MarkupAwareWikipediaResult result = check.checkPage(new URL(urlString), new ErrorMarker("***", "***"));
        int errorCount = 0;
        for (AppliedRuleMatch match : result.getAppliedRuleMatches()) {
            RuleMatchApplication matchApplication = match.getRuleMatchApplications().get(0);
            RuleMatch ruleMatch = match.getRuleMatch();
            Rule rule = ruleMatch.getRule();
            System.out.println("");
            String message = ruleMatch.getMessage().replace("<suggestion>", "'").replace("</suggestion>", "'");
            System.out.print(++errorCount + ". " + message);
            if (rule instanceof PatternRule) {
                System.out.println(" (" + rule.getId() + "[" + ((PatternRule)rule).getSubId() + "])");
            } else {
                System.out.println(" (" + rule.getId() + ")");
            }
            System.out.println("    ..." + matchApplication.getOriginalErrorContext(50).replace("\n", "\\n") + "...");
        }
    }

    class RevisionContentHandler
    extends DefaultHandler {
        private final StringBuilder revisionText = new StringBuilder();
        private String timestamp;
        private boolean inRevision = false;

        RevisionContentHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
            if ("rev".equals(qName)) {
                this.timestamp = attrs.getValue("timestamp");
                this.inRevision = true;
            }
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            if ("rev".equals(qName)) {
                this.inRevision = false;
            }
        }

        @Override
        public void characters(char[] buf, int offset, int len) {
            String s = new String(buf, offset, len);
            if (this.inRevision) {
                this.revisionText.append(s);
            }
        }

        public String getRevisionContent() {
            return this.revisionText.toString();
        }

        public String getTimestamp() {
            return this.timestamp;
        }
    }
}

