/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia.atom;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.dev.wikipedia.LocationHelper;
import org.languagetool.dev.wikipedia.PlainTextMapping;
import org.languagetool.dev.wikipedia.SwebleWikipediaTextFilter;
import org.languagetool.dev.wikipedia.TextMapFilter;
import org.languagetool.dev.wikipedia.atom.AtomFeedItem;
import org.languagetool.dev.wikipedia.atom.AtomFeedParser;
import org.languagetool.dev.wikipedia.atom.ChangeAnalysis;
import org.languagetool.dev.wikipedia.atom.CheckResult;
import org.languagetool.dev.wikipedia.atom.DatabaseConfig;
import org.languagetool.dev.wikipedia.atom.MatchDatabase;
import org.languagetool.dev.wikipedia.atom.WikipediaRuleMatch;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.tools.ContextTools;
import xtc.tree.Location;

class AtomFeedChecker {
    private static final int CONTEXT_SIZE = 60;
    private static final String USER_AGENT = "http://tools.wmflabs.org/languagetool/ bot, contact: naber[@]danielnaber.de";
    private final JLanguageTool langTool;
    private final Language language;
    private final MatchDatabase matchDatabase;
    private final TextMapFilter textFilter = new SwebleWikipediaTextFilter();
    private final ContextTools contextTools = new ContextTools();

    AtomFeedChecker(Language language) throws IOException {
        this(language, null);
    }

    AtomFeedChecker(Language language, DatabaseConfig dbConfig) throws IOException {
        this.language = Objects.requireNonNull(language);
        this.langTool = new JLanguageTool(language);
        this.langTool.activateDefaultPatternRules();
        this.langTool.disableRule("UNPAIRED_BRACKETS");
        this.langTool.disableRule("EN_UNPAIRED_BRACKETS");
        this.langTool.disableRule("EN_QUOTES");
        this.langTool.disableRule("COMMA_PARENTHESIS_WHITESPACE");
        this.langTool.disableRule("UPPERCASE_SENTENCE_START");
        this.langTool.disableRule("FRENCH_WHITESPACE");
        this.activateCategory("Wikipedia", this.langTool);
        this.disableSpellingRules(this.langTool);
        this.matchDatabase = dbConfig != null ? new MatchDatabase(dbConfig.getUrl(), dbConfig.getUser(), dbConfig.getPassword()) : null;
        this.contextTools.setContextSize(60);
        this.contextTools.setErrorMarkerStart("<err>");
        this.contextTools.setErrorMarkerEnd("</err>");
        this.contextTools.setEscapeHtml(false);
    }

    private void activateCategory(String categoryName, JLanguageTool langTool) {
        for (Rule rule : langTool.getAllRules()) {
            if (!rule.getCategory().getName().equals(categoryName)) continue;
            System.out.println("Activating " + rule.getId() + " in category " + categoryName);
            langTool.enableDefaultOffRule(rule.getId());
        }
    }

    private void disableSpellingRules(JLanguageTool langTool) {
        for (Rule rule : langTool.getAllActiveRules()) {
            if (!rule.isDictionaryBasedSpellingRule()) continue;
            langTool.disableRule(rule.getId());
            System.out.println("Disabled spelling rule: " + rule.getId());
        }
    }

    CheckResult runCheck(InputStream feedStream) throws IOException {
        CheckResult checkResult = this.checkChanges(feedStream);
        this.storeResults(checkResult);
        return checkResult;
    }

    CheckResult runCheck(String url) throws IOException {
        CheckResult checkResult = this.checkChanges(new URL(url));
        this.storeResults(checkResult);
        return checkResult;
    }

    private void storeResults(CheckResult checkResult) throws IOException {
        List<ChangeAnalysis> checkResults = checkResult.getCheckResults();
        System.out.println("Check results:");
        for (ChangeAnalysis result : checkResults) {
            List<WikipediaRuleMatch> addedMatches = result.getAddedMatches();
            List<WikipediaRuleMatch> removedMatches = result.getRemovedMatches();
            if (addedMatches.size() <= 0 && removedMatches.size() <= 0) continue;
            System.out.println("'" + result.getTitle() + "' new and removed matches:");
            for (WikipediaRuleMatch match : addedMatches) {
                System.out.println("    [+] " + this.getId(match.getRule()) + ": " + match.getErrorContext());
                if (this.matchDatabase == null) continue;
                this.matchDatabase.add(match);
            }
            for (WikipediaRuleMatch match : removedMatches) {
                System.out.println("    [-] " + this.getId(match.getRule()) + ": " + match.getErrorContext());
                if (this.matchDatabase == null) continue;
                this.matchDatabase.markedFixed(match);
            }
            String diffLink = "https://" + this.language.getShortName() + ".wikipedia.org/w/index.php?title=" + URLEncoder.encode(result.getTitle().replace(" ", "_"), "UTF-8") + "&diff=" + result.getDiffId();
            System.out.println("    " + diffLink);
        }
    }

    private String getId(Rule rule) {
        if (rule instanceof PatternRule) {
            return rule.getId() + "[" + ((PatternRule)rule).getSubId() + "]";
        }
        return rule.getId();
    }

    CheckResult checkChanges(URL atomFeedUrl) throws IOException {
        System.out.println("Getting atom feed from " + atomFeedUrl);
        InputStream xml = this.getXmlStream(atomFeedUrl);
        return this.checkChanges(xml);
    }

    CheckResult checkChanges(InputStream xml) throws IOException {
        Date lastDateOfPreviousRun = this.matchDatabase != null ? this.matchDatabase.getLatestDate(this.language) : null;
        ArrayList<ChangeAnalysis> result = new ArrayList<ChangeAnalysis>();
        long latestDiffId = 0L;
        int skipCount = 0;
        try {
            List<AtomFeedItem> items = new AtomFeedParser().getAtomFeedItems(xml);
            Collections.reverse(items);
            this.printDates(items, lastDateOfPreviousRun);
            for (AtomFeedItem item : items) {
                if (lastDateOfPreviousRun != null && (item.getDate().before(lastDateOfPreviousRun) || item.getDate().equals(lastDateOfPreviousRun))) {
                    System.out.println("Skipping " + item.getTitle() + ", date " + item.getDate());
                    ++skipCount;
                    continue;
                }
                if (this.matchDatabase != null) {
                    this.matchDatabase.updateRuleMatchCheckDate(this.language, item.getDate());
                }
                try {
                    System.out.println("Checking " + item.getTitle() + ", diff #" + item.getDiffId());
                    List<WikipediaRuleMatch> oldMatches = this.getMatches(item, item.getOldContent());
                    List<WikipediaRuleMatch> newMatches = this.getMatches(item, item.getNewContent());
                    ChangeAnalysis changeAnalysis = new ChangeAnalysis(item.getTitle(), item.getDiffId(), oldMatches, newMatches);
                    result.add(changeAnalysis);
                    if (item.getDiffId() <= latestDiffId) continue;
                    latestDiffId = item.getDiffId();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        if (lastDateOfPreviousRun != null && skipCount == 0) {
            System.err.println("Warning: no items from the Atom feed were skipped - this means that changes might be missing");
        }
        return new CheckResult(result, latestDiffId);
    }

    MatchDatabase getDatabase() {
        return this.matchDatabase;
    }

    private void printDates(List<AtomFeedItem> items, Date lastDateOfPreviousRun) {
        if (items.size() > 0) {
            Date firstDate = items.get(0).getDate();
            Date lastDate = items.get(items.size() - 1).getDate();
            System.out.println("Latest date in database: " + lastDateOfPreviousRun);
            System.out.println("Dates in Atom Feed:      " + firstDate + " - " + lastDate);
        }
    }

    private List<WikipediaRuleMatch> getMatches(AtomFeedItem item, List<String> texts) throws IOException {
        ArrayList<WikipediaRuleMatch> oldMatches = new ArrayList<WikipediaRuleMatch>();
        for (String text : texts) {
            PlainTextMapping filteredContent = this.textFilter.filter(text);
            List ruleMatches = this.langTool.check(filteredContent.getPlainText());
            oldMatches.addAll(this.toWikipediaRuleMatches(text, filteredContent, ruleMatches, item));
        }
        return oldMatches;
    }

    private List<WikipediaRuleMatch> toWikipediaRuleMatches(String content, PlainTextMapping filteredContent, List<RuleMatch> ruleMatches, AtomFeedItem item) {
        ArrayList<WikipediaRuleMatch> result = new ArrayList<WikipediaRuleMatch>();
        for (RuleMatch ruleMatch : ruleMatches) {
            Location fromPos = filteredContent.getOriginalTextPositionFor(ruleMatch.getFromPos() + 1);
            Location toPos = filteredContent.getOriginalTextPositionFor(ruleMatch.getToPos() + 1);
            int origFrom = LocationHelper.absolutePositionFor(fromPos, content);
            int origTo = LocationHelper.absolutePositionFor(toPos, content);
            String errorContext = this.contextTools.getContext(origFrom, origTo, content);
            result.add(new WikipediaRuleMatch(this.language, ruleMatch, errorContext, item));
        }
        return result;
    }

    private InputStream getXmlStream(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setRequestProperty("User-Agent", USER_AGENT);
        return conn.getInputStream();
    }
}

