/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.dumpcheck;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.MultiThreadedJLanguageTool;
import org.languagetool.dev.dumpcheck.DatabaseHandler;
import org.languagetool.dev.dumpcheck.DocumentLimitReachedException;
import org.languagetool.dev.dumpcheck.ErrorLimitReachedException;
import org.languagetool.dev.dumpcheck.MixingSentenceSource;
import org.languagetool.dev.dumpcheck.ResultHandler;
import org.languagetool.dev.dumpcheck.Sentence;
import org.languagetool.dev.dumpcheck.StdoutHandler;
import org.languagetool.rules.Rule;

public class SentenceSourceChecker {
    private SentenceSourceChecker() {
    }

    public static void main(String[] args) throws IOException {
        SentenceSourceChecker prg = new SentenceSourceChecker();
        CommandLine commandLine = SentenceSourceChecker.ensureCorrectUsageOrExit(args);
        File propFile = null;
        if (commandLine.hasOption('d') && (!(propFile = new File(commandLine.getOptionValue('d'))).exists() || propFile.isDirectory())) {
            throw new IOException("File not found or isn't a file: " + propFile.getAbsolutePath());
        }
        String languageCode = commandLine.getOptionValue('l');
        HashSet<String> disabledRuleIds = new HashSet<String>();
        if (commandLine.hasOption("rule-properties")) {
            File disabledRulesPropFile = new File(commandLine.getOptionValue("rule-properties"));
            if (!disabledRulesPropFile.exists() || disabledRulesPropFile.isDirectory()) {
                throw new IOException("File not found or isn't a file: " + disabledRulesPropFile.getAbsolutePath());
            }
            Properties disabledRules = new Properties();
            try (FileInputStream stream = new FileInputStream(disabledRulesPropFile);){
                disabledRules.load(stream);
                SentenceSourceChecker.addDisabledRules("all", disabledRuleIds, disabledRules);
                SentenceSourceChecker.addDisabledRules(languageCode, disabledRuleIds, disabledRules);
            }
        }
        int maxArticles = Integer.parseInt(commandLine.getOptionValue("max-sentences", "0"));
        int maxErrors = Integer.parseInt(commandLine.getOptionValue("max-errors", "0"));
        String[] ruleIds = commandLine.hasOption('r') ? commandLine.getOptionValue('r').split(",") : null;
        String[] categoryIds = commandLine.hasOption("also-enable-categories") ? commandLine.getOptionValue("also-enable-categories").split(",") : null;
        String[] fileNames = commandLine.getOptionValues('f');
        File languageModelDir = commandLine.hasOption("languagemodel") ? new File(commandLine.getOptionValue("languagemodel")) : null;
        prg.run(propFile, disabledRuleIds, languageCode, Arrays.asList(fileNames), ruleIds, categoryIds, maxArticles, maxErrors, languageModelDir);
    }

    private static void addDisabledRules(String languageCode, Set<String> disabledRuleIds, Properties disabledRules) {
        String disabledRulesString = disabledRules.getProperty(languageCode);
        if (disabledRulesString != null) {
            String[] ids = disabledRulesString.split(",");
            disabledRuleIds.addAll(Arrays.asList(ids));
        }
    }

    private static CommandLine ensureCorrectUsageOrExit(String[] args) {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"language");
        OptionBuilder.withArgName((String)"code");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"language code like 'en' or 'de'");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"l"));
        OptionBuilder.withLongOpt((String)"db-properties");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"A file to set database access properties. If not set, the output will be written to STDOUT. The file needs to set the properties dbUrl ('jdbc:...'), dbUser, and dbPassword. It can optionally define the batchSize for insert statements, which defaults to 1.");
        options.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withLongOpt((String)"rule-properties");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"A file to set rules which should be disabled per language (e.g. en=RULE1,RULE2 or all=RULE3,RULE4)");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"rule-ids");
        OptionBuilder.withArgName((String)"id");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"comma-separated list of rule-ids to activate");
        options.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withLongOpt((String)"also-enable-categories");
        OptionBuilder.withArgName((String)"categories");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"comma-separated list of categories to activate, additionally to rules activated anyway");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"file");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"an unpacked Wikipedia XML dump; (must be named *.xml, dumps are available from http://dumps.wikimedia.org/backup-index.html) or a Tatoeba CSV file filtered to contain only one language (must be named tatoeba-*). You can specify this option more than once.");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withLongOpt((String)"max-sentences");
        OptionBuilder.withArgName((String)"number");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"maximum number of sentences to check");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"max-errors");
        OptionBuilder.withArgName((String)"number");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"maximum number of errors, stop when finding more");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"languagemodel");
        OptionBuilder.withArgName((String)"indexDir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"directory with a '3grams' sub directory that contains an ngram index");
        options.addOption(OptionBuilder.create());
        try {
            GnuParser parser = new GnuParser();
            return parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println("Error: " + e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(80);
            formatter.setSyntaxPrefix("Usage: ");
            formatter.printHelp(SentenceSourceChecker.class.getSimpleName() + " [OPTION]... --file <file> --language <code>", options);
            System.exit(1);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void run(File propFile, Set<String> disabledRules, String langCode, List<String> fileNames, String[] ruleIds, String[] additionalCategoryIds, int maxSentences, int maxErrors, File languageModelDir) throws IOException {
        Language lang = Languages.getLanguageForShortName((String)langCode);
        MultiThreadedJLanguageTool languageTool = new MultiThreadedJLanguageTool(lang);
        if (languageModelDir != null) {
            languageTool.activateLanguageModelRules(languageModelDir);
        }
        if (ruleIds != null) {
            this.enableOnlySpecifiedRules(ruleIds, (JLanguageTool)languageTool);
        } else {
            this.applyRuleDeactivation((JLanguageTool)languageTool, disabledRules);
        }
        this.activateAdditionalCategories(additionalCategoryIds, (JLanguageTool)languageTool);
        this.disableSpellingRules((JLanguageTool)languageTool);
        System.out.println("Working on: " + StringUtils.join(fileNames, (String)", "));
        System.out.println("Sentence limit: " + (maxSentences > 0 ? Integer.valueOf(maxSentences) : "no limit"));
        System.out.println("Error limit: " + (maxErrors > 0 ? Integer.valueOf(maxErrors) : "no limit"));
        ResultHandler resultHandler = null;
        int ruleMatchCount = 0;
        int sentenceCount = 0;
        resultHandler = propFile != null ? new DatabaseHandler(propFile, maxSentences, maxErrors) : new StdoutHandler(maxSentences, maxErrors);
        MixingSentenceSource mixingSource = MixingSentenceSource.create(fileNames, lang);
        while (mixingSource.hasNext()) {
            Sentence sentence = mixingSource.next();
            try {
                List matches = languageTool.check(sentence.getText());
                resultHandler.handleResult(sentence, matches, lang);
                if (++sentenceCount % 5000 == 0) {
                    System.err.printf("%s sentences checked...\n", NumberFormat.getNumberInstance(Locale.US).format(sentenceCount));
                }
                ruleMatchCount += matches.size();
            }
            catch (DocumentLimitReachedException | ErrorLimitReachedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Check failed on sentence: " + StringUtils.abbreviate((String)sentence.getText(), (int)250), e);
            }
        }
        if (resultHandler == null) return;
        float matchesPerSentence = (float)ruleMatchCount / (float)sentenceCount;
        System.out.printf(lang + ": %d total matches\n", ruleMatchCount);
        System.out.printf(lang + ": \u00f8%.2f rule matches per sentence\n", Float.valueOf(matchesPerSentence));
        try {
            resultHandler.close();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return;
        catch (DocumentLimitReachedException | ErrorLimitReachedException e) {
            try {
                System.out.println(e);
                if (resultHandler == null) return;
            }
            catch (Throwable throwable) {
                if (resultHandler == null) throw throwable;
                float matchesPerSentence2 = (float)ruleMatchCount / (float)sentenceCount;
                System.out.printf(lang + ": %d total matches\n", ruleMatchCount);
                System.out.printf(lang + ": \u00f8%.2f rule matches per sentence\n", Float.valueOf(matchesPerSentence2));
                try {
                    resultHandler.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
            matchesPerSentence = (float)ruleMatchCount / (float)sentenceCount;
            System.out.printf(lang + ": %d total matches\n", ruleMatchCount);
            System.out.printf(lang + ": \u00f8%.2f rule matches per sentence\n", Float.valueOf(matchesPerSentence));
            try {
                resultHandler.close();
                return;
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
            return;
        }
    }

    private void enableOnlySpecifiedRules(String[] ruleIds, JLanguageTool languageTool) {
        for (Rule rule : languageTool.getAllRules()) {
            languageTool.disableRule(rule.getId());
        }
        for (String ruleId : ruleIds) {
            languageTool.enableRule(ruleId);
        }
        for (Rule rule : languageTool.getAllRules()) {
            if (!rule.isDefaultOff()) continue;
            languageTool.enableDefaultOffRule(rule.getId());
        }
        this.warnOnNonExistingRuleIds(ruleIds, languageTool);
        System.out.println("Only these rules are enabled: " + Arrays.toString(ruleIds));
    }

    private void warnOnNonExistingRuleIds(String[] ruleIds, JLanguageTool languageTool) {
        for (String ruleId : ruleIds) {
            boolean found = false;
            for (Rule rule : languageTool.getAllRules()) {
                if (!rule.getId().equals(ruleId)) continue;
                found = true;
                break;
            }
            if (found) continue;
            System.out.println("WARNING: Could not find rule '" + ruleId + "'");
        }
    }

    private void applyRuleDeactivation(JLanguageTool languageTool, Set<String> disabledRules) {
        for (String disabledRuleId : disabledRules) {
            languageTool.disableRule(disabledRuleId);
        }
        System.out.println("These rules are disabled: " + languageTool.getDisabledRules());
    }

    private void activateAdditionalCategories(String[] additionalCategoryIds, JLanguageTool languageTool) {
        if (additionalCategoryIds != null) {
            for (String categoryId : additionalCategoryIds) {
                for (Rule rule : languageTool.getAllRules()) {
                    if (!rule.getCategory().getName().equals(categoryId)) continue;
                    System.out.println("Activating " + rule.getId() + " in category " + categoryId);
                    languageTool.enableDefaultOffRule(rule.getId());
                }
            }
        }
    }

    private void disableSpellingRules(JLanguageTool languageTool) {
        List allActiveRules = languageTool.getAllActiveRules();
        for (Rule rule : allActiveRules) {
            if (!rule.isDictionaryBasedSpellingRule()) continue;
            languageTool.disableRule(rule.getId());
        }
        System.out.println("All spelling rules are disabled");
    }
}

