/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.index;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.util.Version;
import org.languagetool.JLanguageTool;
import org.languagetool.dev.index.AnyCharTokenizer;
import org.languagetool.dev.index.LanguageToolFilter;

public final class LanguageToolAnalyzer
extends Analyzer {
    private final JLanguageTool languageTool;
    private final boolean toLowerCase;
    private final Version luceneVersion;

    public LanguageToolAnalyzer(Version luceneVersion, JLanguageTool languageTool, boolean toLowerCase) {
        this.luceneVersion = luceneVersion;
        this.languageTool = languageTool;
        this.toLowerCase = toLowerCase;
    }

    protected Analyzer.TokenStreamComponents createComponents(String s, Reader reader) {
        AnyCharTokenizer tokenizer = new AnyCharTokenizer(this.luceneVersion, reader);
        LanguageToolFilter result = new LanguageToolFilter((TokenStream)tokenizer, this.languageTool, this.toLowerCase);
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)result);
    }
}

