/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;

public final class LanguageToolFilter
extends TokenFilter {
    static final String POS_PREFIX = "_POS_";
    static final String LEMMA_PREFIX = "_LEMMA_";
    private final JLanguageTool languageTool;
    private final boolean toLowerCase;
    private final Stack<String> posStack;
    private final CharTermAttribute termAtt;
    private final OffsetAttribute offsetAtt;
    private final PositionIncrementAttribute posIncrAtt;
    private final TypeAttribute typeAtt;
    private AttributeSource.State current;
    private Iterator<AnalyzedTokenReadings> tokenIter;

    LanguageToolFilter(TokenStream input, JLanguageTool languageTool, boolean toLowerCase) {
        super(input);
        this.languageTool = languageTool;
        this.toLowerCase = toLowerCase;
        this.posStack = new Stack();
        this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        this.posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        if (this.posStack.size() > 0) {
            String pop = this.posStack.pop();
            this.restoreState(this.current);
            this.termAtt.append(pop);
            this.posIncrAtt.setPositionIncrement(0);
            this.typeAtt.setType("pos");
            return true;
        }
        if (this.tokenIter == null || !this.tokenIter.hasNext()) {
            if (this.input.incrementToken()) {
                AnalyzedSentence sentence = this.languageTool.getAnalyzedSentence(this.termAtt.toString());
                List<AnalyzedTokenReadings> tokenBuffer = Arrays.asList(sentence.getTokens());
                this.tokenIter = tokenBuffer.iterator();
                if (!this.tokenIter.hasNext()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        this.clearAttributes();
        AnalyzedTokenReadings tr = this.tokenIter.next();
        if (tr.isSentenceStart()) {
            this.typeAtt.setType("pos");
            String posTag = tr.getAnalyzedToken(0).getPOSTag();
            String lemma = tr.getAnalyzedToken(0).getLemma();
            if (this.toLowerCase) {
                this.termAtt.append(POS_PREFIX.toLowerCase()).append(posTag.toLowerCase());
                if (lemma != null) {
                    this.termAtt.append(LEMMA_PREFIX.toLowerCase()).append(lemma.toLowerCase());
                }
            } else {
                this.termAtt.append(POS_PREFIX).append(posTag);
                if (lemma != null) {
                    this.termAtt.append(LEMMA_PREFIX).append(lemma);
                }
            }
            return true;
        }
        if (tr.isWhitespace()) {
            return this.incrementToken();
        }
        this.offsetAtt.setOffset(tr.getStartPos(), tr.getEndPos());
        for (AnalyzedToken token : tr) {
            if (token.getPOSTag() != null) {
                if (this.toLowerCase) {
                    this.posStack.push(POS_PREFIX.toLowerCase() + token.getPOSTag().toLowerCase());
                } else {
                    this.posStack.push(POS_PREFIX + token.getPOSTag());
                }
            }
            if (token.getLemma() == null) continue;
            if (this.toLowerCase) {
                this.posStack.push(LEMMA_PREFIX.toLowerCase() + token.getLemma().toLowerCase());
                continue;
            }
            this.posStack.push(LEMMA_PREFIX + token.getLemma());
        }
        this.current = this.captureState();
        if (this.toLowerCase) {
            this.termAtt.append(tr.getAnalyzedToken(0).getToken().toLowerCase());
        } else {
            this.termAtt.append(tr.getAnalyzedToken(0).getToken());
        }
        return true;
    }
}

