/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.index;

import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.sandbox.queries.regex.JavaUtilRegexCapabilities;
import org.apache.lucene.sandbox.queries.regex.RegexCapabilities;
import org.apache.lucene.sandbox.queries.regex.RegexQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.Language;
import org.languagetool.dev.index.UnsupportedPatternRuleException;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.synthesis.Synthesizer;

public class PatternRuleQueryBuilder {
    public static final String FIELD_NAME = "field";
    public static final String SOURCE_FIELD_NAME = "source";
    public static final String FIELD_NAME_LOWERCASE = "fieldLowercase";
    private final Language language;

    public PatternRuleQueryBuilder(Language language) {
        this.language = language;
    }

    public Query buildRelaxedQuery(PatternRule rule) throws UnsupportedPatternRuleException {
        BooleanQuery booleanQuery = new BooleanQuery();
        for (PatternToken patternToken : rule.getPatternTokens()) {
            try {
                BooleanClause clause = this.makeQuery(patternToken);
                booleanQuery.add(clause);
            }
            catch (UnsupportedPatternRuleException e) {
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create query for rule " + rule.getId(), e);
            }
        }
        if (booleanQuery.clauses().size() == 0) {
            throw new UnsupportedPatternRuleException("No items found in rule that can be used to build a search query: " + rule);
        }
        return booleanQuery;
    }

    private BooleanClause makeQuery(PatternToken patternToken) throws UnsupportedPatternRuleException {
        this.checkUnsupportedElement(patternToken);
        String termStr = patternToken.getString();
        String pos = patternToken.getPOStag();
        BooleanClause termQuery = this.getTermQueryOrNull(patternToken, termStr);
        BooleanClause posQuery = this.getPosQueryOrNull(patternToken, pos);
        if (termQuery != null && posQuery != null) {
            if (this.mustOccur(termQuery) && this.mustOccur(posQuery)) {
                SpanQuery spanQueryForTerm = this.asSpanQuery(termQuery);
                SpanQuery spanQueryForPos = this.asSpanQuery(posQuery);
                SpanQuery[] spanClauses = new SpanQuery[]{spanQueryForTerm, spanQueryForPos};
                return new BooleanClause((Query)new SpanNearQuery(spanClauses, 0, false), BooleanClause.Occur.MUST);
            }
            throw new UnsupportedPatternRuleException("Term/POS combination not supported yet: " + patternToken);
        }
        if (termQuery != null) {
            return termQuery;
        }
        if (posQuery != null) {
            return posQuery;
        }
        throw new UnsupportedPatternRuleException("Neither POS tag nor term set for element: " + patternToken);
    }

    private SpanQuery asSpanQuery(BooleanClause query) {
        if (query.getQuery() instanceof MultiTermQuery) {
            return new SpanMultiTermQueryWrapper((MultiTermQuery)query.getQuery());
        }
        HashSet terms = new HashSet();
        query.getQuery().extractTerms(terms);
        if (terms.size() != 1) {
            throw new RuntimeException("Expected term set of size 1: " + terms);
        }
        return new SpanTermQuery((Term)terms.iterator().next());
    }

    private boolean mustOccur(BooleanClause query) {
        return query != null && query.getOccur() == BooleanClause.Occur.MUST;
    }

    @Nullable
    private BooleanClause getTermQueryOrNull(PatternToken patternToken, String termStr) {
        if (termStr == null || termStr.isEmpty()) {
            return null;
        }
        Term termQueryTerm = this.getTermQueryTerm(patternToken, termStr);
        if (patternToken.getNegation() || patternToken.getMinOccurrence() == 0) {
            return null;
        }
        if (patternToken.isInflected() && patternToken.isRegularExpression()) {
            Term lemmaQueryTerm = this.getQueryTerm(patternToken, "_LEMMA_(", this.simplifyRegex(termStr), ")");
            Query regexpQuery = this.getRegexQuery(lemmaQueryTerm, termStr, patternToken);
            return new BooleanClause(regexpQuery, BooleanClause.Occur.MUST);
        }
        if (patternToken.isInflected() && !patternToken.isRegularExpression()) {
            Synthesizer synthesizer = this.language.getSynthesizer();
            if (synthesizer != null) {
                try {
                    Object[] synthesized = synthesizer.synthesize(new AnalyzedToken(termStr, null, termStr), ".*", true);
                    Object query = synthesized.length == 0 ? new TermQuery(termQueryTerm) : new RegexpQuery(this.getTermQueryTerm(patternToken, StringUtils.join((Object[])synthesized, (String)"|")));
                    return new BooleanClause((Query)query, BooleanClause.Occur.MUST);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not build Lucene query for '" + patternToken + "' and '" + termStr + "'", e);
                }
            }
            return null;
        }
        Object termQuery = patternToken.isRegularExpression() ? this.getRegexQuery(termQueryTerm, termStr, patternToken) : new TermQuery(termQueryTerm);
        return new BooleanClause((Query)termQuery, BooleanClause.Occur.MUST);
    }

    private String simplifyRegex(String regex) {
        return regex.replace("(?:", "(").replace("\\d", "[0-9]").replace("\\w", "[a-zA-Z_0-9]");
    }

    private boolean needsSimplification(String regex) {
        return regex.contains("(?:") || regex.contains("\\d") || regex.contains("\\w");
    }

    @Nullable
    private BooleanClause getPosQueryOrNull(PatternToken patternToken, String pos) {
        TermQuery posQuery;
        if (pos == null || pos.isEmpty()) {
            return null;
        }
        if (patternToken.getPOSNegation() || patternToken.getMinOccurrence() == 0) {
            return null;
        }
        if (patternToken.isPOStagRegularExpression()) {
            Term posQueryTerm = this.getQueryTerm(patternToken, "_POS_(", pos, ")");
            posQuery = this.getRegexQuery(posQueryTerm, pos, patternToken);
        } else {
            Term posQueryTerm = this.getQueryTerm(patternToken, "_POS_", pos, "");
            posQuery = new TermQuery(posQueryTerm);
        }
        return new BooleanClause((Query)posQuery, BooleanClause.Occur.MUST);
    }

    private Term getTermQueryTerm(PatternToken patternToken, String str) {
        if (patternToken.isCaseSensitive()) {
            return new Term(FIELD_NAME, str);
        }
        return new Term(FIELD_NAME_LOWERCASE, str.toLowerCase());
    }

    private Term getQueryTerm(PatternToken patternToken, String prefix, String str, String suffix) {
        if (patternToken.isCaseSensitive()) {
            return new Term(FIELD_NAME, prefix + str + suffix);
        }
        return new Term(FIELD_NAME_LOWERCASE, prefix.toLowerCase() + str.toLowerCase() + suffix.toLowerCase());
    }

    private Query getRegexQuery(Term term, String str, PatternToken patternToken) {
        try {
            if (this.needsSimplification(str)) {
                Term newTerm = new Term(term.field(), this.simplifyRegex(term.text()));
                return new RegexpQuery(newTerm);
            }
            if (str.contains("?iu") || str.contains("?-i")) {
                return this.getFallbackRegexQuery(str, patternToken);
            }
            return new RegexpQuery(term);
        }
        catch (IllegalArgumentException e) {
            return this.getFallbackRegexQuery(str, patternToken);
        }
    }

    private RegexQuery getFallbackRegexQuery(String str, PatternToken patternToken) {
        RegexQuery query = new RegexQuery(new Term(patternToken.isCaseSensitive() ? FIELD_NAME : FIELD_NAME_LOWERCASE, str));
        query.setRegexImplementation((RegexCapabilities)new JavaUtilRegexCapabilities(2));
        return query;
    }

    private void checkUnsupportedElement(PatternToken patternPatternToken) throws UnsupportedPatternRuleException {
        if (patternPatternToken.hasOrGroup()) {
            throw new UnsupportedPatternRuleException("<or> not yet supported.");
        }
        if (patternPatternToken.isUnified()) {
            throw new UnsupportedPatternRuleException("Elements with unified tokens are not supported.");
        }
        if (patternPatternToken.getString().matches("\\\\\\d+")) {
            throw new UnsupportedPatternRuleException("Elements with only match references (e.g. \\1) are not supported.");
        }
    }
}

