/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.index;

import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Counter;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.dev.index.MatchingSentence;
import org.languagetool.dev.index.PatternRuleNotFoundException;
import org.languagetool.dev.index.PatternRuleQueryBuilder;
import org.languagetool.dev.index.SearchTimeoutException;
import org.languagetool.dev.index.SearcherResult;
import org.languagetool.dev.index.UnsupportedPatternRuleException;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.tools.ContextTools;

public class Searcher {
    private static boolean WIKITEXT_OUTPUT = false;
    private final Directory directory;
    private int maxHits = 1000;
    private int maxSearchTimeMillis = 5000;
    private IndexSearcher indexSearcher;
    private DirectoryReader reader;
    private boolean limitSearch = true;

    public Searcher(Directory directory) {
        this.directory = directory;
    }

    private void open() throws IOException {
        this.reader = DirectoryReader.open((Directory)this.directory);
        this.indexSearcher = new IndexSearcher((IndexReader)this.reader);
    }

    private void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public int getDocCount() throws IOException {
        try (DirectoryReader reader = DirectoryReader.open((Directory)this.directory);){
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)reader);
            int n = this.getDocCount(indexSearcher);
            return n;
        }
    }

    private int getDocCount(IndexSearcher indexSearcher) throws IOException {
        Term searchTerm = new Term("maxDocCount", "1");
        TopDocs search = indexSearcher.search((Query)new TermQuery(searchTerm), 1);
        if (search.totalHits != 1) {
            return -1;
        }
        ScoreDoc scoreDoc = search.scoreDocs[0];
        Document doc = indexSearcher.doc(scoreDoc.doc);
        return Integer.parseInt(doc.get("maxDocCountValue"));
    }

    public int getMaxHits() {
        return this.maxHits;
    }

    public void setMaxHits(int maxHits) {
        this.maxHits = maxHits;
    }

    public int getMaxSearchTimeMillis() {
        return this.maxSearchTimeMillis;
    }

    public void setMaxSearchTimeMillis(int maxSearchTimeMillis) {
        this.maxSearchTimeMillis = maxSearchTimeMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearcherResult findRuleMatchesOnIndex(PatternRule rule, Language language) throws IOException, UnsupportedPatternRuleException {
        this.open();
        try {
            PatternRuleQueryBuilder patternRuleQueryBuilder = new PatternRuleQueryBuilder(language);
            Query query = patternRuleQueryBuilder.buildRelaxedQuery(rule);
            if (query == null) {
                throw new NullPointerException("Cannot search on null query for rule: " + rule.getId());
            }
            System.out.println("Running query: " + query.toString("fieldLowercase"));
            SearchRunnable runnable = new SearchRunnable(this.indexSearcher, query, language, rule);
            Thread searchThread = new Thread(runnable);
            searchThread.start();
            try {
                if (this.limitSearch) {
                    searchThread.join(this.maxSearchTimeMillis);
                } else {
                    searchThread.join(Integer.MAX_VALUE);
                }
                searchThread.interrupt();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Search thread got interrupted for query " + query, e);
            }
            if (searchThread.isInterrupted()) {
                throw new SearchTimeoutException("Search timeout of " + this.maxSearchTimeMillis + "ms reached for query " + query);
            }
            Exception exception = runnable.getException();
            if (exception != null) {
                if (exception instanceof SearchTimeoutException) {
                    throw (SearchTimeoutException)exception;
                }
                throw new RuntimeException("Exception during search for query " + query + " on rule " + rule.getId(), exception);
            }
            List<MatchingSentence> matchingSentences = runnable.getMatchingSentences();
            int sentencesChecked = this.getSentenceCheckCount(query, this.indexSearcher);
            SearcherResult searcherResult = new SearcherResult(matchingSentences, sentencesChecked, query);
            searcherResult.setHasTooManyLuceneMatches(runnable.hasTooManyLuceneMatches());
            searcherResult.setLuceneMatchCount(runnable.getLuceneMatchCount());
            if (runnable.hasTooManyLuceneMatches()) {
                searcherResult.setDocCount(this.maxHits);
            } else {
                searcherResult.setDocCount(this.getDocCount(this.indexSearcher));
            }
            SearcherResult searcherResult2 = searcherResult;
            return searcherResult2;
        }
        finally {
            this.close();
        }
    }

    private PossiblyLimitedTopDocs getTopDocs(Query query, Sort sort) throws IOException {
        TopFieldCollector topCollector = TopFieldCollector.create((Sort)sort, (int)this.maxHits, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
        final Counter clock = Counter.newCounter((boolean)true);
        int waitMillis = 1000;
        TimeLimitingCollector collector = new TimeLimitingCollector((Collector)topCollector, clock, (long)(this.maxSearchTimeMillis / 1000));
        collector.setBaseline(0L);
        Thread counterThread = new Thread(){

            @Override
            public void run() {
                long startTime = System.currentTimeMillis();
                long runTimeMillis;
                while ((runTimeMillis = System.currentTimeMillis() - startTime) <= (long)Searcher.this.maxSearchTimeMillis) {
                    clock.addAndGet(1L);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                return;
            }
        };
        counterThread.setName("LuceneSearchTimeoutThread");
        counterThread.start();
        boolean timeLimitActivated = false;
        try {
            this.indexSearcher.search(query, (Collector)collector);
        }
        catch (TimeLimitingCollector.TimeExceededException e) {
            timeLimitActivated = true;
        }
        return new PossiblyLimitedTopDocs(topCollector.topDocs(), timeLimitActivated);
    }

    List<PatternRule> getRuleById(String ruleId, Language language) throws IOException {
        ArrayList<PatternRule> rules = new ArrayList<PatternRule>();
        JLanguageTool langTool = new JLanguageTool(language);
        for (Rule rule : langTool.getAllRules()) {
            if (!rule.getId().equals(ruleId) || !(rule instanceof PatternRule)) continue;
            rules.add((PatternRule)rule);
        }
        if (rules.size() > 0) {
            return rules;
        }
        throw new PatternRuleNotFoundException(ruleId, language);
    }

    private int getSentenceCheckCount(Query query, IndexSearcher indexSearcher) {
        int indexSize = indexSearcher.getIndexReader().numDocs();
        int sentencesChecked = Math.min(this.maxHits, indexSize);
        return sentencesChecked;
    }

    private List<MatchingSentence> findMatchingSentences(IndexSearcher indexSearcher, TopDocs topDocs, JLanguageTool languageTool) throws IOException {
        ArrayList<MatchingSentence> matchingSentences = new ArrayList<MatchingSentence>();
        for (ScoreDoc match : topDocs.scoreDocs) {
            Document doc = indexSearcher.doc(match.doc);
            String sentence = doc.get("field");
            List ruleMatches = languageTool.check(sentence);
            if (ruleMatches.size() <= 0) continue;
            String source = doc.get("source");
            String title = doc.get("title");
            AnalyzedSentence analyzedSentence = languageTool.getAnalyzedSentence(sentence);
            MatchingSentence matchingSentence = new MatchingSentence(sentence, source, title, analyzedSentence, ruleMatches);
            matchingSentences.add(matchingSentence);
        }
        return matchingSentences;
    }

    private JLanguageTool getLanguageToolWithOneRule(Language lang, PatternRule patternRule) {
        JLanguageTool langTool = new JLanguageTool(lang);
        for (Rule rule : langTool.getAllActiveRules()) {
            if (rule.getId().equals(patternRule.getId())) continue;
            langTool.disableRule(rule.getId());
        }
        langTool.addRule((Rule)patternRule);
        langTool.enableDefaultOffRule(patternRule.getId());
        return langTool;
    }

    private static void ensureCorrectUsageOrExit(String[] args) {
        if (args.length < 3 || args.length == 4 && !"--no_limit".equals(args[3])) {
            System.err.println("Usage: Searcher <ruleId> <languageCode> <indexDir> [--no_limit]");
            System.err.println("\truleId       Id of the rule to search for (or comma-separated list of ids)");
            System.err.println("\tlanguageCode short language code, e.g. 'en' for English");
            System.err.println("\tindexDir     path to a directory containing the index");
            System.err.println("\t--no_limit   do not limit search time");
            System.exit(1);
        }
    }

    private static ContextTools getContextTools(int contextSize) {
        ContextTools contextTools = new ContextTools();
        contextTools.setEscapeHtml(false);
        contextTools.setContextSize(contextSize);
        contextTools.setErrorMarkerStart("**");
        contextTools.setErrorMarkerEnd("**");
        return contextTools;
    }

    public static void main(String[] args) throws Exception {
        Searcher.ensureCorrectUsageOrExit(args);
        long startTime = System.currentTimeMillis();
        String[] ruleIds = args[0].split(",");
        String languageCode = args[1];
        Language language = Languages.getLanguageForShortName((String)languageCode);
        File indexDir = new File(args[2]);
        boolean limitSearch = args.length > 3 && "--no_limit".equals(args[3]);
        Searcher searcher = new Searcher((Directory)new SimpleFSDirectory(indexDir));
        if (!limitSearch) {
            searcher.setMaxHits(100000);
        }
        searcher.limitSearch = limitSearch;
        ContextTools contextTools = Searcher.getContextTools(140);
        int totalMatches = 0;
        for (String ruleId : ruleIds) {
            long ruleStartTime = System.currentTimeMillis();
            for (PatternRule rule : searcher.getRuleById(ruleId, language)) {
                System.out.println("===== " + ruleId + "[" + rule.getSubId() + "] =========================================================");
                SearcherResult searcherResult = searcher.findRuleMatchesOnIndex(rule, language);
                int i = 1;
                if (searcherResult.getMatchingSentences().size() == 0) {
                    System.out.println("[no matches]");
                }
                for (MatchingSentence ruleMatch : searcherResult.getMatchingSentences()) {
                    for (RuleMatch match : ruleMatch.getRuleMatches()) {
                        String context = contextTools.getContext(match.getFromPos(), match.getToPos(), ruleMatch.getSentence());
                        if (WIKITEXT_OUTPUT) {
                            ContextTools contextTools2 = Searcher.getContextTools(0);
                            String coveredText = contextTools2.getContext(match.getFromPos(), match.getToPos(), ruleMatch.getSentence());
                            coveredText = coveredText.replaceFirst("^\\.\\.\\.", "").replaceFirst("\\.\\.\\.$", "");
                            coveredText = coveredText.replaceFirst("^\\*\\*", "").replaceFirst("\\*\\*$", "");
                            String encodedTextWithQuotes = URLEncoder.encode("\"" + coveredText + "\"", "UTF-8");
                            String searchLink = "https://de.wikipedia.org/w/index.php?search=" + encodedTextWithQuotes + "&title=Spezial%3ASuche&go=Artikel";
                            context = context.replaceAll("\\*\\*.*?\\*\\*", "[" + searchLink + " " + coveredText + "]");
                            String encTitle = URLEncoder.encode(ruleMatch.getTitle(), "UTF-8");
                            String encodedText = URLEncoder.encode(coveredText, "UTF-8");
                            System.out.println("# [[" + ruleMatch.getTitle() + "]]: " + context + " ([http://wikipedia.ramselehof.de/wikiblame.php?user_lang=de&lang=de&project=wikipedia&article=" + encTitle + "&needle=" + encodedText + "&skipversions=0&ignorefirst=0&limit=500&searchmethod=int&order=desc&start=Start WikiBlame])");
                            continue;
                        }
                        System.out.println(i + ": " + context + " [" + ruleMatch.getSource() + "]");
                    }
                    totalMatches += ruleMatch.getRuleMatches().size();
                    ++i;
                }
                System.out.println("Time: " + (System.currentTimeMillis() - ruleStartTime) + "ms");
            }
        }
        System.out.println("Total time: " + (System.currentTimeMillis() - startTime) + "ms, " + totalMatches + " matches");
    }

    class SearchRunnable
    implements Runnable {
        private final IndexSearcher indexSearcher;
        private final Query query;
        private final Language language;
        private final PatternRule rule;
        private List<MatchingSentence> matchingSentences;
        private Exception exception;
        private boolean tooManyLuceneMatches;
        private int luceneMatchCount;

        SearchRunnable(IndexSearcher indexSearcher, Query query, Language language, PatternRule rule) {
            this.indexSearcher = indexSearcher;
            this.query = query;
            this.language = language;
            this.rule = rule;
        }

        @Override
        public void run() {
            try {
                Sort sort = new Sort(new SortField("docCount", SortField.Type.INT));
                long t1 = System.currentTimeMillis();
                JLanguageTool languageTool = Searcher.this.getLanguageToolWithOneRule(this.language, this.rule);
                long langToolCreationTime = System.currentTimeMillis() - t1;
                long t2 = System.currentTimeMillis();
                PossiblyLimitedTopDocs limitedTopDocs = Searcher.this.getTopDocs(this.query, sort);
                long luceneTime = System.currentTimeMillis() - t2;
                long t3 = System.currentTimeMillis();
                this.luceneMatchCount = limitedTopDocs.topDocs.totalHits;
                this.tooManyLuceneMatches = limitedTopDocs.topDocs.scoreDocs.length >= Searcher.this.maxHits;
                this.matchingSentences = Searcher.this.findMatchingSentences(this.indexSearcher, limitedTopDocs.topDocs, languageTool);
                System.out.println("Check done in " + langToolCreationTime + "/" + luceneTime + "/" + (System.currentTimeMillis() - t3) + "ms (LT creation/Lucene/matching) for " + limitedTopDocs.topDocs.scoreDocs.length + " docs");
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        Exception getException() {
            return this.exception;
        }

        boolean hasTooManyLuceneMatches() {
            return this.tooManyLuceneMatches;
        }

        int getLuceneMatchCount() {
            return this.luceneMatchCount;
        }

        List<MatchingSentence> getMatchingSentences() {
            return this.matchingSentences;
        }
    }

    class PossiblyLimitedTopDocs {
        TopDocs topDocs;
        boolean resultIsTimeLimited;

        PossiblyLimitedTopDocs(TopDocs topDocs, boolean resultIsTimeLimited) {
            this.topDocs = topDocs;
            this.resultIsTimeLimited = resultIsTimeLimited;
        }
    }
}

