/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.index;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.dev.dumpcheck.Sentence;
import org.languagetool.dev.index.DoNotUseAnalyzer;
import org.languagetool.dev.index.LanguageToolAnalyzer;
import org.languagetool.tokenizers.SentenceTokenizer;

public class Indexer
implements AutoCloseable {
    static final String TITLE_FIELD_NAME = "title";
    private final IndexWriter writer;
    private final SentenceTokenizer sentenceTokenizer;

    public Indexer(Directory dir, Language language) {
        try {
            Analyzer analyzer = Indexer.getAnalyzer(language);
            IndexWriterConfig writerConfig = Indexer.getIndexWriterConfig(analyzer);
            writerConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            this.writer = new IndexWriter(dir, writerConfig);
            this.sentenceTokenizer = language.getSentenceTokenizer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws IOException {
        Indexer.ensureCorrectUsageOrExit(args);
        Indexer.run(args[0], args[1], args[2]);
    }

    static Analyzer getAnalyzer(Language language) {
        HashMap<String, LanguageToolAnalyzer> analyzerMap = new HashMap<String, LanguageToolAnalyzer>();
        analyzerMap.put("field", new LanguageToolAnalyzer(new JLanguageTool(language), false));
        analyzerMap.put("fieldLowercase", new LanguageToolAnalyzer(new JLanguageTool(language), true));
        return new PerFieldAnalyzerWrapper((Analyzer)new DoNotUseAnalyzer(), analyzerMap);
    }

    static IndexWriterConfig getIndexWriterConfig(Analyzer analyzer) {
        return new IndexWriterConfig(analyzer);
    }

    private static void ensureCorrectUsageOrExit(String[] args) {
        if (args.length != 3) {
            System.err.println("Usage: Indexer <textFile> <indexDir> <languageCode>");
            System.err.println("\ttextFile path to a text file to be indexed (line end implies sentence end)");
            System.err.println("\tindexDir path to a directory storing the index");
            System.err.println("\tlanguageCode short language code, e.g. en for English");
            System.exit(1);
        }
    }

    private static void run(String textFile, String indexDir, String languageCode) throws IOException {
        File file = new File(textFile);
        if (!file.exists() || !file.canRead()) {
            System.out.println("Text file '" + file.getAbsolutePath() + "' does not exist or is not readable, please check the path");
            System.exit(1);
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            System.out.println("Indexing to directory '" + indexDir + "'...");
            try (FSDirectory directory = FSDirectory.open((Path)new File(indexDir).toPath());){
                Language language = Languages.getLanguageForShortName((String)languageCode);
                try (Indexer indexer = new Indexer((Directory)directory, language);){
                    indexer.indexText(reader);
                }
            }
        }
        System.out.println("Index complete!");
    }

    public static void run(String content, Directory dir, Language language) throws IOException {
        BufferedReader br = new BufferedReader(new StringReader(content));
        try (Indexer indexer = new Indexer(dir, language);){
            indexer.indexText(br);
        }
    }

    public void indexSentence(Sentence sentence, int docCount) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(sentence.getText()));
        while ((line = reader.readLine()) != null) {
            this.add(line, sentence.getSource(), sentence.getTitle(), docCount);
        }
    }

    public void indexText(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            List sentences = this.sentenceTokenizer.tokenize(line);
            for (String sentence : sentences) {
                this.add(sentence, null, null, -1);
            }
        }
    }

    public void add(Document doc) throws IOException {
        this.writer.addDocument((Iterable)doc);
    }

    private void add(String sentence, String source, String title, int docCount) throws IOException {
        Document doc = new Document();
        FieldType type = new FieldType();
        type.setStored(true);
        type.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
        type.setTokenized(true);
        doc.add((IndexableField)new Field("field", sentence, type));
        doc.add((IndexableField)new Field("fieldLowercase", sentence, type));
        if (docCount != -1) {
            FieldType countType = new FieldType();
            countType.setStored(true);
            countType.setIndexOptions(IndexOptions.NONE);
            doc.add((IndexableField)new Field("docCount", String.valueOf(docCount), countType));
        }
        if (title != null) {
            FieldType titleType = new FieldType();
            titleType.setStored(true);
            titleType.setIndexOptions(IndexOptions.NONE);
            titleType.setTokenized(false);
            doc.add((IndexableField)new Field(TITLE_FIELD_NAME, title, titleType));
        }
        if (source != null) {
            FieldType sourceType = new FieldType();
            sourceType.setStored(true);
            sourceType.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
            sourceType.setTokenized(false);
            doc.add((IndexableField)new Field("source", source, sourceType));
        }
        this.writer.addDocument((Iterable)doc);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

