/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia.atom;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

class DatabaseConfig {
    private final String url;
    private final String user;
    private final String password;

    DatabaseConfig(String propFile) throws IOException {
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(propFile);){
            properties.load(fis);
        }
        this.url = this.getRequiredProperty(properties, "dbUrl");
        this.user = this.getRequiredProperty(properties, "dbUser");
        this.password = this.getRequiredProperty(properties, "dbPassword");
    }

    DatabaseConfig(String dbUrl, String dbUser, String dbPassword) {
        this.url = dbUrl;
        this.user = dbUser;
        this.password = dbPassword;
    }

    private String getRequiredProperty(Properties properties, String propName) {
        String value = properties.getProperty(propName);
        if (value == null) {
            throw new RuntimeException("Property key '" + propName + "' not found");
        }
        return value;
    }

    String getUrl() {
        return this.url;
    }

    String getUser() {
        return this.user;
    }

    String getPassword() {
        return this.password;
    }
}

