/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.dumpcheck;

import java.util.List;
import org.languagetool.Language;
import org.languagetool.dev.dumpcheck.ResultHandler;
import org.languagetool.dev.dumpcheck.Sentence;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.tools.ContextTools;

class CompactStdoutHandler
extends ResultHandler {
    private final ContextTools contextTools = new ContextTools();

    CompactStdoutHandler(int maxSentences, int maxErrors) {
        super(maxSentences, maxErrors);
        this.contextTools.setContextSize(70);
        this.contextTools.setErrorMarkerStart("**");
        this.contextTools.setErrorMarkerEnd("**");
        this.contextTools.setEscapeHtml(false);
    }

    @Override
    protected void handleResult(Sentence sentence, List<RuleMatch> ruleMatches, Language language) {
        if (ruleMatches.size() > 0) {
            for (RuleMatch match : ruleMatches) {
                String ruleId = match.getRule().getId();
                if (match.getRule() instanceof AbstractPatternRule) {
                    AbstractPatternRule pRule = (AbstractPatternRule)match.getRule();
                    ruleId = pRule.getFullId();
                }
                System.out.println(ruleId + ": " + this.contextTools.getContext(match.getFromPos(), match.getToPos(), sentence.getText()));
                this.checkMaxErrors(++this.errorCount);
            }
        }
        this.checkMaxSentences(++this.sentenceCount);
    }

    @Override
    public void close() throws Exception {
    }
}

