/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.dumpcheck;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.languagetool.Language;
import org.languagetool.dev.dumpcheck.Sentence;
import org.languagetool.dev.dumpcheck.SentenceSource;

public class PlainTextSentenceSource
extends SentenceSource {
    private final List<String> sentences;
    private final Scanner scanner;
    private int articleCount = 0;

    public PlainTextSentenceSource(InputStream textInput, Language language) {
        this(textInput, language, null);
    }

    public PlainTextSentenceSource(InputStream textInput, Language language, Pattern filter) {
        super(language, filter);
        this.scanner = new Scanner(textInput);
        this.sentences = new ArrayList<String>();
    }

    @Override
    public boolean hasNext() {
        this.fillSentences();
        return this.sentences.size() > 0;
    }

    @Override
    public Sentence next() {
        this.fillSentences();
        if (this.sentences.size() == 0) {
            throw new NoSuchElementException();
        }
        return new Sentence(this.sentences.remove(0), this.getSource(), "<plaintext>", null, ++this.articleCount);
    }

    @Override
    public String getSource() {
        return "plaintext";
    }

    private void fillSentences() {
        while (this.sentences.size() == 0 && this.scanner.hasNextLine()) {
            String line = this.scanner.nextLine();
            if (line.isEmpty() || !this.acceptSentence(line)) continue;
            this.sentences.add(line);
        }
    }
}

