/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

class IpaExtractor {
    private static final Pattern FULL_IPA_PATTERN = Pattern.compile("'''?(.*?)'''?\\s+\\[?\\{\\{IPA\\|([^}]*)\\}\\}");
    private static final Pattern IPA_PATTERN = Pattern.compile("\\{\\{IPA\\|([^}]*)\\}\\}");
    private int articleCount = 0;
    private int ipaCount = 0;

    IpaExtractor() {
    }

    public static void main(String[] args) throws XMLStreamException, FileNotFoundException {
        if (args.length == 0) {
            System.out.println("Usage: " + IpaExtractor.class.getSimpleName() + " <xml-dump...>");
            System.exit(1);
        }
        IpaExtractor extractor = new IpaExtractor();
        for (String filename : args) {
            FileInputStream fis = new FileInputStream(filename);
            extractor.run(fis);
        }
        System.err.println("articleCount: " + extractor.articleCount);
        System.err.println("IPA count: " + extractor.ipaCount);
    }

    private void run(FileInputStream fis) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader reader = factory.createXMLEventReader(fis);
        String title = null;
        while (reader.hasNext()) {
            String elementName;
            XMLEvent event = reader.nextEvent();
            if (event.getEventType() != 1) continue;
            switch (elementName = event.asStartElement().getName().getLocalPart()) {
                case "title": {
                    XMLEvent nextEvent = reader.nextEvent();
                    title = nextEvent.asCharacters().getData();
                    ++this.articleCount;
                    break;
                }
                case "text": {
                    this.ipaCount += this.handleTextElement(title, reader);
                }
            }
        }
    }

    private int handleTextElement(String title, XMLEventReader reader) throws XMLStreamException {
        XMLEvent event = reader.nextEvent();
        StringBuilder sb = new StringBuilder();
        while (event.isCharacters()) {
            sb.append(event.asCharacters().getData());
            event = reader.nextEvent();
        }
        String wikiText = sb.toString();
        int index = wikiText.indexOf("{{IPA");
        if (index != -1) {
            Matcher matcher = FULL_IPA_PATTERN.matcher(wikiText);
            if (matcher.find()) {
                System.out.println(title + ": " + matcher.group(1) + " -> " + matcher.group(2));
                return 1;
            }
            Matcher matcher2 = IPA_PATTERN.matcher(wikiText);
            if (matcher2.find()) {
                System.out.println(title + ": " + matcher2.group(1));
                return 1;
            }
            System.out.println(title + ": (no pattern found)");
        }
        return 0;
    }
}

