/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia.atom;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.languagetool.dev.wikipedia.atom.AtomFeedItem;

class AtomFeedParser {
    AtomFeedParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AtomFeedItem> getAtomFeedItems(InputStream xml) throws XMLStreamException {
        String id = null;
        String title = null;
        Date date = null;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        try (XMLEventReader eventReader = inputFactory.createXMLEventReader(xml);){
            ArrayList<AtomFeedItem> items = new ArrayList<AtomFeedItem>();
            while (eventReader.hasNext()) {
                String localPart;
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement()) continue;
                switch (localPart = event.asStartElement().getName().getLocalPart()) {
                    case "id": {
                        id = this.getCharacterData(eventReader);
                        break;
                    }
                    case "title": {
                        title = this.getCharacterData(eventReader);
                        break;
                    }
                    case "updated": {
                        String dateString = this.getCharacterData(eventReader);
                        try {
                            date = DatatypeFactory.newInstance().newXMLGregorianCalendar(dateString).toGregorianCalendar().getTime();
                            break;
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Could not parse date string '" + dateString + "'", e);
                        }
                    }
                    case "summary": {
                        if (id == null || title == null || date == null) {
                            throw new RuntimeException("id, title and/or date is null: id=" + id + ", title=" + title + ", date=" + date);
                        }
                        items.add(new AtomFeedItem(id, title, this.getCharacterData(eventReader), date));
                        id = null;
                        title = null;
                        date = null;
                    }
                }
            }
            ArrayList<AtomFeedItem> arrayList = items;
            return arrayList;
        }
    }

    private String getCharacterData(XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event = eventReader.nextEvent();
        StringBuilder sb = new StringBuilder();
        while (event.isCharacters()) {
            sb.append(event.asCharacters().getData());
            event = eventReader.nextEvent();
        }
        return sb.toString();
    }
}

