/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev.wikipedia.atom;

import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.languagetool.Language;
import org.languagetool.dev.wikipedia.atom.AtomFeedItem;
import org.languagetool.rules.RuleMatch;

final class WikipediaRuleMatch
extends RuleMatch {
    private final Language language;
    private final String errorContext;
    private final String title;
    private final Date editDate;
    private final long diffId;

    WikipediaRuleMatch(Language language, RuleMatch match, String errorContext, AtomFeedItem feedItem) {
        super(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), match.getMessage());
        this.language = Objects.requireNonNull(language);
        this.errorContext = Objects.requireNonNull(errorContext);
        this.title = Objects.requireNonNull(feedItem.getTitle());
        this.editDate = Objects.requireNonNull(feedItem.getDate());
        this.diffId = feedItem.getDiffId();
    }

    Language getLanguage() {
        return this.language;
    }

    String getErrorContext() {
        return this.errorContext;
    }

    String getTitle() {
        return this.title;
    }

    Date getEditDate() {
        return new Date(this.editDate.getTime());
    }

    long getDiffId() {
        return this.diffId;
    }

    public String toString() {
        return this.getRule().getId() + ":" + this.getFromPos() + "-" + this.getToPos();
    }

    public int hashCode() {
        return this.getRule().getId().hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof WikipediaRuleMatch) {
            return new EqualsBuilder().append((Object)this.getRule().getId(), (Object)((RuleMatch)other).getRule().getId()).isEquals();
        }
        return false;
    }
}

